<?php
/**
 * @package    JBusinessDirectory
 *
 * @author CMSJunkie http://www.cmsjunkie.com
 * @copyright  Copyright (C) 2007 - 2021 CMSJunkie. All rights reserved.
 * @license   https://www.gnu.org/licenses/agpl-3.0.en.html
 */
defined('_JEXEC') or die('Restricted access');

jimport('joomla.application.component.modellist');
JTable::addIncludePath(DS.'components'.DS.'com_jbusinessdirectory'.DS.'tables');
require_once(HELPERS_PATH.'/category_lib.php');

class JBusinessDirectoryModelEvents extends JModelList {
	
	public function __construct() {
		parent::__construct();

		$this->appSettings = JBusinessUtil::getApplicationSettings();
		$jinput = JFactory::getApplication()->input;

		$this->searchFilter = array();
		
		$this->keyword = $jinput->getString('searchkeyword');
		
		$categorySuggestion = $jinput->getInt('categorySuggestion');
		$suggestionType     = $jinput->getInt('suggestionType');
		if (!empty($categorySuggestion)) {
			if ($suggestionType == SUGGESTION_TYPE_CATEGORY) {
				$this->keyword        = '';
				$this->categorySearch = $categorySuggestion;
			}
		}
		
		$this->categoryId = $jinput->getInt('categoryId',null);
		if(empty($this->categoryId)){
			$catId = $jinput->getInt('eventCategoryId',null);
			if(!empty($catId)){
				$this->categoryId = $catId;
			}
		}
		$this->typeSearch = $jinput->getInt('typeSearch',null);
		if (empty($this->categorySearch)){
			$this->categorySearch = $jinput->getId('categorySearch');
		}
		$this->menuCategoryId = $jinput->getString('menuCategoryId',null);
		$this->areaSearch = $jinput->getString('areaSearch',null);
		$this->provinceSearch = $jinput->getString('provinceSearch',null);
		$this->dateRange = explode(':',$jinput->getString('dateRange'));
		
		
		if (count($this->dateRange) == 2) {
			$this->startDate = $this->dateRange[0];
			$this->endDate = $this->dateRange[1];
		} else {
			$this->startDate = $jinput->getString('startDate', null);
			$this->endDate = $jinput->getString('endDate', null);
		}
		
		$this->zipCode = $jinput->getString('zipcode');
		$this->preserve = $jinput->getString('preserve', null);
		$this->companyId = $jinput->getInt('companyId', null);
		$this->citySearch = $jinput->getString('citySearch', null);
		$this->regionSearch = $jinput->getString('regionSearch', null);
		$this->countrySearch = $jinput->getInt('countrySearch', null);
		$this->featured = $jinput->getString('featured', null);
		$this->radius = $jinput->getInt('radius');
		$this->orderBy = $jinput->getString("orderBy", $this->appSettings->order_search_events);
		$this->days = $jinput->getString('days');
        $this->filterByFav = $jinput->getInt('filter-by-fav', null);

        $this->age = $jinput->getInt('age');
        $this->startTime = $jinput->getString('start_time');
        $this->endTime = $jinput->getString('end_time');

		$allowedValues = $this->getSortByConfiguration();
		if (!JBusinessUtil::validateOrderBy($this->orderBy, $allowedValues)) {
			$this->orderBy = $this->appSettings->order_search_events;
		}

		$session = JFactory::getSession();
		$resetSearch = $jinput->getInt('resetSearch', null);
		$this->categories = JFactory::getApplication()->input->getString("categories");
		$session->set('ev-categorySearch', '');

		if (isset($this->categorySearch) && empty($this->categoryId)) {
			$this->categoryId = $this->categorySearch;
		}
		
		if (!empty($this->menuCategoryId) && empty($this->categoryId) && !isset($this->preserve)) {
			$this->categoryId = $this->menuCategoryId;
		}
		
		if (isset($this->categoryId)) {
			$this->categoryId = intval($this->categoryId);
		}
		
		$reload = $jinput->getInt('reload', null);
		if (empty($reload)) {
			if (isset($this->categoryId) || !empty($resetSearch)) {
				$session->set('ev-categorySearch', $this->categoryId);
				$session->set('ev-searchkeyword', "");
				$session->set('ev-typeSearch', "");
				$session->set('ev-startDate', "");
				$session->set('ev-countrySearch', "");
				$session->set('ev-endDate', "");
				$session->set('ev-citySearch', "");
				$session->set('ev-regionSearch', "");
				$session->set('ev-zipcode', "");
				$session->set('ev-provinceSearch', "");
				$session->set('customAtrributes', "");
				$session->set('geo-latitude', "");
				$session->set('geo-longitude', "");
				$session->set('geo-country',"");
				$session->set('geolocation',"");
                $session->set('ev-age',"");
                $session->set('ev-start-time',"");
                $session->set('ev-end-time',"");
                $session->set('ev-filter-by-fav', "");
				$session->set('ev-filterParams', "");
				$session->set('ev-categories',"");
			}
			
			if (!empty($resetSearch)) {
				$session->set('ev-categoryId', $this->categoryId);
			}
			
			$activeMenu = JFactory::getApplication()->getMenu()->getActive();
			if (isset($activeMenu)) {
				$session->set("eventsMenuItemId", $activeMenu->id);
			}
			
			if (isset($this->categoryId)) {
				$this->categoryId = intval($this->categoryId);
				$session->set('ev-categoryId', $this->categoryId);
			}
			
			if (isset($this->typeSearch)) {
				$this->typeSearch = intval($this->typeSearch);
				$session->set('ev-typeSearch', $this->typeSearch);
			}
			
			if (isset($this->startDate)) {
				$session->set('ev-startDate', $this->startDate);
			} elseif (!empty($this->days)) {
				$this->startDate = date($this->appSettings->dateFormat);
				$session->set('ev-startDate', $this->startDate);
			}
			
			if (isset($this->endDate)) {
				$session->set('ev-endDate', $this->endDate);
			} elseif (!empty($this->days)) {
				$this->endDate = date($this->appSettings->dateFormat, strtotime("+$this->days days"));
				$session->set('ev-endDate', $this->endDate);
			}
			
			if (isset($this->keyword)) {
				$this->keyword=trim($this->keyword);
				$session->set('ev-searchkeyword', $this->keyword);
			}

            if (!empty($this->age)) {
                $session->set('ev-age', $this->age);
            }

            if (isset($this->startTime)) {
                $session->set('ev-start-time', $this->startTime);
            }

            if (isset($this->endTime)) {
                $session->set('ev-end-time', $this->endTime);
            }

            if (isset($this->citySearch)) {
				$session->set('ev-citySearch', $this->citySearch);
			}
	
			if (isset($this->provinceSearch)) {
				$session->set('ev-provinceSearch', $this->provinceSearch);
			}
	
			if (isset($this->regionSearch)) {
				$session->set('ev-regionSearch', $this->regionSearch);
			}
	
			if (isset($this->countrySearch)) {
				$this->countrySearch = intval($this->countrySearch);
				$session->set('ev-countrySearch', $this->countrySearch);
			}
			
			if (isset($this->zipCode)) {
				$this->zipCode=trim($this->zipCode);
				$session->set('ev-zipcode', $this->zipCode);
			}
			
			if (isset($this->radius)) {
				$this->radius = intval($this->radius);
				$session->set('ev-radius', $this->radius);
			}

            if (isset($this->filterByFav)) {
                $session->set('ev-filter-by-fav', $this->filterByFav);
            }

			if (isset($this->categories)) {
				$session->set('ev-categories', $this->categories);
			}
		}
		
		$this->categories = $session->get('ev-categories');
		$this->categoryId = $session->get('ev-categoryId');
		$this->keyword = $session->get('ev-searchkeyword');
		$this->startDate = $session->get('ev-startDate');
		$this->typeSearch = $session->get('ev-typeSearch');
		$this->endDate = $session->get('ev-endDate');
		$this->categorySearch = $session->get('ev-categorySearch');
		$this->citySearch = $session->get('ev-citySearch');
		$this->regionSearch = $session->get('ev-regionSearch');
		$this->zipCode = $session->get('ev-zipcode');
		$this->radius = $session->get('ev-radius');
		$this->countrySearch = $session->get('ev-countrySearch');
		$this->provinceSearch = $session->get('ev-provinceSearch');
        $this->filterByFav = $session->get('ev-filter-by-fav');
        $this->age = $session->get('ev-age');
        $this->startTime = $session->get('ev-start-time');
        $this->endTime = $session->get('ev-end-time');
		$this->location = null;

		$geolocation = $jinput->getInt('geolocation', null);
		if (isset($geolocation)) {
			$session->set("geolocation", $geolocation);
		}
		$geolocation = $session->get("geolocation");
		// test if geo location is determined and set location array
		if ($geolocation) {
			$geoLatitutde = $jinput->getString('geo-latitude', null);
			$geoLongitude = $jinput->getString('geo-longitude', null);

			if (!empty($geoLatitutde)) {
				$session->set('geo-latitude', $geoLatitutde);
			}
			if (!empty($geoLongitude)) {
				$session->set('geo-longitude', $geoLongitude);
			}
			$geoLatitutde = $session->get('geo-latitude');
			$geoLongitude = $session->get('geo-longitude');

			if (!empty($geoLatitutde) && !empty($geoLongitude)) {
				$this->location =  array();
				$this->location["latitude"] = $geoLatitutde;
				$this->location["longitude"] = $geoLongitude;
			}
		}
		
		if ($this->appSettings->metric==0) {
			$this->radius  = $this->radius * 0.621371;
		}
		$appSettings = JBusinessUtil::getApplicationSettings();
		$mainframe = JFactory::getApplication();
		$app = JFactory::getApplication();

		// Get pagination request variables
		$limit = $mainframe->getUserStateFromRequest('global.list.limit', 'limit', $appSettings->dir_list_limit, 'int');
		$limitstart = $app->input->getInt('limitstart', 0, 'uint');
		$limitstart = ($limit != 0 ? (floor($limitstart / $limit) * $limit) : 0);

		$this->setState('limit', $limit);
		$this->setState('limitstart', $limitstart);
		
		$this->enablePackages = $appSettings->enable_packages;
		$this->showPendingApproval = ($appSettings->enable_item_moderation=='0' || ($appSettings->enable_item_moderation=='1' && $appSettings->show_pending_approval == '1'));
		
		if (!empty($this->zipCode)) {
			$this->location = JBusinessUtil::getCoordinates($this->zipCode);
		}

		if (!empty($this->location)) {
			$session->set("location", $this->location);
		}

		//prepare custom attributes
		$data = $jinput->post->getArray();
		if (empty($data)) {
			$data = $jinput->get->getArray();
		}

		//custom attributes preparation
		if (isset($this->preserve)) {
			$session->set('customAtrributes', "");
		}

		$this->customAtrributes = array();
		foreach ($data as $key=>$value) {
			if (strpos($key, "attribute")===0) {
				$attributeId = explode("_", $key);
				$attributeId = $attributeId[1];
				if (!empty($value)) {
					$this->customAtrributes[$attributeId] = $value;
				}
				$session->set('customAtrributes', "");
			}
		}

		if (!empty($this->customAtrributes)) {
			foreach ($this->customAtrributes as &$customAttribute) {
				if (is_array($customAttribute)) {
					$customAttribute = implode(",", $customAttribute);
				}
			}

			$session->set('customAtrributes', $this->customAtrributes);
		}

		$this->customAtrributes = $session->get('customAtrributes');
	}

	public function getSearchParameters() {
		$categories = $this->getSelectedCategories();
		$categoryService = new JBusinessDirectorCategoryLib();

		$categoriesIds = array();

		if (!empty($categories) && ($this->appSettings->event_search_type==1 && $this->appSettings->enable_search_filter==1)) {
			foreach ($categories as $category) {
				$categoriesLevel= array();
				$cats = $categoryService->getCategoryLeafs($category, CATEGORY_TYPE_EVENT);
				//dump($category);
				//dump($cats);
				if (isset($cats)) {
					$categoriesLevel = array_merge($categoriesLevel, $cats);
				}
				$categoriesLevel[] = $category;
				$categoriesIds[] = implode(",", $categoriesLevel);
			}
		} elseif (!empty($this->categoryId) && ($this->appSettings->event_search_type==0 || $this->appSettings->enable_search_filter==0)) {
			$categoriesIds = $categoryService->getCategoryLeafs($this->categoryId, CATEGORY_TYPE_EVENT);

			if (isset($this->categoryId) && $this->categoryId !=0) {
				if (isset($categoriesIds) && count($categoriesIds) > 0) {
					$categoriesIds[] = $this->categoryId;
				} else {
					$categoriesIds = array($this->categoryId);
				}
			}
			$categoriesIds = array_filter($categoriesIds);
			$categoriesIds = array(implode(",", $categoriesIds));
		}
		
		$params = $this->getSelectedParams();
		if (isset($params["type"])) {
			$this->typeSearch = $params["type"][0];
		}

		if (isset($params["region"])) {
			$this->regionSearch = $params["region"][0];
		}

		if (isset($params["city"])) {
			$this->citySearch = $params["city"][0];
		}

		if (isset($params["area"])) {
			$this->areaSearch = $params["area"][0];
		}

		if (isset($params["country"])) {
			$this->countrySearch = $params["country"][0];
		}

		if (isset($params["province"])) {
			$this->provinceSearch = $params["province"][0];
		}

		$searchDetails = array();
		$searchDetails["keyword"] = $this->keyword;
		$searchDetails["categoriesIds"] = $categoriesIds;
		$searchDetails["startDate"] = JBusinessUtil::convertToMysqlFormat($this->startDate);
		$searchDetails["endDate"] = JBusinessUtil::convertToMysqlFormat($this->endDate);
		$searchDetails["typeSearch"] = $this->typeSearch;
		$searchDetails["companyId"] = $this->companyId;
		$searchDetails["citySearch"] = $this->citySearch;
		$searchDetails["regionSearch"] = $this->regionSearch;
		$searchDetails["areaSearch"] = $this->areaSearch;
		$searchDetails["facetedSearch"] = $this->appSettings->event_search_type;
		$searchDetails["countrySearch"] = $this->countrySearch;
		$searchDetails["provinceSearch"] = $this->provinceSearch;
		$searchDetails["customAttributes"] = $this->customAtrributes;
        $searchDetails["age"] = $this->age;
        $searchDetails["startTime"] = $this->startTime;
        $searchDetails["endTime"] = $this->endTime;

		if (!empty($this->location)) {
			$searchDetails["latitude"] = $this->location["latitude"];
			$searchDetails["longitude"] = $this->location["longitude"];
		}

		$searchDetails["radius"] = $this->radius;
		$searchDetails["enablePackages"] = $this->enablePackages;
		$searchDetails["showPendingApproval"] = $this->showPendingApproval;
		$searchDetails["orderBy"] = $this->orderBy;
		$searchDetails["multilingual"] = $this->appSettings->enable_multilingual;
		$searchDetails["featured"] = $this->featured;
        $searchDetails["filter-by-fav"] = $this->filterByFav;

		return $searchDetails;
	}
	
	/**
	 * Method to get a cache id based on the search results.
	 *
	 * This is necessary because the different search parameters are used
	 *
	 * @param   string  $id  An identifier string to generate the cache id.
	 *
	 * @return  string  A store id.
	 *
	 * @since   12.2
	 */
	protected function getCacheId($params, $id = '') {
		if (!empty($params)) {
			$params = array_filter($params);
			foreach ($params as $param) {
				if (is_array($param)) {
					$id .= ':'.implode(",", $param);
				} else {
					$id .= ':'.$param;
				}
			}
		}
		// Add the list state to the store id.
		$id .= ':'.$this->getState('limitstart');
		$id .= ':'.$this->getState('limit');
		$id .= ':'.$this->getState('list.ordering');
		$id .= ':'.$this->getState('list.direction');
	
		return md5($this->context . ':' . $id);
	}
	
	public function getTotal() {
		// Load the content if it doesn't already exist
		if (empty($this->_total)) {
			$eventsTable = JTable::getInstance("Event", "JTable");
			$searchDetails = $this->getSearchParameters();

			
			if ($this->appSettings->enable_cache) {
				$cacheIdentifier = $this->getCacheId($searchDetails, "getTotal");
				try {
					$cache = JCache::getInstance();
					$this->_total = $cache->get($cacheIdentifier);
					if (empty($this->_total)) {
						$this->_total = $eventsTable->getTotalEventsByCategories($searchDetails);
						$cache->store($this->_total, $cacheIdentifier);
					}
				} catch (RuntimeException $e) {
					$this->setError($e->getMessage());
					return null;
					;
				}
			}
				
			if (empty($this->_total)) {
				$this->_total = $eventsTable->getTotalEventsByCategories($searchDetails);
			}
		}
		return $this->_total;
	}

	public function getType() {
		$table = $this->getTable("EventType", "JTable");
		$item = $table->getEventType($this->typeSearch);

		return $item;
	}
	
	public function getPagination() {
		// Load the content if it doesn't already exist
		if (empty($this->_pagination)) {
			require_once(HELPERS_PATH.'/dirpagination.php');
			$this->_pagination = new JBusinessDirectoryPagination($this->getTotal(), $this->getState('limitstart'), $this->getState('limit'));
			$this->_pagination->setAdditionalUrlParam('controller', 'search');
			if (!empty($this->categoryId)) {
				$this->_pagination->setAdditionalUrlParam('categoryId', $this->categoryId);
			}
			$this->_pagination->setAdditionalUrlParam('categoryId', $this->categoryId);
			if (!empty($this->categorySearch)) {
				$this->_pagination->setAdditionalUrlParam('categorySearch', $this->categorySearch);
			}
			if (!empty($this->keyword)) {
				$this->_pagination->setAdditionalUrlParam('searchkeyword', $this->keyword);
			}

			$orderBy = JFactory::getApplication()->input->getString("orderBy", $this->appSettings->order_search_events);
			if (!empty($orderBy)) {
				$this->_pagination->setAdditionalUrlParam('orderBy', $orderBy);
			}
				
			if (!empty($this->citySearch)) {
				$this->_pagination->setAdditionalUrlParam('citySearch', $this->citySearch);
			}
				
			if (!empty($this->zipCode)) {
				$this->_pagination->setAdditionalUrlParam('zipcode', $this->zipCode);
			}
				
			if (!empty($this->regionSearch)) {
				$this->_pagination->setAdditionalUrlParam('regionSearch', $this->regionSearch);
			}

			if (!empty($this->countrySearch)) {
				$this->_pagination->setAdditionalUrlParam('countrySearch', $this->countrySearch);
			}

			if (!empty($this->provinceSearch)) {
				$this->_pagination->setAdditionalUrlParam('provinceSearch', $this->provinceSearch);
			}

			if (!empty($this->typeSearch)) {
				$this->_pagination->setAdditionalUrlParam('typeSearch', $this->typeSearch);
			}
				
			if (!empty($this->radius)) {
				$this->_pagination->setAdditionalUrlParam('radius', $this->radius);
			}
			if (!empty($this->startDate)) {
				$this->_pagination->setAdditionalUrlParam('startDate', $this->startDate);
			}
			if (!empty($this->endDate)) {
				$this->_pagination->setAdditionalUrlParam('endDate', $this->endDate);
			}
				
			if (!empty($this->preserve)) {
				$this->_pagination->setAdditionalUrlParam('preserve', $this->preserve);
			}

			if (!empty($this->customAtrributes)) {
				foreach ($this->customAtrributes as $key=>$val) {
					$this->_pagination->setAdditionalUrlParam('attribute_'.$key, $val);
				}
			}
			
			$this->_pagination->setAdditionalUrlParam('view', 'events');
		}
		return $this->_pagination;
	}
	
	public function getItems() {
		$eventsTable = JTable::getInstance("Event", "JTable");
		$searchDetails = $this->getSearchParameters();
		JBusinessUtil::logSearch($searchDetails, SEARCH_LOG_TYPE_EVENT);
		$events = array();
		if ($this->appSettings->enable_cache) {
			$cacheIdentifier = $this->getCacheId($searchDetails, "Items");
			try {
				$cache = JCache::getInstance();
				$events = $cache->get($cacheIdentifier);
				if (empty($events)) {
					$events = $eventsTable->getEventsByCategories($searchDetails, $this->getState('limitstart'), $this->getState('limit'));
					$cache->store($events, $cacheIdentifier);
				}
			} catch (RuntimeException $e) {
				$this->setError($e->getMessage());
				return null;
			}
		}
		
		if (empty($events)) {
			$events = $eventsTable->getEventsByCategories($searchDetails, $this->getState('limitstart'), $this->getState('limit'));
		}
		
		
		if ($this->appSettings->enable_multilingual) {
			JBusinessDirectoryTranslations::updateEventsTranslation($events);
			JBusinessDirectoryTranslations::updateEventTypesTranslation($events);
		}
		
		foreach ($events as $event) {
			if (empty($event->latitude) && empty($event->longitude)) {
				$event->distance = 0;
			}

			if (!empty($event->categories)) {
				$event->categories = explode('#|', $event->categories);
				foreach ($event->categories as &$category) {
					$category = explode("|", $category);
				}

				$maxCategories = !empty($event->categories)?count($event->categories):0;
				if (!empty($this->appSettings->max_categories)) {
					$maxCategories = $this->appSettings->max_categories;
				}

				if (!empty($event->categories)) {
					$event->categories = array_slice($event->categories, 0, $maxCategories);
				}
			}
			
			if (!empty($event->distance) && $this->appSettings->metric == 0) {
				$event->distance = $event->distance * 1.6;
			}
		}

		if ($this->appSettings->mix_results_events && $searchDetails["orderBy"]=="") {
			$events = $this->shuffleEvents($events);
		}
		
		$attributeConfig = JBusinessUtil::getAttributeConfiguration(DEFAULT_ATTRIBUTE_TYPE_EVENT);
		foreach ($events as $event) {
			$event = JBusinessUtil::updateItemDefaultAtrributes($event, $attributeConfig);
		}
		
		JFactory::getApplication()->input->set("event-search-results", $events);
		
		return $events;
	}
		
	/**
	 * Change the order the events within their interval
	 *
	 * @param unknown $items
	 */
	public function shuffleEvents($items){
		$result = array();
		$iResult = array();
		$featured = false;
		
		foreach($items as $item){
			if($item->featured !=$featured ){
				$featured = $item->featured;
				
				shuffle($iResult);
				$result = array_merge($result, $iResult);
				
				//reset the temporary array
				$iResult = array();
			}
			$iResult[] = $item;
		}
		
		shuffle($iResult);
		$result = array_merge($result, $iResult);
		
		return $result;
	}
	

	public function getCustomAttributeValues() {
		$attributeTable = $this->getTable("Attribute", "JTable");

		if (empty($this->customAtrributes)) {
			return null;
		}

		$result = array();

        $customAttributes = $this->customAtrributes;

		//remove string values
		foreach ($customAttributes as $key=>$value) {
			if (is_numeric($value)) {
				$result[$key]=$value;
			}
		}
		$attributeIds = implode(",", $result);
		$customAttributeValues = $attributeTable->getCustomAttributeValues($attributeIds);

		//add string values
		foreach ($customAttributes as $key=>$value) {
			if (!is_numeric($value)) {
				$obj = new stdClass();
				$obj->name = $value;
                $obj->attribute_id = $key;
				$customAttributeValues[]=$obj;
			}
		}

		return $customAttributeValues;
	}
	
	public function getCalendarEvents() {
		$events = $this->getItems();
		
		$calendarEvents = array();
		foreach ($events as $event) {
			$calendarEvent = array();
			$calendarEvent["id"] = $event->id;
			$calendarEvent["title"] = $event->name;
			$calendarEvent["allDay"] = false;
			$calendarEvent["start"] = $event->start_date."T".$event->start_time;
			$calendarEvent["end"] = $event->end_date."T".$event->end_time;
			$calendarEvent["url"] =  JBusinessUtil::getEventLink($event->id, $event->alias);
			$calendarEvent["editable"] = false;
			$calendarEvent["overlap"] = false;
			$calendarEvents[] = $calendarEvent;
		}
		
		return $calendarEvents;
	}

	public function getSeachFilter() {
		if (empty($this->appSettings->event_search_filter_fields)) {
			return;
		}
		
		$searchDetails = $this->getSearchParameters();
		$searchDetailsCategories = $searchDetails["categoriesIds"];
		$mtime = microtime();
		$mtime = explode(" ", $mtime);
		$mtime = $mtime[1] + $mtime[0];
		$starttime = $mtime;

		$searchDetails["facetedSearch"] = $this->appSettings->event_search_type;
		$eventsTable = JTable::getInstance("Event", "JTable");

		if (!empty($this->appSettings->event_search_filter_fields)) {
			$this->appSettings->event_search_filter_fields = explode(",", $this->appSettings->event_search_filter_fields);
		}

		if (in_array("categories", $this->appSettings->event_search_filter_fields)) {
			$categoryService = new JBusinessDirectorCategoryLib();
			$category = array();
			if (!empty($this->categoryId)  && $this->appSettings->event_search_type != 1) {
				$category = $categoryService->getCompleteCategoryById($this->categoryId, CATEGORY_TYPE_EVENT);
			} else {
				$category["subCategories"] = $categoryService->getCategories(CATEGORY_TYPE_EVENT);
				$category["path"] = array();
			}
			
			if (empty($category["subCategories"]) && !empty($category[0])) {
				$searchDetails["categoriesIds"] = array($category[0]->parent_id);
			}

			if ($this->appSettings->event_search_type == 1) {
				$searchDetails["categoriesIds"] = null;
			}
			
			$categoriesTotal = $eventsTable->getTotalEventsByObject($searchDetails, 'category');
			
			if (empty($categoriesTotal) && !(empty($category["subCategories"]) && !empty($category[0])) && $this->appSettings->event_search_type != 1) {
				if (isset($category[0]) && $category[0]->parent_id != 1) {
					$category = $categoryService->getCompleteCategoryById($category[0]->parent_id, CATEGORY_TYPE_EVENT);
				} else {
					$category["subCategories"] = $categoryService->getCategories(CATEGORY_TYPE_EVENT);
					$category["path"] = array();
				}
				
				if (isset($category[0])) {
					$searchDetails["categoriesIds"] = array($category[0]->parent_id);
				}
				$categoriesTotal = $eventsTable->getTotalEventsByObject($searchDetails, 'category');
			}
			$subcategories = '';
			$enableSelection = false;

			if ($this->appSettings->enable_multilingual) {
				$categoryTranslations = JBusinessDirectoryTranslations::getCategoriesTranslations();
				foreach ($category["path"] as &$path) {
					if (!empty($categoryTranslations[$path[0]])) {
						$path[1] = $categoryTranslations[$path[0]]->name;
					}
				}
			}

			if (isset($category["path"])) {
				$this->searchFilter["path"] = $category["path"];
			}
			
			if (isset($category["subCategories"]) && count($category["subCategories"]) > 0) {
				$subcategories = $category["subCategories"];
			} else {
				if (!empty($category["path"])) {
					$parentCategories = $category["path"];

					if ($category[0]->parent_id == 1) {
						$subcategories = $categoryService->getCategories(CATEGORY_TYPE_EVENT);
						$this->searchFilter["enableSelection"] = 1;
						$enableSelection = true;
					} elseif (count($parentCategories) > 0) {
						$categoryId = $parentCategories[count($parentCategories)][0];
						//dump($categoryId);
						$parentCategory = $categoryService->getCompleteCategoryById($categoryId, CATEGORY_TYPE_EVENT);
						$subcategories = $parentCategory["subCategories"];
						$this->searchFilter["enableSelection"] = 1;
						$enableSelection = true;
					}
				}
			}

			if (!empty($subcategories)) {
				if ($this->appSettings->enable_multilingual) {
					JBusinessDirectoryTranslations::updateCategoriesTranslation($subcategories);
				}
				foreach ($subcategories as $cat) {
					if (!is_array($cat)) {
						continue;
					}

					$childCategoryIds = $categoryService->getCategoryChilds($cat);
					if (count($childCategoryIds) == 0) {
						$childCategoryIds = array($cat[0]->id);
					} else {
						$mainCat = array($cat[0]->id);
						$childCategoryIds = array_merge($mainCat, $childCategoryIds);
						//$childCategoryIds[] = $cat[0]->id;
					}

					$companiesNumber = 0;
					foreach ($categoriesTotal as $categoryTotal) {
						if (in_array($categoryTotal->id, $childCategoryIds)) {
							$companiesNumber += $categoryTotal->nr_events;
						}
					}

					if ($companiesNumber > 0 || $enableSelection) {
						$this->searchFilter["categories"][] = array($cat, $companiesNumber);
					}
				}
			}
			$searchDetails["categoriesIds"] = $searchDetailsCategories;
			$searchDetails["facetedSearch"] = 0;

			if (!empty($this->searchFilter["categories"]) && $this->appSettings->category_order == ORDER_ALPHABETICALLY) {
				$this->searchFilter["categories"] = $categoryService->sortCategories($this->searchFilter["categories"], false, false);
			}
		}

		if (in_array("area", $this->appSettings->event_search_filter_fields)) {
			$areasTotal = $eventsTable->getTotalEventsByObject($searchDetails, "area");
			$areas = array();
			if (!empty($areasTotal)) {
				foreach ($areasTotal as $area) {
					if (!empty($area->areaName)) {
						if (!isset($areas[$area->areaName])) {
							$areas[$area->areaName] = $area;
							$areas[$area->areaName]->nr_events = (int)$area->nr_events;
						} else {
							$areas[$area->areaName]->nr_events += $area->nr_events;
						}
					}
				}
			}
			$this->searchFilter["areas"] = $areas;
		}

		if (in_array("countries", $this->appSettings->event_search_filter_fields)) {
			$countriesTotal = $eventsTable->getTotalEventsByObject($searchDetails, "country");
			$countries = array();
			foreach ($countriesTotal as $country) {
				if (!empty($country->countryName)) {
					if (!isset($countries[$country->countryId])) {
						$countries[$country->countryId] = $country;
						$countries[$country->countryId]->nr_events = (int)$country->nr_events;
					} else {
						$countries[$country->countryId]->nr_events += $country->nr_events;
					}
				}
			}

			if ($this->appSettings->enable_multilingual) {
				foreach ($countries as $countryData) {
					$country = new stdClass();
					$country->id = $countryData->countryId;
					$country->country_name = $countryData->countryName;

					JBusinessDirectoryTranslations::updateEntityTranslation($country, COUNTRY_TRANSLATION);
					$countryData->countryName = $country->country_name;
				}
			}

			$this->searchFilter["countries"] = $countries;
		}

		if (in_array("cities", $this->appSettings->event_search_filter_fields)) {
			$citiesTotal = $eventsTable->getTotalEventsByObject($searchDetails, "city");
			$cities = array();
			foreach ($citiesTotal as $city) {
				if (!empty($city->cityName)) {
					if (!isset($cities[$city->cityName])) {
						$cities[$city->cityName] = $city;
						$cities[$city->cityName]->nr_events = (int)$city->nr_events;
					} else {
						$cities[$city->cityName]->nr_events += $city->nr_events;
					}
				}
			}

			$this->searchFilter["cities"] = $cities;
		}

		if (in_array("regions", $this->appSettings->event_search_filter_fields)) {
			$regionsTotal = $eventsTable->getTotalEventsByObject($searchDetails, "region");
			$regions = array();
			foreach ($regionsTotal as $region) {
				if (!empty($region->regionName)) {
					if (!isset($regions[$region->regionName])) {
						$regions[$region->regionName] = $region;
						$regions[$region->regionName]->nr_events = (int)$region->nr_events;
					} else {
						$regions[$region->regionName]->nr_events += $region->nr_events;
					}
				}
			}

			$this->searchFilter["regions"] = $regions;
		}

		if (in_array("types", $this->appSettings->event_search_filter_fields)) {
			$typesTotal = $eventsTable->getTotalEventsByObject($searchDetails, "type");
			$types = array();
			if (!empty($typesTotal)) {
				if ($this->appSettings->enable_multilingual) {
					JBusinessDirectoryTranslations::updateEventTypesTranslation($typesTotal);
				}
				foreach ($typesTotal as $type) {
					if (!empty($type->typeName)) {
						if (!isset($types[$type->typeId])) {
							$types[$type->typeId] = $type;
							$types[$type->typeId]->nr_events = (int)$type->nr_events;
						} else {
							$types[$type->typeId]->nr_events += $type->nr_events;
						}
					}
				}
			}
			$this->searchFilter["types"] = $types;
		}

//		$mtime = microtime();
//	    $mtime = explode(" ",$mtime);
//	    $mtime = $mtime[1] + $mtime[0];
//	    $endtime = $mtime;
//	    $totaltime = ($endtime - $starttime);
		//echo "This function was done in ".$totaltime." seconds";
		
		// dump($this->searchFilter);
		return $this->searchFilter;
	}

	public function getSelectedParams() {
		$session = JFactory::getSession();

		$params = array();
		$values = array();
		$input = JFactory::getApplication()->input;
		$this->letter = $input->getString("letter");
		$selectedParams = $input->getString("selectedParams");

		if (empty($selectedParams)) {
			$selectedParams = $session->get("ev-filterParams");
		}

		if (!empty($selectedParams)) {
			$session->set("ev-filterParams", $selectedParams);
			$values = explode(";", $selectedParams);
		}

		foreach ($values as $val) {
			$temp = explode("=", $val);
			if (!isset($params[$temp[0]])) {
				$params[$temp[0]] = array();
			}

			if (!empty($temp[0])) {
				array_push($params[$temp[0]], $temp[1]);
			}
		}

		if (!empty($this->categoryId) && !isset($params["category"])) {
			$params["category"][] = $this->categoryId;
		}

		if (!empty($this->regionSearch) && !isset($params["region"])) {
			$params["region"][] = $this->regionSearch;
		}

		if (!empty($this->citySearch) && !isset($params["city"])) {
			$params["city"][] = $this->citySearch;
		}

		if (!empty($this->typeSearch) && !isset($params["type"])) {
			$params["type"][] = $this->typeSearch;
		}

		if (!empty($this->areaSearch) && !isset($params["area"])) {
			$params["area"][] = $this->areaSearch;
		}

		if (!empty($this->countrySearch) && !isset($params["country"])) {
			$params["country"][] = $this->countrySearch;
		}

		if (!empty($this->provinceSearch) && !isset($params["province"])) {
			$params["province"][] = $this->provinceSearch;
		}

		foreach ($params as $param) {
			if (in_array('', $param)) {
				unset($param[array_search('', $param)]);
			}
		}

		if (in_array('', $params)) {
			unset($params[array_search('', $params)]);
		}

		$params["selectedParams"] = $selectedParams;

		return $params;
	}

	public function getSelectedCategories() {

		$categories = array();
		$session = JFactory::getSession();

		$selectedCat = $session->get("ev-categories", null);
		if (empty($selectedCat)) {
			$selectedCat = JFactory::getApplication()->input->getString("categories");
		}

		if (!empty($selectedCat)) {
			$categories = explode(";", $selectedCat);
		}
		
		if (!empty($this->categoryId) && empty($selectedCat)) {
			$categories[]=$this->categoryId;
		}
		
		if (in_array('', $categories)) {
			unset($categories[array_search('', $categories)]);
		}

		return $categories;
		
	}
	
	public function getCategories() {
		$categoryService = new JBusinessDirectorCategoryLib();
		return $categoryService->getCategories(CATEGORY_TYPE_EVENT);
	}
	
	public function getLocation() {
		return $this->location;
	}
	
	public function getCategoryId() {
		return $this->categoryId;
	}
	
	public function getCategory() {
		$categoryTable = $this->getTable("Category", "JBusinessTable");
		$category = $categoryTable->getCategoryById($this->categoryId);
	
		if ($this->appSettings->enable_multilingual) {
			JBusinessDirectoryTranslations::updateEntityTranslation($category, CATEGORY_TRANSLATION);
		}
		
		return $category;
	}

	public function getEventType() {
		$type = null;
		if (!empty($this->typeSearch)) {
			$eventTypesTable = $this->getTable("EventType", "JTable");
			$type = $eventTypesTable->getEventType($this->typeSearch);

			if ($this->appSettings->enable_multilingual) {
				JBusinessDirectoryTranslations::updateEntityTranslation($type, TYPE_TRANSLATION);
			}
		}
		return $type;
	}
	
	public function getSortByConfiguration() {
		$states = array();
		$state = new stdClass();
		$state->value = '';
		$state->text = JTEXT::_("LNG_RELEVANCE");
		$states[] = $state;
		$state = new stdClass();
		$state->value = 'id desc';
		$state->text = JTEXT::_("LNG_LAST_ADDED");
		$states[] = $state;
		$state = new stdClass();
		$state->value = 'id asc';
		$state->text = JTEXT::_("LNG_FIRST_ADDED");
		$states[] = $state;
		$state = new stdClass();
		$state->value = 'start_date asc';
		$state->text = JTEXT::_("LNG_EARLIEST_DATE");
		$states[] = $state;
		$state = new stdClass();
		$state->value = 'start_date desc';
		$state->text = JTEXT::_("LNG_LATEST_DATE");
		$states[] = $state;
		$state = new stdClass();
		$state->value = 'name';
		$state->text = JTEXT::_("LNG_NAME");
		$states[] = $state;
		$state = new stdClass();
		$state->value = 'city';
		$state->text = JTEXT::_("LNG_CITY");
		$states[] = $state;
		$state = new stdClass();
		$state->value = 'distance asc';
		$state->text = JTEXT::_("LNG_DISTANCE");
		$states[] = $state;
	
		return $states;
	}

	public function getCountry() {
		$country = null;
		if (!empty($this->countrySearch)) {
			$countryTable = $this->getTable("Country", "JTable");
			$country =  $countryTable->getCountry($this->countrySearch);
			if ($this->appSettings->enable_multilingual) {
				JBusinessDirectoryTranslations::updateEntityTranslation($country, COUNTRY_TRANSLATION);
			}
		}

		return $country;
	}
	
	/**
	 * Generate the next 12 months with name, start date and end date
	 * @return stdClass[]
	 */
	 
	public function getFilterMonths() {
		$months = array();
		$currentMonth = (int)date('m');
		
		for ($x = $currentMonth; $x < $currentMonth + 12; $x++) {
			$month = new stdClass();
			$date = JFactory::getDate(mktime(0, 0, 0, $x, 10));
			$month->name = $date->format('F Y');
			$month->start_date = date('Y-m-01', mktime(0, 0, 0, $x, 1));
			$month->end_date = date('Y-m-t', mktime(0, 0, 0, $x, 1));
			$months[] = $month;
		}
		
		return $months;
	}
}
