<?php
/**
 * @package    JBusinessDirectory
 *
 * @author CMSJunkie http://www.cmsjunkie.com
 * @copyright  Copyright (C) 2007 - 2021 CMSJunkie. All rights reserved.
 * @license   https://www.gnu.org/licenses/agpl-3.0.en.html
 */

defined('_JEXEC') or die('Restricted access');
$appSettings = JBusinessUtil::getApplicationSettings();
$enablePackages = $appSettings->enable_packages;
$user = JBusinessUtil::getUser();
$showData = !($user->id==0 && $appSettings->show_details_user == 1);

$mapHeight = "100%";
?>
<style>
    #sp-main-body, #sp-component{
        padding: 0 !important;
    }

</style>

<div id="map-view-container" class="list-style-4" <?php echo $appSettings->search_view_mode?'style="display: none"':'' ?>>
    <div class="row m-0">
        <div id="map-listing-container" class="col-md-6 p-0" itemscope itemtype="http://schema.org/ItemList">
			<div class="search-header">
                <div class="jbd-search-statistics">
            		<div class="search-keyword">
                        <div class="result-counter"><?php echo $this->pagination->getResultsCounter()?></div>
                    </div>
                    <div>
                        <div class="search-options">
                                <div class="jbd-select-box">
                                    <i class="la la-sort"></i>
                                    <select name="orderBy" class="chosen jbd-select" onchange="jbdUtils.changeOrder(this.value)">
                                        <?php echo JHtml::_('select.options', $this->sortByOptions, 'value', 'text', $this->orderBy);?>
                                    </select>
                                </div>
                                
                            <?php if ($appSettings->search_result_view != 5) { ?>
                                <?php if ($appSettings->show_grid_list_option == 1) { ?>
                                	<div class="view-mode">
										<a id="grid-view-link" class="grid" href="javascript:jbdListings.showGrid()"><i class="icon grid"></i></a>
										<a id="list-view-link" class="list active" href="javascript:jbdListings.showList()"><i class="la la-list"></i></a>
									</div>
                                <?php } ?>

                                <?php if ($appSettings->show_search_map && $this->defaultAttributes['map'] != ATTRIBUTE_NOT_SHOW) { ?>
                                	<div class="map-view">
                                        <a id="map-link" class="map <?php echo $appSettings->map_auto_show != 1 ? 'active' : '' ?>" title="Grid" href="javascript:showMap(true)">
                                            <i class="la la-map"></i></a>
                                     </div>
                                <?php } ?>
                            <?php } ?>
                        </div>
                    </div>
                </div>
                
                <div id="search-filters-react">
                </div>
            </div>
                
            <div class="px-5">          	      
                <div class="row">
    				<?php
					if (isset($this->companies)) {
						$itemCount = 1;
						foreach ($this->companies as $company) {
							$showOnMap = (!empty($company->latitude) && !empty($company->longitude) && $showData && (isset($company->packageFeatures) && in_array(GOOGLE_MAP, $company->packageFeatures) || !$appSettings->enable_packages)); ?>
    			    <div class="col-md-6 py-3">
                        <div id="company<?php echo $company->id ?>" class="grid-item-holder" itemscope
                             itemprop="itemListElement" itemtype="http://schema.org/ListItem">
                            <span style="display:none;" itemprop="position"><?php echo $itemCount ?></span>
                                <span itemscope itemprop="item" itemtype="http://schema.org/Organization">
                                    <div class="card place-card <?php echo isset($company->featured) && $company->featured == 1 ? "featured" : "" ?>">
        								<div class="place-card-body">
                                            <?php if ($this->defaultAttributes["logo"]!=ATTRIBUTE_NOT_SHOW && (isset($company->packageFeatures) && in_array(SHOW_COMPANY_LOGO, $company->packageFeatures) || !$enablePackages)) { ?>
    	                                        <?php if (!empty($company->logoLocation)) { ?>
                                                    <img title="<?php echo $this->escape($company->name) ?>"
                                                         alt="<?php echo $this->escape($company->name) ?>"
                                                         src="<?php echo BD_PICTURES_PATH . $company->logoLocation ?>"
                                                         itemprop="contentUrl">
    	                                        <?php } else { ?>
                                                    <img title="<?php echo $this->escape($company->name) ?>"
                                                         alt="<?php echo $this->escape($company->name) ?>"
                                                         src="<?php echo BD_PICTURES_PATH . '/no_image.jpg' ?>"
                                                         itemprop="contentUrl">
    	                                        <?php } ?>
    
                                            <?php } else { ?>
                                                <a <?php echo $newTab; ?> href="<?php echo JBusinessUtil::getCompanyLink($company) ?>"></a>
                                                <img title="<?php echo $this->escape($company->name) ?>"
                                                     alt="<?php echo $this->escape($company->name) ?>"
                                                     src="<?php echo BD_PICTURES_PATH . '/no_image.jpg' ?>">
                                            <?php } ?>
    
                                            <div class="card-hoverable">
        										<div>
            										<?php
													$address = JBusinessUtil::getShortAddress($company);
							if (!empty($company->bestMatchLocation)) {
								$address = $company->bestMatchLocation;
							} ?>
    											    <?php if (!empty($address)) { ?>
                                                        <div>
                                                            <i class="icon map-marker"></i> <span itemprop="address"><?php echo $address ?></span>
                                                        </div>
    											    <?php } ?>
    											    <?php if ($showData && !empty($company->phone) && (isset($company->packageFeatures) && in_array(PHONE, $company->packageFeatures) || !$enablePackages)) { ?>
                                                        <div itemprop="telephone">
                                                            <i class="icon phone-o"></i> <?php echo $company->phone ?>
                                                        </div>
    											    <?php } ?>
    											    <?php if ($showData && !empty($company->website) && (isset($company->packageFeatures) && in_array(WEBSITE_ADDRESS, $company->packageFeatures) || !$enablePackages)) {
								if ($appSettings->enable_link_following) {
									$followLink = (isset($company->packageFeatures) && in_array(LINK_FOLLOW, $company->packageFeatures) && $enablePackages) ? 'rel="follow noopener"' : 'rel="nofollow noopener"';
								} else {
									$followLink ='rel="noopener"';
								} ?>
                                                        <div>
                                                            <a target="_blank" <?php echo $followLink ?>
                                                               class="company-website"
                                                               title="<?php echo $this->escape($company->name) ?>"
                                                               onclick="jbdUtils.registerStatAction(<?php echo $company->id ?>,<?php echo STATISTIC_ITEM_BUSINESS ?>,<?php echo STATISTIC_TYPE_WEBSITE_CLICK ?>)"
                                                               href="<?php echo $this->escape($company->website) ?>"><i
                                                                        class="icon globe"></i> <?php echo $this->escape($company->website) ?></a>
                                                        </div>
    											    <?php
							} ?>
                                                    <span style="display:none;"
                                                          itemprop="url"><?php echo JBusinessUtil::getCompanyLink($company) ?></span>
    
    											    <?php if (!empty($company->distance)) { ?>
                                                        <div>
                                                            <?php echo JText::_("LNG_DISTANCE") . ": " . round($company->distance, 1) . " " . ($appSettings->metric == 1 ? JText::_("LNG_MILES") : JText::_("LNG_KM")) ?>
                                                        </div>
    											    <?php } ?>
                                                    <div class="item-vertical-middle">
                                                        <a <?php echo $newTab; ?> href="<?php echo JBusinessUtil::getCompanyLink($company) ?>"
                                                           class="btn btn-outline-success btn-sm w-auto"><?php echo JText::_("LNG_VIEW") ?></a>
    												    <?php if ($showOnMap) { ?>
                                                            <a href="#"
                                                               class="btn btn-outline-success btn-sm w-auto show-marker"><?php echo JText::_("LNG_SHOW_ON_MAP") ?></a>
    												    <?php } ?>
                                                    </div>
    											    <?php if ($showOnMap) { ?>
                                                    <div
        	                                                <a target="_blank" class="nowrap"
                                                               href="<?php echo JBusinessUtil::getDirectionURL($this->location, $company) ?>"><?php echo JText::_("LNG_GET_MAP_DIRECTIONS") ?></a>
                                                    	</div>
    										    <?php } ?>
                                            	</div>
        	                                </div>
                                        </div>
                                        <div class="place-card-info">
        									<div class="place-card-info-title">
        										<a <?php echo $newTab; ?> href="<?php echo JBusinessUtil::getCompanyLink($company) ?>"><span
                                                            itemprop="name"><?php echo $company->name ?></span></a>
    										    <?php if ($appSettings->enable_ratings) { ?>
                                                    <span title="<?php echo $company->review_score ?>"
                                                          class="rating-review"></span>
    										    <?php } ?>
        									</div>
    	                                    <?php if (!empty($company->mainCategoryIcon) && $company->mainCategoryIcon!="None" || !empty($company->categoryIconImage)) { ?>
                                                <?php $attributes="bg-warning rounded-circle"; ?>
                                                <?php echo JBusinessUtil::renderCategoryIcon($company->mainCategoryIcon, $company->categoryIconImage, $attributes) ?>
    	                                    <?php } ?>
        								</div>
                        </div>
                        <span style="display:none;" itemprop="position"><?php echo $itemCount ?></span>
                        </span>
                    </div>
                </div>
    			<?php $itemCount++; ?>
    			<?php
						} ?>
    			<?php
					} ?>
            </div>
        </div>
    </div>

    <div class="col-md-6 map-view p-0 <?php echo isset($isFixedMapLayout) ? 'map-fixed-right' : '' ?>">
            <div id="style5-map-container">
                <?php require JPATH_COMPONENT_SITE . '/include/search-map.php' ?>
            </div>
    </div>
</div>

<script>
window.addEventListener('load', function() {

    <?php if (isset($isFixedMapLayout)) { ?>
        jQuery('#sp-main-body .container').removeClass('container').addClass('container-fluid');
        jQuery('#sp-bottom').css('position', 'relative');
        jQuery('#sp-bottom').css('z-index', '10');
        jQuery('#sp-footer').css('position', 'relative');
        jQuery('#sp-footer').css('z-index', '10');
        jQuery('#sp-header').css('z-index', '10');
    <?php } ?>

    <?php if ($appSettings->enable_ratings) {?>
        jbdListings.renderGridReviewRating();
    <?php } ?>

	<?php if (isset($isFixedMapLayout)) { ?>
        let style5MapInstance = JBDMapHelper.getMapInstance(<?php echo $mapIdStyle5 ?>);
        style5MapInstance.setMapWidth('100%');
        style5MapInstance.setMapHeight('100%');
    <?php } ?>

	if(jQuery(window).width()>1024){
	    //TODO commented this line out, is this still needed?
	    // var height = jQuery(window).height();

	    var height = '100%';
		<?php if (isset($isFixedMapLayout)) { ?>
            height='100%';
        <?php } ?>

        jQuery("#map-listing-container").height(height);
		jQuery("#style5-map-container").height(height);
    	jQuery(window).scroll(function(){
    		var menuTop = jQuery("#sp-header-sticky-wrapper").height();
    		var containerTop = jQuery("#map-listing-container").offset().top;
    		var containerBottom= jQuery("#map-listing-container").offset().top + jQuery("#map-listing-container").height();
    		var mapContainerBottom = jQuery("#style5-map-container").offset().top+ jQuery("#style5-map-container").height();

    		if(!menuTop){
    			menuTop = 90;
    		}

    		if(containerBottom<mapContainerBottom){
    			menuTop = 20 - (mapContainerBottom - containerBottom);
    		}
    		jQuery("#style5-map-container").css("top",Math.max(menuTop, containerTop-jQuery(this).scrollTop()));

    	});

    	var width = jQuery(".map-view").width();
		<?php if (isset($isFixedMapLayout)) { ?>
            width = '100%';
        <?php } ?>

    	 jQuery("#style5-map-container").width(width);
	} else {
		jQuery("#style5-map-container").height(400);
	}
});

<?php if (isset($isFixedMapLayout)) { ?>
    jQuery(document).scroll(function() {
        checkOffset();
    });

function checkOffset() {
    if(jQuery(window).scrollTop() == 0 || jQuery(window).scrollTop() == jQuery(document).height()- jQuery(window).height()) {
        jQuery('.map-view').css('top', '100px');
    } else {
        jQuery('.map-view').css('top', '74px');
    }
}
<?php } ?>

</script>