<?php

/**
 * @package    JBusinessDirectory
 *
 * @author CMSJunkie http://www.cmsjunkie.com
 * @copyright  Copyright (C) 2007 - 2021 CMSJunkie. All rights reserved.
 * @license   https://www.gnu.org/licenses/agpl-3.0.en.html
 */
defined('_JEXEC') or die('Restricted access');

require_once BD_CLASSES_PATH . '/attributes/attributeservice.php';

$appSettings = JBusinessUtil::getApplicationSettings();
$enableSEO = $appSettings->enable_seo;
$enablePackages = $appSettings->enable_packages;
$enableRatings = $appSettings->enable_ratings;
$enableNumbering = $appSettings->enable_numbering;
$user = JBusinessUtil::getUser();

$limitStart = JFactory::getApplication()->input->get('limitstart');
if (empty($limitStart)) {
	$limitStart = 0;
}

if(!$appSettings->lazy_loading) {
    $total_page_string = $this->pagination->getPagesCounter();
    $current_page = substr($total_page_string, 5, 1);
    if (($current_page === 1) || $total_page_string==null) {
        $limitStart = 0;
    }
}


$showData = !($user->id == 0 && $appSettings->show_details_user == 1);
?>

<div id="jbd-results-container" itemscope itemtype="http://schema.org/ItemList" class="list-style-3" <?php echo $appSettings->search_view_mode?'style="display: none"':'' ?>>
    <?php
    if (!empty($this->companies)) {
        $itemCount = 0;
        foreach ($this->companies as $index => $company) {
            $address = JBusinessUtil::getAddressText($company);
            if (!empty($company->bestMatchLocation)) {
                $address = $company->bestMatchLocation;
                $address .= " <a target=\"_blank\" href=\"" . JBusinessUtil::getCompanyLink($company) . "\"> (" . JText::_("LNG_VIEW_ALL_LOCATIONS") . ")</a>";
            } ?>
            <?php
            if (!empty($searchModules) && isset($searchModules[$index])) {
                foreach ($searchModules[$index] as $module) {
            ?>
                    <div class="search-result-module">
                        <?php echo JModuleHelper::renderModule($module, array("style"=>"xhtml")); ?>
                    </div>
            <?php
                }
            } ?>
            <div class="result-item <?php echo isset($company->featured) && $company->featured == 1 ? "featured" : "" ?>" style="<?php echo !empty($company->featured) && !empty($appSettings->listing_featured_bg) ? "background-color: $appSettings->listing_featured_bg" : "" ?>">
                <div itemscope itemprop="itemListElement" itemtype="http://schema.org/ListItem">
                    <span style="display:none;" itemprop="position"><?php echo $itemCount ?></span>
                    <div itemscope itemprop="item" itemtype="http://schema.org/Organization">
                        <div class="row">
                            <?php if (!empty($company->featured)) { ?>
                                <?php if ($this->defaultAttributes["logo"] != ATTRIBUTE_NOT_SHOW && (isset($company->packageFeatures) && in_array(SHOW_COMPANY_LOGO, $company->packageFeatures) || !$enablePackages)) { ?>
                                    <div class="col-lg-3">
                                        <div class="item-image" itemprop="logo" itemscope itemtype="http://schema.org/ImageObject">
                                            <a <?php echo $newTab; ?> href="<?php echo JBusinessUtil::getCompanyLink($company) ?>">
                                                <?php if (!empty($company->logoLocation)) { ?>
                                                    <img title="<?php echo $this->escape($company->name) ?>" alt="<?php echo $this->escape($company->name) ?>" src="<?php echo BD_PICTURES_PATH . $company->logoLocation ?>" itemprop="contentUrl" />
                                                <?php } else { ?>
                                                    <img title="<?php echo $this->escape($company->name) ?>" alt="<?php echo $this->escape($company->name) ?>" src="<?php echo BD_PICTURES_PATH . '/no_image.jpg' ?>" itemprop="contentUrl" />
                                                <?php } ?>
                                            </a>
                                            <?php if (!empty($company->featured)) { ?>
                                                <div class="featured-text">
                                                    <?php echo JText::_("LNG_FEATURED") ?>
                                                </div>
                                            <?php } ?>
                                        </div>
                                    </div>
                                <?php } ?>
                            <?php } ?>
                            <div class="col-lg">
                                <div class="result-content">
                                    <?php if (!empty($company->featured)) { ?>
                                        <div class="company-rating" <?php echo !$enableRatings ? 'style="display:none"' : '' ?>>
                                            <?php if ($appSettings->enable_ratings) { ?>
                                                <div class="rating">
                                                    <p class="rating-average" title="<?php echo $company->review_score ?>" id="<?php echo $company->id ?>" style="display: block;"></p>
                                                </div>
                                                <div class="review-count">
                                                    <a <?php echo $company->review_score == 0 ? 'style="display:none"' : '' ?>></a>
                                                </div>
                                            <?php } ?>
                                        </div>
                                    <?php } ?>
                                    <h3 class="item-name">
                                        <a <?php echo $newTab; ?> href="<?php echo JBusinessUtil::getCompanyLink($company) ?>"><?php echo $enableNumbering ? "<span>" . ($index + $limitStart + 1) . ". </span>" : "" ?><span itemprop="name"><?php echo $company->name ?> </span></a>
                                        <?php if (!empty($company->recommended) && $appSettings->show_recommended) { ?>
                                            <div class="recommended" title="<?php echo JText::_("LNG_RECOMMENDED") ?>"><i class="la la-check"></i> </div>
                                        <?php } ?>
                                    </h3>
                                    <span style="display:none;" itemprop="url"><?php echo JBusinessUtil::getCompanyLink($company) ?></span>

                                    <?php if (!empty($address)) { ?>
                                        <div class="company-address">
                                            <span itemprop="address"><?php echo JBusinessUtil::getAddressText($company) ?></span>
                                        </div>
                                    <?php } ?>

                                    <?php if (!empty($company->distance)) { ?>
                                        <div class="item-element">
                                            <?php echo JText::_("LNG_DISTANCE") . ": " . round($company->distance, 1) . " " . ($appSettings->metric == 1 ? JText::_("LNG_MILES") : JText::_("LNG_KM")) ?>
                                        </div>
                                    <?php } ?>

                                    <div class="item-element pt-3">
                                        <ul class="horizontal-list item-actions">
                                            <?php if (!empty($company->email) && !empty($company->featured)) { ?>
                                                <?php if ($showData && (isset($company->packageFeatures) && in_array(CONTACT_FORM, $company->packageFeatures) || !$enablePackages)) { ?>
                                                    <?php if ($appSettings->show_contact_form) { ?>
                                                        <li><a href="javascript:jbdListings.showContactCompanyList(<?php echo $company->id ?>,<?php echo $showData ? "1" : "0" ?>, '<?php echo $company->name ?>', '<?php echo $company->logoLocation ?>', <?php echo $company->review_score ?>)"><?php echo JText::_('LNG_CONTACT') ?></a></li>
                                                    <?php } ?>

                                                    <?php if ($appSettings->enable_request_quote) { ?>
                                                        <li><a href="javascript:jbdListings.showQuoteCompany(<?php echo $company->id ?>,<?php echo $showData ? "1" : "0" ?>)"><?php echo JText::_('LNG_QUOTE') ?></a></li>
                                                    <?php } ?>
                                                <?php } ?>
                                            <?php } ?>

                                            <?php if (!empty($company->latitude) && !empty($company->longitude) && $showData && (isset($company->packageFeatures) && in_array(GOOGLE_MAP, $company->packageFeatures) || !$enablePackages)) { ?>
                                                <li><a target="_blank" href="<?php echo JBusinessUtil::getDirectionURL($this->location, $company) ?>"><?php echo JText::_("LNG_GET_MAP_DIRECTIONS") ?></a></li>
                                            <?php } ?>
                                            <li><a <?php echo $newTab; ?> href="<?php echo JBusinessUtil::getCompanyLink($company) ?>"><?php echo JText::_('LNG_MORE_INFO') ?></a></li>
                                            <?php if ($appSettings->show_contact_cards) { ?>
                                                <li><a rel="nofollow" href="<?php echo JRoute::_("index.php?option=com_jbusinessdirectory&task=companies.generateQrCode&itemId=" . $company->id); ?>"><?php echo JText::_("LNG_QR_CODE") ?></a></li>
                                                <li><a rel="nofollow" href="<?php echo JRoute::_("index.php?option=com_jbusinessdirectory&task=companies.generateVCard&itemId=" . $company->id); ?>"><?php echo JText::_("LNG_VCARD") ?></a></li>
                                            <?php } ?>
                                        </ul>
                                    </div>

                                  
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12">
                                <div class=" item-element company-short-description">
                                    <?php echo $company->short_description ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <?php $itemCount++; ?>
        <?php
        } ?>
    <?php
    } ?>
</div>