<?php
/**
 * @package    JBusinessDirectory
 *
 * @author CMSJunkie http://www.cmsjunkie.com
 * @copyright  Copyright (C) 2007 - 2021 CMSJunkie. All rights reserved.
 * @license   https://www.gnu.org/licenses/agpl-3.0.en.html
 */
defined('_JEXEC') or die('Restricted access');
$idnt = rand(500, 1500);
$enablePackages = $appSettings->enable_packages;

?>
<?php if (!$showOnlyItems) { ?>
<div class="jbd-grid-container list-grid-2">
	<div class="row">
	<?php }
		if (isset($this->companies)) {
			$index = 0;
			foreach ($this->companies as $index => $company) {
				$followLink ='rel="noopener"';
				if ($appSettings->enable_link_following) {
					$followLink = (isset($company->packageFeatures) && in_array(LINK_FOLLOW, $company->packageFeatures) ||  !$enablePackages) ? 'rel="follow noopener"' : 'rel="nofollow noopener"';
				}
				$index++; ?>
    	<div class="col-lg-4 col-sm-6 col-12">
        	<div class="card place-card">
        		<div class="place-card-body">
        			<a <?php echo $followLink ?> <?php echo $newTab; ?> href="<?php echo JBusinessUtil::getCompanyLink($company) ?>"> </a>
                    <?php if (!empty($company->logoLocation) &&
							(isset($company->packageFeatures) && in_array(SHOW_COMPANY_LOGO, $company->packageFeatures) || !$appSettings->enable_packages)) { ?>
                        <img title="<?php echo $this->escape($company->name) ?>"
                             alt="<?php echo $this->escape($company->name) ?>"
                             src="<?php echo BD_PICTURES_PATH . $company->logoLocation ?>">
                    <?php } else { ?>
                        <img title="<?php echo $this->escape($company->name) ?>"
                             alt="<?php echo $this->escape($company->name) ?>"
                             src="<?php echo BD_PICTURES_PATH . '/no_image.jpg' ?>">
                    <?php } ?>
                    <?php if (isset($company->featured) && $company->featured==1) { ?>
    					<div class="featured-text">
                            <?php echo JText::_("LNG_FEATURED")?>
                        </div>
    	  	  		<?php } ?>
    		  	  		
        			<div class="card-hoverable white">
                        <?php
							$address = JBusinessUtil::getShortAddress($company);
				if (!empty($company->bestMatchLocation)) {
					$address = $company->bestMatchLocation;
				} ?>
						<?php if (!empty($address)) {?>
    						<div class="company-address">
    							<span><i class="icon map-marker"></i>&nbsp;<?php echo $address?></span>
    						</div>
    					<?php } ?>

                        <?php if ($showData && !empty($company->phone)) { ?>
                            <div>
                                <i class="icon phone-o"></i> <?php echo $company->phone ?>
                            </div>
                        <?php } ?>

                        <?php if ($showData && !empty($company->website) && (isset($company->packageFeatures) && in_array(WEBSITE_ADDRESS, $company->packageFeatures) || !$enablePackages)) { ?>
                            <div>
                                <a target="_blank" <?php echo $followLink ?> title="<?php echo $this->escape($company->name) ?>"
                                    onclick="jbdUtils.registerStatAction(<?php echo $company->id ?>,<?php echo STATISTIC_ITEM_BUSINESS ?>,<?php echo STATISTIC_TYPE_WEBSITE_CLICK ?>);event.stopPropagation();"
                                    href="<?php echo $this->escape($company->website) ?>"><i class="icon link-square"></i> <?php echo $company->website ?>
                                </a>
                            </div>
                        <?php } ?>
        			</div>
        		</div>
        		<div class="place-card-info">
        			<div class="place-card-info-title">
        				<a <?php echo $newTab; ?> href="<?php echo JBusinessUtil::getCompanyLink($company) ?>"><?php echo $company->name ?></a>
        				<?php if ($appSettings->enable_ratings) { ?>
                            <span title="<?php echo $company->review_score ?>" class="rating-review"></span>
                        <?php } ?>
        			</div>
        			<?php if (!empty($company->mainCategoryIcon) || !empty($company->categoryIconImage)) { ?>
						<?php $attributes = "bg-warning rounded-circle"; ?>
						<?php echo JBusinessUtil::renderCategoryIcon($company->mainCategoryIcon, $company->categoryIconImage, $attributes) ?>
					<?php } ?>
        		</div>
        	</div>
        </div>
       
        <?php
			}
		}?>
<?php if (!$showOnlyItems) { ?>
	</div>
</div>
<?php } ?>

<script>
window.addEventListener('load', function(){
	<?php if ($appSettings->enable_ratings) {?>
    	jbdListings.renderGridReviewRating();
	<?php } ?>
});
</script>