<?php
/**
 * @package    JBusinessDirectory
 *
 * @author CMSJunkie http://www.cmsjunkie.com
 * @copyright  Copyright (C) 2007 - 2021 CMSJunkie. All rights reserved.
 * @license   https://www.gnu.org/licenses/agpl-3.0.en.html
 */
defined('_JEXEC') or die('Restricted access');
JBusinessUtil::enqueueStyle('libraries/animate/ultimate.min.css');

if (empty($span)) {
	$span = "col-xl-3 col-lg-4 col-sm-6 col-12";
}
?>

<!-- ICONS VIEW -->
<div class="jbd-container" >
	<div class="row">
	    <?php $k = 0; ?>
	    <?php foreach ($categories as $category) {
	if (!is_array($category)) {
		$category = array($category);
		$category["subCategories"] = array();
	}
	if (isset($category[0]->name)) {
		$k++; ?>
		            <div id="post-<?php echo $category[0]->id ?>" class="<?php echo $span?>">
		                <div class="wpb_wrapper">
		                    <div class="aio-icon-component style_2">
		                        <a class="aio-icon-box-link" style="text-decoration: none;" href="<?php echo htmlspecialchars($category[0]->link, ENT_QUOTES) ?>">
		                            <div class="aio-icon-box top-icon">
		                                <div class="aio-icon-top">
		                                    <div class="aio-icon none" style="">
		                                        <div class="la la-<?php echo $category[0]->icon ?> la-2x"></div>
		                                    </div>
		                                </div>
		                                <div class="aio-icon-header">
		                                    <h3 class="aio-icon-title">
		                                        <?php echo htmlspecialchars($category[0]->name, ENT_QUOTES); ?>
		                                    </h3>
		                                    <?php if ($appSettings->show_total_business_count) { ?>
		                                        <h4>
		                                            <span class="numberCircle"> <?php echo $category[0]->nr_listings ?></span>
		                                        </h4>
		                                    <?php } ?>
		                                </div>
		                                <div class="aio-icon-description">
		                                    <?php echo JBusinessUtil::truncate($category[0]->description, 100); ?>
		                                </div>
		                            </div>
		                        </a>
		                    </div>
		                </div>
		            </div>
	            <?php
	} ?>
	    <?php
} ?>
    </div>
    <div class="clear"></div>
</div>
<?php if (!empty($params) && $params->get('showviewall')) {?>
    <div class="view-all-items">
        <a href="<?php echo $viewAllLink; ?>"><?php echo JText::_("LNG_VIEW_ALL")?></a>
    </div>
<?php }?>