<?php
/**
 * @package    JBusinessDirectory
 *
 * @author     CMSJunkie http://www.cmsjunkie.com
 * @copyright  Copyright (C) 2007 - 2019 CMS Junkie. All rights reserved.
 * @license    https://www.gnu.org/licenses/agpl-3.0.en.html
 */

defined('_JEXEC') or die('Restricted access');

class UBA extends IPaymentProcessor {
	public $type;
	public $name;
	public $mode;

	public $billingDetails;
	public $uniqueId;
	public $currencyCode;
	public $amount;
	public $itemName;

	public $notifyUrl;
	public $returnUrl;
	public $cancelUrl;

	public $merchantId;
	public $shopName;

	public $paymentUrlTest = 'https://bf.instantbillspay.com/api/bill/payment';
	public $paymentUrl = 'https://bf.instantbillspay.com/api/bill/payment';

	public function initialize($data) {
		$this->type       = $data->type;
		$this->name       = $data->name;
		$this->mode       = $data->mode;
		$this->merchantId = $data->merchant_id;
		$this->shopName   = $data->shop_name;
	}

	public function getPaymentGatewayUrl() {
		if ($this->mode == "test") {
			return $this->paymentUrlTest;
		} else {
			return $this->paymentUrl;
		}
	}

	public function getHtmlFields() {
		$pay_args = array(
			'email'       => $this->billingDetails->email,
			'firstname'   => $this->billingDetails->first_name,
			'lastname'    => $this->billingDetails->last_name,
			'phone'       => $this->billingDetails->phone,
			'merchantID'  => $this->merchantId,
			'uniqueID'    => $this->uniqueId,
			'description' => $this->itemName,
			'amount'      => $this->amount,
			'returnUrl'   => $this->returnUrl,
		);

		$pay_args_array = array();
		foreach ($pay_args as $key => $value) {
			$pay_args_array[] = "<input type='hidden' name='$key' value='$value'/>";
		}

		$html = implode('', $pay_args_array);

		return $html;
	}

	public function getPaymentProcessorHtml($data = null) {
		$html = "<ul id=\"payment_form_$this->type\" style=\"display:none\" class=\"form-list\">
		<li>
		    " . JText::_('LNG_PROCESSOR_UBA_INFO', true) . "
		    </li>
		</ul>";

		return $html;
	}

	public function getPaymentDetails($paymentDetails) {
		return JText::_('LNG_PROCESSOR_UBA', true);
	}

	public function processTransaction($data, $controller = "payment") {
		$this->returnUrl    = urldecode(JRoute::_("index.php?option=com_jbusinessdirectory&task=$controller.processResponse&processor=payfast&orderId=" . $data->id, false, -1));
		$this->notifyUrl    = urldecode(JRoute::_("index.php?option=com_jbusinessdirectory&task=$controller.processAutomaticResponse&processor=payfast", false, -1));
		$this->cancelUrl    = urldecode(JRoute::_("index.php?option=com_jbusinessdirectory&task=$controller.processCancelResponse", false, -1));
		$this->amount       = $data->amount;
		$this->itemName     = $data->service . " " . $data->description;
		$this->uniqueId     = $data->id;
		$this->currencyCode = $data->currency;

		$this->billingDetails = $data->billingDetails;

		$result                 = new stdClass();
		$result->transaction_id = 0;
		$result->amount         = $data->amount;
		$result->payment_date   = date("Y-m-d");
		$result->response_code  = 0;
		$result->order_id       = $data->id;
		$result->currency       = $data->currency;
		$result->processor_type = $this->type;
		$result->status         = PAYMENT_REDIRECT;
		$result->payment_status = PAYMENT_STATUS_PENDING;

		return $result;
	}

	public function processResponse() {
		//TODO implement processResponse
	}
}
