<?php

if (!defined('WEBSHOP_LIB_DIR')) define('WEBSHOP_LIB_DIR', dirname(dirname(dirname( __FILE__ ))));


require_once WEBSHOP_LIB_DIR . '/iqsys/otpwebshop/model/WebShopFizetesAdatokLista.php';
require_once WEBSHOP_LIB_DIR . '/iqsys/otpwebshop/model/WebShopFizetesAdatok.php';
require_once WEBSHOP_LIB_DIR . '/iqsys/otpwebshop/model/WebShopFizetesValasz.php';
require_once WEBSHOP_LIB_DIR . '/iqsys/otpwebshop/model/WebShopJovairasValasz.php';
require_once WEBSHOP_LIB_DIR . '/iqsys/otpwebshop/util/WebShopXmlUtils.php';

/**
 * Tranzakcinknti napl fjl ksztse a hrom- s ktszerepls
 * fizetsi tranzakcikhoz.
 * 
 * @version 4.0
 */

class TransactionLogger {

    var $logDir;
    var $logDirSuccess;
    var $logDirFailed;
    
    var $logger;
    
    /**
     * Tranzakcis naplz ltrehozsa
     */
    function TransactionLogger($logDir, $logger) {

        reset($logDir);
        $this->logDir = (is_null(current($logDir)) ? "" : trim(current($logDir)));
        $this->logDirSuccess = (next($logDir) && !is_null(current($logDir)) 
            ? trim(current($logDir)) : $this->logDir);
        $this->logDirFailed = (next($logDir) && !is_null(current($logDir)) 
            ? trim(current($logDir)) : $this->logDir);
        $this->logger = $logger;
    }
    
    /**
     * @desc A tranzakcis log llomny nevnek s elrsi tvonalnak
     * meghatrozsa. Az llomny neve utal a tranzakci azonostjra
     * s az indt bolt azonostjra. 
     * Ha tranzakci indtsrl van sz, j fjlnv kerl kpzsre, 
     * esetleges _x postfix generlsval, ahol x egsz szm.
     * Ha tranzakci befejezdsrl van sz, akkor a tranzakci 
     * indtshoz tartoz adatokat tartalmaz fjl neve kerl meghatrozsra. 
     * 
     * @param string $azonosito fizetsi tranzakci azonost
     * @param string $posId	shopId
     * @param string $logFileName a ltrehozand log file neve. Null, ha a 
     *               metdus hatrozza meg az $azonosito s $posId alapjn
     * @param strgin $uj igaz, ha j fjl ltrehozsrl van sz, pldl 
     *                   a fizetsi tranzakci indtsnl vagy 
     *                   mozgatsnl	
     * @param string $logDir a clknyvtr neve
     * @return string a "generlt" fjl nv
     */
    function getLogFileName($azonosito, $posId, $logFileName, $uj, $logDir) {
        
    	/* Knyvtr lrtehozsa, ha szksges */
        if (file_exists($logDir)) {
        	if (!is_dir($logDir)) {
        		$this->logger->warn(
                    "Ervenytelen tranzakcio log konyvtar: " . $logDir);
            }
        }
        else {
            $this->logger->warn(
                "A tranzakcio log konyvtar nem letezik: " . $logDir);

            $success = mkdir($logDir, 0710);
            if (!success) {
                $this->logger->warn(
                    "A tranzakcio log konyvtar nem hozhato letre: " . $logDir);
            }            
        }
        
        if (is_null($logFileName)) {
            $logFileName = 
                $posId . "_" . $azonosito . ".log";
        }
                
        /* Fel kell kszlni arra, hogy az adott nven mr ltezik fjl */
        $logFile = $logDir . "/" . $logFileName;
        $i = 0;
        while ($uj && file_exists($logFile)) {
        	$i++;
            $logFile = $logDir . "/" . $logFileName . "_" . $i;
        }

        return $i == 0 ? $logFileName : $logFileName . "_" . $i;
    }
   
    /**
     * Objektum string reprezentlsa.
     * Annyiban tr el a toString() ltal visszaadott adattl, hogy
     * null rtk esetn res string a visszatrsi rtk, s nem
     * a "null" szveg
     * 
     * @param value rtk
     * @return string reprezentci
     */
    function nvl($value) {
        return (is_null($value) ? "" : $value);
    }

    
    /**
    * @desc Szveg kirsa fjlba.
    */
    function filePutContents($fileName, $data, $flags, $fileDir) {
        $resource=@fopen($fileDir . "/" . $fileName, $flags);   
        if (!$resource) {
            return false;
        }
        else {
            $success = fwrite($resource, $data);
            fclose($resource);
            return $success;   
        }
    }
   
  /**
   * @desc Hromszerepls fizetsi tranzakci indtsnak naplzsa.
   *
   * @param posId webshop azonost
   * @param azonosito fizetsi tranzakci azonost
   * @param osszeg fizetend sszeg 
   * @param devizanem fizetend devizanem
   * @param nyelvkod a megjelentend vev oldali fellet nyelve
   * @param nevKell a megjelentend vev oldali felleten be kell krni a vev nevt
   * @param orszagKell a megjelentend vev oldali felleten be kell krni a vev cmnek "orszg rszt"
   * @param megyeKell a megjelentend vev oldali felleten be kell krni a vev cmnek "megye rszt"
   * @param telepulesKell a megjelentend vev oldali felleten be kell krni a vev cmnek "telepls rszt"
   * @param iranyitoszamKell a megjelentend vev oldali felleten be kell krni  a vev cmnek "irnytszm rszt"
   * @param utcaHazszamKell a megjelentend vev oldali felleten be kell  krni a vev cmnek "utca/hzszm rszt"
   * @param mailCimKell a megjelentend vev oldali felleten be kellkrni a vev e-mail cmt
   * @param kozlemenyKell a megjelentend vev oldali felleten fel kell knlni a kzlemny megadsnak lehetsgt
   * @param vevoVisszaigazolasKell a tranzakci eredmnyt a vev oldalon meg kell jelenteni (azaz nem a backURL-re kell irnytani)
   * @param ugyfelRegisztracioKell ha a regisztraltUgyfelId rtke nem res, akkor megadja, hogy a megadott azonost jonnan regisztrland-e, vagy mr regisztrlsra kerlt az OTP Internetes Fizet felletn. 
   * @param regisztraltUgyfelId az OTP fizetfelleten regisztrland vagy regisztrlt  gyfl azonost kdja. 
   * @param shopMegjegyzes a webshop megjegyzse a tranzakcihoz a vev rszre
   * @param backURL a tranzakci vgrehajtsa utn erre az internet cmre kell irnytani a vev oldalon az gyfelet (ha a vevoVisszaigazolasKell hamis)
   * @param $zsebAzonosito a cafeteria krtya zseb azonostja
   * @param string $logFileName a ltrehozand log file neve. Null, ha a metdus hatrozza meg az $azonosito s $posId alapjn
   * 
   * @access public
   */
    function logHaromszereplosFizetesInditas(
            $posId,
            $azonosito,
            $osszeg,
            $devizanem,
            $nyelvkod,
            $nevKell,
            $orszagKell,
            $megyeKell,
            $telepulesKell,
            $iranyitoszamKell,
            $utcaHazszamKell,
            $mailCimKell,
            $kozlemenyKell,
            $vevoVisszaigazolasKell,
            $ugyfelRegisztracioKell,
            $regisztraltUgyfelId,
            $shopMegjegyzes,
            $backURL,
            $ketlepcsosFizetes,
            $zsebAzonosito,
            $logFileName = null) {
    	
       if (!is_null($azonosito) && (trim($azonosito) != "")) {
            $logFileName = $this->getLogFileName($azonosito, $posId, $logFileName, true, $this->logDir); 

            $logContent = "Haromszereplos fizetesi tranzakcio" . "\n"
                . "\nInditas: " . date(LOG_DATE_FORMAT, time()) . "\n" 
                . "\nIndito adatok" . "\n"
                . "  posId: " . $posId . "\n"
                . "  azonosito: " . $azonosito . "\n"
                . "  osszeg: " . $osszeg . "\n"
                . "  devizanem: " . $devizanem . "\n"
                . "  nyelvkod: " . $nyelvkod . "\n"
                . "  nevKell: " . $nevKell . "\n"
                . "  orszagKell: " . $orszagKell . "\n"
                . "  megyeKell: " . $megyeKell . "\n"
                . "  telepulesKell: " . $telepulesKell . "\n"
                . "  iranyitoszamKell: " . $iranyitoszamKell . "\n"
                . "  utcaHazszamKell: " . $utcaHazszamKell . "\n"
                . "  mailCimKell: " . $mailCimKell . "\n"
                . "  kozlemenyKell: " . $kozlemenyKell . "\n"
                . "  vevoVisszaigazolasKell: " . $vevoVisszaigazolasKell . "\n"
                . "  ugyfelRegisztracioKell: " . $ugyfelRegisztracioKell . "\n"
                . "  regisztraltUgyfelId: " . $regisztraltUgyfelId . "\n"
                . "  shopMegjegyzes: " . $shopMegjegyzes . "\n"
                . "  backURL: " . $backURL . "\n"
                . "  zsebAzonosito: " . $zsebAzonosito . "\n"
                . "  ketlepcsosFizetes: " . $ketlepcsosFizetes . "\n";	

            if (!$this->filePutContents($logFileName, $logContent, "w+b", $this->logDir)) {
                $this->logger->warn("Hiba tortent a tranzakcios naplo fajl letrehozasa " 
                    . "vagy irasa kozben: " . $logFileName);
            }
        }
        else {
        	$this->logger->warn("A tranzakcio adatai nem naplozhatoak, a fizetesi azonosito nincs megadva.");
        }
    }

   /**
    * Hromszerepls fizetsi tranzakci befejezdsnek naplzsa.
    *
    * @param string $azonosito fizetsi tranzakci azonost
    * @param string $posId shopID bolt azonost
    * @param WResponse $response a fizetsi tranzakci vlasza
    * @param boolean $moveFile mozgassa-e a fjlt a vgrehajts utn
    * @param string $logFileName a ltrehozand log file neve. 
    *        Null, ha a metdus hatrozza meg az $azonosito s $posId alapjn
    */
    function logHaromszereplosFizetesBefejezes(
            $azonosito,
            $posId,
    		$response,
            $moveFile = true,
            $logFileName = null) {

       if (is_null($response) || !$response->isFinished()) {
            $this->logger->warn(
                "A tranzakcio adatai nem naplozhatoak, a valasz ures: " . $azonosito);
       }
       else if (!is_null($azonosito) && (trim($azonosito) != "")) {
            $logFileName = $this->getLogFileName($azonosito, $posId, $logFileName, false, $this->logDir); 

            $logContent = 
                "\nBefejezes: " . date(LOG_DATE_FORMAT, time()) . "\n" 
                . "\nValasz: " . implode(", " , $response->getMessages()) . "\n";

            $fizetesAdatok = $response->getAnswer();

            if (!is_null($fizetesAdatok)) {

                $logContent .=
                    "\nValasz adatok" . "\n"
                    . "  posId: " . $fizetesAdatok->getPosId() . "\n"
                    . "  azonosito: " . $fizetesAdatok->getAzonosito() . "\n"
                    . "  posValaszkod: " . $fizetesAdatok->getPosValaszkod() . "\n"
                    . "  authorizaciosKod: " . $fizetesAdatok->getAuthorizaciosKod() . "\n"
                    . "  statuszKod: " . $fizetesAdatok->getStatuszKod() . "\n"
                    . "  teljesites: " . $fizetesAdatok->getTeljesites() . "\n"
                    . "  nev: " . $fizetesAdatok->getNev() . "\n"
                    . "  orszag: " . $fizetesAdatok->getOrszag() . "\n"
                    . "  megye: " . $fizetesAdatok->getMegye() . "\n"
                    . "  varos: " . $fizetesAdatok->getVaros() . "\n"
                    . "  iranyitoszam: " . $fizetesAdatok->getIranyitoszam() . "\n"
                    . "  utcaHazszam: " . $fizetesAdatok->getUtcaHazszam() . "\n"
                    . "  mailCim: " . $fizetesAdatok->getMailCim() . "\n"
                    . "  kozlemeny: " . $fizetesAdatok->getKozlemeny() . "\n";
            }


            if (!$this->filePutContents($logFileName, $logContent, "a+b", $this->logDir)) {
                $this->logger->warn("Hiba tortent a tranzakcios naplo fajl letrehozasa " 
                    . "vagy irasa kozben: " . $logFileName);
            }
            else if ($moveFile){
                $newLoc = $response->isSuccessful() ? $this->logDirSuccess : $this->logDirFailed;
                if (!is_null($newLoc)) {
                    rename($this->logDir . "/" . $logFileName, 
                        $newLoc . "/" . $this->getLogFileName($azonosito, $posId, $logFileName, true, $newLoc));
                }
            }
        }
        else {
            $this->logger->warn("A tranzakcio adatai nem naplozhatoak," 
                . " az azonosito nincs megadva.");
            
        }
    }
    
   /**
    * Ktszerepls fizetsi tranzakci indtsi adatainak naplzsa.
    *
    * @param string $posId tranzakci egyedi azonostja 
    * @param string $azonosito a shop azonostja 
    * @param string $osszeg vsrls sszege 
    * @param string $devizanem vsrls devizaneme 
    * @param string $nyelvkod nyelvkd 
    * @param string $regisztraltUgyfelId 
    * az OTP fizetfelleten regisztrlt gyfl azonost kdja. 
    * @param string $kartyaszam    krtyaszm 
    * @param string $cvc2cvv2      CVC2/CVV2 kd 
    * @param string $kartyaLejarat krtya lejrati dtuma, MMyy formban
    * @param string $vevoNev       vev neve 
    * @param string $vevoPostaCim  vev postai cme 
    * @param string $vevoIPCim     vev gpnek IP cme 
    * @param string $ertesitoMail  vev kirtestsi mailcme 
    * @param string $ertesitoTel   vev kirtestsi telefonszma 
    * @param string $logFileName a ltrehozand log file neve. Null, ha a metdus hatrozza meg az $azonosito s $posId alapjn
    * @param $zsebAzonosito a cafeteria krtya zseb azonostja
    */
    function logKetszereplosFizetesInditas(
            $posId,
            $azonosito,
            $osszeg,
            $devizanem,
            $nyelvkod,
            $regisztraltUgyfelId,
            $kartyaszam,
            $cvc2cvv2,
            $kartyaLejarat,
            $vevoNev,
            $vevoPostaCim,
            $vevoIPCim,
            $ertesitoMail,
            $ertesitoTel,
            $ketlepcsosFizetes,
            $logFileName = null,
            $zsebAzonosito) {

       if (!is_null($azonosito) && (trim($azonosito) != "")) {
            $logFileName = $this->getLogFileName($azonosito, $posId, $logFileName, true, $this->logDir); 
            
            $logContent = 
                "Ketszereplos fizetesi tranzakcio" . "\n"
                . "\nInditas: " . date(LOG_DATE_FORMAT, time()) . "\n" 
                . "\nIndito adatok" . "\n"
                . "  posId: " . $posId . "\n"
                . "  azonosito: " . $azonosito . "\n"
                . "  osszeg: " . $osszeg . "\n"
                . "  devizanem: " . $devizanem . "\n"
                . "  nyelvkod: " . $nyelvkod . "\n"
                . "  regisztraltUgyfelId: " . $regisztraltUgyfelId . "\n"
                . "  vevoNev: " . $vevoNev . "\n"
                . "  vevoPostaCim: " . $vevoPostaCim . "\n"
                . "  vevoIPCim: " . $vevoIPCim . "\n"
                . "  ertesitoMail: " . $ertesitoMail . "\n"
                . "  ertesitoTel: " . $ertesitoTel . "\n"
                . "  ketlepcsos: " . $ketlepcsosFizetes . "\n"	
                . "  zsebAzonosito: " . $zsebAzonosito . "\n";
                
            if (!$this->filePutContents($logFileName, $logContent, "w+b", $this->logDir)) {
                $this->logger->warn("Hiba tortent a tranzakcios naplo fajl letrehozasa " 
                    . "vagy irasa kozben: " . $logFileName);
            }
       }
        else {
            $this->loggerwarn("A tranzakcio adatai nem naplozhatoak," 
                . " az azonosito nincs megadva.");
            
        }
        
    }

   /**
    * Ktszerepls fizetsi tranzakci befejezdsnek naplzsa.
    *
    * @param string $azonosito fizetsi tranzakci azonost
    * @param string $posId shopID bolt azonost
    * @param WResponse $response a fizetsi tranzakci vlasza
    * @param boolean $moveFile mozgassa-e a fjlt a vgrehajts utn
    * @param string $logFileName a ltrehozand log file neve. Null, ha a metdus hatrozza meg az $azonosito s $posId alapjn
    */
    function logKetszereplosFizetesBefejezes(
            $azonosito,
            $posId,
            $response,
            $moveFile = true,
            $logFileName = null) {

       if (is_null($response) || !$response->isFinished()) {
            $this->logger->warn(
                "A tranzakcio adatai nem naplozhatoak, a valasz ures: " . $azonosito);
       }
       else if (!is_null($azonosito) && (trim($azonosito) != "")) {
            $logFileName = $this->getLogFileName($azonosito, $posId, $logFileName, false, $this->logDir); 

            $valasz = $response->getAnswer();                         
            $logContent = 
                "\nBefejezes: " . date(LOG_DATE_FORMAT, time()) . "\n" 
                . "\nValasz: " . implode(", " , $response->getMessages()) . "\n"
                . "\nValasz adatok" . "\n"
                . "  posId: " . $valasz->getPosId() . "\n"
                . "  azonosito: " . $valasz->getAzonosito() . "\n"
                . "  posValaszkod: " . $valasz->getValaszKod() . "\n"
                . "  authorizaciosKod: " . $valasz->getAuthorizaciosKod() . "\n"
                . "  teljesites: " . $valasz->getTeljesites() . "\n";
                
            if (!$this->filePutContents($logFileName, $logContent, "a+b", $this->logDir)) {
                $this->logger->warn("Hiba tortent a tranzakcios naplo fajl letrehozasa " 
                    . "vagy irasa kozben: " . $logFileName);
            }
            else if ($moveFile) {
                $newLoc = $response->isSuccessful() ? $this->logDirSuccess : $this->logDirFailed;
                if (!is_null($newLoc) && $newLoc != $this->logDir) {
                    $targetFile = $newLoc . "/" . $this->getLogFileName($azonosito, $posId, $logFileName, true, $newLoc);
                    if (file_exists($targetFile) && filesize($targetFile) === 0) {
                        // lockols vgett hoztuk ltre, trlhetjk
                        delete($targetFile);
                    }
                    rename($this->logDir . "/" . $logFileName, $targetFile );
                }
            }
        }
        else {
            $this->loggerwarn(
                "A tranzakcio adatai nem naplozhatoak, az azonosito nincs megadva.");
        }
    }

    /**
     * Ktlpcss fizetsi tranzakci lezrsa indtsi adatainak naplzsa.
     *
     * @param string $posId tranzakci egyedi azonostja 
     * @param string $azonosito a shop azonostja 
     * @param mixed $jovahagyo jvhagy-e a lezrs
     * @param string $osszeg komplettrozs sszege 
     * @param string $logFileName a ltrehozand log file neve. Null, ha a metdus hatrozza meg az $azonosito s $posId alapjn
     */
     function logFizetesLezarasInditas(
             $posId,
             $azonosito,
             $jovahagyo,
             $osszeg,
             $logFileName = null) {
         
         if (!is_null($azonosito) && (trim($azonosito) != "")) {
            $logFileName = $this->getLogFileName($azonosito, $posId, $logFileName, false, $this->logDir); 

            $logContent = 
                 "Ketlepcsos fizetes lezaras tranzakcio" . "\n"
                 . "\nInditas: " . date(LOG_DATE_FORMAT, time()) . "\n" 
                 . "\nIndito adatok" . "\n"
                 . "  posId: " . $posId . "\n"
                 . "  azonosito: " . $azonosito . "\n"
                 . "  jovahagyo: " . $jovahagyo . "\n"
                 . "  osszeg: " . $osszeg . "\n";

            if (!$this->filePutContents($logFileName, $logContent, "a+b", $this->logDir)) {
                $this->logger->warn("Hiba tortent a tranzakcios naplo fajl letrehozasa " 
                    . "vagy irasa kozben: " . $logFileName);
            }
         }
         else {
             $this->logger->warn("A tranzakcio adatai nem naplozhatoak," 
                             . " az azonosito nincs megadva.");
             
         }
         
     }

    /**
     * Ktlpcss fizetsi tranzakci lezrsa befejezdsnek naplzsa.
     *
    * @param string $azonosito fizetsi tranzakci azonost
    * @param string $posId shopID bolt azonost
    * @param WResponse $response a fizetsi tranzakci vlasza
    * @param boolean $moveFile mozgassa-e a fjlt a vgrehajts utn
    * @param string $logFileName a ltrehozand log file neve. Null, ha a metdus hatrozza meg az $azonosito s $posId alapjn
     */
     function logFizetesLezarasBefejezes(
             $azonosito,
             $posId,
             $response,
             $moveFile = true,
             $logFileName = null) {

       if (is_null($response) || !$response->isFinished()) {
            $this->logger->warn(
                "A tranzakcio adatai nem naplozhatoak, a valasz ures: " . $azonosito);
       }
       else if (!is_null($azonosito) && (trim($azonosito) != "")) {
            $logFileName = $this->getLogFileName($azonosito, $posId, $logFileName, false, $this->logDir); 

            $valasz = $response->getAnswer();                         
            $logContent = 
                "\nBefejezes: " . date(LOG_DATE_FORMAT, time()) . "\n" 
                . "\nValasz: " . implode(", " , $response->getMessages()) . "\n"
                . "\nValasz adatok" . "\n"
                . "  posId: " . $valasz->getPosId() . "\n"
                . "  azonosito: " . $valasz->getAzonosito() . "\n"
                . "  posValaszkod: " . $valasz->getValaszKod() . "\n"
                . "  authorizaciosKod: " . $valasz->getAuthorizaciosKod() . "\n"
                . "  teljesites: " . $valasz->getTeljesites() . "\n";
                
            if (!$this->filePutContents($logFileName, $logContent, "a+b", $this->logDir)) {
                $this->logger->warn("Hiba tortent a tranzakcios naplo fajl letrehozasa " 
                    . "vagy irasa kozben: " . $logFileName);
            }
            else if ($moveFile) {
                $newLoc = $response->isSuccessful() ? $this->logDirSuccess : $this->logDirFailed;
                if (!is_null($newLoc) && $newLoc != $this->logDir) {
                    $targetFile = $newLoc . "/" . $this->getLogFileName($azonosito, $posId, $logFileName, true, $newLoc);
                    if (file_exists($targetFile) && filesize($targetFile) === 0) {
                        // lockols vgett hoztuk ltre, trlhetjk
                        delete($targetFile);
                    }
                    rename($this->logDir . "/" . $logFileName, $targetFile );
                }
            }
        }
        else {
            $this->loggerwarn(
                "A tranzakcio adatai nem naplozhatoak, az azonosito nincs megadva.");
        }
                 
     }
    
   /**
    * Fizets jvrs tranzakci indtsi adatainak naplzsa.
    *
    * @param string $posId tranzakci egyedi azonostja 
    * @param string $azonosito a shop azonostja 
    * @param string $osszeg jvrs sszege 
    * @param string $logFileName a ltrehozand log file neve. Null, ha a metdus hatrozza meg az $azonosito s $posId alapjn
    */
    function logFizetesJovairasInditas(
            $posId,
            $azonosito,
            $osszeg,
            $logFileName = null) {

       if (!is_null($azonosito) && (trim($azonosito) != "")) {
            $logFileName = $this->getLogFileName($azonosito, $posId, $logFileName, true, $this->logDir); 
            
            $logContent = 
                "Fizetes jovairas tranzakcio" . "\n"
                . "\nInditas: " . date(LOG_DATE_FORMAT, time()) . "\n" 
                . "\nIndito adatok" . "\n"
                . "  posId: " . $posId . "\n"
                . "  azonosito: " . $azonosito . "\n"
                . "  osszeg: " . $osszeg . "\n";
                
            if (!$this->filePutContents($logFileName, $logContent, "w+b", $this->logDir)) {
                $this->logger->warn("Hiba tortent a tranzakcios naplo fajl letrehozasa " 
                    . "vagy irasa kozben: " . $logFileName);
            }
       }
        else {
            $this->loggerwarn("A tranzakcio adatai nem naplozhatoak," 
                . " az azonosito nincs megadva.");
            
        }
        
    }

   /**
    * Fizets jvrs tranzakci befejezdsnek naplzsa.
    *
    * @param string $azonosito fizetsi tranzakci azonost
    * @param string $posId shopID bolt azonost
    * @param WResponse $response a fizetsi tranzakci vlasza
    * @param boolean $moveFile mozgassa-e a fjlt a vgrehajts utn
    * @param string $logFileName a ltrehozand log file neve. Null, ha a metdus hatrozza meg az $azonosito s $posId alapjn
    */
    function logFizetesJovairasBefejezes(
            $azonosito,
            $posId,
            $response,
            $moveFile = true,
            $logFileName = null) {

       if (is_null($response) || !$response->isFinished()) {
            $this->logger->warn(
                "A tranzakcio adatai nem naplozhatoak, a valasz ures: " . $azonosito);
       }
       else if (!is_null($azonosito) && (trim($azonosito) != "")) {
            $logFileName = $this->getLogFileName($azonosito, $posId, $logFileName, false, $this->logDir); 

            $valasz = $response->getAnswer();                         
            $logContent = 
                "\nBefejezes: " . date(LOG_DATE_FORMAT, time()) . "\n" 
                . "\nValasz: " . implode(", " , $response->getMessages()) . "\n"
                . "\nValasz adatok" . "\n"
                . "  posId: " . $posId . "\n"
                . "  azonosito: " . $azonosito . "\n"
                . "  posValaszkod: " . $valasz->getValaszKod() . "\n"
                . "  authorizaciosKod: " . $valasz->getAuthorizaciosKod() . "\n"
                . "  mwTransactionId: " . $valasz->getMwTransactionId() . "\n";
                
            if (!$this->filePutContents($logFileName, $logContent, "a+b", $this->logDir)) {
                $this->logger->warn("Hiba tortent a tranzakcios naplo fajl letrehozasa " 
                    . "vagy irasa kozben: " . $logFileName);
            }
            else if ($moveFile) {
                $newLoc = $response->isSuccessful() ? $this->logDirSuccess : $this->logDirFailed;
                if (!is_null($newLoc) && $newLoc != $this->logDir) {
                    $targetFile = $newLoc . "/" . $this->getLogFileName($azonosito, $posId, $logFileName, true, $newLoc);
                    if (file_exists($targetFile) && filesize($targetFile) === 0) {
                        // lockols vgett hoztuk ltre, trlhetjk
                        delete($targetFile);
                    }
                    rename($this->logDir . "/" . $logFileName, $targetFile );
                }
            }
        }
        else {
            $this->loggerwarn(
                "A tranzakcio adatai nem naplozhatoak, az azonosito nincs megadva.");
        }
    }
}

?>