<?php

if (!defined('WEBSHOP_LIB_DIR')) define('WEBSHOP_LIB_DIR', dirname(dirname(dirname( __FILE__ ))));

require_once WEBSHOP_LIB_DIR . '/iqsys/otpwebshop/factory/WAnswerOfWebShopFizetes.php';
require_once WEBSHOP_LIB_DIR . '/iqsys/otpwebshop/factory/WAnswerOfWebShopFizetesKetszereplos.php';
require_once WEBSHOP_LIB_DIR . '/iqsys/otpwebshop/factory/WAnswerOfWebShopTranzAzonGeneralas.php';
require_once WEBSHOP_LIB_DIR . '/iqsys/otpwebshop/factory/WAnswerOfWebShopTrazakcioLekerdezes.php';
require_once WEBSHOP_LIB_DIR . '/iqsys/otpwebshop/factory/WAnswerOfWebShopJovairas.php';
require_once WEBSHOP_LIB_DIR . '/iqsys/otpwebshop/factory/WAnswerOfWebShopKulcsLekerdezes.php';

/**
* A tranzakcis vlasz XML-eket reprezentl value object 
* s azt elllt WAnswerOf... osztlyok sszerendelse.
* 
* @access private
* 
* @version 4.0
*/
class WSAnswerFactory  {

    /**
    * Adott tranzakcis vlasz XML-t reprezentl value object-et 
    * elllt WAnswerOf... objektum ellltsa.
    *  
    * @param string a tranzakci kdja
    * @return mixed a megfelel WAnswerOf... objektum
    */
    function getAnswerFactory($workflowName) {
        switch ($workflowName) {
           case 'WEBSHOPTRANZAZONGENERALAS':
                return new WAnswerOfWebShopTranzAzonGeneralas();
           case 'WEBSHOPTRANZAKCIOLEKERDEZES':
                return new WAnswerOfWebShopTrazakcioLekerdezes();
           case 'WEBSHOPFIZETES':
                return new WAnswerOfWebShopFizetes();
           case 'WEBSHOPFIZETESKETSZEREPLOS':
                return new WAnswerOfWebShopFizetesKetszereplos();
           case 'WEBSHOPFIZETESLEZARAS':
                return new WAnswerOfWebShopFizetesKetszereplos();    
           case 'WEBSHOPFIZETESJOVAIRAS':
                return new WAnswerOfWebShopJovairas();
           case 'WEBSHOPKULCSLEKERDEZES':
                return new WAnswerOfWebShopKulcsLekerdezes();
        }        
        return NULL;
    }

}

?>