<?php

if (!defined('WEBSHOP_LIB_DIR')) define('WEBSHOP_LIB_DIR', dirname(dirname(dirname(__FILE__))));

require_once WEBSHOP_LIB_DIR . '/iqsys/otpwebshop/WebShopService.php';
require_once WEBSHOP_LIB_DIR . '/iqsys/otpwebshop/model/WorkflowState.php';

define('PROPERTY_SIMULATEDXMLDIR', 'otp.webshop.SIMULATED_XML_DIR'); 

/**
 * WebShop PHP szimultor - Fizetfellet Banki oldalnak szimullsa.
 *
 * A WebShop-ok rszre ksztett PHP alkalmazs csomag rsze. 
 * Ez az alkalmazs csupn szimullja az OTP Bank rendszernek megfelel WebShop
 * folyamat-hvst: 
 * - ping 
 * - tranzakci azonost generls 
 * - hromszerepls fizetsi folyamat indtsa 
 * - ktszerepls fizetsi folyamat indtsa 
 * - tranzakci adatok, tranzakci sttusz lekrdezse
 * - ktlpcss fizets lezrs
 * - fizets jvrs indtsa
 *
 * A fenti szolgltatsok az OTP MWAccess fellet hvst csupn szimulljk, az egyes
 * krsekre adand vlaszokat ugyanis fjlbl olvassk ki. A Banki fellet nem kerl
 * megszltsra.
 * 
 * A fjlok elnevezsi konvencijnak a [tranzakcinev]_output.xml kell lenni,
 * ahol a [tranzakcinev] lehet WEBSHOPTRANZAZONGENERALAS, 
 * WEBSHOPTRANZAKCIOLEKERDEZES, WEBSHOPFIZETES, WEBSHOPFIZETESKETSZEREPLOS, 
 * WEBSHOPFIZETESLEZARAS s WEBSHOPFIZETESJOVAIRAS.  
 * A knyvtrat, melyben ezek a fjlok elhelyezend?k, a konfigurcis llomny
 * otp.webshop.SIMULATED_XML_DIR bejegyzsben kell megadni, kvetve a szoksos
 * elrsi tvonal megadsi szablyokat.
 * 
 * @version 4.0
 */

class WebShopServiceSimulator extends WebShopService {

    /**
    * @desc Konstruktor
    */
    function WebShopServiceSimulator() {
        $this->logger =& LoggerManager::getLogger("WebShopClient");
        $this->logger->debug("OTPWebShopService (PHP) szimulator peldanyositas...");
       
        $this->property = parse_ini_file(WEBSHOPSERVICE_CONFIGURATION);
        
        $this->operationLogNames = array(
            "tranzakcioAzonositoGeneralas" => "tranzakcioAzonositoGeneralas" . " *** SZIMULATOR ***",
            "fizetesiTranzakcioKetszereplos" => "fizetesiTranzakcioKetszereplos" . " *** SZIMULATOR ***",
            "fizetesiTranzakcio" => "fizetesiTranzakcio" . " *** SZIMULATOR ***",
            "tranzakcioStatuszLekerdezes" => "tranzakcioStatuszLekerdezes" . " *** SZIMULATOR ***",
            "ketlepcsosFizetesLezaras" => "ketlepcsosFizetesLezaras" . " *** SZIMULATOR ***",
            "fizetesJovairas" => "fizetesJovairas" . " *** SZIMULATOR ***",
        );
    }

    /**
    * @desc Szimullt WorkflowState ellltsa.
    * A result tartalma fjlbl kerl beolvassra,
    * mely fjl neve a 
    * PROPERTY_SIMULATEDXMLDIR + "/" + $workflowName + "_output.xml";
    * lesz.
    * A Banki tranzakci azonost az aktulis id alapjn generlt rtk.
    * 
    * @return WorkflowState szimullt vlasz.
    */
    function getSimulatedWorkflowState($workflowName, $inputXml) {
        $workflowState = new WorkflowState(NULL);
        $workflowState->templateName = $workflowName;
        $workflowState->instanceId = date("YmdHis");
        $workflowState->startTime = date("YmdHis") . " 000";
        $workflowState->endTime = $workflowState->startTime;
        $workflowState->timeout = false;

        $simXmlFolder = $this->property[PROPERTY_SIMULATEDXMLDIR];
        $simXmlFile = $simXmlFolder . "/" . $workflowName . "_output.xml";
        $workflowState->result = file_get_contents($simXmlFile);            
        if ($workflowState->result === FALSE) {
            $this->logger->error("Szimulator XML output nem talalhato: " . $simXmlFile);
            $workflowState->completed = false;
        }
        else {
            $workflowState->completed = true;
        }            
        return $workflowState;
    }
    
    /**
     * @desc A banki fellet Ping szolgltatsnak meghvsa. 
     * Mivel tranzakci indts nem trtnik, a sikeres ping
     * esetn sem garantlt az, hogy az egyes fizetsi tranzakcik
     * sikeresen el is indthatk -  csupn az biztos, hogy a
     * hlzati architektrn keresztl sikeresen elrhet a
     * banki fellet. 
     * 
     * Digitlis alrs nem kpzdik.
     * 
     * @return boolean true sikeres ping-ets esetn, egybknt false.
     */
    function ping() {
        $this->logger->debug("ping *** SZIMULATOR *** indul...");
        $this->logger->debug("ping  *** SZIMULATOR *** befejezdtt.");
        return true;
    }
    
    /**
     * Tranzakci indtsa. 
     */
    function startWorkflowSynch($workflowName, $inputXml) {
        return $this->getSimulatedWorkflowState($workflowName, $inputXml);
    }

}

?>