<?php

require_once JPATH_SITE . '/components/com_jbusinessdirectory/libraries/vendor/autoload.php';

class LinkedinAuth extends JBDAuth {
	private $clientId;
	private $clientSecret;

	public function __construct() {
		$this->type = 'linkedin';
		parent::__construct();

		$appSettings              = JBusinessUtil::getApplicationSettings();
		$this->clientId           = $appSettings->linkedin_client_id;
		$this->clientSecret       = $appSettings->linkedin_client_secret;
	}

	/**
	 * Initializes provider. Throws exception if client-id or client-secret is missing;
	 *
	 * @throws Exception
	 *
	 * @since 5.2.2
	 */
	public function initializeProvider() {
		if (empty($this->clientId) || empty($this->clientSecret)) {
			throw new Exception(JText::_('LNG_MISSING_CLIENT_DETAILS'));
		}

		$this->provider = new \League\OAuth2\Client\Provider\LinkedIn(array(
			'clientId'     => $this->clientId,
			'clientSecret' => $this->clientSecret,
			'redirectUri'  => $this->redirectUri,
		));
	}

	/**
	 * Get Access Token object by code
	 *
	 * @param $code string
	 *
	 * @return mixed
	 *
	 * @since 5.2.2
	 */
	public function getToken($code) {
		$token = $this->provider->getAccessToken('authorization_code', array(
			'code' => $_GET['code']
		));

		return $token;
	}

	/**
	 * Retrieves user details by access token
	 *
	 * @param $token object
	 *
	 * @return mixed
	 *
	 * @since 5.2.2
	 */
	public function getUserDetails($token) {
		$user = $this->provider->getResourceOwner($token);

		return $user;
	}

	/**
	 * Get state
	 *
	 * @return mixed
	 *
	 * @since 5.2.2
	 */
	public function getState() {
		return $this->provider->getState();
	}

	/**
	 * Get authorization URL of provider
	 *
	 * @param null $options
	 *
	 * @return mixed
	 *
	 * @since 5.2.2
	 */
	public function getAuthorizationUrl($options = null) {
		return $this->provider->getAuthorizationUrl($options);
	}

	/**
	 * Formatting the linkedin userData response array to match our expected structure.
	 *
	 * @param array $userData
	 *
	 * @return array|mixed
	 *
	 * @since 5.5.0
	 */
	public function formatUserData($userData) {
		$data = $userData;
		$data["name"] = $userData["localizedFirstName"] . " " . $userData["localizedLastName"];

		return $data;
	}
}
