<?php
/**
 * Created by PhpStorm.
 * User: krisli
 * Date: 19-08-23
 * Time: 4.29.MD
 */

require_once BD_CLASSES_PATH . '/oauth/JBDAuth.php';

class JBDAuthFactory {
	public static function getOAuthProviders() {
		$providers                          = array();
		$providers[OAUTH_PROVIDER_FACEBOOK] = 'facebook';
		$providers[OAUTH_PROVIDER_GOOGLE]   = 'google';
		$providers[OAUTH_PROVIDER_LINKEDIN] = 'linkedin';

		return $providers;
	}

	public static function getOAuthProviderCode($type) {
		$providers = self::getOAuthProviders();

		foreach ($providers as $key => $provider) {
			if (strcasecmp($provider, $type) == 0) {
				return $key;
			}
		}

		return null;
	}

	public static function isOAuthProviderValid($type) {
		return self::getOAuthProviderCode($type) != null;
	}

	public static function create($type) {
		$authProvider = null;
		switch ($type) {
			case 'google':
				require_once BD_CLASSES_PATH . '/oauth/providers/google.php';
				$authProvider = new GoogleAuth();
				break;
			case 'facebook':
				require_once BD_CLASSES_PATH . '/oauth/providers/facebook.php';
				$authProvider = new FacebookAuth();
				break;
			case 'linkedin':
				require_once BD_CLASSES_PATH . '/oauth/providers/linkedin.php';
				$authProvider = new LinkedinAuth();
				break;
		}

		return $authProvider;
	}
}
