<?php

jimport('joomla.user.helper');
JTable::addIncludePath('administrator/components/com_jbusinessdirectory/tables');

abstract class JBDAuth {
	protected $type;

	protected $redirectUri;

	protected $appSettings;

	protected $provider;

	public function __construct() {
		$this->appSettings = JBusinessUtil::getApplicationSettings();
		$this->setRedirectUri(JBusinessUtil::getWebsiteURL(true) . "index.php?option=com_jbusinessdirectory&task=userprofile.oauthCallback&type=" . $this->type);
	}

	abstract public function initializeProvider();

	abstract public function getToken($code);

	abstract public function getUserDetails($token);

	abstract public function getState();

	abstract public function getAuthorizationUrl($options = null);

	/**
	 * Override this if keys in the userData response array are not the same as the ones that we are expecting on the
	 * createUser function.
	 *
	 * @param $userData array
	 *
	 * @return mixed
	 *
	 * @since 5.5.0
	 */
	public function formatUserData($userData) {
		return $userData;
	}

	/**
	 * @return mixed
	 *
	 * @since 5.2.2
	 */
	public function getProvider() {
		return $this->provider;
	}

	/**
	 * @return mixed
	 *
	 * @since 5.2.2
	 */
	public function getRedirectUri() {
		return $this->redirectUri;
	}

	/**
	 * @param mixed $redirectUri
	 *
	 * @since 5.2.2
	 */
	public function setRedirectUri($redirectUri) {
		$this->redirectUri = $redirectUri;
	}

	/**
	 * @return mixed
	 *
	 * @since 5.2.2
	 */
	public function getType() {
		return $this->type;
	}

	/**
	 * @param mixed $type
	 *
	 * @since 5.2.2
	 */
	public function setType($type) {
		$this->type = $type;
	}

	/**
	 * Generates random password
	 *
	 * @return string
	 *
	 * @since 5.2.2
	 */
	private function getRandomPassword() {
		//TODO change this
		return md5(strtotime(date('Y-m-d H:i:s')));
	}

	/**
	 * Retrieves user by email along with profile data
	 *
	 * @param $email string email of the user
	 *
	 * @return mixed
	 *
	 * @since 5.2.2
	 */
	private function getUser($email) {
		$table = JTable::getInstance("UserProfile", "JTable");
		$user  = $table->getOAuthUser($email);

		return $user;
	}

	/**
	 * Creates a new Joomla user and user_profile record based on the data recieved
	 * by the provider.
	 *
	 * @param $userData array of user data
	 * @param $token    string
	 * @param $provider int type of the provider
	 *
	 * @return JUser
	 * @throws Exception
	 *
	 * @since 5.2.2
	 */
	private function createUser($userData, $token, $provider) {
		$password = $this->getRandomPassword();

		$data = array(
			"name"      => $userData['name'],
			"username"  => $userData['email'],
			"password"  => $password,
			"password2" => $password,
			"email"     => $userData['email'],
			"block"     => 0,
			"groups"    => array("1", "2")
		);

		$user = new JUser;
		if (!$user->bind($data)) {
			throw new Exception($user->getError());
		}
		if (!$user->save()) {
			throw new Exception($user->getError());
		}

		$userProfileTable                = JTable::getInstance('UserProfile', 'JTable');
		$userProfileTable->id            = 0;
		$userProfileTable->token         = $token;
		$userProfileTable->provider_type = $provider;
		$userProfileTable->user_id       = $user->id;

		if (!$userProfileTable->store()) {
			throw new Exception($userProfileTable->getError());
		}

		return $user;
	}

	/**
	 * Logs in user
	 *
	 * @param $userData array of user data
	 * @param $token    string
	 * @param $provider int type of the provider
	 *
	 * @return bool
	 * @throws Exception
	 *
	 * @since 5.2.2
	 */
	public function loginUser($userData, $token, $provider) {
		$user = $this->getUser($userData['email']);

		$userData = $this->formatUserData($userData);

		if (empty($user)) {
			try {
				$user = $this->createUser($userData, $token, $provider);
				$user = $this->getUser($user->email);
			} catch (Exception $e) {
				throw $e;
			}
		}

		$user = json_decode(json_encode($user), true); //convert to array

		try {
			JPluginHelper::importPlugin('user');
			$dispatcher = JDispatcher::getInstance();

			// Initiate log in
			$options = array('action' => 'core.login.site', 'remember' => false);
			$results = $dispatcher->trigger('onUserLogin', array($user, $options));

			return $results;
		} catch (Exception $e) {
			throw $e;
		}
	}
}
