class SearchFilterHorizontal extends React.Component {

    constructor(props) {
        super(props);
    }

    componentDidMount() {
        jQuery(".chosen-react").on('change', function(e) {
            let type = jQuery(this).attr('name');
            let val = jQuery(this).chosen().val();

            console.debug(type);
            console.debug(val);
            if(val){
                switch (type) {
                    case "categories":
                        jbdUtils.addFilterRuleCategory(val);
                        break;
                    case "distance":
                        jbdListings.setRadius(val);
                        break;
                    default:
                        jbdUtils.addFilterRule(type, val);
                }
            }
        });

        jQuery(".chosen-react").chosen({
            width: "155px",
            disable_search_threshold: 5,
            inherit_select_classes: true,
            placeholder_text_single: Joomla.JText._('LNG_SELECT_OPTION'),
            placeholder_text_multiple: Joomla.JText._('LNG_SELECT_OPTION')
        });
    }

    render() {

        let showClearFilter = false;

        if (
            this.props.searchKeyword != null ||
            this.props.zipCode != null ||
            (this.props.searchFilter['categories'] != null && this.props.searchFilter['categories'].length > 0) ||
            (this.props.searchFilter['starRating'] != null && this.props.searchFilter['starRating'].length > 0) ||
            (this.props.searchFilter['types'] != null && this.props.searchFilter['types'].length > 0) ||
            (this.props.searchFilter['countries'] != null && this.props.searchFilter['countries'].length > 0) ||
            (this.props.searchFilter['provinces'] != null && this.props.searchFilter['provinces'].length > 0) ||
            (this.props.searchFilter['regions'] != null && this.props.searchFilter['regions'].length > 0) ||
            (this.props.searchFilter['cities'] != null && this.props.searchFilter['cities'].length > 0) ||
            (this.props.searchFilter['areas'] != null && this.props.searchFilter['areas'].length > 0) ||
            (this.props.searchFilter['companies'] != null && this.props.searchFilter['companies'].length > 0) ||
            (this.props.customAttributesValues != null && this.props.customAttributesValues.length > 0) ||
            (this.props.location != null && this.props.location['latitude'] != null)
        ) {
            showClearFilter = false;
        }

        let selectedCategory = null;
        let selectedCategoryName = null;
        if (this.props.category != null) {
            selectedCategory = this.props.category.id;
            selectedCategoryName = this.props.category.name;
        }

        //disable selection
        selectedCategory = null;

        let cityValueField = "city";
        let regionValueField = "region";

        return (
            <div id="search-filter-horizontal" className="search-filter-horizontal">
                <div class="search-filter-label">
                    {Joomla.JText._('LNG_FILTERS')}:
                </div>
                {
                    this.props.searchKeyword != null ?
                        <div className="search-options-item">
                            <div className="jbd-input-box">
                                <i className="icon pencil"></i>
                                <a onClick={() => jbdUtils.removeSearchRule('keyword')}>{this.props.searchKeyword} x</a>
                            </div>
                        </div> : null
                }

                {
                    (this.props.searchFilter['categories'] != null && this.props.searchFilter['categories'].length > 0) ?
                        <div className="search-options-item">
                            <div className="jbd-select-box">
                                <i className="la la-list"></i>
                                <select name="categories" className="chosen-react" value={selectedCategory}
                                        onChange={(e) => jbdUtils.chooseCategory(e.target.value)}>
                                    {selectedCategory != null ? (
                                        <>
                                            <option value="">{Joomla.JText._("LNG_CATEGORY")}</option>
                                            <option value={selectedCategory}>{selectedCategoryName}</option>
                                        </>
                                        ) : (
                                            <option value="">{Joomla.JText._("LNG_CATEGORY")}</option>
                                    )}
                                    {
                                        this.props.searchFilter['categories'].map((filterCriteria) => {
                                            if (filterCriteria[1] > 0 && filterCriteria[0][0].id != selectedCategory) {
                                                return (
                                                    <option
                                                        value={filterCriteria[0][0].id}>{filterCriteria[0][0].name}</option>
                                                )
                                            } else {
                                                return null;
                                            }
                                        })
                                    }
                                </select>
                            </div>
                        </div>
                        : null
                }

                {
                    (this.props.searchFilter['starRating'] != null && this.props.searchFilter['starRating'].length > 0) ?
                        <SearchFilterHorizontalItems
                            items={this.props.searchFilter['starRating']}
                            selectedItems={this.props.selectedParams['starRating']}
                            title={Joomla.JText._('LNG_SELECT_RATING')}
                            type={"starRating"}
                            valueField={"reviewScore"}
                            nameField={"reviewScore"}
                        />
                        : null
                }

                {
                    (this.props.searchFilter['types'] != null && this.props.searchFilter['types'].length > 0) ?
                        <SearchFilterHorizontalItems
                            items={this.props.searchFilter['types']}
                            selectedItems={this.props.selectedParams['type']}
                            title={Joomla.JText._('LNG_SELECT_TYPE')}
                            type={"type"}
                            valueField={"typeId"}
                            nameField={"typeName"}
                        />
                        : null
                }

                {
                    (this.props.searchFilter['countries'] != null && this.props.searchFilter['countries'].length > 0) ?
                        <SearchFilterHorizontalItems
                            items={this.props.searchFilter['countries']}
                            selectedItems={this.props.selectedParams['country']}
                            title={Joomla.JText._('LNG_SELECT_COUNTRY')}
                            type={"country"}
                            valueField={"countryId"}
                            nameField={"countryName"}
                        />
                        : null
                }

                {
                    (this.props.searchFilter['provinces'] != null && this.props.searchFilter['provinces'].length > 0) ?
                        <SearchFilterHorizontalItems
                            items={this.props.searchFilter['provinces']}
                            selectedItems={this.props.selectedParams['province']}
                            title={Joomla.JText._('LNG_PROVINCE')}
                            type={"province"}
                            valueField={"provinceName"}
                            nameField={"provinceName"}
                        />
                        : null
                }

                {
                    (this.props.searchFilter['regions'] != null && this.props.searchFilter['regions'].length > 0) ?
                        <SearchFilterHorizontalItems
                            items={this.props.searchFilter['regions']}
                            selectedItems={this.props.selectedParams['region']}
                            title={Joomla.JText._('LNG_SELECT_REGION')}
                            type={"region"}
                            valueField={regionValueField}
                            nameField={"regionName"}
                        />
                        : null
                }

                {
                    (this.props.searchFilter['cities'] != null && this.props.searchFilter['cities'].length > 0) ?
                        <SearchFilterHorizontalItems
                            items={this.props.searchFilter['cities']}
                            selectedItems={this.props.selectedParams['city']}
                            title={Joomla.JText._('LNG_SELECT_CITY')}
                            type={"city"}
                            valueField={cityValueField}
                            nameField={"cityName"}
                        />
                        : null
                }

                {
                    (this.props.searchFilter['areas'] != null && this.props.searchFilter['areas'].length > 0) ?
                        <SearchFilterHorizontalItems
                            items={this.props.searchFilter['areas']}
                            selectedItems={this.props.selectedParams['area']}
                            title={Joomla.JText._('LNG_SELECT_AREA')}
                            type={"area"}
                            valueField={"areaName"}
                            nameField={"areaName"}
                        />
                        : null
                }

                {
                    (this.props.searchFilter['memberships'] != null && this.props.searchFilter['memberships'].length > 0) ?
                        <SearchFilterHorizontalItems
                            items={this.props.searchFilter['memberships']}
                            selectedItems={this.props.selectedParams['membership']}
                            title={Joomla.JText._('LNG_SELECT_MEMBERSHIP')}
                            type={"membership"}
                            valueField={"membership_id"}
                            nameField={"membership_name"}
                        />
                        : null
                }

                {
                    (this.props.searchFilter != null && this.props.searchFilter['attributes'] != null && this.props.searchFilter['attributes'].length > 0) ?
                        this.props.searchFilter['attributes'].map((items) => {
                            let item = Object.values(items)[0];
                            let nameField = "value";
                            //console.debug(item["optionName"]);
                            if(item["optionName"] != null){
                                nameField = "optionName";
                            }
                            let type = "attribute_" + item["id"];

                            //console.debug(type);
                            //console.debug(nameField);
                            return (
                                <SearchFilterHorizontalItems
                                    items={items}
                                    selectedItems={this.props.selectedParams[type]}
                                    title={item["name"]}
                                    type={type}
                                    valueField={"value"}
                                    nameField={nameField}
                                />
                            )
                        })
                    : null
                }

                {
                    (this.props.searchFilter['companies'] != null && this.props.searchFilter['companies'].length > 0) ?
                        <SearchFilterHorizontalItems
                            items={this.props.searchFilter['companies']}
                            selectedItems={this.props.selectedParams['company']}
                            title={Joomla.JText._('LNG_SELECT_COMPANY')}
                            type={"company"}
                            valueField={"companyId"}
                            nameField={"companyName"}
                        />
                        : null
                }

                {
                    this.props.searchFilter['showDates'] != null && this.props.itemType == JBDConstants.ITEM_TYPE_REQUEST_QUOTE ?
                    <div className="search-options-item">
                    <div className="jbd-date-box">
                        <input type="date" value={this.props.startDate} onChange={(e) => jbdUtils.setFilterDates('startDate', e.target.value)}/>
                    </div>
                </div> : null
                }

                {
                    this.props.searchFilter['showDates'] != null && this.props.itemType == JBDConstants.ITEM_TYPE_REQUEST_QUOTE ?
                    <div className="search-options-item">
                    <div className="jbd-date-box">
                        <input type="date" value={this.props.endDate} onChange={(e) => jbdUtils.setFilterDates('endDate', e.target.value)}/>
                    </div>
                </div> : null
                }

                {/* {
                    (this.props.customAttributesValues != null && this.props.customAttributesValues.length > 0) ?
                        <div className="custom-attributes-filter">
                            {this.props.customAttributesValues.map((attribute, index) => {
                                if (attribute != null) {
                                    return (
                                        <div className="search-options-item" key={index}>
                                            <div className="jbd-input-box">
                                                <a className="filter-type-elem"
                                                   onClick={() => jbdUtils.removeAttrCond(attribute.attribute_id)}>{attribute.name} x</a>
                                            </div>
                                        </div>
                                    )
                                } else {
                                    return null;
                                }
                            })}
                        </div> : null
                } */}

                {
                    this.props.zipCode != null ?
                        <div className="search-options-item">
                            <div className="jbd-input-box">
                                <i className="icon map-marker"></i>
                                <a className="filter-type-elem"
                                   onClick={() => jbdUtils.removeSearchRule('zipcode')}>{this.props.zipCode} x</a>
                            </div>
                        </div> : null
                }

                {
                    (this.props.location != null && this.props.location['latitude'] != null) ?
                        <div className="search-options-item">
                            <div className="jbd-select-box">
                                <i className="la la-list"></i>
                                <select name="distance" className="chosen-react"
                                        onChange={(e) => jbdListings.setRadius(e.target.value)}>
                                    <option value="0">{Joomla.JText._('LNG_RADIUS')}</option>
                                    <option value="10">10</option>
                                    <option value="25">25</option>
                                    <option value="50">50</option>
                                </select>
                            </div>
                        </div> : null
                }

                {
                    showClearFilter ?
                        <div className="search-options-item">
                            <a className="clear-search cursor-pointer" onClick={() => jbdUtils.resetFilters(true, true)}
                               style={{textDecoration: "none"}}>{Joomla.JText._('LNG_CLEAR')}</a>
                        </div> : null
                }
            </div>
        )
    }
}