<?php
/**
 * @package    JBusinessDirectory
 *
 * @author CMSJunkie http://www.cmsjunkie.com
 * @copyright  Copyright (C) 2007 - 2021 CMSJunkie. All rights reserved.
 * @license   https://www.gnu.org/licenses/agpl-3.0.en.html
 */
defined('_JEXEC') or die('Restricted access');



// No direct access
defined('_JEXEC') or die('Restricted access');


class JBusinessDirectoryViewUpdates extends JBusinessDirectoryAdminView {
	
	/**
	 * Display the view
	 */
	public function display($tpl = null) {
		$this->appSettings = JBusinessUtil::getApplicationSettings();
		$this->items = $this->get('Items');
		$this->currentVersion = JBusinessUtil::getCurrentVersion();
		$this->state = $this->get('State');
		$this->expirationDate= $this->get('ExpirationDate');

		// Check for errors.
		if (count($errors = $this->get('Errors'))) {
			JError::raiseError(500, implode("\n", $errors));
			return false;
		}
		
		$language = JFactory::getLanguage();
		$language_tag 	= $language->getTag();
		
		$language->load(
			'com_installer',
			dirname(JPATH_ADMINISTRATOR.DS.'language'),
			$language_tag,
			true
		);
		
		$this->addToolbar();
		parent::display($tpl);
	}
	
	/**
	 * Add the page title and toolbar.
	 *
	 * @since   1.6
	 */
	protected function addToolbar() {
		JToolBarHelper::title('J-BusinessDirectory '.JText::_('LNG_UPDATES', true), 'generic.png');
		JToolbarHelper::custom('updates.saveOrder', 'save', 'save', 'LNG_SAVE_ORDER', false, false);
		JToolbarHelper::custom('updates.update', 'upload', 'upload', 'COM_INSTALLER_TOOLBAR_UPDATE', false, false);
		JToolbarHelper::custom('updates.find', 'refresh', 'refresh', 'COM_INSTALLER_TOOLBAR_FIND_UPDATES', false, false);
		JToolbarHelper::divider();
		JToolBarHelper::custom('updates.back', 'dashboard', 'dashboard', JText::_("LNG_CONTROL_PANEL"), false, false);
		JToolBarHelper::help('', false, DOCUMENTATION_URL.'businessdiradmin.html#updates');
	}
}
