<?php
/**
 * @package    JBusinessDirectory
 *
 * @author CMSJunkie http://www.cmsjunkie.com
 * @copyright  Copyright (C) 2007 - 2021 CMSJunkie. All rights reserved.
 * @license   https://www.gnu.org/licenses/agpl-3.0.en.html
 */

defined('_JEXEC') or die('Restricted access');
JHtml::addIncludePath(JPATH_COMPONENT.'/helpers/html');

JHtml::_('bootstrap.tooltip');
JHtml::_('behavior.multiselect');
JBusinessUtil::initializeChosen();

use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Multilanguage;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Layout\LayoutHelper;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Session\Session;

$listOrder	= $this->escape($this->state->get('list.ordering'));
$listDirn	= $this->escape($this->state->get('list.direction'));
$canOrder	= true;
$saveOrder	= $listOrder == 'p.ordering';
$saveOrderingUrl = JBusinessUtil::addSorting($saveOrder, $listDirn);

?>

<script type="text/javascript">
window.addEventListener('load', function() {
	Joomla.submitbutton = function(task) {
		if (task != 'companies.delete' || confirm('<?php echo JText::_('COM_JBUSINESS_DIRECTORY_OFFERS_CONFIRM_DELETE', true);?>')) {
			Joomla.submitform(task);
		}
    }
});
</script>

<div id="jbd-container" class="jbd-container">
    <form action="<?php echo JRoute::_('index.php?option=com_jbusinessdirectory&view=packages');?>" method="post" name="adminForm" id="adminForm">
        <div id="j-main-container" class="j-main-container">
		    <?php
		    // Search tools bar
		    echo
            JLayoutHelper::render('joomla.searchtools.default', array('view' => $this, 'options' => array('filtersHidden' =>JBusinessUtil::setFilterVisibility($this->state))));
            ?>
        </div>
        <div class="clr clearfix"></div>

	    <?php if (empty($this->items)) { ?>
            <div class="alert alert-warning">
			    <?php echo Text::_('JGLOBAL_NO_MATCHING_RESULTS'); ?>
            </div>
	    <?php } else { ?>

        <table class="jtable" id="itemList">
            <thead class="jtable-head">
                <tr class="jtable-head-row">
                    <td class="jtable-head-row-data"></td>
                    <th class="jtable-head-row-data">
                        <?php echo JHtml::_('searchtools.sort', '', 'p.ordering', $listDirn, $listOrder, null, 'asc', 'JGRID_HEADING_ORDERING', 'icon-menu-2'); ?>
                    </th>
                    <th class="jtable-head-row-data">
                        <div class="d-flex justify-content-center align-items-center">
                            <div class="jradio">
                                <input id="jradio-2" type="checkbox" title="<?php echo JText::_('JGLOBAL_CHECK_ALL');?>" onclick="Joomla.checkAll(this)" />
                                <label for="jradio-2"></label>
                            </div>
                        </div>
                    </th>
                    <th class="jtable-head-row-data">
                        <div class="d-flex justify-content-center align-items-center">
                            <span class="jtable-head-row-data-title"> # </span>
                        </div>
                    </th>
                    <th class="jtable-head-row-data"><?php echo HTMLHelper::_('searchtools.sort', 'LNG_NAME', 'p.name', $listDirn, $listOrder); ?></th>
                    <th class="jtable-head-row-data"><?php echo JText::_('LNG_TYPE')?></th>
                    <th class="jtable-head-row-data"><?php echo JText::_('LNG_PACKAGE_TYPE')?></th>
                    <th class="jtable-head-row-data"><?php echo JText::_('LNG_ONLY_FOR_ADMIN');?></th>
                    <th class="jtable-head-row-data"><?php echo JText::_('LNG_FEATURES')?></th>
                    <th class="jtable-head-row-data"><?php echo HTMLHelper::_('searchtools.sort', 'LNG_PRICE', 'p.price', $listDirn, $listOrder); ?></th>
                    <!-- th nowrap="nowrap" width='10%' ><?php echo HTMLHelper::_('searchtools.sort', 'LNG_SPECIAL_PRICE', 'p.special_price', $listDirn, $listOrder); ?></th>
                    <th nowrap="nowrap" width='10%' ><?php echo HTMLHelper::_('searchtools.sort', 'LNG_SPECIAL_START_DATE', 'p.special_from_date', $listDirn, $listOrder); ?></th>
                    <th nowrap="nowrap" width='10%' ><?php echo HTMLHelper::_('searchtools.sort', 'LNG_SPECIAL_END_DATE', 'p.special_to_date', $listDirn, $listOrder); ?></th-->
                    <th class="jtable-head-row-data"><?php echo JText::_('LNG_DURATION')?></th>
                    <th class="jtable-head-row-data"><?php echo HTMLHelper::_('searchtools.sort', 'LNG_POPULAR', 'p.popular', $listDirn, $listOrder); ?></th>
                    <th class="jtable-head-row-data"><?php echo HTMLHelper::_('searchtools.sort', 'LNG_STATUS', 'p.status', $listDirn, $listOrder); ?></th>
                    <th class="jtable-head-row-data"><?php echo HTMLHelper::_('searchtools.sort', 'LNG_ID', 'p.id', $listDirn, $listOrder); ?></th>
                </tr>
            </thead>
            <tfoot>
                <tr>
                    <td colspan="15">
                        <?php echo $this->pagination->getListFooter(); ?>
                    </td>
                </tr>
            </tfoot>
            <tbody <?php if ($saveOrder) :?> class="jtable-body js-draggable" data-url="<?php echo $saveOrderingUrl; ?>" data-direction="<?php echo strtolower($listDirn); ?>" data-nested="false"<?php endif; ?>>
            <?php $nrcrt = 1; $i=0;
                $count = count($this->items);
                foreach ($this->items as $item) {
                    $ordering  = ($listOrder == 'p.ordering');
                    $canCreate  = true;
                    $canEdit    = true;
                    $canChange  = true;
                    ?>
                    <TR class="jtable-body-row" data-draggable-group="3">
                        <td class="jtable-body-row-data">
                            <div class="d-flex align-items-center">
                                <div id="item-status-<?php echo $item->id?>" class="jtable-body-status <?php echo $item->status == 1?"bg-success":"bg-danger" ?> "></div>
                            </div>
                        </td>

                        <td class="order jtable-body-row-data">
                            <?php
                            $iconClass = '';
                            if (!$canChange) {
                                $iconClass = ' inactive';
                            }
                            elseif (!$saveOrder) {
                                $iconClass = ' inactive tip-top hasTooltip" title="' . JHtml::tooltipText('JORDERINGDISABLED');
                            } ?>
                            <span class="sortable-handler<?php echo $iconClass ?>">
                                <i class="la la-ellipsis-v"></i>
                            </span>
                            <?php if ($canChange && $saveOrder) : ?>
                                <input type="text" style="display:none" name="order[]" size="5" value="<?php echo !empty($item->ordering)?$item->ordering : $nrcrt; ?>" />
                            <?php endif; ?>
                        </td>

                        <td class="jtable-body-row-data px-3">
                            <?php echo HTMLHelper::_('jbdgrid.id', $i, $item->id); ?>
                        </td>

                        <td class="jtable-body-row-data"><?php echo $nrcrt++?></td>

                        <TD class="jtable-body-row-data">
                            <a href='<?php echo JRoute::_( 'index.php?option=com_jbusinessdirectory&task=package.edit&id='. $item->id )?>'
                                title="<?php echo JText::_('LNG_CLICK_TO_EDIT'); ?>"> <B><?php echo $item->name?>
                                </B>
                            </a>
                        </TD>

                        <td class="jtable-body-row-data">
                            <?php
                            switch($item->expiration_type){
                                  case 1:
                                  echo JText::_("LNG_LIFE_TIME");
                                      break;
                                  case 2:
                                      echo JText::_("LNG_FIXED");
                                      break;
                                  case 3:
                                      echo JText::_("LNG_RECURRING");
                                      break;
                                  case 4:
                                      echo JText::_("LNG_RECURRING_WTIH_TRIAL");
                                      break;
                                  default:
                                      echo JText::_("LNG_FIXED");
                              }

                            ?>
                        </td>

                        <td class="jtable-body-row-data">
                            <?php
                                switch($item->package_type){
                                  case 1:
                                  echo JText::_("LNG_BUSINESS");
                                      break;
                                  case 2:
                                      echo JText::_("LNG_USER");
                                      break;
                                  default:
                                      echo JText::_("LNG_NONE");
                              }

                            ?>
                        </td>

                        <td class="jtable-body-row-data">
				            <?php echo $item->only_for_admin? JText::_('LNG_YES'):JText::_('LNG_NO')?>
		                </td>
		                
                        <td class="jtable-body-row-data">
                            <?php echo $item->features ?>
                        </td>

                        <td class="jtable-body-row-data">
                            <?php echo JBusinessUtil::convertPriceFromMysql($item->price);?>
                        </td>
						<td class="jtable-body-row-data nowrap">
                        	<span>
                                <?php
                                    echo JBusinessUtil::getPackageDuration($item);
                                ?>
                        	</span>
                        </td>
                        <td class="jtable-body-row-data px-3">
                            <?php echo HTMLHelper::_('jbdgrid.action', $i , "chagePopularState", 'packages.',"",$item->popular==1?"Popular":"Set as popular","",true, $item->popular==1?"la la-star":"la la-star-o","", true); ?>
                        </td>

                        <td class="jtable-body-row-data">
                            <?php echo HTMLHelper::_('jbdgrid.published', $item->status, $i, 'packages.', true, 'cb', true, true, $item->id); ?>
                        </td>

                        <td class="jtable-body-row-data">
                            <?php echo $item->id?>
                        </td>
                    </TR>
                <?php
                $i++;
                } ?>
            </tbody>
        </table>

        <?php } ?>

        <input type="hidden" name="option" value="<?php echo JBusinessUtil::getComponentName()?>" />
        <input type="hidden" name="task" value="" />
        <input type="hidden" name="boxchecked" value="0" />
        <?php echo JHTML::_('form.token'); ?>
    </form>
</div>