<?php
/**
 * @package    JBusinessDirectory
 *
 * @author CMSJunkie http://www.cmsjunkie.com
 * @copyright  Copyright (C) 2007 - 2021 CMSJunkie. All rights reserved.
 * @license   https://www.gnu.org/licenses/agpl-3.0.en.html
 */

defined('_JEXEC') or die('Restricted access');

/**
 * The HTML  View.
 */

JBusinessUtil::loadJQueryUI();

JBusinessUtil::enqueueStyle('libraries/multi/multi.css');
JBusinessUtil::enqueueScript('libraries/multi/multi.js');

JBusinessUtil::includeValidation();
require_once HELPERS_PATH.'/helper.php';

class JBusinessDirectoryViewPackage extends JBusinessDirectoryAdminView {
	protected $item;
	protected $state;

	/**
	 * Display the view
	 */
	public function display($tpl = null) {
		$this->item	 = $this->get('Item');
		$this->state = $this->get('State');

		$this->statuses	= JBusinessDirectoryHelper:: getStatuses();
		$this->userGroups = JBusinessUtil::getUserGroups();
		
		$this->selectedFeatures = $this->get('SelectedFeatures');
		$this->extraFeatures = array();

		// Check if the attribute is being created or edited, and assign the type value accordingly
		if (!isset($this->item->package_type)) {
			$this->type = $this->state->get('package.type');
		} else {
			$this->type = $this->item->package_type;
		}
		if($this->type == PACKAGE_TYPE_BUSINESS) {
			$this->features = JBusinessDirectoryHelper::getPackageFeatures();
			$this->customFeatures = JBusinessDirectoryHelper::getPackageCustomFeatures();
		}else {
			$this->features = JBusinessDirectoryHelper::getUserPackageFeatures();
			$this->customFeatures = array();
		}


		foreach ($this->selectedFeatures as $selFeature) {
			if (!array_key_exists($selFeature, $this->features)) {
				$found = false;
				foreach ($this->customFeatures as $cFeature) {
					if ($cFeature->code==$selFeature) {
						$found = true;
						break;
					}
				}
				if (!$found) {
					$this->extraFeatures[] = $selFeature;
				}
			}
		}
		
		$this->appSettings = JBusinessUtil::getApplicationSettings();
		$this->translations = JBusinessDirectoryTranslations::getAllTranslations(PACKAGE_TRANSLATION, $this->item->id);
		$this->languages = JBusinessUtil::getLanguages();
		
		$this->paymentOccurances = JBusinessUtil::getPaymentOccurances();

		// Check for errors.
		if (count($errors = $this->get('Errors'))) {
			JError::raiseError(500, implode("\n", $errors));
			return false;
		}
		$this->addToolbar();
		
		parent::display($tpl);
	}

	/**
	 * Add the page title and toolbar.
	 *
	 * @since   1.6
	 */
	protected function addToolbar() {
		$canDo = JBusinessDirectoryHelper::getActions();
		$input = JFactory::getApplication()->input;
		$input->set('hidemainmenu', true);

		$isNew = ($this->item->id == 0);

		JToolbarHelper::title(JText::_($isNew ? 'COM_JBUSINESSDIRECTORY_NEW_PACKAGE' : 'COM_JBUSINESSDIRECTORY_EDIT_PACKAGE'), 'menu.png');
		
		if ($canDo->get('core.edit')) {
			JToolbarHelper::apply('package.apply');
			JToolbarHelper::save('package.save');
		}
		
		JToolbarHelper::cancel('package.cancel', 'JTOOLBAR_CLOSE');
		
		JToolbarHelper::divider();
		JToolBarHelper::help('', false, DOCUMENTATION_URL.'businessdiradmin.html#packages');
	}
}
