<?php
/**
 * @package    JBusinessDirectory
 *
 * @author     CMSJunkie http://www.cmsjunkie.com
 * @copyright  Copyright (C) 2007 - 2018 CMS Junkie. All rights reserved.
 * @license    https://www.gnu.org/licenses/agpl-3.0.en.html
 */

defined('_JEXEC') or die('Restricted access');
require_once HELPERS_PATH.'/helper.php';
JBusinessUtil::includeValidation();

/**
 * The HTML View
 *
 */
class JBusinessDirectoryViewOrder extends JBusinessDirectoryAdminView {
	protected $item;
	protected $state;

	/**
	 * Display the view
	 */
	public function display($tpl = null) {
		$this->item  = $this->get('Item');
		$this->state = $this->get('State');

		$this->states      = JBusinessDirectoryHelper::getOrderStates();
		$this->appSettings = JBusinessUtil::getApplicationSettings();

		// Check for errors.
		if (count($errors = $this->get('Errors'))) {
			JError::raiseError(500, implode("\n", $errors));
			return false;
		}
		$this->addToolbar();

		parent::display($tpl);
	}

	/**
	 * Add the page title and toolbar.
	 *
	 * @since   1.6
	 */
	protected function addToolbar() {
		$canDo = JBusinessDirectoryHelper::getActions();
		$input = JFactory::getApplication()->input;
		$input->set('hidemainmenu', true);
		$isNew = ($this->item->id == 0);

		JToolbarHelper::title(JText::_($isNew ? 'COM_JBUSINESSDIRECTORY_NEW_ORDER' : 'COM_JBUSINESSDIRECTORY_EDIT_ORDER'), 'menu.png');

		if ($canDo->get('core.edit') && (!empty($this->item->company) || $this->item->company_id == -1)) {
			JToolbarHelper::apply('order.apply');
			JToolbarHelper::save('order.save');
		}

		JToolbarHelper::cancel('order.cancel', 'JTOOLBAR_CLOSE');

		JToolbarHelper::divider();
		JToolBarHelper::help('', false, DOCUMENTATION_URL . 'businessdiradmin.html#orders');
	}
}
