<?php
/**
 * @package    JBusinessDirectory
 *
 * @author     CMSJunkie http://www.cmsjunkie.com
 * @copyright  Copyright (C) 2007 - 2018 CMS Junkie. All rights reserved.
 * @license    https://www.gnu.org/licenses/agpl-3.0.en.html
 */

defined('_JEXEC') or die('Restricted access');

// Include the component HTML helpers.
JHtml::addIncludePath(JPATH_COMPONENT.'/helpers/html');

// Load the tooltip behavior.
JHtml::_('formbehavior.chosen', 'select');
?>

<script type="text/javascript">
window.addEventListener('load', function() {
	Joomla.submitbutton = function(task)
	{
		jQuery("#item-form").validationEngine('detach');
		if (task == 'order.cancel' || !jbdUtils.validateCmpForm(false, false)){
			Joomla.submitform(task, document.getElementById('item-form'));
		}
		jQuery("#item-form").validationEngine('attach');
    }
});
</script>

<div id="jbd-container" class="jbd-container jbd-edit-container">
    <form action="<?php echo JRoute::_('index.php?option=com_jbusinessdirectory&layout=edit&id='.(int) $this->item->id); ?>" method="post" name="adminForm" id="item-form" class="form-horizontal">
        <div class="row">
            <div class="col-md-7">
            <?php if(empty($this->item->company) && $this->item->company_id != -1){?>
                <div><?php echo JText::_("LNG_BUSINESS_DELETED");?></div>
            <?php }else{ ?>
                <div class="row">
                    <div class="col-md-12">
                        <fieldset class="boxed">

                            <h2> <?php echo JText::_('LNG_EDIT_ORDER');?></h2>
                            <div class="form-container">

                                <div class="form-group">
                                    <label for="order"><?php echo JText::_('LNG_ORDER_ID')?> </label>
                                    <input type="text"
                                           name="order_id" id="order_id-lbl" class="form-control hasTooltip" data-toggle="tooltip" value="<?php echo $this->item->order_id ?>" maxlength="4" disabled>
                                </div>
                                <?php if($this->item->company_id != -1) {?>
                                    <div class="form-group">
                                        <label for="company"><?php echo JText::_('LNG_COMPANY')?> </label>
                                        <input type="text" name="companyName" id="company_id-lbl" class="form-control hasTooltip" data-toggle="tooltip" value="<?php echo $this->item->companyName ?>" maxlength="45" disabled>
                                    </div>                                    
                                <?php } else { ?>
                                    <div class="form-group">
                                        <label for="user"><?php echo JText::_('LNG_USER')?> </label>
                                        <input type="text" name="userName" id="company_id-lbl" class="form-control hasTooltip" data-toggle="tooltip" value="<?php echo $this->item->user_name ?>" maxlength="45" disabled>
                                    </div>
                                <?php } ?>

                                <div class="form-group">
                                    <label for="package"><?php echo JText::_('LNG_PACKAGE')?> </label>
                                    <input type="text" name="packageName" id="package_id" class="form-control hasTooltip" data-toggle="tooltip" value="<?php echo $this->item->packageName ?>" maxlength="45" disabled>
                                </div>

                                <div class="form-group">
                                    <label for="package"><?php echo JText::_('LNG_AMOUNT')?> </label>
                                    <input type="text" name="amount" id="amount_id" class="form-control hasTooltip" data-toggle="tooltip" value="<?php echo $this->item->amount ?>" maxlength="45">
                                </div>

                                <div class="form-group">
                                    <label for="payment_date_fld"><?php echo JText::_('LNG_PAYMENT_DATE')?></label>
                                        <?php echo JHTML::_('calendar', $this->item->paid_at, 'paid_at', 'paid_at', $this->appSettings->calendarFormat, array('class'=>'form-control calendar-date', 'size'=>'10',  'maxlength'=>'10')); ?>
                                </div>

                                <div class="form-group">
                                    <label for="transaction"><?php echo JText::_('LNG_TRANSACTION_ID')?> </label>
                                    <input type="text"
                                           name="transaction_id" id="transaction_id" class="form-control hasTooltip" data-toggle="tooltip" value="<?php echo $this->item->transaction_id ?>" maxlength="45">
                                </div>

                                <div class="form-group">
                                    <label for="state"><?php echo JText::_('LNG_STATE')?> </label>
                                    <select id='state' name='state' class="form-control">
                                        <?php foreach ($this->states as $allstates){?>
                                            <option value = '<?php echo $allstates->value?>' <?php echo $allstates->value==$this->item->state? "selected" : ""?>> <?php echo $allstates->text?></option>
                                        <?php } ?>
                                    </select>
                                </div>

                                <div class="form-group">
                                    <label for="start_date_fld"><?php echo JText::_('LNG_START_DATE')?> </label>
                                        <?php echo JHTML::_('calendar', $this->item->start_date, 'start_date', 'start_date', $this->appSettings->calendarFormat, array('class'=>'form-control calendar-date', 'size'=>'10',  'maxlength'=>'10')); ?>
                                </div>
                                
                                <div class="form-group">
                                    <label for="start_date_fld"><?php echo JText::_('LNG_END_DATE')?> </label>
                                        <?php echo JHTML::_('calendar', $this->item->end_date, 'end_date', 'end_date', $this->appSettings->calendarFormat, array('class'=>'form-control calendar-date', 'size'=>'10',  'maxlength'=>'10')); ?>
                                </div>

                                <div class="form-group">
                                    <label for="start_date_fld"><?php echo JText::_('LNG_START_TRIAL_DATE')?> </label>
                                        <?php echo JHTML::_('calendar', $this->item->start_trial_date, 'start_trial_date', 'start_trial_date', $this->appSettings->calendarFormat, array('class'=>'form-control calendar-date', 'size'=>'10',  'maxlength'=>'10')); ?>
                                </div>

                                <div class="form-group">
                                    <label for="start_date_fld"><?php echo JText::_('LNG_END_TRIAL_DATE')?> </label>
                                        <?php echo JHTML::_('calendar', $this->item->end_trial_date, 'end_trial_date', 'end_trial_date', $this->appSettings->calendarFormat, array('class'=>'form-control calendar-date', 'size'=>'10',  'maxlength'=>'10')); ?>
                                </div>

                                <div class="form-group">
                                    <label for="order"><?php echo JText::_('LNG_CREATION_DATE')?> </label>
                                    <input type="text"
                                           name="creation-date_id" id="creation-date-lbl" class="form-control hasTooltip" data-toggle="tooltip" value="<?php echo $this->item->created ?>" maxlength="4" disabled>
                                </div>

                                <div class="form-group">
                                    <label for="order"><?php echo JText::_('LNG_ID')?> </label>
                                    <input type="text"
                                           name="id_id" id="id_id" class="form-control hasTooltip" data-toggle="tooltip" value="<?php echo $this->item->id ?>" maxlength="4" disabled>
                                </div>

                                <div class="form-group">
                                    <label for="observation_id"><?php echo JText::_("LNG_OBSERVATION")?></label>
                                    <p class="small"><?php echo JText::_("LNG_OBSERVATION_INFO")?></p>
                                    <textarea name="observation" id="observation" class="form-control text-input h-auto" cols="75" rows="10" maxLength="250"><?php echo $this->item->observation ?></textarea>
                                </div>
                            </div>
                        </fieldset>
                    </div>
                </div>
            <?php }?>
            </div>
        </div>
        <input type="hidden" name="option" value="<?php echo JBusinessUtil::getComponentName()?>" />
        <input type="hidden" name="task" value="" />
        <input type="hidden" name="id" value="<?php echo $this->item->id ?>" />

        <?php echo JHTML::_( 'form.token' ); ?>
    </form>
</div>

<script>
	window.addEventListener('load', function(){
		jQuery("#item-form").validationEngine('attach');
	});
</script>
