<?php
/**
 * @package    JBusinessDirectory
 *
 * @author CMSJunkie http://www.cmsjunkie.com
 * @copyright  Copyright (C) 2007 - 2021 CMSJunkie. All rights reserved.
 * @license   https://www.gnu.org/licenses/agpl-3.0.en.html
 */

defined('_JEXEC') or die('Restricted access');

// Include the component HTML helpers.
JHtml::addIncludePath(JPATH_COMPONENT.'/helpers/html');

// Load the tooltip behavior.
?>

<script type="text/javascript">
window.addEventListener('load', function() {
	Joomla.submitbutton = function(task) {
		var defaultLang="<?php echo JBusinessUtil::getLanguageTag() ?>";

		jQuery("#item-form").validationEngine('detach');
		var evt = document.createEvent("HTMLEvents");
		evt.initEvent("click", true, true);
		var tab = ("tab-"+defaultLang);
		if(!(document.getElementsByClassName(tab)[0] === undefined || document.getElementsByClassName(tab)[0] === null))
			document.getElementsByClassName(tab)[0].dispatchEvent(evt);
		if (task == 'offertype.cancel' || !jbdUtils.validateCmpForm(false, false)) {
			Joomla.submitform(task, document.getElementById('item-form'));
		}
		jQuery("#item-form").validationEngine('attach');
    }
});
</script>

<?php
$jbdTabs = new JBDTabs();
$options = array(
	'onActive' => 'function(title, description){
		description.setStyle("display", "block");
		title.addClass("open").removeClass("closed");
}',
	'onBackground' => 'function(title, description){
		description.setStyle("display", "none");
		title.addClass("closed").removeClass("open");
}',
	'startOffset' => 0,  // 0 starts on the first tab, 1 starts the second, etc...
	'useCookie' => true, // this must not be a string. Don't use quotes.
);
?>
<div id="jbd-container" class="jbd-container jbd-edit-container">
	<form action="<?php echo JRoute::_('index.php?option=com_jbusinessdirectory&view=offertype');?>" method="post" name="adminForm" id="item-form">
        <div class="row">
            <div class="col-12 order-1 col-md-7">
                <div class="row">
                    <div class="col-md-12">
                        <fieldset class="boxed">

                            <h2> <?php echo JText::_('LNG_OFFER_TYPE');?></h2>

                            <div class="form-container  label-w-100">

                                <div class="form-group">
                                    <label for="subject"><?php echo JText::_('LNG_NAME')?><?php echo JBusinessUtil::showMandatory(ATTRIBUTE_MANDATORY) ?></label>
                                    <?php
                                    $jbdTabs->setOptions($options);
                                    if($this->appSettings->enable_multilingual) {
                                        echo $jbdTabs->startTabSet('tab_groupsd_id');
                                        foreach ($this->languages as $k => $lng) {
                                            echo $jbdTabs->addTab('tab_groupsd_id', 'tab-' . $lng, $k);
                                            $langContent = isset($this->translations[$lng . "_name"]) ? $this->translations[$lng . "_name"] : "";
                                            if ($lng == JBusinessUtil::getLanguageTag() && empty($langContent)) {
                                                $langContent = $this->item->name;
                                            }
                                            $langContent = $this->escape($langContent);
                                            echo "<input type='text' name='name_$lng' id='name_$lng' class='input_txt form-control validate[required]' value=\"" . stripslashes($langContent) . "\"  maxLength='100'>";
                                            echo $jbdTabs->endTab();
                                        }
                                        echo $jbdTabs->endTabSet();
                                    } else { ?>
                                            <input type="text" name="name" id="name" class="input_txt form-control validate[required]" value="<?php echo $this->escape($this->item->name) ?>"  maxLength="100">
                                    <?php } ?>
                                </div>

                            </div>

                        </fieldset>
                    </div>
                </div>
            </div>
        </div>
		<input type="hidden" name="option" value="<?php echo JBusinessUtil::getComponentName()?>" />
		<input type="hidden" name="task" value="" />
		<input type="hidden" name="id" value="<?php echo $this->item->id ?>" />
		<?php echo JHTML::_( 'form.token' ); ?>
	</form>
</div>