<?php
/**
 * @package    JBusinessDirectory
 *
 * @author CMSJunkie http://www.cmsjunkie.com
 * @copyright  Copyright (C) 2007 - 2021 CMSJunkie. All rights reserved.
 * @license   https://www.gnu.org/licenses/agpl-3.0.en.html
 */ 
defined('_JEXEC') or die('Restricted access');
JHtml::addIncludePath(JPATH_COMPONENT.'/helpers/html');

use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Multilanguage;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Layout\LayoutHelper;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Session\Session;

JHtml::_('bootstrap.tooltip');
JHtml::_('behavior.multiselect');
 JBusinessUtil::initializeChosen();

$listOrder	= $this->escape($this->state->get('list.ordering'));
$listDirn	= $this->escape($this->state->get('list.direction'));
?>

<script type="text/javascript">
window.addEventListener('load', function() {
	Joomla.submitbutton = function(task) {
		if (task != 'offers.delete' || confirm('<?php echo JText::_('ARE_YOU_SURE_YOU_WANT_TO_DELETE', true);?>')) {
			Joomla.submitform(task);
		}
	}
});
</script>

<div id="jbd-container" class="jbd-container">
    <form action="<?php echo JRoute::_('index.php?option=com_jbusinessdirectory&view=offers');?>" method="post" name="adminForm" id="adminForm">
    	<div id="j-main-container" class="j-main-container">
    		<?php
        		// Search tools bar
        		echo
                JLayoutHelper::render('joomla.searchtools.default', array('view' => $this, 'options' => array('filtersHidden' =>JBusinessUtil::setFilterVisibility($this->state))));
            ?>
    	</div>
    	<div class="clr clearfix"></div>
    	
    	<?php if (empty($this->items)) { ?>
			<div class="alert alert-warning">
				<?php echo Text::_('JGLOBAL_NO_MATCHING_RESULTS'); ?>
			</div>
		<?php }else{ ?>

        	<table class="jtable" id="itemList">
        		<thead class="jtable-head">
        			<tr class="jtable-head-row">
                        <td class="jtable-head-row-data"></td>
                        <th class="jtable-head-row-data">
                            <div class="d-flex justify-content-center align-items-center">
                                <div class="jradio">
                                    <input id="jradio-2" type="checkbox" title="<?php echo JText::_('JGLOBAL_CHECK_ALL');?>" onclick="Joomla.checkAll(this)" />
                                    <label for="jradio-2"></label>
                                </div>
                            </div>
                        </th>
                        <th class="jtable-head-row-data">
                            <div class="d-flex justify-content-center align-items-center">
                                <span class="jtable-head-row-data-title"> # </span>
                            </div>
                        </th>

                        <th class="jtable-head-row-data"></th>
                        <th class="jtable-head-row-data"><?php echo HTMLHelper::_('searchtools.sort', 'LNG_NAME', 'co.subject', $listDirn, $listOrder); ?></th>
                        <th class="jtable-head-row-data"><?php echo HTMLHelper::_('searchtools.sort', 'LNG_COMPANY', 'bc.name', $listDirn, $listOrder); ?></th>

                        <?php if ($this->state->get('filter.type') == OFFER_TYPE_OFFER){ ?>
                            <th class="jtable-head-row-data" width="10%"><?php echo HTMLHelper::_('searchtools.sort', 'LNG_PUBLISH_DATES', 'co.publish_start_date', $listDirn, $listOrder); ?></th>
                            <th class="jtable-head-row-data text-center" width="10%"><?php echo HTMLHelper::_('searchtools.sort', 'LNG_DATES', 'co.startDate', $listDirn, $listOrder); ?></th>
                        <?php } ?>

                        <th class="jtable-head-row-data"><?php echo HTMLHelper::_('searchtools.sort', 'LNG_VIEW_NUMBER', 'co.viewCount', $listDirn, $listOrder,"LNG_VIEWS"); ?></th>


                        <th class="jtable-head-row-data"><?php echo HTMLHelper::_('searchtools.sort', 'LNG_STATE', 'co.state', $listDirn, $listOrder); ?></th>
                        <th class="jtable-head-row-data"><?php echo HTMLHelper::_('searchtools.sort', 'LNG_APROVED', 'co.approved', $listDirn, $listOrder); ?></th>
                        <th class="jtable-head-row-data"><?php echo JText::_('LNG_STATUS') ?></th>

                        <th class="jtable-head-row-data"></th>

                        <th class="jtable-head-row-data"><?php echo HTMLHelper::_('searchtools.sort', 'LNG_ID', 'co.id', $listDirn, $listOrder); ?></th>
        			</tr>
        		</thead>
        		<tfoot>
        			<tr>
        				<td colspan="15">
        					<?php echo $this->pagination->getListFooter(); ?>
        				</td>
        			</tr>
        		</tfoot>
        		<tbody class="jtable-body">
        			<?php $nrcrt = 1; $i=0;
        			foreach ($this->items as $offer) { ?>
                        <tr class="jtable-body-row">
                            <td class="jtable-body-row-data">
                                <div class="d-flex align-items-center">
			                        <?php
			                        $bgClass = "bg-success";
			                        if (($offer->state == 1) && ($offer->approved == 1)) {
				                        if ($offer->expired || !$offer->allow_offers || $offer->not_visible) {
					                        $bgClass = "bg-warning";
				                        }
			                        } else {
				                        $bgClass = "bg-danger";
			                        }

			                        ?>

                                    <div id="item-status-<?php echo $offer->id?>" class="jtable-body-status <?php echo $bgClass ?>"></div>
                                </div>
                            </td>

                            <td class="jtable-body-row-data px-3">
		                        <?php echo HTMLHelper::_('jbdgrid.id', $i, $offer->id); ?>
                            </td>

                            <td class="jtable-body-row-data"><?php echo $nrcrt++?></td>

                            <td class="jtable-body-row-data px-3">
		                        <?php echo HTMLHelper::_('jbdgrid.action', $i , "changeStateFeatured", 'offer.',"",$offer->featured == 1 ? "Featured":"Not featured","",true, $offer->featured == 1 ? "la la-star" : "la la-star-o","", true); ?>
                            </td>

                            <td class="jtable-body-row-data jtable-body-name">
                                <div class="d-flex align-items-center">
                                    <a href='<?php echo JRoute::_( 'index.php?option=com_jbusinessdirectory&task=offer.edit&id='. $offer->id ) ?>'>
				                        <?php if (!empty($offer->picture_path)) { ?>
                                            <img src="<?php echo BD_PICTURES_PATH.$offer->picture_path ?>" class="jtable-data-img" />
				                        <?php } else { ?>
                                            <img src="<?php echo BD_PICTURES_PATH.'/no_image.jpg' ?>" class="jtable-data-img" />
				                        <?php } ?>
                                    </a>

                                    <span class="ml-3 d-flex flex-column justify-content-center">
                                    <span class="jtable-body-row-data-title">
                                        <a href="<?php echo JRoute::_( 'index.php?option=com_jbusinessdirectory&task=offer.edit&id='. $offer->id ) ?>"
                                           title="<?php echo JText::_('LNG_CLICK_TO_EDIT'); ?>">
                                            <b><?php echo strip_tags($offer->subject) ?></b>
                                        </a><br/>
                                    </span>
                                    <span class="jtable-body-row-data-allias"><?php echo $offer->alias ?></span>
                                </span>
                                </div>
                            </td>

                            <td class="jtable-body-row-data">
		                        <?php echo strip_tags($offer->companyName) ?>
                            </td>

	                        <?php if ($this->state->get('filter.type') == OFFER_TYPE_OFFER){ ?>
                                <td class="jtable-body-row-data">
                                    <div class="d-flex justify-content-center">
                                        <div class="text-right pr-2">
                                            <span class="d-block jtable-body-text jtable-body-text-seconday">
                                                <?php
                                                if (!JBusinessUtil::emptyDate($offer->publish_start_date)) {
                                                    echo JText::_('LNG_FROM');
                                                } ?>
                                            </span>

                                            <span class="d-block jtable-body-text jtable-body-text-seconday">
                                                <?php
                                                if (!JBusinessUtil::emptyDate($offer->publish_end_date)) {
                                                    echo JText::_('LNG_TO');
                                                } ?>
                                            </span>
                                        </div>

                                        <div class="text-right">
                                            <span class="d-block jtable-body-text"><?php echo JBusinessUtil::getDateGeneralShortFormat($offer->publish_start_date) ?></span>
                                            <span class="d-block jtable-body-text"><?php echo JBusinessUtil::getDateGeneralShortFormat($offer->publish_end_date) ?></span>
                                        </div>
                                    </div>
                                </td>

                                <td class="jtable-body-row-data">
                                    <div class="d-flex justify-content-center">
                                        <div class="text-right pr-2">
                                            <span class="d-block jtable-body-text jtable-body-text-seconday">
                                                <?php
                                                if (!JBusinessUtil::emptyDate($offer->startDate)) {
                                                    echo JText::_('LNG_FROM');
                                                } ?>
                                            </span>

                                            <span class="d-block jtable-body-text jtable-body-text-seconday">
                                                <?php
                                                if (!JBusinessUtil::emptyDate($offer->endDate)) {
                                                    echo JText::_('LNG_TO');
                                                } ?>
                                            </span>
                                        </div>

                                        <div class="text-right">
                                            <span class="d-block jtable-body-text"><?php echo JBusinessUtil::getDateGeneralShortFormat($offer->startDate) ?></span>
                                            <span class="d-block jtable-body-text"><?php echo JBusinessUtil::getDateGeneralShortFormat($offer->endDate) ?></span>
                                        </div>
                                    </div>
                                </td>
                            <?php } ?>
                            <td class="jtable-body-row-data pl-5">
		                        <?php echo $offer->viewCount ?>
                            </td>

                            <td class="jtable-body-row-data">
		                        <?php echo HTMLHelper::_('jbdgrid.published', $offer->state, $i, 'offers.', true, 'cb', true, true, $offer->id); ?>
                            </td>

                            <td class="jtable-body-row-data">
		                        <?php
		                        $text   = "";
		                        $action = "";
		                        switch ($offer->approved) {
			                        case OFFER_STATUS_NEEDS_APPROVAL:
				                        $text   = JText::_("LNG_NEEDS_APPROVAL");
				                        $action = "aprove";
				                        break;
			                        case OFFER_STATUS_DISAPPROVED:
				                        $text   = JText::_("LNG_DISAPPROVED");
				                        $action = "aprove";
				                        break;
			                        case OFFER_STATUS_APPROVED:
				                        $text   = JText::_("LNG_APPROVED");
				                        $action = "disaprove";
				                        break;
		                        }
		                        ?>
		                        <?php
		                        echo HTMLHelper::_('jbdgrid.approve', $action, $offer->approved == 1 ? 2 : 1, $i, 'offer.', true, 'cb', true, true, $offer->id); ?>
                            </td>

                            <td class="jtable-body-row-data">
	                            <?php if (($offer->state == 1) && ($offer->approved == 1)) {
		                            if ($offer->expired) {
			                            echo '<span class="status-badge badge-warning">' . JText::_("LNG_EXPIRED") . '</span>';
		                            }
		                            else if ($offer->not_visible) {
			                            echo '<span class="status-badge badge-warning">' . JText::_("LNG_NOT_VISIBLE") . '</span>';
		                            }
                                    elseif (!$offer->allow_offers) {
			                            echo '<span class="status-badge badge-warning warn">' . JText::_("LNG_NOT_INCLUDED") . '</span>';
		                            }
		                            else {
			                            echo '<span class="status-badge badge-success">' . JText::_("LNG_ACTIVE") . '</span>';
		                            }
	                            }
	                            else {
		                            echo '<span class="status-badge badge-danger">' . JText::_("LNG_NOT_ACTIVE") . '</span>';
	                            } ?>
                            </td>

                            <td class="jtable-body-row-data">
                                <div class="row-fluid jbd-buttons-row">
                                    <div class="d-flex align-items-center justify-content-center">
                                        <a title="<?php echo JText::_('LNG_CLICK_TO_VIEW'); ?>" href="<?php echo JBusinessUtil::getOfferLink($offer->id, $offer->alias) ?>" class="jtable-btn" target="_blank">
                                            <i class="la la-eye"></i>
                                        </a>
                                    </div>

                                </div>
                            </td>

                            <td class="jtable-body-row-data">
                                <span><?php echo (int) $offer->id; ?></span>
                            </td>

                        </tr>
        			<?php
        				$i++;
        			} ?>
        		</tbody>
        		<tfoot>
        		<tr>
        			<td colspan="16">
        				<a href="#" id="open_legend_offers">
        					<h5 class="right"><?php echo JText::_('LNG_STATUS_MESSAGES_LEGEND'); ?></h5>
        				</a>
        			</td>
        		</tr>
        		</tfoot>
        	</table>
        <?php } ?>
    
    	<!-- Modal -->
<div id="legend_offers" class="jbd-container" style="display: none">    
    <div class="jmodal-sm">
        <div class="jmodal-header">
            <p class="jmodal-header-title"><?php echo JText::_('LNG_STATUS_MESSAGES_LEGEND') ?></p>
            <a href="#close-modal" rel="modal:close" class="close-btn"><i class="la la-close "></i></a>
        </div>
        <div class="jmodal-body">
		<div class="row-fluid">
				<div class="row-fluid">
					<div class="col-md-10">
						<dl class="dl-horizontal">
							<dt><span class="status-badge badge-success"><?php echo JText::_('LNG_ACTIVE'); ?></span></dt>
							<dd><?php echo JText::_('LNG_ACTIVE_LEGEND'); ?></dd>
							<dt><span class="status-badge badge-warning"><?php echo JText::_('LNG_EXPIRED'); ?></span></dt>
							<dd><?php echo JText::_('LNG_EXPIRED_LEGEND'); ?></dd>
							<dt><span class="status-badge badge-warning"><?php echo JText::_('LNG_NOT_VISIBLE'); ?></span></dt>
							<dd><?php echo JText::_('LNG_NOT_VISIBLE_LEGEND'); ?></dd>
							<dt><span class="status-badge badge-warning warn"><?php echo JText::_('LNG_NOT_INCLUDED'); ?></span></dt>
							<dd><?php echo JText::_('LNG_NOT_INCLUDED_LEGEND'); ?></dd>
							<dt><span class="status-badge badge-danger"><?php echo JText::_('LNG_NOT_ACTIVE'); ?></span></dt>
							<dd><?php echo JText::_('LNG_NOT_ACTIVE_LEGEND'); ?></dd>
						</dl>
					</div>
				</div>
			</div>
        </div>            
    </div>
</div>
    
    	<input type="hidden" name="option"	value="<?php echo JBusinessUtil::getComponentName()?>" />
    	<input type="hidden" name="task" value="" /> 
    	<input type="hidden" name="companyId" value="" />
    	<input type="hidden" name="boxchecked" value="0" />
    	<?php echo JHTML::_('form.token'); ?>
    
    	<?php // Load the batch processing form. ?>
    	<?php echo $this->loadTemplate('batch'); ?>
    </form>
</div>
<?php echo $this->loadTemplate('export'); ?>
<?php echo $this->loadTemplate('import'); ?>
<script>
	window.addEventListener('load', function() {
		jQuery('#open_legend_offers').click(function() {
			jQuery('#legend_offers').jbdModal();
			
			!function(d,s,id){var js,fjs=d.getElementsByTagName(s)[0],p=/^http:/.test(d.location)?'http':'https';if(!d.getElementById(id)){js=d.createElement(s);js.id=id;js.src=p+'://platform.twitter.com/widgets.js';fjs.parentNode.insertBefore(js,fjs);}}(document, 'script', 'twitter-wjs');
		});
	});
</script>