<?php
/**
 * @package	JBusinessDirectory
 *
 * @author CMSJunkie http://www.cmsjunkie.com
 * @copyright  Copyright (C) 2007 - 2021 CMSJunkie. All rights reserved.
 * @license   https://www.gnu.org/licenses/agpl-3.0.en.html
 */

defined('_JEXEC') or die('Restricted access');

// Include the component HTML helpers.
JHtml::addIncludePath(JPATH_COMPONENT.'/helpers/html');
require_once BD_CLASSES_PATH.'/attributes/attributeservice.php';

JBusinessUtil::enqueueStyle('libraries/bootstrap/bootstrap-tagsinput.css');
JBusinessUtil::enqueueScript('libraries/bootstrap/bootstrap-tagsinput.min.js');

$attributeConfig = $this->item->defaultAtrributes;
$isNew     = ($this->item->id == 0 && isset($isProfile)) ? true : false;

$maxPictures = isset($this->item->package)?$this->item->package->max_pictures:$this->appSettings->max_pictures;
$nrPictures = count($this->item->pictures);
$allowedNr = $maxPictures - $nrPictures;
$allowedNr=($allowedNr<0)?0:$allowedNr;
$allowedNr = ($allowedNr == 0)?$maxPictures:$allowedNr;
// Load the tooltip behavior.
JBusinessUtil::loadJQueryChosen();

$langTab = JBusinessUtil::getLanguageTag();
$langTab = str_replace("-", "_", $langTab);

$mapKey  = JBusinessUtil::loadMapScripts(null, true);

$aliasStyle = (!$this->appSettings->show_alias && isset($isProfile))?"display:none":"";
$itemType = $this->state->get('filter.type');
if(!empty($this->item->item_type)){
	$itemType = $this->item->item_type;
}


if($itemType == OFFER_TYPE_PRODUCT){
	$headText   = '<h3>'. JText::_('LNG_PRODUCT_DETAILS') .'</h3>';
	$subText	= '<p>'. JText::_('LNG_DISPLAY_INFO_TXT_PRODUCT') .'</p>';
}else{
	$headText   = '<h3>'. JText::_('LNG_OFFER_DETAILS') .'</h3>';
	$subText	= '<p>'. JText::_('LNG_DISPLAY_INFO_TXT') .'</p>';
}
?>

<script type="text/javascript">
window.addEventListener('load', function() {
	Joomla.submitbutton = function(task) {

		jQuery("#item-form").validationEngine('detach');
		var evt = document.createEvent("HTMLEvents");
		evt.initEvent("click", true, true);
		var tab = ("tab-"+jbdUtils.getProperty("defaultLang"));
		if(!(document.getElementsByClassName(tab)[0] === undefined || document.getElementsByClassName(tab)[0] === null))
			document.getElementsByClassName(tab)[0].dispatchEvent(evt);

		if (task == 'offer.cancel' || task == 'offer.aprove' || task == 'offer.disaprove' || !jbdUtils.validateCmpForm(true, <?php echo $attributeConfig["description"] == ATTRIBUTE_MANDATORY?'true':'false' ?>, task, validatePictures)) {
			jbdOffers.saveDates();
			Joomla.submitform(task, document.getElementById('item-form'));
		}

		jQuery("#item-form").validationEngine('attach');
	}
});
</script>

<?php 
$user = JBusinessUtil::getUser();
if(empty($this->item->id)){
    $this->item->id = 0;
}

$options = array(
	'onActive' => 'function(title, description){
		description.setStyle("display", "block");
		title.addClass("open").removeClass("closed");
	}',
	'onBackground' => 'function(title, description){
		description.setStyle("display", "none");
		title.addClass("closed").removeClass("open");
	}',
	'startOffset' => 0,  // 0 starts on the first tab, 1 starts the second, etc...
	'useCookie' => true, // this must not be a string. Don't use quotes.
);

$jbdTabs = new JBDTabs();
$jbdTabs->setOptions($options);
?>

<div id="jbd-container" class="jbd-container jbd-edit-container">
	<?php if(isset($isProfile)) { ?>
		<div class="row py-2">
			<div class="col-md-12">
				<div>
					<div class="button-row">
						<button id="save-btn" type="button" class="btn btn-success button-save" onclick="saveCompanyInformation('apply')">
							<i class="la la-edit"></i> <?php echo JText::_("LNG_SAVE")?>
						</button>						
						<button type="button" class="btn btn-success button-close" onclick="saveCompanyInformation('save');">
							<span class="ui-button-text"><i class="la la-check"></i> <?php echo JText::_("LNG_SAVE_AND_CLOSE")?></span>
						</button>
						<?php if (!$isNew) { ?>
							<button id="duplicate-btn" type="button" class="btn btn-warning button-save" onclick="saveCompanyInformation('duplicate')">
								<i class="icon-save-copy"></i> <?php echo JText::_("LNG_DUPLICATE")?>
							</button>
						<?php } ?>						
						<button type="button" class="btn btn-dark button-cancel" onclick="cancel()">
							<i class="la la-close"></i> <?php echo JText::_("LNG_CANCEL")?>
						</button>
					</div>
				</div>
			</div>
		</div>
	<?php } ?>

	<form action="<?php echo JRoute::_('index.php?option=com_jbusinessdirectory&layout=edit&id='.(int) $this->item->id); ?>" method="post" name="adminForm" id="item-form" class="form-horizontal jbd-edit-container" enctype="multipart/form-data">
		<div class="row">
			<div class="<?php echo isset($isProfile) ?"col-12":"col-lg-7"?>">
				 <div class="row">
				 	<div class="col-12">
				 		<fieldset class="boxed">
				 			<div class="row align-items-center">
				 				<div class="col-md ">
				 					<h4><?php echo JText::_('LNG_SELECT_A_BUSINESS')?> <?php echo !$this->appSettings->item_decouple?JBusinessUtil::showMandatory(ATTRIBUTE_MANDATORY):""; ?></h4>
				 				</div>
				 				<div class="col-md">
				 					<select data-placeholder="<?php echo JText::_("LNG_SELECT_OR_SEARCH_COMPANY") ?>" class="form-control input-medium ajax-chosen-select <?php echo !$this->appSettings->item_decouple?"validate[required]":""?>" name="companyId" id="companyId">
										<option value=""><?php echo JText::_("LNG_SELECT_OR_SEARCH_COMPANY")?></option>
										<?php if (!empty($this->item->companyId)){
											echo JHtml::_('select.options', $this->item->companyOptions, 'id', 'name', $this->item->companyId);
										}
										?>
										<?php echo JHtml::_('select.options', $this->companyOptions, 'id', 'name', -1); ?>
									</select>
				 				</div>
				 			</div>
						</fieldset>
				 	</div>
	   			 </div>
			
				<div class="row">
					<div class="col-12">
						<fieldset class="boxed">
							<div class="row">
								<div class="col-md">
									<?php 
										echo $headText;
										echo $subText;
									?>
								</div>
								<div class="col-lg-5 my-auto text-right">
									<fieldset id="state" class="radio btn-group btn-group-yesno">
										<input type="radio" class="validate[required]" name="state" id="state1" value="<?php echo 1 ?>" <?php echo $this->item->state==1? 'checked="checked"' :""?> />
										<label class="btn" id="label_state1" for="state1"><?php echo JTEXT::_("LNG_PUBLISHED")?></label>
										<input type="radio" class="validate[required]" name="state" id="state2" value="<?php echo 0 ?>"  <?php echo $this->item->state==0? 'checked="checked"' :""?> />
										<label class="btn" id="label_state2" for="state2"><?php echo JText::_('LNG_UNPUBLISHED')?></label>
									</fieldset>
								</div>
							</div>
							<div class="form-container">
								<div class="form-group">
									<label for="subject"><?php echo JText::_('LNG_SUBJECT')?><?php echo JBusinessUtil::showMandatory(ATTRIBUTE_MANDATORY)?></label>
									<?php
										if ($this->appSettings->enable_multilingual) {
											echo $jbdTabs->startTabSet('tab_group_subject');
											foreach ($this->languages as $k=>$lng) {
												echo $jbdTabs->addTab('tab_group_subject', 'tab-'.$lng, $k);
												$langContent = isset($this->translations[$lng."_name"])?$this->translations[$lng."_name"]:"";
												if ($lng == JBusinessUtil::getLanguageTag() && empty($langContent)) {
													$langContent = $this->item->subject;
												}
												echo "<input type='text' name='subject_$lng' id='subject_$lng' class='form-control  validate[required]' value=\"".stripslashes($this->escape($langContent))."\"  maxLength='110'>";
												echo $jbdTabs->endTab();
											}
											echo $jbdTabs->endTabSet();
										} else { ?>
											<input type="text" name="subject" id="subject" class="form-control validate[required]"  value="<?php echo $this->escape($this->item->subject) ?>" maxLength="110">
										<?php } ?>
								</div>
								<div class="form-group" style="<?php echo $aliasStyle ?>">
									<label for="name"><?php echo JText::_('LNG_ALIAS')?></label>
									<input type="text"	name="alias" id="alias"  placeholder="<?php echo JText::_('LNG_AUTO_GENERATE_FROM_NAME')?>" class="form-control text-input" value="<?php echo $this->escape($this->item->alias) ?>"  maxLength="100">
								</div>
								<?php if ($attributeConfig["short_description"] != ATTRIBUTE_NOT_SHOW) { ?>
								<div class="form-group">
									<label for="short_description"><?php echo JText::_('LNG_SHORT_DESCRIPTION')?><?php echo JBusinessUtil::showMandatory($attributeConfig["short_description"])?></label>
									<?php 
									if ($this->appSettings->enable_multilingual) {
										echo $jbdTabs->startTabSet('tab_group_short_description');
										foreach ($this->languages  as $k=>$lng) {
											echo $jbdTabs->addTab('tab_group_short_description', 'tab-'.$lng, $k);
											$langContent = isset($this->translations[$lng."_short"]) ? $this->translations[$lng."_short"] : "";
											if ($lng == JBusinessUtil::getLanguageTag() && empty($langContent)) {
												$langContent = $this->item->short_description;
											}
											$required = ($attributeConfig['short_description'] == ATTRIBUTE_MANDATORY) ? 'validate[required]' : '';
											echo "<textarea id='short_description_$lng' name='short_description_$lng' class='input_txt $required' cols='75' rows='4' maxLength='250'>$langContent</textarea>";
											echo $jbdTabs->endTab();
										}
										echo $jbdTabs->endTabSet();
									}
									else { ?>
										<textarea name="short_description" id="short_description" class="form-control <?php echo ($attributeConfig["short_description"] == ATTRIBUTE_MANDATORY)?"validate[required]":""?>"  cols="75" rows="4"  maxLength="250"><?php echo $this->item->short_description ?></textarea>
									<?php 
									} ?>
								</div>
								<?php } ?>
								<?php if ($attributeConfig["description"] != ATTRIBUTE_NOT_SHOW) { ?>
									<div class="row">
										<div class="col-md">
											<div class="form-group">
												<label for="description_id"><?php echo JText::_('LNG_DESCRIPTION')?><?php echo JBusinessUtil::showMandatory($attributeConfig["description"])?></label>
												<?php
												if ($this->appSettings->enable_multilingual) {
													echo $jbdTabs->startTabSet('tab_group_description');
													foreach ($this->languages  as $k=>$lng) {
														echo $jbdTabs->addTab('tab_group_description', 'tab-'.$lng, $k);
														$langContent = isset($this->translations[$lng]) ? $this->translations[$lng] : "";
														if ($lng==JBusinessUtil::getLanguageTag() && empty($langContent)) {
															$langContent = $this->item->description;
														}
														echo JBusinessUtil::getEditor()->display('description_'.$lng, $langContent, '100%', '200', '70', '10', false);
														echo $jbdTabs->endTab();
													}
													echo $jbdTabs->endTabSet();
												}
												else {
													echo JBusinessUtil::getEditor()->display('description', $this->item->description, '100%', '200', '70', '10', false);
												} ?>
											</div>
										</div>
									</div>
								<?php } ?>

									<div class="row">
										<div class="col-md">
											<div class="form-group">
												<label for="startDate"><?php echo JText::_('LNG_OFFER_START_DATE')?> </label> 
												<?php 
													$this->item->startDate = $this->item->startDate=="0000-00-00"?"":$this->item->startDate;
													echo JHTML::_('calendar', $this->item->startDate, 'startDate', 'startDate', $this->appSettings->calendarFormat, array('class'=>'form-control calendar-date', 'size'=>'10',  'maxlength'=>'10')); 
												?>
											</div>
										</div>
										<div class="col-md">
											<div class="form-group">
												<label for="endDate"><?php echo JText::_('LNG_OFFER_END_DATE')?> </label>
												<?php 
													$this->item->endDate = $this->item->endDate=="0000-00-00"?"":$this->item->endDate;
													echo JHTML::_('calendar', $this->item->endDate, 'endDate', 'endDate', $this->appSettings->calendarFormat, array('class'=>'form-control calendar-date', 'size'=>'10',  'maxlength'=>'10')); 
												?>
											</div>
										</div>
									</div>
									
									
									
									<div class="row">
										<div class="col-md">
											<div class="form-group">
												<label for="startDate"><?php echo JText::_('LNG_PUBLISH_START_DATE')?> </label> 
												<?php 
												   $this->item->publish_start_date = $this->item->publish_start_date=="0000-00-00"?"":$this->item->publish_start_date;
												   echo JHTML::_('calendar', $this->item->publish_start_date, 'publish_start_date', 'publish_start_date', $this->appSettings->calendarFormat, array('class'=>'form-control calendar-date', 'size'=>'10',  'maxlength'=>'10')); 
												?>
											</div>
										</div>
										<div class="col-md">
											<div class="form-group">
												<label for="endDate"><?php echo JText::_('LNG_PUBLISH_END_DATE')?> </label>
												<?php 
												   $this->item->publish_end_date= $this->item->publish_end_date=="0000-00-00"?"":$this->item->publish_end_date;
												   echo JHTML::_('calendar', $this->item->publish_end_date, 'publish_end_date', 'publish_end_date', $this->appSettings->calendarFormat, array('class'=>'form-control calendar-date', 'size'=>'10',  'maxlength'=>'10')); ?>
											</div>
										</div>
									</div>
									<div class="row">
										<div class="col-md-12">
											<p> <?php echo JText::_('LNG_TIME_ZONE_INFORMATION_TEXT');?>.</p>
											<div class="form-group" id="time_zoneContainer">
												<select class="form-control input-medium chosen-select" id="time_zone" name="time_zone">
													<?php $timeZones = JBusinessUtil::timeZonesList();
													foreach ($timeZones as $key => $zone) {
														$selected = ($key == $this->item->time_zone) ? " selected" : "";
														echo "<option value='" . $key . "'" . $selected . ">" . $zone . "</option>";
													} ?>
												</select>
											</div>
										</div>
										<div class="col-md">
											<div class="form-group">
												<label for="publish_start_time"><?php echo JText::_('LNG_PUBLISH_START_TIME')?> </label>
												<div class="has-jicon-right">
													<input type="text" name="publish_start_time" id="publish_start_time" class="form-control timepicker" value="<?php echo $this->item->publish_start_time ?>">
													<i class="la la-clock-o"></i>
									   			 </div>
											</div>
										</div>
										<div class="col-md">
											<div class="form-group">
												<label for="publish_end_time"><?php echo JText::_('LNG_PUBLISH_END_TIME')?> </label>
												<div class="has-jicon-right">
													<input type="text" name="publish_end_time" id="publish_end_time" class="form-control timepicker" value="<?php echo $this->item->publish_end_time ?>">
													<i class="la la-clock-o"></i>
									   			 </div>
											</div>
										</div>
										<div class="col-md">
											<div class="form-group" >
												<label for="show_time"><?php echo JText::_('LNG_SHOW_REMAINING_TIME')?> </label> 
												<div>
													<fieldset id="show_time_fld" class="radio btn-group btn-group-yesno">
														<input type="radio" class="validate[required]" name="show_time" id="show_time1" value="1" <?php echo $this->item->show_time==1? 'checked="checked"' :""?> />
														<label class="btn" for="show_time1"><?php echo JText::_('LNG_YES')?></label> 
														<input type="radio" class="validate[required]" name="show_time" id="show_time0" value="0" <?php echo $this->item->show_time==0? 'checked="checked"' :""?> />
														<label class="btn" for="show_time0"><?php echo JText::_('LNG_NO')?></label> 
													</fieldset>
												</div>
											</div>
										</div>
									</div>
								
								<div class="row">
									<div class="col-md">
										<div class="form-group">
											<label for="price"><?php echo JText::_('LNG_PRICE')?> </label> 
											<div class="has-jicon-right">
												<input type="text" name="price" id="price" class="form-control" value="<?php echo $this->escape($this->item->price) ?>">
												<i class="la la-money-bill-alt"></i>
								   			 </div>
											<div id="showPriceLink" style="<?php echo !empty($this->item->price_base)?"display: none":""?>">
												<a href="javascript:jbdOffers.showPriceBase('offer_price_more','showPriceLink')"> <span><?php echo JText::_('LNG_MORE_PRICE_SETTINGS') ?></span></a>
											</div>
										</div>
										<div id="offer_price_more"  style="<?php echo empty($this->item->price_base)?"display: none":""?>">
											<div class="form-group">
												<label for="price_base"><?php echo JText::_('LNG_PRICE_BASE')?> </label>
												<input type="text" name="price_base" id="price_base" class="form-control" value="<?php echo $this->escape($this->item->price_base) ?>">
											</div>
											<div class="form-group">
												<label for="price_base_unit"><?php echo JText::_('LNG_PRICE_BASE_UNIT')?> </label>
												<input type="text" name="price_base_unit" id="price_base_unit" class="form-control" value="<?php echo $this->escape($this->item->price_base_unit) ?>">
												<a style="<?php echo !empty($this->item->price_base)?"display: none":""?>" href="javascript:jbdOffers.lessPriceBase('offer_price_more','showPriceLink')"> <span><?php echo JText::_('LNG_LESS') ?></span></a>
											</div>
										</div>
									</div>
									<div class="col-md">
										<div class="form-group">
											<label for="specialPrice"><?php echo JText::_('LNG_SPECIAL_PRICE')?> </label>
											<div class="has-jicon-right"> 
												<input type="text" name=specialPrice id="specialPrice" class="form-control" value="<?php echo $this->escape($this->item->specialPrice) ?>">
												<i class="la la-money-bill-alt"></i>
								   			 </div>
											<div id="showSpecialPriceLink" style="<?php echo !empty($this->item->special_price_base)?"display: none":""?>">
												<a href="javascript:jbdOffers.showPriceBase('offer_special_price_more','showSpecialPriceLink')"> <span><?php echo JText::_('LNG_MORE_PRICE_SETTINGS') ?></span></a>
											</div>
										</div>
										<div id="offer_special_price_more" style="<?php echo empty($this->item->special_price_base)?"display: none":""?>">
											<div class="form-group">
												<label for="specialPrice"><?php echo JText::_('LNG_SPECIAL_PRICE_BASE')?> </label>
												<input type="text" name=special_price_base id="special_price_base" class="form-control" value="<?php echo $this->escape($this->item->special_price_base) ?>">
											</div>
											<div class="form-group">
												<label for="specialPrice"><?php echo JText::_('LNG_SPECIAL_PRICE_BASE_UNIT')?> </label>
												<input type="text" name=special_price_base_unit id="special_price_base_unit" class="form-control" value="<?php echo $this->escape($this->item->special_price_base_unit) ?>">
						  						<a style="<?php echo !empty($this->item->special_price_base)?"display: none":""?>" href="javascript:jbdOffers.lessPriceBase('offer_special_price_more','showSpecialPriceLink')"> <span><?php echo JText::_('LNG_LESS') ?></span></a>
											</div>
										</div>
									</div>
									
									<div class="col-md">
										<div class="form-group">
											<label for="state"><?php echo JText::_('LNG_CURRENCY')?></label>
											<select data-placeholder="<?php echo JText::_("LNG_SELECT_CURRENCY") ?>" class="inputbox input-medium chosen-select" name="currencyId" id="currencyId">
												<?php
                                                    for($i = 0; $i <  count( $this->currencies ); $i++){
                                                        $currency = $this->currencies[$i];
                                                ?>
                                                        <option value = '<?php echo $currency->currency_id?>' <?php echo $currency->currency_id==$this->item->currencyId? "selected" : ""?>> <?php echo $currency->currency_name." - ". $currency->currency_description ?></option>
                                                <?php }	?>
											</select>
										</div>
										<?php if($this->appSettings->show_offer_price_list) {?>											
												<div class="form-group mt-5">
													<label for="add_to_price_list"><?php echo JText::_('LNG_PRICE_LIST_ADD')?> </label> 
													<p><?php echo JText::_('LNG_PRICE_LIST_ADD_DESC'); ?></p>
													<div>
														<fieldset id="add_to_price_list_fld" class="radio btn-group btn-group-yesno">
															<input type="radio" class="validate[required]" name="add_to_price_list" id="add_to_price_list1" value="1" <?php echo $this->item->add_to_price_list==1? 'checked="checked"' :""?> />
															<label class="btn" for="add_to_price_list1"><?php echo JText::_('LNG_YES')?></label> 
															<input type="radio" class="validate[required]" name="add_to_price_list" id="add_to_price_list0" value="0" <?php echo $this->item->add_to_price_list==0? 'checked="checked"' :""?> />
															<label class="btn" for="add_to_price_list0"><?php echo JText::_('LNG_NO')?></label> 
														</fieldset>
													</div>
												</div>											
										<?php }?>
									</div>
								</div>
	
								<?php if($attributeConfig["price_text"]!=ATTRIBUTE_NOT_SHOW) { ?>
	
									<div class="row">
										<div class="col-md">
											<div class="form-group">
												<label for="price_text"><?php echo JText::_('LNG_PRICE_TEXT')?><?php echo JBusinessUtil::showMandatory($attributeConfig["price_text"])?></label>
												<?php
													if($this->appSettings->enable_multilingual) {
														echo $jbdTabs->startTabSet('tab_groupsd_price_desc');
														foreach( $this->languages  as $k=>$lng ) {
															echo $jbdTabs->addTab('tab_groupsd_price_desc', 'tab-'.$lng, $k);
															$langContent = isset($this->translations[$lng . "_additional"])?$this->translations[$lng . "_additional"]:"";
															if($lng==JBusinessUtil::getLanguageTag() && empty($langContent)) {
																$langContent = $this->item->price_text;
															}
															$required = ($attributeConfig['price_text'] == ATTRIBUTE_MANDATORY) ? 'validate[required]' : '';
															echo "<textarea id='additional_description_$lng' name='additional_description_$lng' class='form-control $required' cols='75' rows='2' maxLength='100'>$langContent</textarea>";
															echo $jbdTabs->endTab();
														}
														echo $jbdTabs->endTabSet();
													} else { ?>
												<textarea  name="price_text" class="form-control  <?php echo ($attributeConfig['price_text'] == ATTRIBUTE_MANDATORY)?"validate[required]":""?>" id="price_text" cols='75' rows='2' maxlength="100"><?php echo $this->item->price_text ?></textarea>
													<?php } ?>
											</div>
										 </div>
									</div>
								<?php } ?>

								<div class="row">
                                    <div class="col-md">
										<div class="form-group">
											<label for="contact_email"><?php echo JText::_('LNG_EMAIL')?><?php echo JBusinessUtil::showMandatory($attributeConfig["email"])?></label>
                                            <div class="has-jicon-right">
                                                <input type="text" name="contact_email" id="contact_email" class="input_txt form-control text-input <?php echo $attributeConfig["email"] == ATTRIBUTE_MANDATORY?"validate[required,custom[email]]":" validate[custom[email]]"?>" value="<?php echo $this->escape($this->item->contact_email) ?>" maxlength="60">
                                                <i class="la la-envelope"></i>
                                            </div>
                                            <div class="description">e.g. office@site.com</div>
										</div>
									</div>
									
									<?php if ($attributeConfig["type"] != ATTRIBUTE_NOT_SHOW) { ?>
										<div class="col-md">
											<div class="form-group">
												<label for="offer_type"><?php echo JText::_('LNG_TYPE')?> <?php echo JBusinessUtil::showMandatory($attributeConfig["type"]) ?></label>
												<select data-placeholder="<?php echo JText::_("LNG_SELECT_OFFERTYPE") ?>" class="input_sel select <?php echo $attributeConfig["type"] == ATTRIBUTE_MANDATORY?"validate[required]":""?>" name="offer_type" id="offer_type">
													<?php foreach( $this->item->types as $type ) { ?>
														<option <?php echo $this->item->offer_type==$type->id? "selected" : ""?> value='<?php echo $type->id?>'><?php echo $type->name ?></option>
													<?php } ?>
												</select>
											</div>
										</div>
									<?php } ?>
								</div>

								<?php if($this->appSettings->enable_offer_coupons && $this->item->item_type == OFFER_TYPE_OFFER){?>
                                    <?php  if ($attributeConfig["coupons"] != ATTRIBUTE_NOT_SHOW) { ?>
                                        <div class="row">
                                            <div class="col-md">
                                                <div class="form-group">
                                                    <label for="total_coupons"><?php echo JText::_('LNG_COUPONS_NUMBER')?> <?php echo JBusinessUtil::showMandatory($attributeConfig["coupons"]) ?></label>
                                                    <input type="number" name="total_coupons" id="total_coupons" class="form-control <?php echo $attributeConfig["coupons"] == ATTRIBUTE_MANDATORY?"validate[required]":""?>" value="<?php echo $this->escape($this->item->total_coupons) ?>">
                                                </div>
                                            </div>
                                        </div>
                                    <?php } ?>
                                <?php } ?>
							</div>
						</fieldset>
	
						<?php if (JBusinessUtil::isAppInstalled(JBD_APP_SELL_OFFERS) && file_exists(JPATH_ADMINISTRATOR.'/components/com_jbusinessdirectory/models/shippingmethod.php') && $this->appSettings->enable_shipping) { ?>
							<fieldset class="boxed">
								<h2> <?php echo JText::_('LNG_SHIPPING_METHODS');?> </h2>
								<p> <?php echo JText::_('LNG_SHIPPING_METHODS_TEXT');?></p>
	
								<select data-placeholder="<?php echo JText::_("LNG_SELECT_SERVICE") ?>" class="form-control select chosen-select" multiple name="shippingMethods[]" id="shippingMethods">
									<?php
									foreach ($this->item->shippingMethods as $method) {
										$selected = false;
										$shippingPrice = 0;
										foreach($this->item->selectedShippingMethods as $sMethod) {
											if($sMethod->id == $method->id) {
												$selected = true;
												$shippingPrice = $sMethod->price;
											}
										} ?>
										<option <?php echo $selected ? "selected" : ""?> value='<?php echo $method->id ?>' data-price="<?php echo $shippingPrice ?>">
											<?php echo $method->name ?>
										</option>
										<?php
									} ?>
								</select>
	
								<div class="jupload" id="shipping-methods-list">
									<div class="jupload-header">
										<div class="jupload-header-title"></div>
										<div class="jupload-header-desc"></div>
									</div>
									<div class="jupload-body">
										<ul id="sortable-shipping-methods" class="jbd-item-list">
											<?php
											if (!empty($this->item->selectedShippingMethods)) {
												foreach ($this->item->selectedShippingMethods as $method) { ?>
													<li class="jbd-item" id="jbd-item-<?php echo $method->id ?>">
														<div class="jupload-files">
															<div class="jupload-files-img">
																<i class="la la-shipping-fast"></i>
															</div>
															<div class="jupload-files-info">
																<div class="jupload-filename">
																	<p><?php echo $method->name ?></p>
																	<input id="jupload-filename-<?php echo $method->id ?>" type="text" class="w-25 d-inline"
																		   name="shippingMethodPrices[]" value="<?php echo $method->price ?>"> (<?php echo $this->appSettings->currency_name ?>)
																</div>
																<div class="jupload-actions jbd-item-actions">
																	<label for="jupload-filename-<?php echo $method->id ?>">
																		<i class="la la-pencil"></i>
																	</label>
	
																	<input type='hidden' name='shippingMethodIds[]' id='shipping_method_<?php echo $method->id ?>' value='<?php echo $this->escape($method->id)?>' />
																</div>
															</div>
														</div>
													</li>
													<?php
												}
											} ?>
										</ul>
									</div>
								</div>
							</fieldset>
						<?php } ?>
			
						<?php if($attributeConfig["category"]!=ATTRIBUTE_NOT_SHOW || $itemType == OFFER_TYPE_PRODUCT) { ?>
						<fieldset class="boxed">
							<h2> <?php echo JText::_('LNG_CATEGORIES');?></h2>
							<p><?php echo JText::_('LNG_SELECT_CATEGORY');?></p>
							<div class="form-group">
								<label for="categories"><?php echo JText::_('LNG_CATEGORY')?> <?php echo JBusinessUtil::showMandatory($attributeConfig["category"]||$itemType==OFFER_TYPE_PRODUCT)?></label>
								<select name="categories[]" id="categories" data-placeholder="<?php echo JText::_("LNG_SELECT_CAT") ?>" multiple class="form-control input-medium chosen-select-categories">
									<?php echo JHtml::_('select.options', $this->categoryOptions, 'value', 'text', $this->item->selectedCategories); ?>
								</select>
								<a href="javascript:jbdUtils.uncheckAllCategories()"><?php echo JText::_("LNG_UNCHECK_ALL")?></a>
							</div>
							<div class="form-group">
								<label for="subcat_main_id"><?php echo JText::_('LNG_MAIN_SUBCATEGORY');?> <?php echo JBusinessUtil::showMandatory($attributeConfig["category"]||$itemType==OFFER_TYPE_PRODUCT)?></label>
								<select data-placeholder="<?php echo JText::_("LNG_SELECT_CAT") ?>" name="main_subcategory" id="main_subcategory" onchange="jbdOffers.updateAttributes(this.value,<?php echo $this->item->id ?>);jbdOffers.updateSellingOptionsAjax(this.value,<?php echo $this->item->id ?>)" class="form-control select <?php echo ($attributeConfig['category'] == ATTRIBUTE_MANDATORY || $itemType == OFFER_TYPE_PRODUCT)?"validate[required]":""?>">
									<?php foreach( $this->item->selectedSubCategories as $selectedCategory){?>
										<option value="<?php echo $selectedCategory->id ?>" <?php echo $selectedCategory->id == $this->item->main_subcategory ? "selected":"" ; ?>><?php echo $selectedCategory->name ?></option>
									<?php } ?>
								</select>
							</div>
						</fieldset>
						<?php } ?>

						<?php if(!empty($this->item->customFields) || $this->appSettings->enable_attribute_category) {
							$renderedContent = AttributeService::renderAttributes($this->item->customFields, false, array());
						?>
							<fieldset class="boxed">
								<h2> <?php echo JText::_('LNG_ADDITIONAL_INFO'); ?></h2>
								<p><?php echo JText::_('LNG_ADDITIONAL_INFO_TEXT'); ?></p>
								<div class="form-box" id="customFieldsContent">
									<?php
									if ($this->appSettings->enable_attribute_category) {
										if (!empty($this->item->main_subcategory))
											echo $renderedContent;
										else
											echo JText::_("LNG_NO_ATTRIBUTES_FOR_CATEGORY");
									} else {
										echo $renderedContent;
									}
									?>
								</div>
							</fieldset>
						<?php } ?>

						<?php if (JBusinessUtil::isAppInstalled(JBD_APP_SELL_OFFERS) && $this->appSettings->enable_offer_selling) {
							$renderedContent = AttributeService::renderOfferStocks($this->item->stocks, false, array());
							$displaySellingOptions = !$this->item->enable_offer_selling?"display:none;":"";
							$displayStockCombination = empty($renderedContent)?true:false;
							?>
							<fieldset class="boxed">
								<h2> <?php echo JText::_('LNG_ITEM_SELL'); ?></h2>
								<p><?php echo JText::_('LNG_ITEM_SELLING_TEXT'); ?></p>

								<div class="form-group row">
									<div class="col-md">
										<label for="enable_offer_selling"><?php echo JText::_('LNG_ENABLE_ITEM_SELLING') ?></label>
										<p><?php echo JText::_('LNG_ENABLE_SELLING_TO_PROCEED'); ?></p>
										<div>
											<fieldset id="enable_offer_selling_fld"
														class="radio btn-group btn-group-yesno">
												<input type="radio" class="validate[required]"
														name="enable_offer_selling" id="enable_offer_selling0"
														value="0" <?php echo $this->item->enable_offer_selling == 0 ? 'checked="checked"' : "" ?> />
												<label class="btn"
														for="enable_offer_selling0" onclick="jbdOffers.displayOfferSelling(0);"><?php echo JText::_('LNG_DISABLED') ?></label>
												<input type="radio" class="validate[required]"
														name="enable_offer_selling" id="enable_offer_selling1"
														value="1" <?php echo $this->item->enable_offer_selling == 1 ? 'checked="checked"' : "" ?> />
												<label class="btn"
														for="enable_offer_selling1" onclick="jbdOffers.displayOfferSelling(1);"><?php echo JText::_('LNG_OFFER') ?></label>
												<input type="radio" class="validate[required]"
														name="enable_offer_selling" id="enable_offer_selling2"
														value="2" <?php echo $this->item->enable_offer_selling == 2 ? 'checked="checked"' : "" ?> />
												<label class="btn"
														for="enable_offer_selling2" onclick="jbdOffers.displayOfferSelling(0);"><?php echo JText::_('LNG_COUPON') ?></label>
											</fieldset>
										</div>
									</div>										
								</div>
								<div id="offerSellingOptions" style="display:<?php echo $this->item->enable_offer_selling == OFFER_SELLING_REGULAR?"":"none"?>">
									<?php if(!empty($this->item->stocks)) { ?>
										<div class="form-group">
											<label for="use_stock_price"><?php echo JText::_('LNG_USE_STOCK_PRICE') ?></label>
											<p><?php echo JText::_('LNG_ENABLE_STOCK_PRICE_DESCR'); ?></p>
											<div>
												<fieldset id="use_stock_price_fld"
														  class="radio btn-group btn-group-yesno">
													<input type="radio" class="validate[required]"
														   name="use_stock_price" id="use_stock_price1"
														   value="1" <?php echo $this->item->use_stock_price == 1 ? 'checked="checked"' : "" ?> />
													<label class="btn"
														   for="use_stock_price1" onclick="jbdOffers.displayStockPrice(1);"><?php echo JText::_('LNG_YES') ?></label>
													<input type="radio" class="validate[required]"
														   name="use_stock_price" id="use_stock_price0"
														   value="0" <?php echo $this->item->use_stock_price == 0 ? 'checked="checked"' : "" ?> />
													<label class="btn"
														   for="use_stock_price0" onclick="jbdOffers.displayStockPrice(0);"><?php echo JText::_('LNG_NO') ?></label>
												</fieldset>
											</div>
										</div>
									<?php } ?>
									<div class="row">
										<div class="col-md">
											<div class="form-group">
												<label for="min_purchase"><?php echo JText::_('LNG_MIN_ITEM_PURCHASE'); ?></label>
												<input type="text" name="min_purchase" id="min_purchase"
													   class="form-control"
													   value="<?php echo $this->escape($this->item->min_purchase); ?>">
											</div>
										</div>
										<div class="col-md">
											<div class="form-group">
												<label for="max_purchase"><?php echo JText::_('LNG_MAX_ITEM_PURCHASE'); ?></label>
												<input type="text" name="max_purchase" id="max_purchase"
													   class="form-control"
													   value="<?php echo $this->escape($this->item->max_purchase); ?>">
											</div>
										</div>
									 </div>

									<div class="row" id="defaultQuantity" style="<?php echo !empty($renderedContent)?"display:none":""; ?>">
										<div class="col-md">
											<div class="form-group">
												<label for="quantity"><?php echo JText::_('LNG_ITEM_QUANTITY') ?> </label>
												<input type="text" name="quantity" id="quantity"
													   class="form-control"
													   value="<?php echo $this->escape($this->item->quantity) ?>">
											</div>
										</div>
										<div class="col-md">
											<div class="form-group">
												<label for="quantity"><?php echo JText::_('LNG_NOTIFY_AT_STOCK_QTY') ?> </label>
												<input type="text" name="notify_offer_quantity"
													   id="notify_offer_quantity" class="form-control"
													   value="<?php echo $this->escape($this->item->notify_offer_quantity) ?>">
											</div>
										</div>
									</div>
									<div id="noAttributesExplain" style="<?php echo !empty($renderedContent)?"display:none":""; ?>">
										<?php echo JText::_("LNG_NO_SELLING_ATTRIBUTES_AVAILABLE_FOR_ITEM"); ?>
									</div>

									<div class="form-box" id="customOptionsContent"  style="<?php echo empty($renderedContent)?"display:none":""; ?>">
										<?php echo $renderedContent;  ?>
									</div>
								</div>
							</fieldset>
							<?php
						} ?>
						
						<fieldset class="boxed" style="display:none">
							<h2> <?php echo JText::_('LNG_CONFIGURATION');?></h2>
							<div class="form-box">
								<div class="form-group" >
									<div class="form-detail req"></div>
									<label for="view_type"><?php echo JText::_('LNG_VIEW_TYPE')?></label> 
									<div>
										<fieldset id="view_type_fld" class="radio btn-group btn-group-yesno">
											<input type="radio" class="validate[required]" name="view_type" id="view_type1" value="1" <?php echo $this->item->view_type==1 || empty($this->item->view_type) ? 'checked="checked"' :""?> />
											<label class="btn" for="view_type1"><?php echo JText::_('LNG_OFFER')?></label> 
											<input type="radio" class="validate[required]" name="view_type" id="view_type2" value="2" <?php echo $this->item->view_type==2? 'checked="checked"' :""?> />
											<label class="btn" for="view_type2"><?php echo JText::_('LNG_ARTICLE')?></label> 
											<input type="radio" class="validate[required]" name="view_type" id="view_type3" value="3" <?php echo $this->item->view_type==3? 'checked="checked"' :""?> />
											<label class="btn" for="view_type3"><?php echo JText::_('LNG_URL')?></label> 
										</fieldset>
									</div>
								</div>
								<!-- >div class="form-group">
									<label for="article_id"><?php echo JText::_('LNG_ARTICLE_ID')?> </label> 
									<input class="form-control" type="text" name="article_id" id="article_id" value="<?php echo $this->item->article_id ?>">
								</div>
								<div class="form-group">
									<label for="url"><?php echo JText::_('LNG_URL')?> </label>
									<input class="form-control" type="text" name="url" id="url" value="<?php echo $this->item->url ?>">
								</div-->
							</div>
						</fieldset>
			
						<?php if(($attributeConfig["street_number"]!=ATTRIBUTE_NOT_SHOW || $attributeConfig["address"]!=ATTRIBUTE_NOT_SHOW ||$attributeConfig["area"]!=ATTRIBUTE_NOT_SHOW
						|| $attributeConfig["country"]!=ATTRIBUTE_NOT_SHOW || $attributeConfig["city"]!=ATTRIBUTE_NOT_SHOW
						|| $attributeConfig["province"]!=ATTRIBUTE_NOT_SHOW || $attributeConfig["region"]!=ATTRIBUTE_NOT_SHOW || $attributeConfig["postal_code"]!=ATTRIBUTE_NOT_SHOW || $attributeConfig["map"]!=ATTRIBUTE_NOT_SHOW)){?>
						<fieldset class="boxed">
							<h2> <?php echo JText::_('LNG_LOCATION');?></h2>
							<div class="row align-items-center">
								<div class="col-md">
									<p class="m-0"><?php echo JText::_("LNG_ADDRESS_SUGESTION")?></p>
								</div>
								<div class="col-md-3 text-right">
									<a href="javascript:void(0)" class="btn btn-success flex-row-centered" onclick="jbdOffers.loadAddress(<?php echo $this->appSettings->limit_cities_regions ? 'true' : 'false' ?>)" >
										<?php echo JText::_('LNG_LOAD_ADDRESS'); ?>
									</a>
								</div>
							</div>
							<div class="form-box">
								<div class="form-group autocomplete-box" id="autocomplete-box">
									<input type="text" id="autocomplete" class="form-control" placeholder="<?php echo JText::_("LNG_ENTER_ADDRESS") ?>" onFocus="" ></input>
								</div>
								
								<div class="row">
									<?php if($attributeConfig["address"]!=ATTRIBUTE_NOT_SHOW){?>
										<div class="col-md">
											<div class="form-group">
												<label for="subject"><?php echo JText::_('LNG_ADDRESS')?> <?php echo JBusinessUtil::showMandatory($attributeConfig["address"])?></label> 
												<input type="text" name="address" id="route" class="form-control <?php echo ($attributeConfig["address"] == ATTRIBUTE_MANDATORY)?"validate[required]":""?>" value="<?php echo $this->escape($this->item->address) ?>" maxlength="45">
											</div>
										</div>
									<?php } ?>
									<?php if($attributeConfig["street_number"]!=ATTRIBUTE_NOT_SHOW){?>
										<div class="col-md">
											<div class="form-group">
												<label for="address_id"><?php echo JText::_('LNG_STREET_NUMBER')?> <?php echo JBusinessUtil::showMandatory($attributeConfig["street_number"])?></label>
												<input type="text" name="street_number" id="street_number" class="form-control <?php echo ($attributeConfig["street_number"] == ATTRIBUTE_MANDATORY)?"validate[required]":""?>" value="<?php echo $this->escape($this->item->street_number) ?>" maxlength="20">
											</div>
										</div>
									<?php } ?>
									<?php if($attributeConfig["area"]!=ATTRIBUTE_NOT_SHOW){?>
										<div class="col-md">
											<div class="form-group" id="districtContainer">
												<label for="subject"><?php echo JText::_('LNG_AREA')?> <?php echo JBusinessUtil::showMandatory($attributeConfig["area"])?></label>
												<input type="text" name="area" id="area_id" class="form-control <?php echo ($attributeConfig["area"] == ATTRIBUTE_MANDATORY)?"validate[required]":""?>" value="<?php echo $this->escape($this->item->area) ?>" maxlength="45">
											</div>
										</div>
									<?php } ?>
								</div>
								 <?php if($attributeConfig["country"]!=ATTRIBUTE_NOT_SHOW){?>
									<div class="form-group">
										<label for="country"><?php echo JText::_('LNG_COUNTRY')?> <?php echo JBusinessUtil::showMandatory($attributeConfig["country"])?></label>
										<select data-placeholder="<?php echo JText::_("LNG_SELECT_COUNTRY") ?>" class="form-control <?php echo $attributeConfig["country"] == ATTRIBUTE_MANDATORY?"validate[required]":""?> select" name="countryId" id="country" <?php echo $this->appSettings->limit_cities_regions ? 'onclick="updateRegions()"' : ''; ?> >
											<option value=''></option>
											<?php
											foreach( $this->item->countries as $country ) { ?>
												<option <?php echo $this->item->countryId==$country->id? "selected" : ""?> value='<?php echo $country->id?>'><?php echo $country->country_name ?></option>
												<?php
											} ?>
										</select>
									</div>
								<?php } ?>
								<div class="row">
									<?php if ($attributeConfig["region"] != ATTRIBUTE_NOT_SHOW) { ?>
										<div class="col-md">
											<div class="form-group" id="districtContainer">
												<label for="county"><?php echo JText::_('LNG_REGION') ?> <?php echo JBusinessUtil::showMandatory($attributeConfig["region"])?></label>
					
												<?php if ($this->appSettings->limit_cities_regions != 1) { ?>
													<input type="text" name="county" id="administrative_area_level_1"
														   class="form-control <?php echo ($attributeConfig["region"] == ATTRIBUTE_MANDATORY) ? "validate[required]" : "" ?>"
														   value="<?php echo $this->escape($this->item->county) ?>" maxlength="45">
												<?php } else { ?>
													<select name="county" id="administrative_area_level_1" class="form-control <?php echo ($attributeConfig["region"] == ATTRIBUTE_MANDATORY) ? "validate[required]" : "" ?>" onchange="updateCities()" >
														<option value=""><?php echo JText::_('LNG_SELECT_REGION') ?></option>
														<?php foreach ($this->item->regions as $region) { ?>
															<option value="<?php echo $region->name ?>" <?php echo $this->item->county == $region->name ? "selected" : "" ?>><?php echo $region->name ?></option>
														<?php } ?>
													</select>
												<?php } ?>
											</div>
										</div>
									<?php } ?>
									<?php if ($attributeConfig["city"] != ATTRIBUTE_NOT_SHOW) { ?>
										<div class="col-md">
											<div class="form-group">
												<label for="subject"><?php echo JText::_('LNG_CITY') ?> <?php echo JBusinessUtil::showMandatory($attributeConfig["city"])?></label>
												<?php if ($this->appSettings->limit_cities_regions != 1) { ?>
													<input type="text" name="city" id="locality"
														   class="form-control <?php echo ($attributeConfig["city"] == ATTRIBUTE_MANDATORY) ? "validate[required]" : "" ?>"
														   value="<?php echo $this->escape($this->item->city) ?>" maxlength="45">
													<div class=?></div>
												<?php } else { ?>
													<select name="city" id="locality" class="form-control <?php echo ($attributeConfig["city"] == ATTRIBUTE_MANDATORY) ? "validate[required]" : "" ?>" >
														<option value=""><?php echo JText::_('LNG_SELECT_CITY') ?></option>
														<?php foreach ($this->item->cities as $city) { ?>
															<option value="<?php echo $city->name ?>" <?php echo $this->item->city == $city->name ? "selected" : "" ?> ><?php echo $city->name ?></option>
														<?php } ?>
													</select>
												<?php } ?>
											</div>
										</div>
									<?php } ?>
								</div>
								<div class="row">
									<?php if($attributeConfig["province"]!=ATTRIBUTE_NOT_SHOW){?>
										<div class="col-md">
											<div class="form-group">
												<label for="subject"><?php echo JText::_('LNG_PROVINCE')?> <?php echo JBusinessUtil::showMandatory($attributeConfig["province"])?></label>
												<input type="text" name="province" id="administrative_area_level_2" class="form-control <?php echo ($attributeConfig["province"] == ATTRIBUTE_MANDATORY)?"validate[required]":""?>" value="<?php echo $this->escape($this->item->province) ?>" maxlength="45">
											</div>
										</div>
									<?php } ?>
									<?php if($attributeConfig["postal_code"]!=ATTRIBUTE_NOT_SHOW){?>
										<div class="col-md">
											<div class="form-group" id="districtContainer">
												<label for="district_id"><?php echo JText::_('LNG_POSTAL_CODE')?> <?php echo JBusinessUtil::showMandatory($attributeConfig["postal_code"])?></label>
												<input class="form-control <?php echo $attributeConfig["postal_code"] == ATTRIBUTE_MANDATORY?"validate[required]":""?>" type="text" name="postalCode" id="postal_code" value="<?php echo $this->escape($this->item->postalCode) ?>" maxlength="55" />
											</div>
										</div>
									<?php } ?>
								</div>
								<?php if($attributeConfig["map"]!=ATTRIBUTE_NOT_SHOW){?>
									<div class="row">
										<div class="col-md">
											<div class="form-group">
												<label for="latitude"><?php echo JText::_('LNG_LATITUDE')?> <?php echo JBusinessUtil::showMandatory($attributeConfig["map"])?></label> 
												<p class="small"><?php echo JText::_('LNG_MAP_INFO')?></p>
												<input class="form-control <?php echo ($attributeConfig["map"] == ATTRIBUTE_MANDATORY)?"validate[required]":""?>" type="text" name="latitude" id="latitude" value="<?php echo $this->escape($this->item->latitude) ?>" maxlength="45">
											</div>
										</div>
										<div class="col-md">
											<div class="form-group">
												<label for="longitude"><?php echo JText::_('LNG_LONGITUDE')?> <?php echo JBusinessUtil::showMandatory($attributeConfig["map"])?></label>
												<p class="small"><?php echo JText::_('LNG_MAP_INFO')?></p>
												<input class="form-control <?php echo ($attributeConfig["map"] == ATTRIBUTE_MANDATORY)?"validate[required]":""?>" type="text" name="longitude" id="longitude" value="<?php echo $this->escape($this->item->longitude) ?>" maxlength="45">
											</div>
										</div>
									</div>
									<div id="map-container">
										<div id="company-map"></div>
									</div>
								<?php }?>
							</div>
						</fieldset>
						<?php } ?>
			
						<?php if ($itemType == OFFER_TYPE_PRODUCT){ ?>
							<!-- Associated companies Field-->
							<fieldset class="boxed">
								<h2> <?php echo JText::_('LNG_MERCHANTS');?></h2>
								<p><?php echo JText::_('LNG_SELECT_MERCHANTS');?></p>
								<div class="form-container">
									<div class="form-group">
										<select data-placeholder="<?php echo JText::_("LNG_SELECT_MERCHANTS") ?>" class="inputbox input-medium" multiple name="associated-listings[]" id="associated-listings">
											<?php echo JHtml::_('select.options', $this->companies, 'id', 'name', $this->item->merchantsOptions);?>
										</select>
										<div>
											<a href="javascript:jbdUtils.checkAll('associated-listings')"><?php echo JText::_("LNG_CHECK_ALL") ?></a> &nbsp;&nbsp;&nbsp; <a href="javascript:jbdUtils.uncheckAll('associated-listings')"><?php echo JText::_("LNG_UNCHECK_ALL")?></a>
										</div>
										<div id="norelatedcomp"></div>
									</div>
									<div class="clear"></div>
								</div>
							</fieldset>
							<!-- END Associated companies Field-->
						<?php } ?>
						
						<?php if($attributeConfig["pictures"]!=ATTRIBUTE_NOT_SHOW) { ?>
							<fieldset class="boxed">
								<?php if ($attributeConfig["pictures"] == ATTRIBUTE_MANDATORY) { ?>
									<input type="text" id="pictures_validate" class="validate[required] hidden-validate right" value="" />
								<?php } ?>
								<h2> <?php echo JText::_('LNG_OFFER_PICTURES');?> </h2>
								<p> <?php echo JText::_('LNG_OFFER_PICTURES_INFORMATION_TEXT');?>.</p>
								<a class="btn btn-outline-danger" id="remove-pictures" href="javascript:void(0);" onclick="uploadInstance.removeAllPicture()"><?php echo JText::_('LNG_DELETE_ALL')?></a>
								<input type='button' name='btn_removefile' id='btn_removefile' value='x' style='display:none'>
								<input type='hidden' name='crt_pos' id='crt_pos' value=''>
								<input type='hidden' name='crt_path' id='crt_path' value=''>
	
								<div class="jupload" id="pictures-list">
									<div class="jupload-header">
										<div class="jupload-header-title"></div>
										<div class="jupload-header-desc"></div>
									</div>
									<div class="jupload-body">
										<ul id="sortable" class="jbd-item-list">
											<?php
											if (!empty($this->item->pictures)) {
												foreach ($this->item->pictures as $picture ) { ?>
													<li class="jbd-item" id="jbd-item-<?php echo $picture['id'] ?>">
														<div class="jupload-files">
															<div class="jupload-files-img">
																<img src='<?php echo BD_PICTURES_PATH.$picture['picture_path']?>'>
															</div>
															<div class="jupload-files-info">
																<div class="jupload-filename">
																	<p><?php echo substr(basename($picture['picture_path']),0,30)?></p>
                                                                    <input id="jupload-filename-<?php echo $picture['id'] ?>" type="text"
                                                                           name="picture_title[]" value="<?php echo $picture['picture_title']?>" placeholder="<?php echo JText::_('LNG_TITLE') ?>">
                                                                    <input id="jupload-filename-<?php echo $picture['id'] ?>" type="text"
                                                                           name="picture_info[]" value="<?php echo $picture['picture_info']?>" placeholder="<?php echo JText::_('LNG_DESCRIPTION') ?>">
																</div>
																<div class="jupload-actions jbd-item-actions">
																	<label for="jupload-filename-<?php echo $picture['id'] ?>">
																		<i class="la la-pencil"></i>
																	</label>
	
																	<input type="hidden" name="picture_enable[]" id="picture_enable_<?php echo $picture['id'] ?>" value="<?php echo $picture['picture_enable'] ?>" />
																	<input type='hidden' name='picture_path[]' id='picture_path_<?php echo $picture['id'] ?>' value='<?php echo $this->escape($picture['picture_path'])?>' />
																</div>
															</div>
														</div>
													</li>
	
													<?php
												}
											} ?>
										</ul>
	
										<div class="dropzone dropzone-previews container-fluid" id="file-upload">
											<div id="actions" style="margin-left:-15px;" class="row">
												<div class="col d-flex justify-content-center">
													<!-- The fileinput-button span is used to style the file input field as button -->
													<span class="btn btn-success fileinput-button dz-clickable mr-1">
															<i class="glyphicon glyphicon-plus"></i>
															<span><?php echo JText::_('LNG_ADD_FILES'); ?></span>
														</span>
													<button  class="btn btn-primary start" id="submitAll">
														<i class="glyphicon glyphicon-upload"></i>
														<span><?php echo JText::_('LNG_UPLOAD_ALL'); ?></span>
													</button>
												</div>
											</div>
										</div>
									</div>
								</div>
							</fieldset>
						<?php } ?>
			
						<?php if($attributeConfig["video"]!=ATTRIBUTE_NOT_SHOW) { ?>
							<fieldset class="boxed">
								<h2> <?php echo JText::_('LNG_OFFER_VIDEOS');?></h2>
								<p> <?php echo JText::_('LNG_OFFER_VIDEO_INFORMATION_TEXT');?></p>
								<div class="form-box">
									<div id="video-container">
										<?php
										if(count($this->item->videos) == 0){?>
											<div class="video-item" id="detailBox0">
												<?php if ($attributeConfig["video"] == ATTRIBUTE_MANDATORY) { ?>
													<div  class="form-detail req"> <?php echo JBusinessUtil::showMandatory($attributeConfig["video"]) ?></div>
												<?php } ?>
												<label for="video1"><?php echo JText::_('LNG_VIDEO') ?></label>
												<div class="input-group">
													<input type="text" name="videos[]" id="0" class="form-control <?php echo $attributeConfig["video"] == ATTRIBUTE_MANDATORY ? "validate[required]" : "" ?> " value="" />
													<div class="input-group-append">
														<button class="btn btn-secondary" onclick="uploadInstance.removeRow('detailBox0');">
															<i class="la la-lg la-remove"></i>
														</button>
													</div>
												</div>
											</div> 
											<?php
										} ?>
				
										<?php $index = 0;
										if(count($this->item->videos)>0)
											foreach($this->item->videos as $video) { ?>
												<div class="video-item" id="detailBox<?php echo $index ?>">
													<label for="<?php echo $video->id ?>"><?php echo JText::_('LNG_VIDEO') ?> <?php echo JBusinessUtil::showMandatory($attributeConfig["video"]) ?></label>
													<div class="input-group">
														<input name="videos[]" id="<?php echo $video->id ?>" class="form-control <?php echo $attributeConfig["video"] == ATTRIBUTE_MANDATORY ? "validate[required]" : "" ?> " value="<?php echo $this->escape($video->url) ?>" />
														<div class="input-group-append">
															<button class="input-group-text btn-secondary" onclick="uploadInstance.removeRow('detailBox<?php echo $index++; ?>');">
																<i class="la la-lg la-remove"></i>
															</button>
														</div>
													</div>
												</div> 
												<?php
											} ?>
									</div>
									<a id="add-video" href="javascript:void(0);" onclick="uploadInstance.addVideo()"><?php echo JText::_('LNG_ADD_VIDEO')?></a>
								</div>
							</fieldset>
						<?php } ?>
			
						<?php if($this->appSettings->enable_attachments == 1) { ?>
							<?php if($attributeConfig["attachments"]!=ATTRIBUTE_NOT_SHOW) { ?>
								<fieldset class="boxed">
									<h2> <?php echo JText::_('LNG_ATTACHMENTS');?></h2>
									<p> <?php echo JText::_('LNG_ATTACHMENTS_INFORMATION_TEXT');?>.</p>
									<div class="form-box">
										<div class="form-group">
											<input type='button' name='btn_removefile_at' id='btn_removefile_at' value='x' style='display:none'>
											<input type='hidden' name='crt_pos_a' id='crt_pos_a' value=''>
											<input type='hidden' name='crt_path_a' id='crt_path_a' value=''>
											<input type="hidden" name="process-attachments" value="1">
		
											<div class="jupload" id="attachment-list">
												<div class="jupload-header">
													<div class="jupload-header-title"></div>
													<div class="jupload-header-desc"></div>
												</div>
												<div class="jupload-body">
													<ul id="sortable-attachment" class="jbd-item-list">
														<?php
														if (!empty($this->item->attachments)) {
															foreach ($this->item->attachments as $attachment ) { ?>
		
																<li class="jbd-item" id="jbd-item-<?php echo $attachment->id ?>">
																	<div class="jupload-files">
																		<div class="jupload-files-img">
																			<i class="la la-file"></i>
																		</div>
																		<div class="jupload-files-info">
																			<div class="jupload-filename">
																				<p><?php echo basename($attachment->path)?></p>
																				<input id="jupload-filename-<?php echo $attachment->id ?>" type="text"
																					name="attachment_name[]" value="<?php echo $attachment->name ?>">
																			</div>
																			<div class="jupload-actions jbd-item-actions">
																				<label for="jupload-filename-<?php echo $attachment->id ?>">
																					<i class="la la-pencil"></i>
																				</label>
		
																				<input type="hidden" name="attachment_status[]" id="attachment_status_<?php echo $attachment->id ?>" value="<?php echo $attachment->status ?>" />
																				<input type='hidden' name='attachment_path[]' id='attachment_path_<?php echo $attachment->id ?>' value='<?php echo $this->escape($attachment->path)?>' />
																			</div>
																		</div>
																	</div>
																</li>
		
																<?php
															}
														} ?>
													</ul>
		
													<fieldset class="jupload-field">
														<p><i class="la la-cloud-upload la-2x"></i><label
																	for="multiFileUploader"><?php echo JText::_('LNG_CHOOSE_FILE') ?></label></p>
														<input class="jupload-field-input" type="file" name="uploadAttachment" id="multiFileUploader">
													</fieldset>
												</div>
											</div>
		
										</div>
									</div>
								</fieldset>
							<?php } ?>
						<?php } ?>
							
						<?php if($attributeConfig["metadata_information"]!=ATTRIBUTE_NOT_SHOW && (!isset($isProfile) || isset($isProfile) && $this->appSettings->front_end_meta_data)) { ?>
							<fieldset class="boxed">
								<h2> <?php echo JText::_('LNG_METADATA_INFORMATION');?></h2>
								<p> <?php echo JText::_('LNG_METADATA_INFORMATION_TEXT');?>.</p>
								<div class="form-group">
									<label for="meta_title"><?php echo JText::_('LNG_META_TITLE')?></label>
									<?php
									if($this->appSettings->enable_multilingual) {
										echo $jbdTabs->startTabSet('tab_group_metadata');
										foreach( $this->languages  as $k=>$lng ) {
											echo $jbdTabs->addTab('tab_group_metadata', 'tab-'.$lng, $k);
											$langContent = isset($this->translationsMeta[$lng."_name"]) ? $this->translationsMeta[$lng."_name"] : "";
											if ($lng == JBusinessUtil::getLanguageTag() && empty($langContent)) {
												$langContent = $this->item->meta_title;
											}
											$langContent=$this->escape($langContent);
											echo "<input type='text' name='meta_title_$lng' id='meta_title_$lng' class='form-control' value=\"".stripslashes($langContent)."\"  maxLength='100'>";
											echo $jbdTabs->endTab();
										}
										echo $jbdTabs->endTabSet();
									} else { ?>
										<input type="text" name="meta_title" id="meta_title" class="form-control" value="<?php echo $this->escape($this->item->meta_title) ?>"  maxLength="100">
									<?php } ?>
								</div>
								<div class="bootstrap-tags form-group">
									<label for="meta_keywords"><?php echo JText::_('LNG_META_KEYWORDS')?></label>
									<?php
									if($this->appSettings->enable_multilingual) {
										echo $jbdTabs->startTabSet('tab_group_meta_keywords');
										foreach( $this->languages  as $k=>$lng ) {
											echo $jbdTabs->addTab('tab_group_meta_keywords', 'tab-'.$lng, $k);
											$langContent = isset($this->translationsMeta[$lng."_short"])?$this->translationsMeta[$lng."_short"]:"";
											if($lng==JBusinessUtil::getLanguageTag() && empty($langContent)){
												$langContent = $this->item->meta_keywords;
											}
											$langContent=$this->escape($langContent);
											echo "<input type='text'  data-role='tagsinput' name='meta_keywords_$lng' id='meta_keywords_$lng' class='form-control' value=\"".stripslashes($langContent)."\"  maxLength='100'>";
											echo $jbdTabs->endTab();
										}
										echo $jbdTabs->endTabSet();
									} else { ?>
										<input type="text" data-role="tagsinput" name="meta_keywords" class="form-control" id="meta_keywords" value="<?php echo $this->item->meta_keywords ?>" maxlength="150" />
									<?php } ?>
								</div>
								<div class="form-group">
									<label for="meta_description"><?php echo JText::_('LNG_META_DESCRIPTION')?></label>
									<?php
									if($this->appSettings->enable_multilingual) {
										echo $jbdTabs->startTabSet('tab_group_meta_description');
										foreach ($this->languages as $k=>$lng) {
											echo $jbdTabs->addTab('tab_group_meta_description', 'tab-'.$lng, $k);
											$langContent = isset($this->translationsMeta[$lng])?$this->translationsMeta[$lng]:"";
											if ($lng == JBusinessUtil::getLanguageTag() && empty($langContent)) {
												$langContent = $this->item->meta_description;
											}
											$langContent=$this->escape($langContent);
											echo "<textarea name='meta_description_$lng' id='meta_description_$lng' rows='4' maxLength='255'>$langContent</textarea>";
											echo $jbdTabs->endTab();
										}
										echo $jbdTabs->endTabSet();
									} else { ?>
										<textarea name="meta_description" id="meta_description" class="form-control" rows="4" maxLength="255"><?php echo $this->item->meta_description ?></textarea>
									<?php } ?>
								</div>
							</fieldset>
							<?php } elseif (isset($isProfile) && !$this->appSettings->front_end_meta_data ) { ?>
								<input type="hidden" name="meta_title" id="meta_title" value="<?php echo $this->item->meta_title ?>"/>
								<input type="hidden" name="meta_description" id="meta_description" value="<?php echo $this->item->meta_description ?>"/>
								<input type="hidden" name="meta_keywords" value="<?php echo $this->item->meta_keywords ?>" />
							<?php }  ?>
					</div>
				</div>
			</div>
			<div class="col-12 order-1 col-md-5 col-lg-4 order-md-2 ml-0 ml-lg-auto">
				<?php if(!isset($isProfile)) { ?>
					<div class="metainfo-container">
						<fieldset class="boxed approved-label ">
							<div class="form-box">
								<div ><label id="approved" for="approved" title=""><?php echo JText::_('LNG_APPROVED'); ?></label></div>
								<div class="form-group">
									<fieldset id="approved" class="radio btn-group btn-group-yesno">
										<input type="radio" class="validate[required]" name="approved" id="approved5" value="<?php echo 1  ?>" <?php echo $this->item->approved==1? 'checked="checked"' :""?> />
										<label class="btn" id="label_approved5" for="approved5"><?php echo JTEXT::_("LNG_APPROVED")?></label>
										<input type="radio" class="validate[required]" name="approved" id="approved6" value="<?php echo -1 ?>"  <?php echo $this->item->approved==-1? 'checked="checked"' :""?> />
										<label class="btn" id="label_approved6" for="approved6"><?php echo JText::_('LNG_DISAPPROVED')?></label>
									</fieldset>
								</div>
							</div>
						</fieldset>
						
						<?php 
							if(!isset($this->item->user_id)){
							 $this->item->user_id = 0;
							}
							$itemOwner = JBusinessUtil::getUser($this->item->user_id); 
						?>
						<fieldset class="boxed">
							<h2> <?php echo JText::_('LNG_USER');?></h2>
							<p>User information</p>
							<div class="form-box">
								<div class="form-group">
									<?php JBusinessUtil::renderUserSelection($itemOwner->name, $this->item->user_id,"user_id"); ?>
								</div>
							</div>
						</fieldset>
					</div>
				<?php } ?>
		   </div>

			<?php if(isset($isProfile)) { ?>
				<div class="row py-2">
					<div class="col-md-12">
						<div>
							<?php if($this->item->id == 0) { ?>
								<?php echo JBusinessUtil::renderTermsAndConditions(); ?>
							<?php } ?>
							<div class="button-row">
								<button id="save-btn" type="button" class="btn btn-success button-save" onclick="saveCompanyInformation('apply')">
									<i class="la la-edit"></i> <?php echo JText::_("LNG_SAVE")?>
								</button>
								<button type="button" class="btn btn-success button-close" onclick="saveCompanyInformation('save');">
									<span class="ui-button-text"><i class="la la-check"></i> <?php echo JText::_("LNG_SAVE_AND_CLOSE")?></span>
								</button>
								<?php if (!$isNew) { ?>
									<button id="duplicate-btn" type="button" class="btn btn-success button-save" onclick="saveCompanyInformation('duplicate')">
										<i class="icon-save-copy"></i> <?php echo JText::_("LNG_DUPLICATE")?>
									</button>
								<?php } ?>
								<button type="button" class="btn btn-dark button-cancel" onclick="cancel()">
									<i class="la la-close"></i> <?php echo JText::_("LNG_CANCEL")?>
								</button>
							</div>
						</div>
					</div>
				</div>
			<?php } ?>
		</div>

		<input type="hidden" name="option" value="<?php echo JBusinessUtil::getComponentName()?>" /> 
		<input type="hidden" name="task" id="task" value="" /> 
		<input type="hidden" name="item_type" id="item_type" value="<?php echo !empty($this->item->item_type)?$this->item->item_type:$itemType ?>" />
		<input type="hidden" name="id" value="<?php echo $this->item->id ?>" />

		<?php if(isset($isProfile)) { ?>
			<input type="hidden" id="user_id" name="user_id" value="<?php echo !empty($this->item->user_id)? $this->item->user_id : $user->id ?>" />
		 <?php } ?>
	
		<?php echo JHTML::_( 'form.token' ); ?>
	</form>
</div>

<div id="shipping-method-item-template" style="display:none;">
	<li class="jbd-item" id="jbd-item-{shipping_method_id}">
		<div class="jupload-files">
			<div class="jupload-files-img">
				<i class="la la-shipping-fast"></i>
			</div>
			<div class="jupload-files-info">
				<div class="jupload-filename">
					<p>{shipping_method_name}</p>
					<input id="jupload-filename-{shipping_method_id}" type="text" class="w-25 d-inline"
						   name="shippingMethodPrices[]" value="{shipping_method_price}"> (<?php echo $this->appSettings->currency_name ?>)
				</div>
				<div class="jupload-actions jbd-item-actions">
					<label for="jupload-filename-{shipping_method_id}">
						<i class="la la-pencil"></i>
					</label>

					<input type='hidden' name='shippingMethodIds[]' id='shipping_method_{shipping_method_id}' value='{shipping_method_id}' />
				</div>
			</div>
		</div>
	</li>
</div>

<?php

if (isset($isProfile)) {
	echo JBusinessUtil::getMapGDPRModal();
}

JBusinessUtil::loadUploadScript(true, true, false);

$map_latitude = $this->appSettings->map_latitude;
if ((empty($map_latitude)) || (!is_numeric($map_latitude)))
	$map_latitude = 0;

$map_longitude = $this->appSettings->map_longitude;
if ((empty($map_longitude)) || (!is_numeric($map_longitude)))
	$map_longitude = 0;

$map_zoom = $this->appSettings->map_zoom;
if ((empty($map_zoom)) || (!is_numeric($map_zoom)))
	$map_zoom = 10;

$latitude = !empty($this->item->latitude)?$this->item->latitude:$map_latitude;
$longitude = !empty($this->item->longitude)?$this->item->longitude:$map_longitude;

$initparams =  array();
$initparams['map_latitude'] = $latitude;
$initparams['map_longitude'] = $longitude;
$initparams['map_zoom'] = empty($this->item->latitude)?(int)$map_zoom:15;
$initparams['longitude'] = $this->item->longitude;
$initparams['latitude'] = $this->item->latitude;
$initparams['is_admin'] = true;
if ($this->appSettings->map_type == MAP_TYPE_BING) {
	$initparams["key"] = $mapKey;
}

$initLocation = new stdClass();
$initLocation->longitude = $longitude;
$initLocation->latitude = $latitude;
$initLocations = array($initLocation);
?>

<script>
	var maxVideos = <?php echo $this->appSettings->max_video ?>;
	var maxPictures = '<?php echo $maxPictures ?>';

	var maxCategories = <?php echo isset($this->item->package)?$this->item->package->max_categories :$this->appSettings->max_categories ?>;
	var offerFolder = '<?php echo OFFER_PICTURES_PATH.((int)$this->item->id)."/"?>';
	var offerFolderPath = '<?php echo JBusinessUtil::getUploadUrl() ?>&t=<?php echo strtotime("now")?>&picture_type=<?php echo PICTURE_TYPE_OFFER?>&_path_type=1&_target=<?php echo urlencode(OFFER_PICTURES_PATH.((int)$this->item->id)."/")?>';
	var offerAttachFolderPath = '<?php echo JBusinessUtil::getUploadUrl('uploadFile') ?>&t=<?php echo strtotime("now")?>&_path_type=4&_target=<?php echo urlencode(OFFER_PICTURES_PATH.((int)$this->item->id)."/")?>'
	var removePath = '<?php echo JBusinessUtil::getUploadUrl('remove') ?>&_path_type=3&_filename=';
	var removePath_at = '<?php echo JBusinessUtil::getUploadUrl('remove') ?>&_path_type=2&_filename=';
	var siteRoot = '<?php echo JRoute::_('index.php?option=com_jbusinessdirectory');?>';

	var jbdAdminMapInstance;
	var uploadInstance;

	<?php $loadMap = ($attributeConfig["map"] != ATTRIBUTE_NOT_SHOW); ?>

	function initializeMap() {
		<?php if($loadMap) { ?>
		jbdAdminMapInstance = JBDMapHelper.loadMapScript(
			<?php echo json_encode($initLocations) ?>,
			<?php echo json_encode($initparams)?>
		);

		jbdUtils.addAdminMapClickAction();
		<?php } ?>
	}

	function validatePictures()
	{
		<?php if($attributeConfig["pictures"] == ATTRIBUTE_MANDATORY) { ?>
		var root = jQuery('#pictures-list');
		var list = root.find('.jbd-item-list');
		var items = list.find('.jbd-item');
		var value = items.length > 0 ? 'not-empty' : '';

		jQuery('#pictures_validate').val(value);
		<?php } ?>
	}

	window.addEventListener('load', function() {

		uploadInstance = JBDUploadHelper.getUploadInstance({
			'maxPictures': maxPictures,
			'maxVideos': maxVideos,
			'removePath': removePath
		});

		uploadInstance.imageUploaderDropzone(
			"#file-upload",
			'<?php echo JBusinessUtil::getUploadUrl() ?>&t=<?php echo strtotime("now")?>&picture_type=<?php echo PICTURE_TYPE_GALLERY?>&_path_type=1&_target=<?php echo urlencode(OFFER_PICTURES_PATH.($this->item->id)."/")?>',
			".fileinput-button","<?php echo JText::_('LNG_DRAG_N_DROP',true); ?>",
			offerFolder ,
			<?php echo $allowedNr ?>,
			"addPicture"
		);
		jQuery( "#sortable" ).sortable();
		jQuery( "#sortable" ).disableSelection();


		jbdOffers.displayStockPrice(<?php echo $this->item->use_stock_price?>);
		
		jQuery('#pictures-list').jbdList({
			statusCallback: uploadInstance.changePictureStatus,
			deleteCallback: uploadInstance.deletePicture,
			statusSelector: 'picture_enable_',
			deleteMsg: "<?php echo JText::_('LNG_CONFIRM_DELETE_PICTURE') ?>"
		});

		jQuery('#attachment-list').jbdList({
			statusCallback: uploadInstance.changeAttachmentStatus,
			deleteCallback: uploadInstance.deleteAttachment,
			statusSelector: 'attachment_status_',
			deleteMsg: "<?php echo JText::_('LNG_CONFIRM_DELETE_ATTACHMENT') ?>"
		});

		jQuery('#shipping-methods-list').jbdList({
			status: false,
			deleteMsg: "<?php echo JText::_('LNG_CONFIRM_DELETE_SHIPPING_METHOD') ?>"
		});

		jQuery("#sortable-attachment").sortable();
		jQuery("#sortable-attachment").disableSelection();

		jQuery("#sortable-shipping-methods").sortable();
		jQuery("#sortable-shipping-methods").disableSelection();

		uploadInstance.checkNumberOfVideos();

		uploadInstance.multiFileUploader(offerFolder, offerAttachFolderPath);
		uploadInstance.btn_removefile(removePath);
		uploadInstance.btn_removefile_at(removePath_at);

		jQuery("#associated-listings").chosen({width:"95%", max_selected_options: 0});
		jQuery(".ajax-chosen-select").chosen({width: "95%", disable_search_threshold: -1, allow_single_deselect: true});

		if (jbdUtils.getProperty("isProfile") != 1) {
			var isProfile = false;
			var userId = 0;
		} else {
			var userId = '<?php echo $user->id ?>';
		}

		let urlGetCompanies = jbdUtils.getAjaxUrl('getCompaniesByStringAjax', 'companies', 'managecompanies');

		jQuery("#companyId").ajaxChosen({
				type: 'GET',
				url: urlGetCompanies,
				data: {
					isProfile: isProfile,
					userId: userId
				},
				dataType: 'json'
			},
			function (data) {
				var results = [];
				jQuery.each(data, function (i, val) {
					results.push({value: val.id, text: val.name});
				});
				return results;
			},
			{
				width: "95%", disable_search_threshold: -1, allow_single_deselect: true
			}
		);

		jQuery("#item-form").validationEngine('attach');
		if(jQuery("#companyId_chosen input").length || jQuery("#companyId_chzn input").length){
			document.querySelector("#companyId_chosen input, #companyId_chzn input").placeholder = "<?php echo JText::_('LNG_COMPANY_SEARCH_HINT')  ?>";
		}
		
		jQuery(".chosen-select").chosen({width:"95%", disable_search_threshold: 5, placeholder_text_single: "<?php echo JText::_('LNG_SELECT_OPTION')  ?>" , placeholder_text_multiple: "<?php echo JText::_('LNG_SELECT_OPTION')  ?>"});
		jQuery(".chosen-select-categories").chosen({width:"95%", max_selected_options: maxCategories});

		jQuery('#shippingMethods').chosen().change(function() {
			var ids = jQuery(this).val();

			jQuery('#sortable-shipping-methods').find('.jbd-item').each(function() {
				var elementId = jQuery(this).attr('id');
				var id = elementId.substring(9);

				if (typeof ids !== "undefined" && ids !== null) {
					if (!ids.includes(id)) {
						jQuery(this).remove();
					}
				} else {
					jQuery(this).remove();
				}
			});

			if (typeof ids !== "undefined" && ids !== null) {
				for (var i in ids) {
					if (ids.hasOwnProperty(i)) {
						var id = ids[i];

						if (!jQuery('#sortable-shipping-methods').find('#jbd-item-' + id).length) {
							var name = jQuery('#shippingMethods option[value="' + id + '"]').text();
							var price = jQuery('#shippingMethods option[value="' + id + '"]').attr('data-price');
							addShippingMethod(id, price, name);
						}
					}
				}
			}
		});

		jQuery('.timepicker').timepicker({ 'timeFormat': jbdUtils.getProperty("timeFormat"), 'minTime': '6:00am', })

		jQuery('select#categories').on('change', function() {
			var selected = jQuery('#main_subcategory option:selected').val();
			jQuery('select#main_subcategory').find('option').remove();
			jQuery('select#categories option:selected').each(function () {
				if (jQuery(this).length) {
					var selCategoryOption = jQuery(this).clone();
					selCategoryOption.removeAttr('selected');
					jQuery('select#main_subcategory').append(selCategoryOption);
					if(selCategoryOption.val() === selected) {
						jQuery('select#main_subcategory').find('option').attr('selected', 'selected');
					}
					jbdUtils.updateChosenSelect('select#main_subcategory');
				}
			});

			var catId = jQuery('#main_subcategory option:selected').val();
			if(catId === 0 || typeof catId === "undefined" ) {
				catId = -1;
			}

			jbdOffers.updateAttributes(catId, '<?php echo $this->item->id ?>');
			jbdOffers.updateSellingOptionsAjax(catId,<?php echo $this->item->id ?>);
		});

		initializeMap();
		jbdUtils.initializeAdminAutocomplete(false);

		jQuery(".button-cancel").click(function() {
			jQuery(this).addClass("loader")
		})

		<?php if ($this->appSettings->limit_cities_regions == 1) { ?>
			//updateRegions();
			//updateCities();
		<?php } ?>

		jQuery('.bootstrap-tagsinput input').on('keypress', function(e){
            if (e.keyCode == 13){
                e.keyCode = 188;
                e.preventDefault();
            }
        });
	});

	function saveCompanyInformation(task) {
		var defaultLang="<?php echo JBusinessUtil::getLanguageTag() ?>";
		var evt = document.createEvent("HTMLEvents");
		evt.initEvent("click", true, true);
		var tab = ("tab-"+defaultLang);
		if(!(document.getElementsByClassName(tab)[0] === undefined || document.getElementsByClassName(tab)[0] === null))
			document.getElementsByClassName(tab)[0].dispatchEvent(evt);
		if(jbdUtils.validateCmpForm(true, <?php echo $attributeConfig["description"] == ATTRIBUTE_MANDATORY?'true':'false' ?>,task, validatePictures))
			return false;
		jQuery("#item-form #task").val('managecompanyoffer.'+task);
		jQuery("#item-form").submit();
	}
	
	function cancel() {
		jQuery("#item-form").validationEngine('detach');
		jQuery("#item-form #task").val("managecompanyoffer.cancel");
		jQuery("#item-form").submit();
	}

	function addShippingMethod(id, price, name) {
		var attachTemplate = jQuery('#shipping-method-item-template').html();

		attachTemplate = attachTemplate.replaceAll('{shipping_method_id}', id);
		attachTemplate = attachTemplate.replaceAll('{shipping_method_name}', name);
		attachTemplate = attachTemplate.replaceAll('{shipping_method_price}', price);

		jQuery('#shipping-methods-list').find('.jbd-item-list').append(attachTemplate);
		jQuery('#shipping-methods-list').jbdList({
			status: false,
			deleteMsg: "<?php echo JText::_('LNG_CONFIRM_DELETE_SHIPPING_METHOD') ?>"
		});
	}

	function addShippingMethod(id, price, name) {
		var attachTemplate = jQuery('#shipping-method-item-template').html();

		attachTemplate = attachTemplate.replaceAll('{shipping_method_id}', id);
		attachTemplate = attachTemplate.replaceAll('{shipping_method_name}', name);
		attachTemplate = attachTemplate.replaceAll('{shipping_method_price}', price);

		jQuery('#shipping-methods-list').find('.jbd-item-list').append(attachTemplate);
		jQuery('#shipping-methods-list').jbdList({
			status: false,
			deleteMsg: "<?php echo JText::_('LNG_CONFIRM_DELETE_SHIPPING_METHOD') ?>"
		});
	}

	<?php if ($this->appSettings->limit_cities_regions == 1) { ?>
        var showCountryAttr = <?php echo $attributeConfig["country"]!=ATTRIBUTE_NOT_SHOW ?'true':'false'; ?>

		function updateCities(callback){
			var regionIds = jQuery('#administrative_area_level_1').val();

			var dataSelected = [];
			jQuery('#locality').find('option:selected').each(function(){
				dataSelected.push(jQuery(this).val());
			});

			if (regionIds == null) {
				jQuery('#locality').empty();
				jbdUtils.updateChosenSelect('#locality');
				return;
			}
			let url = jbdUtils.getAjaxUrl('getCitiesByRegionsAjax', 'offer', 'managecompanyoffer');
			jQuery.ajax({
				type: 'GET',
				url: url,
				data: {regionName: regionIds},
				dataType: 'json',
				success: function (data) {
					var selectedVar;
					jQuery('#locality').empty();
					jQuery('#locality').append('<option value=""><?php echo JText::_('LNG_SELECT_CITY') ?></option>');
					jQuery.each(data, function (i, val) {
						selectedVar = "";
						if (jQuery.inArray(val.name, dataSelected) != '-1' && dataSelected.length > 0) {
							selectedVar = "selected";
						}
						jQuery('#locality').append('<option ' + selectedVar + ' value="' + val.name + '">' + val.name + '</option>');
					});

					if (typeof callback !== "undefined") {
						callback();
					}
				}
			});
		}

		function updateRegions(callback)
		{
			var countryId = jQuery('#country').val();

			var dataSelected = [];
			jQuery('#administrative_area_level_1').find('option:selected').each(function(){
				dataSelected.push(jQuery(this).val());
			});

			if (showCountryAttr && countryId == null) {
				jQuery('#administrative_area_level_1').empty();
				jbdUtils.updateChosenSelect('#administrative_area_level_1');
				return;
			}

			jQuery.ajax({
				type: 'GET',
				url: jbdUtils.getAjaxUrl('getRegionsByCountryAjax', 'offer', 'managecompanyoffer'),
				data: {countryId: countryId},
				dataType: 'json',
				success: function (data) {
					var selectedVar;
					jQuery('#administrative_area_level_1').empty();
					jQuery('#administrative_area_level_1').append('<option value=""><?php echo JText::_('LNG_SELECT_REGION') ?></option>');
					jQuery.each(data, function (i, val) {
						selectedVar = "";
						if (jQuery.inArray(val.name, dataSelected) != '-1' && dataSelected.length > 0) {
							selectedVar = "selected";
						}
						jQuery('#administrative_area_level_1').append('<option ' + selectedVar + ' value="' + val.name + '">' + val.name + '</option>');
					});

					if (jQuery('#administrative_area_level_1').val().length > 0) {
						updateCities();
					} else {
						updateCities(function(){
							jQuery('#locality').empty();
							jQuery('#locality').append('<option value=""><?php echo JText::_('LNG_SELECT_CITY') ?></option>');
						});
					}

					if (typeof callback !== "undefined") {
						callback();
					}
				}
			});
		}
	<?php } ?>
</script>