<?php
/**
 * @package    JBusinessDirectory
 * @subpackage  com_jbusinessdirectory
 *
 * @copyright   Copyright (C) 2007 - 2015 CMS Junkie. All rights reserved.
 * @license     GNU General Public License version 2 or later;
 */

defined('_JEXEC') or die('Restricted access');

// Include the component HTML helpers.
JHtml::addIncludePath(JPATH_COMPONENT.'/helpers/html');

// Load the tooltip behavior.
?>

<?php
$appSetings = JBusinessUtil::getApplicationSettings();
$membership=$this->item;

$options = array(
        'onActive' => 'function(title, description) {
		description.setStyle("display", "block");
		title.addClass("open").removeClass("closed");
	}',
        'onBackground' => 'function(title, description) {
		description.setStyle("display", "none");
		title.addClass("closed").removeClass("open");
	}',
        'startOffset' => 0,  // 0 starts on the first tab, 1 starts the second, etc...
        'useCookie' => true, // this must not be a string. Don't use quotes.
);

$jbdTabs = new JBDTabs();
$jbdTabs->setOptions($options);

?>

<script type="text/javascript">
window.addEventListener('load', function() {
    Joomla.submitbutton = function (task) {

        var defaultLang = "<?php echo JBusinessUtil::getLanguageTag() ?>";

        jQuery("#item-form").validationEngine('detach');
        var evt = document.createEvent("HTMLEvents");
        evt.initEvent("click", true, true);
        var tab = ("tab-" + defaultLang);
        if (!(document.getElementsByClassName(tab)[0] === undefined || document.getElementsByClassName(tab)[0] === null))
            document.getElementsByClassName(tab)[0].dispatchEvent(evt);
        if (task == 'membership.cancel' || !jbdUtils.validateCmpForm(false, false)) {
            Joomla.submitform(task, document.getElementById('item-form'));
        }
        jQuery("#item-form").validationEngine('attach');
    }
});
</script>

<div id="jbd-container" class="jbd-container jbd-edit-container">
    <form action="<?php echo JRoute::_('index.php?option=com_jbusinessdirectory&layout=edit&id='.(int) $this->item->id); ?>" method="post" name="adminForm" id="item-form" class="form-horizontal">
        <div class="row">
            <div class="col-md-7">
                <div class="row">
                    <div class="col-md-12">
                        <fieldset class="boxed">
                            <h2> <?php echo JText::_('LNG_MEMBERSHIP'); ?></h2>
                            <div class="form-container" id="tax-form-box">
                                <div class="form-group">
                                    <label for="name"><?php echo JText::_('LNG_NAME') ?><?php echo JBusinessUtil::showMandatory(ATTRIBUTE_MANDATORY) ?></label>
                                    <?php
                                    if($appSetings->enable_multilingual){
                                        echo $jbdTabs->startTabSet('tab_group_name');
                                        foreach( $this->languages as $k=>$lng ){
                                            echo $jbdTabs->addTab('tab_group_name', 'tab-' . $lng, $k);
                                            $langContent = isset($this->translations[$lng."_name"])?$this->translations[$lng."_name"]:"";
                                            if($lng == JBusinessUtil::getLanguageTag() && empty($langContent)){
                                                $langContent = $membership->name;
                                            }
                                            echo "<input type='text' name='name_$lng' id='name_$lng' class='input_txt form-control validate[required]' value=\"".stripslashes($langContent)."\"  maxLength='100'>";
                                            echo $jbdTabs->endTab();
                                        }
                                        echo $jbdTabs->endTabSet();
                                    } else { ?>
                                        <input type="text" name="name" id="name" class="input_txt form-control validate[required]" value="<?php echo $membership->name ?>"  maxLength="100">
                                    <?php } ?>
                                </div>

                                <div class="form-group">
                                    <label for="companyId"><?php echo JText::_('LNG_TYPE')?></label>
                                    <select id='type' name='type'>
                                        <option value = "<?php echo MEMBERSHIP_TYPE_1 ?>" <?php echo ($membership->type==MEMBERSHIP_TYPE_1)?"selected":"" ?> ><?php echo JText::_("LNG_MEMBERSHIP_TYPE_1")?></option>
                                        <option value = "<?php echo MEMBERSHIP_TYPE_2 ?>" <?php echo ($membership->type==MEMBERSHIP_TYPE_2)?"selected":"" ?> ><?php echo JText::_("LNG_MEMBERSHIP_TYPE_2")?></option>
                                        <option value = "<?php echo MEMBERSHIP_TYPE_3 ?>" <?php echo ($membership->type==MEMBERSHIP_TYPE_3)?"selected":"" ?> ><?php echo JText::_("LNG_MEMBERSHIP_TYPE_3")?></option>
                                    </select>
                                </div>

                                <div class="form-group">
                                    <label for="url"><?php echo JText::_('LNG_URL')?> </label>
                                    <input type="text"	name="url" id="url" class="input_txt form-control text-input" value="<?php echo $membership->url ?>"  maxLength="125">
                                </div>

                                <div class="form-group">
                                    <label for="description"><?php echo JText::_('LNG_DESCRIPTION') ?></label>
                                    <?php
                                    if($appSetings->enable_multilingual) {
                                        echo $jbdTabs->startTabSet('tab_groupsd_id');
                                        foreach( $this->languages  as $k=>$lng ) {
                                            echo $jbdTabs->addTab('tab_groupsd_id', 'tab-'.$lng, $k);
                                            $langContent = isset($this->translations[$lng])?$this->translations[$lng]:"";
                                            if($lng==JBusinessUtil::getLanguageTag() && empty($langContent)) {
                                                $langContent = $membership->description;
                                            }
                                            echo "<textarea id='description_$lng' name='description_$lng' class='input_txt form-control' cols='75' rows='5' maxLength='250'>$langContent</textarea>";
                                            echo $jbdTabs->endTab();
                                        }
                                        echo $jbdTabs->endTabSet();
                                    } else { ?>
                                        <textarea name="description" id="description" class="input_txt form-control"  cols="75" rows="5"  maxLength="250"><?php echo $membership->description ?></textarea>
                                        <div class="clear"></div>
                                        <?php
                                    } ?>
                                </div>

                                <div class="form-group">
                                    <label for="show_in_front_fld"><?php echo JText::_('LNG_SHOW_IN_FRONT')?> </label>
                                    <fieldset id="show_in_front_fld" class="radio btn-group btn-group-yesno">
                                        <input type="radio" class="validate[required]" name="show_in_front" id="show_in_front1" value="1" <?php echo $membership->show_in_front==1? 'checked="checked"' :""?> />
                                        <label class="btn" for="show_in_front1"><?php echo JText::_('LNG_YES')?></label>
                                        <input type="radio" class="validate[required]" name="show_in_front" id="show_in_front0" value="0" <?php echo $membership->show_in_front==0? 'checked="checked"' :""?> />
                                        <label class="btn" for="show_in_front0"><?php echo JText::_('LNG_NO')?></label>
                                    </fieldset>
                                    <div class="clear"></div>
                                </div>

                                <div class="form-group">
                                    <label for="status"><?php echo JText::_('LNG_STATUS')?> </label>
                                    <fieldset id="status_fld" class="radio btn-group btn-group-yesno">
                                        <input type="radio" class="validate[required]" name="status" id="status1" value="1" <?php echo $membership->status==1? 'checked="checked"' :""?> />
                                        <label class="btn" for="status1"><?php echo JText::_('LNG_PUBLISHED')?></label>
                                        <input type="radio" class="validate[required]" name="status" id="status0" value="0" <?php echo $membership->status==0? 'checked="checked"' :""?> />
                                        <label class="btn" for="status0"><?php echo JText::_('LNG_UNPUBLISHED')?></label>
                                    </fieldset>
                                    <div class="clear"></div>
                                </div>
                            </div>
                        </fieldset>

                        <fieldset class="boxed">
                            <div class="form-container">
                                <h2> <?php echo JText::_('LNG_IMAGE'); ?></h2>
                                <div class="form-group">
                                    <label for="image_title"><?php echo JText::_('LNG_TITLE')?> </label>
                                    <input type="text"	name="image_title" id="image_title" class="input_txt form-control text-input" value="<?php echo $membership->image_title ?>"  maxLength="125">
                                </div>
                                <div class="jupload logo-jupload">
                                    <div class="jupload-header">
                                        <div class="jupload-header-title">
                                            <?php echo JText::_("LNG_SELECT_IMAGE_TYPE") ?>.
                                        </div>
                                    </div>
                                    <div class="jupload-body">
                                        <div class="jupload-files">
                                            <div class="jupload-files-img image-fit-contain" id="picture-preview">
                                                <?php if (!empty($membership->logo_location)) {
                                                    echo "<img src='" . BD_PICTURES_PATH . $membership->logo_location . "'/>";
                                                }else{
                                                    echo "<i class='la la-image'></i>";
                                                } ?>
                                            </div>
                                        </div>
                                    </div>
                                    <input type="text" name="logo_location" style="visibility:hidden;height:1px;" id="imageLocation" class="form-control" value="<?php echo $membership->logo_location ?>"><br/>
                                    <div class="jupload-footer">
                                        <fieldset>
                                            <p class="hint"><?php echo JText::_('LNG_LOGO_MAX_SIZE'); ?></p>
                                            <input type="file" id="imageUploader" name="uploadLogo" size="50">
                                        </fieldset>
                                        <div class="btn-group">
                                            <label for="imageUploader" class="btn btn-success"><?php echo JText::_("LNG_UPLOAD")?></label>
                                            <a name="" id="" class="btn btn-danger" href="javascript:uploadInstance.removeImage()" role="button"><?php echo JText::_("LNG_REMOVE_LOGO")?></a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </fieldset>
                    </div>
                </div>
            </div>
        </div>

        <input type="hidden" name="option" value="<?php echo JBusinessUtil::getComponentName()?>" />
        <input type="hidden" name="task" id="task" value="" />
        <input type="hidden" name="id" id="id" value="<?php echo $membership->id ?>" />
        <input type="hidden" name="view" id="view" value="membership" />
        <?php echo JHTML::_( 'form.token' ); ?>
    </form>
</div>

<?php JBusinessUtil::loadUploadScript(); ?>

<script>

	var removePath = '<?php echo JBusinessUtil::getUploadUrl('remove') ?>&_path_type=2&_filename=';
    var companyFolder = '<?php echo MEMBERSHIP_PICTURES_PATH ?>';
    var companyFolderPath = '<?php echo JBusinessUtil::getUploadUrl() ?>&t=<?php echo strtotime("now")?>&picture_type=<?php echo PICTURE_TYPE_LOGO?>&_path_type=1&_target=<?php echo urlencode(MEMBERSHIP_PICTURES_PATH)?>';

    var uploadInstance;

    window.addEventListener('load', function() {
        uploadInstance = JBDUploadHelper.getUploadInstance({
            'removePath': removePath
        });

        uploadInstance.imageUploader(companyFolder, companyFolderPath);
    });
</script>