<?php
/**
 * @package    JBusinessDirectory
 *
 * @author CMSJunkie http://www.cmsjunkie.com
 * @copyright  Copyright (C) 2007 - 2021 CMSJunkie. All rights reserved.
 * @license   https://www.gnu.org/licenses/agpl-3.0.en.html
 */ 
defined('_JEXEC') or die('Restricted access');
?>

<div id="jbd-container" class="jbd-container">
<form name="tabsForm" action="<?php echo JRoute::_('index.php?option=com_jbusinessdirectory') ?>" id="tabsForm" method="post">
    <div class="row-fluid">
        <div class="col-md-12 general-settings">
            <fieldset class="form-horizontal">
                <legend><?php echo JText::_('LNG_CHOSE_EMAIL_TYPE'); ?></legend>
                <div class="col-md-5 py-2">
                    <select id="email_notification_type" onchange="setValue()">
                        <option value="<?php echo CREATE_LISTINGS_EMAIL_NOTIFICATION_TYPE ?>" selected><?php echo JText::_('LNG_CREATE_LISTINGS_EMAIL_NOTIFICATION_TYPE'); ?></option>
                        <option value="<?php echo STATISTICS_EMAIL_NOTIFICATION_TYPE ?>"><?php echo JText::_('LNG_STATISTICS_EMAIL_NOTIFICATION_TYPE'); ?></option>
                        <option value="<?php echo UPGRADE_LISTING_EMAIL_NOTIFICATION_TYPE ?>"><?php echo JText::_('LNG_UPGRADE_LISTING_EMAIL_NOTIFICATION_TYPE'); ?></option>
                    </select>
                    <button type="submit" class="btn btn-success" onclick="this.form.submit()">
                        <span class="ui-button-text">
                            <i class="la la-plus-sign"></i><?php echo JText::_('LNG_SEND_EMAIL'); ?>
                        </span>
                    </button>
                </div>
                <div class="col-md-6">
                    <div id="address-hint" class="dir-notice"></div>
                </div>
            </fieldset>

            <div class="clear"></div>
            <br/>

            <table class="jtable" id="itemList">
                <thead class="jtable-head">
                <tr class="jtable-head-row">
                    <th class="jtable-head-row-data">#</th>
                    <th class="jtable-head-row-data" ><?php echo JText::_('LNG_TYPE'); ?></th>
                    <th class="jtable-head-row-data" ><?php echo JText::_('LNG_SENT_TIMES'); ?></th>
                    <th class="jtable-head-row-data" ><?php echo JText::_('LNG_LAST_SENT_DATE'); ?></th>
                    <th class="jtable-head-row-data" ><?php echo JText::_('LNG_FAILED_SENT'); ?></th>
                </tr>
                </thead>

                <tfoot>
                </tfoot>

                <tbody class="jtable-body">
                <?php $nrcrt = 1;
                $i = 0;
                foreach ($this->logs as $log) { ?>
                    <TR class="jtable-body-row <?php echo $i % 2; ?>">
                        <TD class="jtable-head-row-data" align=""><?php echo $nrcrt++ ?></TD>
                        <TD class="jtable-head-row-data" align="">
                            <?php echo $log->email_type; ?>
                        </TD>
                        <td class="jtable-head-row-data" align="">
                            <div>
                                <?php echo $log->totalSent; ?>
                            </div>
                        </td>
                        <td class="jtable-head-row-data" align="">
                            <div>
                                <?php echo $log->lastSentDate; ?>
                            </div>
                        </td>
                        <td class="jtable-head-row-data" align="">
                            <div>
                                <?php echo $log->totalFailed; ?>
                            </div>
                        </td>

                    </TR>
                    <?php
                    $i++;
                } ?>
                </tbody>
            </table>

            <input type="hidden" name="task" id="task" value="marketing.CreationListingsNotification"/>
            <input type="hidden" name="option" value="<?php echo JBusinessUtil::getComponentName() ?>"/>
            <input type="hidden" name="view" value="marketing"/>
            <input type="hidden" name="controller" value="marketing"/>
        </div>
    </div>
</form>
</div>

<script>
    let emailDescriptions = [];
    window.addEventListener("load", function () {
	    <?php foreach ($this->emailDescriptions as $key=>$item) { ?>
        emailDescriptions['<?php echo $key ?>'] = '<?php echo $item?>';
        jQuery('#address-hint').html(emailDescriptions[0]);
	    <?php } ?>
    });

  function setValue() {
      let x = document.getElementById('email_notification_type').value;
      jQuery("#email_notification_name").val(x);
      if (x == 0) {
          jQuery("#task").val("marketing.CreationListingsNotification");
      } else if (x == 1) {
          jQuery("#task").val("marketing.StatisticsNotification");
      } else {
          jQuery("#task").val("marketing.UpgradeNotification");
      }
      jQuery('#address-hint').html(emailDescriptions[x]);
  }
</script>