<?php
/**
 * Main view responsable for creating the extension menu structure and admin template
 *
 * @package    JBusinessDirectory
 * @subpackage  com_jbusinessdirectory
 *
 * @copyright   Copyright (C) 2007 - 2015 CMS Junkie. All rights reserved.
 * @license     GNU General Public License version 2 or later;
 */

defined('_JEXEC') or die('Restricted access');

//
JBusinessUtil::enqueueStyle('libraries/metis-menu/metisMenu.css');

require_once HELPERS_PATH.'/helper.php';

class JBusinessDirectoryAdminView extends JViewLegacy {
	public $section_name="";
	public $section_description = "";

	public function __construct($config = array()) {
		parent::__construct($config);
		$this->appSettings = JBusinessUtil::getApplicationSettings();
		$type = JFactory::getApplication()->input->get('filter_type');
		if ($type == OFFER_TYPE_PRODUCT && $this->_name == 'offers') {
			$this->_name = "products";
		}
		if ($type == OFFER_TYPE_PRODUCT && $this->_name == 'offerorders') {
			$this->_name = "productsorders";
		}
		$this->section_name = JText::_("LNG_" . strtoupper($this->_name));
		$this->section_description = JText::_("LNG_" . strtoupper($this->_name) . "_HEADER_DESCR");
	}

	/**
	 * Generate the main display for extension views
	 *
	 * @param unknown_type $tpl
	 */
	public function display($tpl = null) {
		$content = $this->loadTemplate($tpl);

		if ($content instanceof Exception) {
			return $content;
		}

		$input = JFactory::getApplication()->input;
		if ($input->get('hidemainmenu')) {
			echo $content;
			return;
		}

		$template = new stdClass();
		$template->content = $content;
		$template->menus = $this->generateMenu();
		$this->checkAccessRights($template->menus);
		$this->setActiveMenus($template->menus, $this->_name);

		//include the template and create the view
		$path = JPATH_ADMINISTRATOR . '/components/com_jbusinessdirectory/theme/template.php';
		$templateFileExists = JFile::exists($path);

		$templateContent = $content;

		if ($templateFileExists) {
			ob_start();

			// Include the requested template filename in the local scope
			// (this will execute the view logic).
			include $path;

			// Done with the requested template; get the buffer and
			// clear it.
			$templateContent = ob_get_contents();
			ob_end_clean();
		}

		echo $templateContent;
	}

	/**
	 * Check for selected menu and set it active
	 *
	 */
	private function setActiveMenus(&$menus, $view) {
		$app = JFactory::getApplication();
		$type="";
		if ($view=="categories") {
			$type = $app->getUserStateFromRequest('com_jbusinessdirectory.categories'.'.filter.type', 'filter_type', CATEGORY_TYPE_BUSINESS);
		}
		if ($view=="attributes") {
			$type = $app->getUserStateFromRequest('com_jbusinessdirectory.attributes'.'.filter.attribute_type', 'filter_attribute_type', ATTRIBUTE_TYPE_BUSINESS);
		}
		if ($view=="offers") {
			$type = $app->getUserStateFromRequest('com_jbusinessdirectory.offers'.'.filter.type', 'filter_type', OFFER_TYPE_OFFER);
		}

		if(!empty($menus)){
			foreach ($menus as &$menu) {
				if ($view == "offers" && $type == OFFER_TYPE_PRODUCT && $menu['view'] == 'products') {
					$menu["active"] = true;
					break;
				}
				if ($menu["view"] == $view) {
					$menu["active"] = true;
				}
				if (isset($menu["submenu"])) {
					foreach ($menu["submenu"] as &$submenu) {
						if ($view == "productsorders" && $submenu['view'] == 'productorders') {
							$menu["active"] = true;
							$submenu["active"] = true;
							break 2;
						}

						if ($view == "offerorders" && $submenu['view'] == 'offerorders') {
							$menu["active"] = true;
							$submenu["active"] = true;
							break 2;
						}

						if ($submenu["view"] == $view) {
							if (preg_match('/type=/', $submenu["link"])) {
								switch ($type) {
									case CATEGORY_TYPE_OFFER:
										$parent = 'offers';
										break;
									case CATEGORY_TYPE_EVENT:
										$parent = 'events';
										break;									
									case CATEGORY_TYPE_CONFERENCE:
										$parent = 'sessions';
										break;
									case CATEGORY_TYPE_VIDEO:
										$parent = 'videos';
										break;
									default:
										$parent = 'companies';
								}
								if ($menu["view"] == $parent) {
									$menu["active"] = true;
									$submenu["active"] = true;
								}
							} else {
								$submenu["active"] = true;
								$menu["active"] = true;
							}
						}
					}
				}
			}
		}
	}

	/**
	 * Check the access rights for the menu items
	 * @param unknown_type $menus
	 */
	private function checkAccessRights(&$menus) {
		$actions = JBusinessDirectoryHelper::getActions();

		foreach ($menus as $i => &$menu) {
			if (!$actions->get($menu["access"])) {
				unset($menus[$i]);
				continue;
			}
			if (isset($menu["submenu"])) {
				foreach ($menu["submenu"] as $j => $submenu) {
					if (!$actions->get($submenu["access"])) {
						unset($menu["submenu"][$j]);
						continue;
					}
				}
			}
		}

		return $menus;
	}
	
	/**
	 * Build the menu items with all subments
	 *
	 */
	private function generateMenu() {
		$menus = array();

		$menuItem  = array(
				"title" => JText::_('COM_JBUSINESS_DIRECTORY_SUBMENU_DASHBOARD'),
				"access"=> "directory.access.directory.management",
				"link" => "index.php?option=com_jbusinessdirectory&view=jbusinessdirectory",
				"view" => "jbusinessdirectory",
				"icon" => "la la-th-large");
		$menus[] = $menuItem;

		$menuItem  = array(
				"title" => JText::_('COM_JBUSINESS_DIRECTORY_SUBMENU_SETTINGS'),
				"access"=> "directory.access.directory.settings",
				"link" => "index.php?option=com_jbusinessdirectory&view=applicationsettings",
				"view" => "applicationsettings",
				"icon" => "la la-cog");
		$menus[] = $menuItem;

		if (JBusinessUtil::isAppInstalled(JBD_APP_ELASTIC_SEARCH)) {
			$menuItem  = array(
					"title" => JText::_('COM_JBUSINESS_DIRECTORY_SUBMENU_ELASTIC_SEARCH'),
					"access"=> "directory.access.directory.management",
					"link" => "index.php?option=com_jbusinessdirectory&view=elasticsearch",
					"view" => "elasticsearch",
					"icon" => "la la-sitemap");
			$menus[] = $menuItem;
		}

		$menuItem  = array(
				"title" => JText::_('COM_JBUSINESS_DIRECTORY_SUBMENU_COMPANIES'),
				"access"=> "directory.access.listings",
				"link" => "#",
				"view" => "companies",
				"icon" => "la la-building");

		$submenu = array();
		$smenuItem  = array(
				"title" => JText::_('COM_JBUSINESS_DIRECTORY_SUBMENU_LISTINGS'),
				"access"=> "directory.access.listings",
				"link" => "index.php?option=com_jbusinessdirectory&view=companies",
				"view" => "companies");
		$submenu[] = $smenuItem;

		$smenuItem  = array(
				"title" => JText::_('COM_JBUSINESS_DIRECTORY_SUBMENU_COMPANY_CATEGORIES'),
				"access"=> "directory.access.categories",
				"link" => "index.php?option=com_jbusinessdirectory&view=categories&filter_type=".CATEGORY_TYPE_BUSINESS,
				"view" => "categories",
				"icon" => "la la-certificate");
		$submenu[] = $smenuItem;

		$smenuItem  = array(
				"title" => JText::_('COM_JBUSINESS_DIRECTORY_SUBMENU_ATTRIBUTES'),
				"access"=> "directory.access.attributes",
				"link" => "index.php?option=com_jbusinessdirectory&view=attributes&filter_attribute_type=1",
				"view" => "attributes");
		$submenu[] = $smenuItem;

		$smenuItem  = array(
				"title" => JText::_('COM_JBUSINESS_DIRECTORY_SUBMENU_COMPANY_TYPES'),
				"access"=> "directory.access.listing.types",
				"link" => "index.php?option=com_jbusinessdirectory&view=companytypes",
				"view" => "companytypes");
		$submenu[] = $smenuItem;

		if ($this->appSettings->enable_price_list) {
			$smenuItem = array(
				"title" => JText::_('COM_JBUSINESS_DIRECTORY_SUBMENU_COMPANY_PRICE_LIST'),
				"access" => "directory.access.listing.pricelist",
				"link" => "index.php?option=com_jbusinessdirectory&view=companypricelists",
				"view" => "companypricelists");
			$submenu[] = $smenuItem;
		}

		if ($this->appSettings->enable_projects) {
			$smenuItem = array(
				"title" => JText::_('COM_JBUSINESS_DIRECTORY_SUBMENU_COMPANY_PROJECTS'),
				"access" => "directory.access.projects",
				"link" => "index.php?option=com_jbusinessdirectory&view=projects",
				"view" => "projects");
			$submenu[] = $smenuItem;
		}

		$smenuItem  = array(
			"title" => JText::_('COM_JBUSINESS_DIRECTORY_SUBMENU_MEMBERSHIP'),
			"access"=> "directory.access.memberships",
			"link" => "index.php?option=com_jbusinessdirectory&view=memberships",
			"view" => "memberships",
			"icon" => "la la-group");
		$submenu[] = $smenuItem;

		if ($this->appSettings->enable_announcements) {
			$smenuItem = array(
				"title" => JText::_('COM_JBUSINESS_DIRECTORY_SUBMENU_ANNOUNCEMENTS'),
				"access" => "directory.access.announcements",
				"link" => "index.php?option=com_jbusinessdirectory&view=announcements",
				"view" => "announcements",
				"icon" => "la la-bullhorn");
			$submenu[] = $smenuItem;
		}

		$menuItem["submenu"] = $submenu;
		$menus[] = $menuItem;

		
		if ($this->appSettings->enable_services==1 && file_exists(JPATH_ADMINISTRATOR.'/components/com_jbusinessdirectory/models/companyservice.php')) {
			$menuItem  = array(
				"title" => JText::_('COM_JBUSINESS_DIRECTORY_APPOINTMENTS'),
				"access"=> "directory.access.listing.services",
				"link" => "#",
				"view" => "companyservices",
				"icon" => "la la-list");

			$submenu = array();

			$smenuItem = array(
				"title" => JText::_('COM_JBUSINESS_DIRECTORY_SUBMENU_COMPANY_SERVICES'),
				"access" => "directory.access.listing.services",
				"link" => "index.php?option=com_jbusinessdirectory&view=companyservices",
				"view" => "companyservices");
			$submenu[] = $smenuItem;

			$smenuItem = array(
				"title" => JText::_('COM_JBUSINESS_DIRECTORY_SUBMENU_COMPANY_SERVICE_PROVIDERS'),
				"access" => "directory.access.listing.providers",
				"link" => "index.php?option=com_jbusinessdirectory&view=companyserviceproviders",
				"view" => "companyserviceproviders");
			$submenu[] = $smenuItem;

			$smenuItem = array(
				"title" => JText::_('COM_JBUSINESS_DIRECTORY_SUBMENU_COMPANY_SERVICE_RESERVATIONS'),
				"access" => "directory.access.listing.service.reservation",
				"link" => "index.php?option=com_jbusinessdirectory&view=companyservicereservations",
				"view" => "companyservicereservations");
			$submenu[] = $smenuItem;

			$smenuItem = array(
				"title" => JText::_('COM_JBUSINESS_DIRECTORY_SUBMENU_BOOKINGS_CALENDAR'),
				"access" => "directory.access.listing.service.reservation",
				"link" => "index.php?option=com_jbusinessdirectory&view=bookingscalendar",
				"view" => "bookingscalendar");
			$submenu[] = $smenuItem;
			
			$menuItem["submenu"] = $submenu;
			$menus[] = $menuItem;
		}
		
		$menuItem  = array(
			"title" => JText::_('COM_JBUSINESS_DIRECTORY_SUBMENU_OFFERS'),
			"access"=> "directory.access.offers",
			"link" => "#",
			"view" => "offers",
			"icon" => "la la-archive");

		$submenu = array();
		$smenuItem  = array(
				"title" => JText::_('COM_JBUSINESS_DIRECTORY_SUBMENU_OFFERS_ITEMS'),
				"access"=> "directory.access.offers",
				"link" => "index.php?option=com_jbusinessdirectory&view=offers&filter_type=".OFFER_TYPE_OFFER,
				"view" => "offers",
				"icon" => "la la-certificate");
		$submenu[] = $smenuItem;

		
		$smenuItem  = array(
				"title" => JText::_('COM_JBUSINESS_DIRECTORY_SUBMENU_OFFER_CATEGORIES'),
				"access"=> "directory.access.categories",
				"link" => "index.php?option=com_jbusinessdirectory&view=categories&filter_type=".CATEGORY_TYPE_OFFER,
				"view" => "categories",
				"icon" => "la la-certificate");
		$submenu[] = $smenuItem;

		if ($this->appSettings->enable_offer_selling==1 && file_exists(JPATH_ADMINISTRATOR.'/components/com_jbusinessdirectory/models/offerorder.php')) {
			$smenuItem = array(
				"title" => JText::_('COM_JBUSINESS_DIRECTORY_SUBMENU_OFFER_ORDERS'),
				"access" => "directory.access.offer.orders",
				"link" => "index.php?option=com_jbusinessdirectory&view=offerorders&filter_type=".OFFER_TYPE_OFFER,
				"view" => "offerorders",
				"icon" => "la la-certificate");
			$submenu[] = $smenuItem;
		}

		if (file_exists(JPATH_ADMINISTRATOR.'/components/com_jbusinessdirectory/models/shippingmethod.php') && $this->appSettings->enable_shipping) {
			$smenuItem = array(
				"title"  => JText::_('COM_JBUSINESS_DIRECTORY_SUBMENU_SHIPPING_METHODS'),
				"access" => "directory.access.shipping.methods",
				"link"   => "index.php?option=com_jbusinessdirectory&view=shippingmethods",
				"view"   => "shippingmethods",
				"icon"   => "la la-ship");
			$submenu[]  = $smenuItem;
		}

		$smenuItem  = array(
			"title" => JText::_('COM_JBUSINESS_DIRECTORY_SUBMENU_ATTRIBUTES'),
			"access"=> "directory.access.attributes",
			"link" => "index.php?option=com_jbusinessdirectory&view=attributes&filter_attribute_type=2",
			"view" => "attributes");
		$submenu[] = $smenuItem;

		$smenuItem  = array(
			"title" => JText::_('COM_JBUSINESS_DIRECTORY_SUBMENU_OFFERCOUPONS'),
			"access"=> "directory.access.offercoupons",
			"link" => "index.php?option=com_jbusinessdirectory&view=offercoupons",
			"view" => "offercoupons",
			"icon" => "la la-ticket");
		$submenu[] = $smenuItem;

		$smenuItem  = array(
			"title" => JText::_('COM_JBUSINESS_DIRECTORY_SUBMENU_OFFER_TYPES'),
			"access"=> "directory.access.offer.types",
			"link" => "index.php?option=com_jbusinessdirectory&view=offertypes",
			"view" => "offertypes",
			"icon" => "la la-cog");
		$submenu[] = $smenuItem;

		$menuItem["submenu"] = $submenu;
		$menus[] = $menuItem;
		
		$menuItem  = array(
				"title" => JText::_('COM_JBUSINESS_DIRECTORY_SUBMENU_EVENTS'),
				"access"=> "directory.access.events",
				"link" => "#",
				"view" => "events",
				"icon" => "la la-calendar");

		$submenu = array();
		$smenuItem  = array(
				"title" => JText::_('COM_JBUSINESS_DIRECTORY_SUBMENU_EVENTS_ITEMS'),
				"access"=> "directory.access.events",
				"link" => "index.php?option=com_jbusinessdirectory&view=events",
				"view" => "events",
				"icon" => "la la-cog");
		$submenu[] = $smenuItem;

		$smenuItem  = array(
				"title" => JText::_('COM_JBUSINESS_DIRECTORY_SUBMENU_EVENT_CATEGORIES'),
				"access"=> "directory.access.categories",
				"link" => "index.php?option=com_jbusinessdirectory&view=categories&filter_type=".CATEGORY_TYPE_EVENT,
				"view" => "categories",
				"icon" => "la la-certificate");
		$submenu[] = $smenuItem;

		if ($this->appSettings->enable_event_reservation && file_exists(JPATH_ADMINISTRATOR.'/components/com_jbusinessdirectory/models/eventticket.php')) {
			$smenuItem = array(
				"title" => JText::_('COM_JBUSINESS_DIRECTORY_SUBMENU_EVENT_TICKETS'),
				"access" => "directory.access.event.tickets",
				"link" => "index.php?option=com_jbusinessdirectory&view=eventtickets&filter_event_id=0",
				"view" => "eventtickets");
			$submenu[] = $smenuItem;

			$smenuItem = array(
				"title" => JText::_('COM_JBUSINESS_DIRECTORY_SUBMENU_EVENT_RESERVATIONS'),
				"access" => "directory.access.event.reservation",
				"link" => "index.php?option=com_jbusinessdirectory&view=eventreservations&filter_event_id=0",
				"view" => "eventreservations");
			$submenu[] = $smenuItem;
		}

		if ($this->appSettings->enable_event_appointments && file_exists(JPATH_ADMINISTRATOR.'/components/com_jbusinessdirectory/models/eventappointment.php')) {
			$smenuItem = array(
				"title" => JText::_('COM_JBUSINESS_DIRECTORY_SUBMENU_EVENT_APPOINTMENTS'),
				"access" => "directory.access.event.appointments",
				"link" => "index.php?option=com_jbusinessdirectory&view=eventappointments&filter_event_id=0",
				"view" => "eventappointments");
			$submenu[] = $smenuItem;
		}

		$smenuItem  = array(
			"title" => JText::_('COM_JBUSINESS_DIRECTORY_SUBMENU_ATTRIBUTES'),
			"access"=> "directory.access.attributes",
			"link" => "index.php?option=com_jbusinessdirectory&view=attributes&filter_attribute_type=3",
			"view" => "attributes");
		$submenu[] = $smenuItem;

		$smenuItem  = array(
				"title" => JText::_('COM_JBUSINESS_DIRECTORY_SUBMENU_EVENT_TYPES'),
				"access"=> "directory.access.event.types",
				"link" => "index.php?option=com_jbusinessdirectory&view=eventtypes",
				"view" => "eventtypes",
				"icon" => "la la-cog");
		$submenu[] = $smenuItem;

		$menuItem["submenu"] = $submenu;
		$menus[] = $menuItem;
			
		if (JBusinessUtil::isAppInstalled(JBD_APP_QUOTE_REQUESTS) && $this->appSettings->enable_request_quote_app) {
			$menuItem = array(
				"title" => JText::_('COM_JBUSINESS_DIRECTORY_SUBMENU_REQUEST_QUOTES'),
				"access" => "directory.access.request.quote",
				"link" => "#",
				"view" => "requestquotequestions",
				"icon" => "la la-envelope-square");
			$submenu = array();

			$smenuItem = array(
				"title" => JText::_('COM_JBUSINESS_DIRECTORY_SUBMENU_REQUEST_QUOTES'),
				"access" => "directory.access.request.quote",
				"link" => "index.php?option=com_jbusinessdirectory&view=requestquotes",
				"view" => "requestquotes",
				"icon" => "la la-envelope-square");
			$submenu[] = $smenuItem;
			$menuItem["submenu"] = $submenu;

			$smenuItem = array(
				"title" => JText::_('COM_JBUSINESS_DIRECTORY_SUBMENU_REQUEST_QUOTE_QUESTIONS'),
				"access" => "directory.access.request.quote.questions",
				"link" => "index.php?option=com_jbusinessdirectory&view=requestquotequestions",
				"view" => "requestquotequestions",
				"icon" => "la la-envelope-square");
			$submenu[] = $smenuItem;
			$menuItem["submenu"] = $submenu;
			$menus[] = $menuItem;
		}
		
		if (JBusinessUtil::isAppInstalled(JBD_APP_TRIPS)) {
			$menuItem  = array(
				"title" => JText::_('COM_JBUSINESS_DIRECTORY_SUBMENU_TRIPS'),
				"access"=> "directory.access.trips",
				"link" => "#",
				"view" => "trips",
				"icon" => "la la-bus");
			$submenu = array();
			$smenuItem = array(
				"title" => JText::_('COM_JBUSINESS_DIRECTORY_SUBMENU_TRIPS'),
				"access" => "directory.access.trips",
				"link" => "index.php?option=com_jbusinessdirectory&view=trips",
				"view" => "trips");
			$submenu[] = $smenuItem;
			
			$smenuItem = array(
				"title" => JText::_('COM_JBUSINESS_DIRECTORY_SUBMENU_TRIP_BOOKINGS'),
				"access" => "directory.access.trips",
				"link" => "index.php?option=com_jbusinessdirectory&view=tripbookings",
				"view" => "tripbookings");
			$submenu[] = $smenuItem;
			$menuItem["submenu"] = $submenu;
			$menus[] = $menuItem;
		}

		$menuItem = array(
			"title" => JText::_('COM_JBUSINESS_DIRECTORY_SUBMENU_MESSAGES'),
			"access" => "directory.access.messages",
			"link" => "index.php?option=com_jbusinessdirectory&view=messages",
			"icon" => "la la-comments",
			"view" => "messages",
			"display-unread-message" => true);
		$menus[] = $menuItem;
		
		/*
		$menuItem  = array(
			"title" => JText::_('COM_JBUSINESS_DIRECTORY_SUBMENU_PRODUCTS'),
			"access"=> "directory.access.products",
			"link" => "index.php?option=com_jbusinessdirectory&view=offers&filter_type=".OFFER_TYPE_PRODUCT,
			"view" => "products",
			"icon" => "la la-gift");

		$submenu = array();
		$smenuItem  = array(
			"title" => JText::_('COM_JBUSINESS_DIRECTORY_SUBMENU_PRODUCTS'),
			"access"=> "directory.access.products",
			"link" => "index.php?option=com_jbusinessdirectory&view=offers&filter_type=".OFFER_TYPE_PRODUCT,
			"view" => "products",
			"icon" => "la la-gift");
		$submenu[] = $smenuItem;

		$smenuItem = array(
			"title" => JText::_('COM_JBUSINESS_DIRECTORY_SUBMENU_PRODUCT_ORDERS'),
			"access" => "directory.access.products",
			"link" => "index.php?option=com_jbusinessdirectory&view=offerorders&filter_type=".OFFER_TYPE_PRODUCT,
			"view" => "productorders",
			"icon" => "la la-certificate");
		$submenu[] = $smenuItem;

		$menuItem["submenu"] = $submenu;
		$menus[] = $menuItem;
		*/
		
		$menuItem  = array(
				"title" => JText::_('COM_JBUSINESS_DIRECTORY_SUBMENU_PACKAGES'),
				"access"=> "directory.access.packages",
				"link" => "index.php?option=com_jbusinessdirectory&view=packages",
				"view" => "packages",
				"icon" => "la la-database");
		$menus[] = $menuItem;

		$menuItem  = array(
				"title" => JText::_('COM_JBUSINESS_DIRECTORY_SUBMENU_DISCOUNTS'),
				"access"=> "directory.access.discounts",
				"link" => "index.php?option=com_jbusinessdirectory&view=discounts",
				"view" => "discounts",
				"icon" => "la la-ticket");
		$menus[] = $menuItem;

		$menuItem  = array(
				"title" => JText::_('COM_JBUSINESS_DIRECTORY_SUBMENU_ORDERS'),
				"access"=> "directory.access.orders",
				"link" => "index.php?option=com_jbusinessdirectory&view=orders",
				"view" => "orders",
				"icon" => "la la-shopping-cart");
		$menus[] = $menuItem;	

		// $menuItem = array(
		// 	"title" => JText::_('COM_JBUSINESS_DIRECTORY_SUBMENU_VIDEOS'),
		// 	"access" => "directory.access.videos",
		// 	"link" => "#",
		// 	"view" => "videos",
		// 	"icon" => "la la-film");

		// $submenu = array();
		// $smenuItem = array(
		// 	"title" => JText::_('COM_JBUSINESS_DIRECTORY_SUBMENU_VIDEOS'),
		// 	"access" => "directory.access.videos",
		// 	"link" => "index.php?option=com_jbusinessdirectory&view=videos",
		// 	"view" => "videos",
		// 	"icon" => "la la-film");
		// $submenu[] = $smenuItem;

		// $smenuItem  = array(
		// 	"title" => JText::_('COM_JBUSINESS_DIRECTORY_SUBMENU_ATTRIBUTES'),
		// 	"access"=> "directory.access.attributes",
		// 	"link" => "index.php?option=com_jbusinessdirectory&view=attributes&filter_attribute_type=4",
		// 	"view" => "attributes");
		// $submenu[] = $smenuItem;

		// $smenuItem  = array(
		// 	"title" => JText::_('COM_JBUSINESS_DIRECTORY_SUBMENU_CATEGORIES'),
		// 	"access"=> "directory.access.categories",
		// 	"link" => "index.php?option=com_jbusinessdirectory&view=categories&filter_type=".CATEGORY_TYPE_VIDEO,
		// 	"view" => "categories",
		// 	"icon" => "la la-certificate");
		// $submenu[] = $smenuItem;

		// $menuItem["submenu"] = $submenu;
		// $menus[] = $menuItem;

		$menuItem  = array(
				"title" => JText::_('COM_JBUSINESS_DIRECTORY_SUBMENU_TAXES'),
				"access"=> "directory.access.taxes",
				"link" => "index.php?option=com_jbusinessdirectory&view=taxes",
				"view" => "taxes",
				"icon" => "la la-pencil");
		$menus[] = $menuItem;

		$menuItem  = array(
				"title" => JText::_('COM_JBUSINESS_DIRECTORY_SUBMENU_PAYMENT_PROCESSORS'),
				"access"=> "directory.access.payment.config",
				"link" => "index.php?option=com_jbusinessdirectory&view=paymentprocessors",
				"view" => "paymentprocessors",
				"icon" => "la la-money");
		$menus[] = $menuItem;

		$menuItem = array(
			"title" => JText::_('COM_JBUSINESS_DIRECTORY_SUBMENU_CURRENCIES'),
			"access" => "directory.access.currencies",
			"link" => "index.php?option=com_jbusinessdirectory&view=currencies",
			"view" => "currencies",
			"icon" => "la la-google-wallet");
		$menus[] = $menuItem;

		$menuItem  = array(
				"title" => JText::_('COM_JBUSINESS_DIRECTORY_SUBMENU_COUNTRIES'),
				"access"=> "directory.access.countries",
				"link" => "index.php?option=com_jbusinessdirectory&view=countries",
				"view" => "countries",
				"icon" => "la la-globe");
		$menus[] = $menuItem;
		
		if ($this->appSettings->limit_cities_regions == 1) {
			$menuItem  = array(
					"title" => JText::_('LNG_CITIES'),
					"access"=> "directory.access.cities",
					"link" => "index.php?option=com_jbusinessdirectory&view=cities",
					"view" => "cities",
					"icon" => "la la-cog");
			$menus[] = $menuItem;
		}

		if ($this->appSettings->limit_cities_regions == 1) {
			$menuItem  = array(
				"title" => JText::_('LNG_REGIONS'),
				"access"=> "directory.access.regions",
				"link" => "index.php?option=com_jbusinessdirectory&view=regions",
				"view" => "regions",
				"icon" => "la la-cog");
			$menus[] = $menuItem;
		}

		if ($this->appSettings->enable_reviews) {
			$menuItem = array(
				"title" => JText::_('COM_JBUSINESS_DIRECTORY_SUBMENU_REVIEW_AND_RATING'),
				"access" => "directory.access.reviews",
				"link" => "#",
				"view" => "ratings",
				"icon" => "la la-comment");

			$submenu = array();
			$smenuItem = array(
				"title" => JText::_('COM_JBUSINESS_DIRECTORY_SUBMENU_RATING'),
				"access" => "directory.access.reviews",
				"link" => "index.php?option=com_jbusinessdirectory&view=ratings",
				"view" => "ratings",
				"icon" => "la la-cog");
			//$submenu[] = $smenuItem;

			$smenuItem = array(
				"title" => JText::_('COM_JBUSINESS_DIRECTORY_SUBMENU_REVIEW'),
				"access" => "directory.access.reviews",
				"link" => "index.php?option=com_jbusinessdirectory&view=reviews",
				"view" => "reviews",
				"icon" => "la la-cog");
			$submenu[] = $smenuItem;

			$smenuItem = array(
				"title" => JText::_('COM_JBUSINESS_DIRECTORY_SUBMENU_REVIEW_QUESTIONS'),
				"access" => "directory.access.review.questions",
				"link" => "index.php?option=com_jbusinessdirectory&view=reviewquestions",
				"view" => "reviewquestions",
				"icon" => "la la-cog");
			$submenu[] = $smenuItem;

			$smenuItem = array(
				"title" => JText::_('COM_JBUSINESS_DIRECTORY_SUBMENU_REVIEW_CRITERIAS'),
				"access" => "directory.access.review.criterias",
				"link" => "index.php?option=com_jbusinessdirectory&view=reviewcriterias",
				"view" => "reviewcriterias",
				"icon" => "la la-cog");
			$submenu[] = $smenuItem;

			$smenuItem = array(
				"title" => JText::_('COM_JBUSINESS_DIRECTORY_SUBMENU_REVIEW_RESPONSE'),
				"access" => "directory.access.review.response",
				"link" => "index.php?option=com_jbusinessdirectory&view=reviewresponses",
				"view" => "reviewresponses",
				"icon" => "la la-cog");
			$submenu[] = $smenuItem;

			$smenuItem = array(
				"title" => JText::_('COM_JBUSINESS_DIRECTORY_SUBMENU_REVIEW_ABUSE'),
				"access" => "directory.access.review.abuse",
				"link" => "index.php?option=com_jbusinessdirectory&view=reviewabuses",
				"view" => "reviewabuses",
				"icon" => "la la-cog");
			$submenu[] = $smenuItem;
			$menuItem["submenu"] = $submenu;
			$menus[] = $menuItem;
		}
		
		$menuItem  = array(
		  "title" => JText::_('COM_JBUSINESS_DIRECTORY_SUBMENU_MARKETING'),
		  "access"=> "directory.access.marketing",
		  "link" => "index.php?option=com_jbusinessdirectory&view=marketing",
		  "view" => "marketing",
		  "icon" => "la la-inbox");
		$menus[] = $menuItem;

		$menuItem  = array(
			"title" => JText::_('COM_JBUSINESS_DIRECTORY_SUBMENU_REPORTS'),
			"access"=> "directory.access.reports",
			"link" => "#",
			"view" => "reports",
			"icon" => "la la-bar-chart");

		$submenu = array();
		$smenuItem  = array(
			"title" => JText::_('COM_JBUSINESS_DIRECTORY_SUBMENU_REPORTS_LISTINGS'),
			"access"=> "directory.access.reports",
			"link" => "index.php?option=com_jbusinessdirectory&view=reports",
			"view" => "reports",
			"icon" => "la la-chart-bar");
		$submenu[] = $smenuItem;

		$smenuItem  = array(
			"title" => JText::_('COM_JBUSINESS_DIRECTORY_SUBMENU_REPORTS_PAYMENTS'),
			"access"=> "directory.access.reports",
			"link" => "index.php?option=com_jbusinessdirectory&view=paymentreports",
			"view" => "paymentreports",
			"icon" => "la la-chart-bar");
		$submenu[] = $smenuItem;
		$menuItem["submenu"] = $submenu;
		$menus[] = $menuItem;

		$menuItem  = array(
			"title" => JText::_('COM_JBUSINESS_DIRECTORY_SUBMENU_STATISTICS'),
			"access"=> "directory.access.statistics",
			"link" => "index.php?option=com_jbusinessdirectory&view=statistics",
			"view" => "statistics",
			"icon" => "la la-pie-chart"); 
		$menus[] = $menuItem;

		$menuItem  = array(
			"title" => JText::_('COM_JBUSINESS_DIRECTORY_SUBMENU_SEARCH_LOGS'),
			"access"=> "directory.access.search.logs",
			"link" => "index.php?option=com_jbusinessdirectory&view=searchlogs",
			"view" => "searchlogs",
			"icon" => "la la-file");
		$menus[] = $menuItem;

		$menuItem  = array(
				"title" => JText::_('COM_JBUSINESS_DIRECTORY_SUBMENU_EMAILS_TEMPLATES'),
				"access"=> "directory.access.emails",
				"link" => "index.php?option=com_jbusinessdirectory&view=emailtemplates",
				"view" => "emailtemplates",
				"icon" => "la la-envelope");
		$menus[] = $menuItem;

		if (JBusinessUtil::isAppInstalled(JBD_APP_CAMPAIGNS)) {
			if ($this->appSettings->enable_campaigns) {
				$menuItem = array(
					"title" => JText::_('COM_JBUSINESS_DIRECTORY_SUBMENU_CAMPAIGNS'),
					"access" => "directory.access.campaigns",
					"link" => "#",
					"view" => "campaigns",
					"icon" => "la la-envelope");

				$submenu = array();
				$smenuItem = array(
					"title" => JText::_('COM_JBUSINESS_DIRECTORY_SUBMENU_CAMPAIGNS'),
					"access" => "directory.access.campaigns",
					"link" => "index.php?option=com_jbusinessdirectory&view=campaigns",
					"view" => "campaigns",
					"icon" => "la la-envelope");
				$submenu[] = $smenuItem;

				$smenuItem = array(
					"title" => JText::_('COM_JBUSINESS_DIRECTORY_SUBMENU_CAMPAIGN_PLANS'),
					"access" => "directory.access.campaign.plans",
					"link" => "index.php?option=com_jbusinessdirectory&view=campaignplans",
					"view" => "campaignplans",
					"icon" => "la la-envelope");
				$submenu[] = $smenuItem;

				$menuItem["submenu"] = $submenu;
				$menus[] = $menuItem;
			}
		}

		if (file_exists(JPATH_SITE.'/plugins/content/business/business.php')) {
			if ($this->appSettings->enable_articles) {
				$menuItem = array(
					"title" => JText::_('COM_JBUSINESS_DIRECTORY_SUBMENU_COMPANY_ARTICLES'),
					"access" => "directory.access.articles",
					"link" => "index.php?option=com_jbusinessdirectory&view=companyarticles",
					"icon" => "la la-newspaper-o",
					"view" => "companyarticles");
				$menus[] = $menuItem;
			}
		}

		if ($this->appSettings->enable_linked_listings) {
			$menuItem  = array(
				"title" => JText::_('COM_JBUSINESS_DIRECTORY_SUBMENU_LISTING_REGISTERED'),
				"access"=> "directory.access.listing.registrations",
				"link" => "index.php?option=com_jbusinessdirectory&view=listingregistrations",
				"view" => "listingregistrations",
				"icon" => "la la-user");
			$menus[] = $menuItem;
		}

		if (file_exists(JPATH_ADMINISTRATOR.'/components/com_jbusinessdirectory/models/conference.php')) {
			$menuItem  = array(
					"title" => JText::_('COM_JBUSINESS_DIRECTORY_SUBMENU_CONFERENCES'),
					"access"=> "directory.access.conferences",
					"link" => "index.php?option=com_jbusinessdirectory&view=conferences",
					"view" => "conferences",
					"icon" => "la la-graduation-cap");
			$menus[] = $menuItem;

			$menuItem  = array(
					"title" => JText::_('COM_JBUSINESS_DIRECTORY_SUBMENU_SPEAKERS'),
					"access"=> "directory.access.speakers",
					"link" => "#",
					"view" => "speakers",
					"icon" => "la la-user");

			$submenu = array();
			$smenuItem  = array(
					"title" => JText::_('COM_JBUSINESS_DIRECTORY_SUBMENU_SPEAKERS'),
					"access"=> "directory.access.speakers",
					"link" => "index.php?option=com_jbusinessdirectory&view=speakers",
					"view" => "speakers",
					"icon" => "la la-cog");
			$submenu[] = $smenuItem;

			$smenuItem  = array(
					"title" => JText::_('COM_JBUSINESS_DIRECTORY_SUBMENU_SPEAKER_TYPES'),
					"access"=> "directory.access.speaker.types",
					"link" => "index.php?option=com_jbusinessdirectory&view=speakertypes",
					"view" => "speakertypes",
					"icon" => "la la-cog");
			$submenu[] = $smenuItem;
			$menuItem["submenu"] = $submenu;
			$menus[] = $menuItem;

			$menuItem  = array(
					"title" => JText::_('COM_JBUSINESS_DIRECTORY_SUBMENU_SESSIONS'),
					"access"=> "directory.access.sessions",
					"link" => "#",
					"view" => "sessions",
					"icon" => "la la-language");

			$submenu = array();
			$smenuItem  = array(
					"title" => JText::_('COM_JBUSINESS_DIRECTORY_SUBMENU_SESSIONS'),
					"access"=> "directory.access.sessions",
					"link" => "index.php?option=com_jbusinessdirectory&view=sessions",
					"view" => "sessions",
					"icon" => "la la-cog");
			$submenu[] = $smenuItem;

			$smenuItem  = array(
				"title" => JText::_('COM_JBUSINESS_DIRECTORY_SUBMENU_SESSION_CATEGORIES'),
				"access"=> "directory.access.categories",
				"link" => "index.php?option=com_jbusinessdirectory&view=categories&filter_type=".CATEGORY_TYPE_CONFERENCE,
				"view" => "categories",
				"icon" => "la la-certificate");
			$submenu[] = $smenuItem;

			$smenuItem  = array(
					"title" => JText::_('COM_JBUSINESS_DIRECTORY_SUBMENU_SESSION_TYPES'),
					"access"=> "directory.access.session.types",
					"link" => "index.php?option=com_jbusinessdirectory&view=sessiontypes",
					"view" => "sessiontypes",
					"icon" => "la la-cog");
			$submenu[] = $smenuItem;

			$smenuItem  = array(
					"title" => JText::_('COM_JBUSINESS_DIRECTORY_SUBMENU_SESSION_LOCATIONS'),
					"access"=> "directory.access.session.locations",
					"link" => "index.php?option=com_jbusinessdirectory&view=sessionlocations",
					"view" => "sessionlocations",
					"icon" => "la la-cog");
			$submenu[] = $smenuItem;

			$smenuItem  = array(
					"title" => JText::_('COM_JBUSINESS_DIRECTORY_SUBMENU_SESSION_LEVELS'),
					"access"=> "directory.access.session.levels",
					"link" => "index.php?option=com_jbusinessdirectory&view=sessionlevels",
					"view" => "sessionlevels",
					"icon" => "la la-cog");
			$submenu[] = $smenuItem;
			$menuItem["submenu"] = $submenu;
			$menus[] = $menuItem;
		}
		
		$menuItem  = array(
				"title" => JText::_('COM_JBUSINESS_DIRECTORY_SUBMENU_UPDATE'),
				"access"=> "directory.access.directory.management",
				"link" => "index.php?option=com_jbusinessdirectory&view=updates",
				"view" => "updates",
				"icon" => "la la-download");
		$menus[] = $menuItem;

		return $menus;
	}

	public function setSectionDetails($name, $description) {
		$this->section_name = $name;
		$this->section_description = $description;
	}
}
