<?php
/**
 * @package     JBusinessDirectory
 * @subpackage  com_jbusinessdirectory
 *
 * @copyright   Copyright (C) 2007 - 2015 CMS Junkie. All rights reserved.
 * @license     GNU General Public License version 2 or later;
 */

defined('_JEXEC') or die('Restricted access');


require_once HELPERS_PATH.'/helper.php';

/**
 * The HTML Menus Menu Menus View.
 *
 * @package     JBusinessDirectory
 * @subpackage  com_jbusinessdirectory
 */
class JBusinessDirectoryViewEvents extends JBusinessDirectoryAdminView {
	protected $items;
	protected $pagination;
	protected $state;

	/**
	 * Display the view
	 */
	public function display($tpl = null) {
		$this->items		= $this->get('Items');
		$this->pagination	= $this->get('Pagination');
		$this->state		= $this->get('State');

		$this->filterForm    = $this->get('FilterForm');
		$this->activeFilters = $this->get('ActiveFilters');

		$this->statuses		= $this->get('Statuses');
		$this->states		= $this->get('States');
		
		JBusinessDirectoryHelper::addSubmenu('events');

		// Check for errors.
		if (count($errors = $this->get('Errors'))) {
			JFactory::getApplication()->enqueueMessage(implode("\n", $errors), 'error');
			return false;
		}

		$this->addToolbar();
		parent::display($tpl);
	}

	/**
	 * Add the page title and toolbar.
	 *
	 * @since   1.6
	 */
	protected function addToolbar() {
		$canDo = JBusinessDirectoryHelper::getActions();
		$bar = JToolBar::getInstance('toolbar');

		JToolBarHelper::title('J-BusinessDirectory : '.JText::_('LNG_EVENTS'), 'generic.png');
		
		if ($canDo->get('core.create')) {
			JToolbarHelper::addNew('event.add');
		}
		
		if (($canDo->get('core.edit'))) {
			JToolbarHelper::editList('event.edit');
		}

		if ($canDo->get('core.create')) {
			$dhtml = '<button data-toggle="modal" onclick="jQuery( \'#collapseModal\' ).jbdModal({attachTo: \'adminForm\'});" class="btn btn-small">
			<i class="icon-checkbox-partial" title="'.JText::_('JTOOLBAR_BATCH').'"></i>'.JText::_('JTOOLBAR_BATCH').'</button>';
			$bar->appendButton('Custom', $dhtml, 'batch');
		}
		
		if ($canDo->get('core.delete')) {
			JToolbarHelper::divider();
			JToolbarHelper::deleteList('', 'events.delete');
		}

		JToolbarHelper::divider();

		$dhtml = '<button data-toggle="modal" onclick="jQuery( \'#import-model\' ).jbdModal({attachTo: \'adminForm\'}); " class="btn btn-small">
		<i class="icon-upload" title="'.JText::_('LNG_IMPORT_CSV').'"></i>'.JText::_('LNG_IMPORT_CSV').'</button>';
		$bar->appendButton('Custom', $dhtml, 'events.importFromCsv');

		$dhtml = '<button data-toggle="modal" onclick="jQuery( \'#export-model\' ).jbdModal({attachTo: \'adminForm\'});" class="btn btn-small">
		<i class="icon-download" title="'.JText::_('LNG_EXPORT_CSV').'"></i>'.JText::_('LNG_EXPORT_CSV').'</button>';
		$bar->appendButton('Custom', $dhtml, 'events.showExportCsv');

		if ($canDo->get('core.admin')) {
			JToolbarHelper::preferences('com_jbusinessdirectory');
		}
		
		JToolbarHelper::divider();
		JToolBarHelper::custom('events.back', 'dashboard', 'dashboard', JText::_("LNG_CONTROL_PANEL"), false, false);
		JToolBarHelper::help('', false, DOCUMENTATION_URL.'businessdiradmin.html#events');
	}
}
