<?php
/**
 * @package    JBusinessDirectory
 *
 * @author CMSJunkie http://www.cmsjunkie.com
 * @copyright  Copyright (C) 2007 - 2021 CMSJunkie. All rights reserved.
 * @license   https://www.gnu.org/licenses/agpl-3.0.en.html
 */ 
defined('_JEXEC') or die('Restricted access');
JHtml::addIncludePath(JPATH_COMPONENT.'/helpers/html');
JHtml::_('bootstrap.tooltip');
JHtml::_('behavior.multiselect');
 JBusinessUtil::initializeChosen();

use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Multilanguage;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Layout\LayoutHelper;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Session\Session;

$listOrder	= $this->escape($this->state->get('list.ordering'));
$listDirn	= $this->escape($this->state->get('list.direction'));
?>

<script type="text/javascript">
window.addEventListener('load', function() {
	Joomla.submitbutton = function(task) {
		if(task == 'events.delete') {
			//showDeleteDialog();
		}
		if (task != 'events.delete' || confirm('<?php echo JText::_('ARE_YOU_SURE_YOU_WANT_TO_DELETE', true);?>')) {
			Joomla.submitform(task);
		}
	}
});
	
</script>
<div id="jbd-container" class="jbd-container">
    <form action="<?php echo JRoute::_('index.php?option=com_jbusinessdirectory&view=events');?>" method="post" name="adminForm" id="adminForm">
        <div id="j-main-container" class="j-main-container">
            <?php
            // Search tools bar
            echo JLayoutHelper::render('joomla.searchtools.default', array('view' => $this, 'options' => array('filtersHidden' =>JBusinessUtil::setFilterVisibility($this->state))));
            ?>
        </div>
        <div class="clr clearfix"></div>
    
        <?php if (empty($this->items)) { ?>
            <div class="alert alert-warning">
                <?php echo Text::_('JGLOBAL_NO_MATCHING_RESULTS'); ?>
            </div>
        <?php } else { ?>

    	<table class="jtable" id="itemList">
    		<thead class="jtable-head">
    			<tr class="jtable-head-row">
                    <td class="jtable-head-row-data"></td>
    				<th class="jtable-head-row-data">
                        <div class="d-flex justify-content-center align-items-center">
                            <div class="jradio">
                                <input id="jradio-2" type="checkbox" title="<?php echo JText::_('JGLOBAL_CHECK_ALL');?>" onclick="Joomla.checkAll(this)" />
                                <label for="jradio-2"></label>
                            </div>
                        </div>
                    </th>
                    <th class="jtable-head-row-data">
                        <div class="d-flex justify-content-center align-items-center">
                            <span class="jtable-head-row-data-title"> # </span>
                        </div>
                    </th>

                    <th class="jtable-head-row-data"></th>
                    <th class="jtable-head-row-data"><?php echo HTMLHelper::_('searchtools.sort', 'LNG_NAME', 'co.name', $listDirn, $listOrder); ?></th>
                    <th class="jtable-head-row-data"><?php echo HTMLHelper::_('searchtools.sort', 'LNG_COMPANY', 'bc.name', $listDirn, $listOrder); ?></th>
                    <th class="jtable-head-row-data"><?php echo HTMLHelper::_('searchtools.sort', 'LNG_TYPE', 'co.type', $listDirn, $listOrder); ?></th>
                    <th class="jtable-head-row-data"><?php echo HTMLHelper::_('searchtools.sort', 'LNG_LOCATION', 'co.location', $listDirn, $listOrder); ?></th>
                    <th class="jtable-head-row-data text-center" width="10%"><?php echo HTMLHelper::_('searchtools.sort', 'LNG_DATES', 'co.start_date', $listDirn, $listOrder); ?></th>
                    <th class="jtable-head-row-data"><?php echo HTMLHelper::_('searchtools.sort', 'LNG_VIEW_NUMBER', 'co.view_count', $listDirn, $listOrder,"LNG_VIEWS"); ?></th>

                    <th class="jtable-head-row-data"><?php echo HTMLHelper::_('searchtools.sort', 'LNG_STATE', 'co.state', $listDirn, $listOrder); ?></th>
                    <th class="jtable-head-row-data"><?php echo HTMLHelper::_('searchtools.sort', 'LNG_APROVED', 'co.approved', $listDirn, $listOrder); ?></th>
                    <th class="jtable-head-row-data"><?php echo JText::_('LNG_STATUS') ?></th>

                    <th class="jtable-head-row-data"></th>

                    <th class="jtable-head-row-data"><?php echo HTMLHelper::_('searchtools.sort', 'LNG_ID', 'co.id', $listDirn, $listOrder); ?></th>
                </tr>
    		</thead>
    		<tfoot>
    			<tr>
    				<td colspan="15">
    					<?php echo $this->pagination->getListFooter(); ?>
    				</td>
    			</tr>
    		</tfoot>
    		<tbody class="jtable-body">
    			<?php $nrcrt = 1; $i=0;
    			foreach( $this->items as $event) { ?>
                    <tr class="jtable-body-row">
                        <td class="jtable-body-row-data">
                            <div class="d-flex align-items-center">
                                <?php
                                $bgClass = "bg-success";
                                if (($event->state == 1) && ($event->approved == 1)) {
                                    if ($event->expired || !$event->allow_events) {
                                        $bgClass = "bg-warning";
                                    }
                                } else {
                                    $bgClass = "bg-danger";
                                }

                                ?>

                                <div id="item-status-<?php echo $event->id?>" class="jtable-body-status <?php echo $bgClass ?>"></div>
                            </div>
                        </td>

                        <td class="jtable-body-row-data px-3">
		                    <?php echo HTMLHelper::_('jbdgrid.id', $i, $event->id); ?>
                        </td>

                        <td class="jtable-body-row-data"><?php echo $nrcrt++?></td>

                        <td class="jtable-body-row-data px-3">
	                        <?php echo HTMLHelper::_('jbdgrid.action', $i , "changeStateFeatured", 'event.',"",$event->featured == 1 ? "Featured":"Not featured","",true, $event->featured == 1 ? "la la-star" : "la la-star-o","", true); ?>
                        </td>

                        <td class="jtable-body-row-data jtable-body-name">
                            <div class="d-flex align-items-center">
                                <a href='<?php echo JRoute::_( 'index.php?option=com_jbusinessdirectory&task=event.edit&id='. $event->id ) ?>'>
		                            <?php if (!empty($event->picture_path)) { ?>
                                        <img src="<?php echo BD_PICTURES_PATH.$event->picture_path ?>" class="jtable-data-img" />
		                            <?php } else { ?>
                                        <img src="<?php echo BD_PICTURES_PATH.'/no_image.jpg' ?>" class="jtable-data-img" />
		                            <?php } ?>
                                </a>

                                <span class="ml-3 d-flex flex-column justify-content-center">
                                    <span class="jtable-body-row-data-title">
                                        <a href="<?php echo JRoute::_( 'index.php?option=com_jbusinessdirectory&task=event.edit&id='. $event->id ) ?>"
                                           title="<?php echo JText::_('LNG_CLICK_TO_EDIT'); ?>">
                                            <b><?php echo strip_tags($event->name) ?></b>
                                        </a><br/>
                                    </span>
                                    <span class="jtable-body-row-data-allias"><?php echo $event->alias ?></span>
                                </span>
                            </div>
                        </td>

                        <td class="jtable-body-row-data">
                            <?php echo $event->companyName ?>
                        </td>

                        <td class="jtable-body-row-data">
	                        <?php echo $event->eventType ?>
                        </td>

                        <td class="jtable-body-row-data">
	                        <?php echo $event->address.", ".$event->city ?>
                        </td>

                        <td class="jtable-body-row-data">
                            <div class="d-flex justify-content-center">
                                <div class="text-right pr-2">
                                        <span class="d-block jtable-body-text jtable-body-text-seconday">
                                            <?php
                                            if (!JBusinessUtil::emptyDate($event->start_date)) {
	                                            echo JText::_('LNG_FROM');
                                            } ?>
                                        </span>

                                    <span class="d-block jtable-body-text jtable-body-text-seconday">
                                        <?php
                                        if (!JBusinessUtil::emptyDate($event->end_date)) {
                                            echo JText::_('LNG_TO');
                                        } ?>
                                    </span>
                                </div>

                                <div class="text-right">
                                    <span class="d-block jtable-body-text"><?php echo JBusinessUtil::getDateGeneralShortFormat($event->start_date) ?></span>
                                    <span class="d-block jtable-body-text"><?php echo JBusinessUtil::getDateGeneralShortFormat($event->end_date) ?></span>
                                </div>
                            </div>
                        </td>

                        <td class="jtable-body-row-data pl-5">
	                        <?php echo $event->view_count ?>
                        </td>

                        <td class="jtable-body-row-data">
		                    <?php echo HTMLHelper::_('jbdgrid.published', $event->state, $i, 'events.', true, 'cb', true, true, $event->id); ?>
                        </td>

                        <td class="jtable-body-row-data">
		                    <?php
		                    $text   = "";
		                    $action = "";
		                    switch ($event->approved) {
			                    case EVENT_STATUS_NEEDS_APPROVAL:
				                    $text   = JText::_("LNG_NEEDS_APPROVAL");
				                    $action = "aprove";
				                    break;
			                    case EVENT_STATUS_DISAPPROVED:
				                    $text   = JText::_("LNG_DISAPPROVED");
				                    $action = "aprove";
				                    break;
			                    case EVENT_STATUS_APPROVED:
				                    $text   = JText::_("LNG_APPROVED");
				                    $action = "disaprove";
				                    break;
		                    }
		                    ?>
		                    <?php
                            echo HTMLHelper::_('jbdgrid.approve', $action, $event->approved == 1 ? 2 : 1, $i, 'event.', true, 'cb', true, true, $event->id); ?>
                        </td>

                        <td class="jtable-body-row-data">
		                    <?php if (($event->state == 1) && ($event->approved == 1)) {
			                    if ($event->expired)
				                    echo '<span class="status-badge badge-warning">' . JText::_("LNG_EXPIRED") . '</span>';
                                elseif (!$event->allow_events)
				                    echo '<span class="status-badge badge-warning warn">' . JText::_("LNG_NOT_INCLUDED") . '</span>';
			                    else
				                    echo '<span class="status-badge badge-success">' . JText::_("LNG_ACTIVE") . '</span>';
		                    }
		                    else {
			                    echo '<span class="status-badge badge-danger">' . JText::_("LNG_NOT_ACTIVE") . '</span>';
		                    } ?>
                        </td>

                        <td class="jtable-body-row-data">
                            <div class="row-fluid jbd-buttons-row">
                                <div class="d-flex align-items-center justify-content-center">
                                    <a title="<?php echo JText::_('LNG_CLICK_TO_VIEW'); ?>" href="<?php echo JBusinessUtil::getEventLink($event->id, $event->alias) ?>" class="jtable-btn" target="_blank">
                                        <i class="la la-eye"></i>
                                    </a>
                                </div>

                            </div>
                        </td>

                        <td class="jtable-body-row-data">
                            <span><?php echo (int) $event->id; ?></span>
                        </td>

                    </tr>

    			<?php
    				$i++;
    			} ?>
    		</tbody>
    		<tfoot>
    		<tr>
    			<td colspan="16">
    				<a href="#" id="open_legend_events">
    					<h5 class="right"><?php echo JText::_('LNG_STATUS_MESSAGES_LEGEND'); ?></h5>
    				</a>
    			</td>
    		</tr>
    		</tfoot>
    	</table>
        <?php } ?>
    
    	<!-- Modal -->
<div id="legend_events" class="jbd-container" style="display: none">    
    <div class="jmodal-sm">
        <div class="jmodal-header">
            <p class="jmodal-header-title"><?php echo JText::_('LNG_STATUS_MESSAGES_LEGEND') ?></p>
            <a href="#close-modal" rel="modal:close" class="close-btn"><i class="la la-close "></i></a>
        </div>
        <div class="jmodal-body">
		<div class="row-fluid">
			<div class="row-fluid">
				<div class="col-md-10">
					<dl class="dl-horizontal">
						<dt><span class="status-badge badge-success"><?php echo JText::_('LNG_ACTIVE'); ?></span></dt>
						<dd><?php echo JText::_('LNG_ACTIVE_LEGEND'); ?></dd>
						<dt><span class="status-badge badge-warning"><?php echo JText::_('LNG_EXPIRED'); ?></span></dt>
						<dd><?php echo JText::_('LNG_EXPIRED_LEGEND'); ?></dd>
						<dt><span class="status-badge badge-warning warn"><?php echo JText::_('LNG_NOT_INCLUDED'); ?></span></dt>
						<dd><?php echo JText::_('LNG_NOT_INCLUDED_LEGEND'); ?></dd>
						<dt><span class="status-badge badge-danger"><?php echo JText::_('LNG_NOT_ACTIVE'); ?></span></dt>
						<dd><?php echo JText::_('LNG_NOT_ACTIVE_LEGEND'); ?></dd>
					</dl>
				</div>
			</div>
		</div>           
    </div>
</div>

    	<input type="hidden" name="option"	value="<?php echo JBusinessUtil::getComponentName()?>" />
    	<input type="hidden" name="task" value="" /> 
    	<input type="hidden" name="companyId" value="" />
    	<input type="hidden" name="delete_mode" id="delete_mode" value="" />
    	<input type="hidden" name="boxchecked" value="0" />
    	<input type="hidden" id="clear_form" name="clear_form" value="" />

    	<?php echo JHTML::_('form.token'); ?>
    
    	<?php // Load the batch processing form. ?>
    	<?php echo $this->loadTemplate('batch'); ?>
    </form>
</div>

<?php echo $this->loadTemplate('export'); ?>
<?php echo $this->loadTemplate('import'); ?>
<div id="delete-event-dialog" class="jbd-container" style="display: none">    
    <div class="jmodal-sm">
        <div class="jmodal-header">
            <p class="jmodal-header-title"><?php echo JText::_('LNG_DELETE_RECURRING_EVENT') ?></p>
            <a href="#close-modal" rel="modal:close" class="close-btn"><i class="la la-close "></i></a>
        </div>
        <div class="jmodal-body">
			<p>
				<?php echo JText::_('LNG_DELETE_RECURRING_EVENT_INFO') ?>
			</p>
			<fieldset>
				<div>
					<button type="button" class="btn" onclick="deleteEvent()">
						<span class="ui-button-text"> <?php echo JText::_("LNG_DELETE_ONLY_THIS_EVENT")?></span>
					</button>
					<?php echo JText::_('LNG_DELETE_ONLY_THIS_EVENT_INFO') ?>
				</div>
				<div>
					<button type="button" class="btn" onclick="deleteAllFollowignEvents()">
						<span class="ui-button-text"> <?php echo JText::_("LNG_DELETE_ALL_FOLLOWINGS_EVENT")?></span>
					</button>
					<?php echo JText::_('LNG_DELETE_ALL_FOLLOWINGS_EVENT_INFO') ?>
				</div>
				<div>
					<button type="button" class="btn" onclick="deleteAllSeriesEvents()">
						<span class="ui-button-text"> <?php echo JText::_("LNG_DELETE_ALL_SERIES_EVENTS")?></span>
					</button>
					<?php echo JText::_('LNG_DELETE_ALL_SERIES_EVENTS_INFO') ?>
				</div>
				<div class="clearfix clear-left">
				<div class="button-row">
					<button type="button" class="btn btn-dark" onclick="jQuery.jbdModal.close()">
						<span class="ui-button-text"><i class="la la la-close"></i> <?php echo JText::_("LNG_CANCEL")?></span>
					</button>
				</div>
			</div>
			</fieldset>	
    </div>
</div>

<script>
	function showDeleteDialog() {
		jQuery('#delete-event-dialog').jbdModal();
	} 

	function deleteEvent() {
		jQuery("#delete_mode").val(1);
		Joomla.submitform('events.delete');
		jQuery.jbdModal.close();
	}

	function deleteAllFollowignEvents() {
		jQuery("#delete_mode").val(2);
		Joomla.submitform('events.delete');
		jQuery.jbdModal.close();
	}
	
	function deleteAllSeriesEvents() {
		jQuery("#delete_mode").val(3);
		Joomla.submitform('events.delete');
		jQuery.jbdModal.close();
	}

	window.addEventListener('load', function() {
		jQuery('#open_legend_events').click(function() {
			jQuery('#legend_events').jbdModal();
			!function(d,s,id){var js,fjs=d.getElementsByTagName(s)[0],p=/^http:/.test(d.location)?'http':'https';if(!d.getElementById(id)){js=d.createElement(s);js.id=id;js.src=p+'://platform.twitter.com/widgets.js';fjs.parentNode.insertBefore(js,fjs);}}(document, 'script', 'twitter-wjs');
		});

		jQuery(".js-stools-btn-clear").click(function(){
			jQuery("#clear_form").val(1);
		});
	});
</script>