<?php
/**
 * @package    JBusinessDirectory
 *
 * @author CMSJunkie http://www.cmsjunkie.com
 * @copyright  Copyright (C) 2007 - 2021 CMSJunkie. All rights reserved. 
 * @license   https://www.gnu.org/licenses/agpl-3.0.en.html
 */

defined('_JEXEC') or die('Restricted access');
if (file_exists(__DIR__.'/edit_recurring.php')) {
   require_once __DIR__.'/edit_recurring.php';
   return;
}

// Include the component HTML helpers.
JHtml::addIncludePath(JPATH_COMPONENT.'/helpers/html');
require_once BD_CLASSES_PATH.'/attributes/attributeservice.php';

JBusinessUtil::enqueueScript('libraries/bootstrap/bootstrap-tagsinput.min.js');
JBusinessUtil::enqueueStyle('libraries/bootstrap/bootstrap-tagsinput.css');

$maxPictures = isset($this->item->package)?$this->item->package->max_pictures:$this->appSettings->max_pictures;
$nrPictures = count($this->item->pictures);
$allowedNr = $maxPictures - $nrPictures;
$allowedNr=($allowedNr<0)?0:$allowedNr;
$allowedNr = ($allowedNr == 0)?$maxPictures:$allowedNr;
$isNew     = ($this->item->id == 0 && isset($isProfile)) ? true : false;

// Load the tooltip behavior.

JBusinessUtil::loadJQueryChosen();

$langTab = JBusinessUtil::getLanguageTag();
$langTab = str_replace("-","_", $langTab);

$attributeConfig = $this->item->defaultAtrributes;
$jbdTabs = new JBDTabs();
$mapKey  = JBusinessUtil::loadMapScripts(null, true);

$aliasStyle = (!$this->appSettings->show_alias && isset($isProfile))?"display:none":"";

$user = JBusinessUtil::getUser();
if(empty($this->item->id)){
    $this->item->id = 0;
}
$options = array(
		'onActive' => 'function(title, description){
		description.setStyle("display","block");
		title.addClass("open").removeClass("closed");
}',
		'onBackground' => 'function(title, description){
		description.setStyle("display","none");
		title.addClass("closed").removeClass("open");
}',
		'startOffset' => 0,  // 0 starts on the first tab, 1 starts the second, etc...
		'useCookie' => true, // this must not be a string. Don't use quotes.
);
?>

<script type="text/javascript">
    window.addEventListener('load', function() {
        Joomla.submitbutton = function(task) {	
        
            jQuery("#item-form").validationEngine('detach');
            var evt = document.createEvent("HTMLEvents");
            evt.initEvent("click", true, true);
            var tab = ("tab-"+jbdUtils.getProperty("defaultLang"));
            if(!(document.getElementsByClassName(tab)[0] === undefined || document.getElementsByClassName(tab)[0] === null))
                document.getElementsByClassName(tab)[0].dispatchEvent(evt);
            if (task == 'event.cancel' || task == 'event.aprove' || task == 'event.disaprove' || !jbdUtils.validateCmpForm(true, <?php echo $attributeConfig["description"] == ATTRIBUTE_MANDATORY?'true':'false' ?>, task, validatePictures)) {
                jbdEvents.saveDates();
                Joomla.submitform(task, document.getElementById('item-form'));
            }
            jQuery("#item-form").validationEngine('attach');
            
        }
    });
</script>

<div id="jbd-container" class="jbd-container jbd-edit-container">
    <?php  if(isset($isProfile)) { ?>
    	<div class="row py-2 mb-2">
    		<div class="col-md-12">
    			<div>
    				<div class="button-row">
                        <button id="save-btn" type="button" class="btn btn-success button-save" onclick="saveEventCompanyInformation('apply')">
                            <i class="la la-edit"></i> <?php echo JText::_("LNG_SAVE")?>
                        </button>
                        <button type="button" class="btn btn-success button-close" onclick="saveEventCompanyInformation('save');">
                            <span class="ui-button-text"><i class="la la-check"></i> <?php echo JText::_("LNG_SAVE_AND_CLOSE")?></span>
                        </button>
                        <?php if(!$isNew) {?>
                            <button type="button" class="btn btn-primary button-close" onclick="saveEventCompanyInformation('duplicate');">
                                    <span class="ui-button-text"><i class="icon-save-copy"></i> <?php echo JText::_("LNG_DUPLICATE")?></span>
                            </button>
                        <?php } ?>
    					<button type="button" class="btn btn-dark button-cancel" onclick="cancel()">
    						<i class="la la-close"></i> <?php echo JText::_("LNG_CANCEL")?>
    					</button>
    				</div>
    			</div>
    		</div>
    	</div>
    <?php  } ?>

    <form action="<?php echo JRoute::_('index.php?option=com_jbusinessdirectory&layout=edit&id='.(int) $this->item->id); ?>" method="post" name="adminForm" id="item-form" class="form-horizontal"  enctype="multipart/form-data">
        <div class="row">
            <div class="<?php echo isset($isProfile)?"col-12":"col-md-7"?>">

                <div class="row">
                    <div class="col-md-12">
                        <fieldset class="boxed">
                            <div class="row align-items-center">
                                <div class="col-md ">
                                    <strong><?php echo JText::_('LNG_HOSTED_BY')?> <?php echo !$this->appSettings->item_decouple?JBusinessUtil::showMandatory(ATTRIBUTE_MANDATORY):""; ?></strong>
                                </div>
                                <div class="col-md">
                                    <select data-placeholder="<?php echo JText::_("LNG_SELECT_OR_SEARCH_COMPANY") ?>" class="form-control input-medium ajax-chosen-select <?php echo !$this->appSettings->item_decouple?"validate[required]":""?>" name="company_id" id="company_id">
                                        <option value=""><?php echo JText::_("LNG_SELECT_OR_SEARCH_COMPANY")?></option>
	                                    <?php if (!empty($this->item->company_id))
		                                    echo JHtml::_('select.options', $this->item->companyOptions, 'id', 'name', $this->item->company_id);
	                                    ?>
	                                    <?php echo JHtml::_('select.options', $this->companyOptions, 'id', 'name', -1); ?>
                                    </select>
                                </div>
                            </div>
                        </fieldset>
                    </div>
                </div>
            
                <div class="row">
                	<div class="col-12">
                        <fieldset class="boxed" >
                        	<div class="row">
                        		<div class="col-lg">
                        			<h3> <?php echo JText::_('LNG_EVENT_DETAILS');?></h3>
                            		<p><?php echo JText::_('LNG_DISPLAY_INFO_TXT');?></p>		
                        		</div>
                        		<div class="col-lg-5 my-auto text-right">
                			        <fieldset id="state" class="radio btn-group btn-group-yesno">
                                        <input type="radio" class="validate[required]" name="state" id="state1" value="<?php echo 1 ?>" <?php echo $this->item->state==1? 'checked="checked"' :""?> />
                                        <label class="btn" id="label_state1" for="state1"><?php echo JTEXT::_("LNG_PUBLISHED")?></label>
                                        <input type="radio" class="validate[required]" name="state" id="state2" value="<?php echo 0 ?>"  <?php echo $this->item->state==0? 'checked="checked"' :""?> />
                                        <label class="btn" id="label_state2" for="state2"><?php echo JText::_('LNG_UNPUBLISHED')?></label>
                                    </fieldset>
                            	</div>
                        	</div>
                            <div class="form-container">
                                <div class="form-group">
                                    <label for="subject"><?php echo JText::_('LNG_NAME')?><?php echo JBusinessUtil::showMandatory(ATTRIBUTE_MANDATORY)?> </label>
                                    <?php
                                    $jbdTabs->setOptions($options);
                                    if($this->appSettings->enable_multilingual){
                                            echo $jbdTabs->startTabSet('tab_groupsd_id');
                                            foreach( $this->languages as $k=>$lng ){
                                                echo $jbdTabs->addTab('tab_groupsd_id', 'tab-'.$lng, $k);
                                                $langContent = isset($this->translations[$lng."_name"])?$this->translations[$lng."_name"]:"";
                                                if($lng == JBusinessUtil::getLanguageTag() && empty($langContent)){
                                                    $langContent = $this->item->name;
                                                }
                                                echo "<input type='text' name='name_$lng' id='name_$lng' class='input_txt form-control validate[required]' value=\"".stripslashes($this->escape($langContent))."\"  maxLength='110'>";
                                                echo $jbdTabs->endTab();
                                            }
                                            echo $jbdTabs->endTabSet();
                                        } else { ?>
                                            <input type="text" name="name" id="name" class="input_txt form-control validate[required]" value="<?php echo $this->escape($this->item->name) ?>"  maxLength="110">
                                        <?php } ?>
                                </div>
                                <div class="form-group" style="<?php echo $aliasStyle ?>">
                                    <label for="alias"><?php echo JText::_('LNG_ALIAS')?> </label>
                                    <input type="text"	name="alias" id="alias"  placeholder="<?php echo JText::_('LNG_AUTO_GENERATE_FROM_NAME')?>" class="input_txt form-control text-input" value="<?php echo $this->escape($this->item->alias) ?>"  maxLength="100">
                                </div>
    
                                <?php if($attributeConfig["short_description"]!=ATTRIBUTE_NOT_SHOW) { ?>
                                <div class="form-group">
                                    <label for="short_description"><?php echo JText::_('LNG_SHORT_DESCRIPTION')?> <?php echo JBusinessUtil::showMandatory($attributeConfig["short_description"])?>  </label>
                                    <?php
                                    $jbdTabs->setOptions($options);
                                        if($this->appSettings->enable_multilingual){
                                            echo $jbdTabs->startTabSet('tab_groupsd_id');
                                            foreach( $this->languages  as $k=>$lng ){
                                                echo $jbdTabs->addTab('tab_groupsd_id', 'tab-'.$lng, $k);
                                                $langContent = isset($this->translations[$lng."_short"])?$this->translations[$lng."_short"]:"";
                                                if($lng==JBusinessUtil::getLanguageTag() && empty($langContent)){
                                                    $langContent = $this->item->short_description;
                                                }
                                                $required = ($attributeConfig['short_description'] == ATTRIBUTE_MANDATORY)?'validate[required]':'';
                                                echo "<textarea id='short_description_$lng' name='short_description_$lng' class='input_txt form-control h-auto $required' cols='75' rows='4' maxLength='245'>$langContent</textarea>";
                                                echo $jbdTabs->endTab();
                                            }
                                            echo $jbdTabs->endTabSet();
                                        }else {
                                        ?>
                                            <textarea name="short_description" id="short_description" class="input_txt form-control h-auto <?php echo ($attributeConfig["short_description"] == ATTRIBUTE_MANDATORY)?"validate[required]":""?>"  cols="75" rows="4"  maxLength="245"
                                                ><?php echo $this->item->short_description ?></textarea>
                                    <?php
                                        }
                                    ?>
                                </div>
                                <?php } ?>
                                <?php if($attributeConfig["description"]!=ATTRIBUTE_NOT_SHOW) { ?>
                                    <div class="form-group">
                                        <label for="description_id"><?php echo JText::_('LNG_DESCRIPTION')?>  <?php echo JBusinessUtil::showMandatory($attributeConfig["description"])?>  </label>
                                        <?php
                                            if($this->appSettings->enable_multilingual) {
                                                $options = array(
                                                        'onActive' => 'function(title, description){
                                                        description.setStyle("display", "block");
                                                        title.addClass("open").removeClass("closed");
                                                }',
                                                        'onBackground' => 'function(title, description){
                                                        description.setStyle("display", "none");
                                                        title.addClass("closed").removeClass("open");
                                                }',
                                                        'startOffset' => 0,  // 0 starts on the first tab, 1 starts the second, etc...
                                                        'useCookie' => true, // this must not be a string. Don't use quotes.
                                                );
                                                $jbdTabs->setOptions($options);
                                                echo $jbdTabs->startTabSet('tab_groupsd_id');
                                                foreach( $this->languages  as $k=>$lng ) {
                                                    echo $jbdTabs->addTab('tab_groupsd_id', 'tab-'.$lng, $k);
                                                    $langContent = isset($this->translations[$lng])?$this->translations[$lng]:"";
                                                    if($lng==JBusinessUtil::getLanguageTag() && empty($langContent)) {
                                                        $langContent = $this->item->description;
                                                    }
                                                    $editor = JBusinessUtil::getEditor();
                                                    echo $editor->display('description_'.$lng, $langContent, '95%', '200', '70', '10', false);
                                                    echo $jbdTabs->endTab();
                                                }
                                                echo $jbdTabs->endTabSet();
                                            } else {
        
                                                $editor = JBusinessUtil::getEditor();
                                                echo $editor->display('description', $this->item->description, '95%', '200', '70', '10', false);
                                            } ?>
                                    </div>
                                <?php } ?>

                                <div class="clear"></div>

                                <div class="form-group" style="display:none">
                                    <label for="location"><?php echo JText::_('LNG_LOCATION')?> </label>
                                    <input type="text" name="location" id="location" class="input_txt" value="<?php echo $this->escape($this->item->location) ?>" maxlength="45">
                                </div>

                                <div class="row">
                                    <?php if ($attributeConfig["attendance"] != ATTRIBUTE_NOT_SHOW) { ?>
                                        <div class="col-md">
                                            <div class="form-group">
                                                <label for="status"><?php echo JText::_('LNG_ATTENDANCE_MODE') ?> <?php echo JBusinessUtil::showMandatory($attributeConfig["attendance"]) ?></label>
                                                <select name="attendance_mode" id="attendance_mode" class="form-control <?php echo $attributeConfig["attendance"] == ATTRIBUTE_MANDATORY?"validate[required]":""?>">
                                                    <option value=""><?php echo JText::_('LNG_JOPTION_SELECT_ATTENDANCE_MODE');?></option>
                                                    <?php echo JHtml::_('select.options', $this->attendanceModes, 'value', 'text', $this->item->attendance_mode);?>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md">
                                            <div class="form-group">
                                                <label for="attendance_url"><?php echo JText::_('LNG_ATTENDANCE_URL') ?> <?php echo JBusinessUtil::showMandatory($attributeConfig["attendance"]) ?></label>
                                                <input type="text" name="attendance_url" id="attendance_url" class="input_txt <?php echo $attributeConfig["attendance"] == ATTRIBUTE_MANDATORY?"validate[required]":""?>" value="<?php echo $this->escape($this->item->attendance_url) ?>" maxlength="245">
                                            </div>
                                        </div>
                                    <?php } ?>
                                    <?php if ($attributeConfig["type"] != ATTRIBUTE_NOT_SHOW) { ?>
                                        <div class="col-md">
                                            <div class="form-group">
                                                <label for="type"><?php echo JText::_('LNG_TYPE')?> <?php echo JBusinessUtil::showMandatory($attributeConfig["type"]) ?></label>

                                                <select data-placeholder="<?php echo JText::_("LNG_SELECT_EVENTTYPE") ?>" class="form-control <?php echo $attributeConfig["type"] == ATTRIBUTE_MANDATORY?"validate[required]":""?>" name="type" id="eventTypes">
                                                    <?php foreach( $this->item->types as $type ) { ?>
                                                        <option <?php echo $this->item->type==$type->id? "selected" : ""?> value='<?php echo $type->id?>'><?php echo $type->name ?></option>
                                                    <?php } ?>
                                                </select>
                                            </div>
                                        </div>
                                    <?php } ?>
                                </div>
                                <?php if ($attributeConfig["price"] != ATTRIBUTE_NOT_SHOW) { ?>
                                    <div class="row">
                                        <div class="col-md">
                                            <div class="form-group">
                                                <label for="price"><?php echo JText::_('LNG_PRICE')?><?php echo JBusinessUtil::showMandatory($attributeConfig["price"]) ?></label>
                                                <input type="text"
                                                    name="price" id="price" class="input_txt form-control <?php echo $attributeConfig["price"] == ATTRIBUTE_MANDATORY?"validate[required]":""?>"
                                                    value="<?php echo $this->escape($this->item->price) ?>">
                                            </div>
                                        </div>
                                        <div class="col-md">
                                            <div class="form-group">
                                                <label for="state"><?php echo JText::_('LNG_CURRENCY')?></label>
                                                <select data-placeholder="<?php echo JText::_("LNG_SELECT_CURRENCY") ?>" class="inputbox input-medium chosen-select" name="currency_id" id="currency_id">
                                                    <?php
                                                    for($i = 0; $i <  count( $this->currencies ); $i++){
                                                        $currency = $this->currencies[$i];
                                                        ?>
                                                        <option value = '<?php echo $currency->currency_id?>' <?php echo $currency->currency_id==$this->item->currency_id? "selected" : ""?>> <?php echo $currency->currency_name." - ". $currency->currency_description ?></option>
                                                    <?php }	?>
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                <?php }	?>

                                <?php if($attributeConfig["age"]!=ATTRIBUTE_NOT_SHOW) { ?>
                                    <div class="row">
                                        <div class="col-md">
                                            <div class="form-group">
                                                <label for="ad_caption"><?php echo JText::_('LNG_MIN_AGE')?> <?php echo JBusinessUtil::showMandatory($attributeConfig["age"]) ?></label>
                                                <input type="text" name="min_age" id="min_age" class="form-control <?php echo $attributeConfig["age"] == ATTRIBUTE_MANDATORY?"validate[required]":""?>" value="<?php echo $this->escape($this->item->min_age);?>" maxlength="3">
                                            </div>
                                        </div>
                                        <div class="col-md">
                                            <div class="form-group">
                                                <label for="ad_caption"><?php echo JText::_('LNG_MAX_AGE')?> <?php echo JBusinessUtil::showMandatory($attributeConfig["age"]) ?></label>
                                                <input type="text" name="max_age" id="max_age" class="form-control <?php echo $attributeConfig["age"] == ATTRIBUTE_MANDATORY?"validate[required]":""?>" value="<?php echo $this->escape($this->item->max_age);?>" maxlength="3">
                                            </div>
                                        </div>
                                    </div>
                                <?php } ?>

                                <?php if($this->appSettings->enable_event_reservation && $attributeConfig["total_tickets"]!=ATTRIBUTE_NOT_SHOW) { ?>
                                    <div class="form-group">
                                        <label for="total_tickets"><?php echo JText::_('LNG_TOTAL_TICKETS'); ?><?php echo JBusinessUtil::showMandatory($attributeConfig["total_tickets"]) ?></label>
                                        <input type="text" name="total_tickets" id="total_tickets" class="input_txt form-control <?php echo $attributeConfig["total_tickets"] == ATTRIBUTE_MANDATORY?"validate[required]":""?>" value="<?php echo $this->escape($this->item->total_tickets) ?>">
                                    </div>
                                <?php } ?>
    
                                <?php if($this->appSettings->enable_event_subscription) { ?>
                                    <div class="form-group" >
                                        <label for="enable_subscription"><?php echo JText::_('LNG_ENABLE_EVENT_JOINING')?> </label>
                                        <div>
                                            <fieldset id="enable_subscription_fld" class="radio btn-group btn-group-yesno">
                                                <input type="radio" class="validate[required]" name="enable_subscription" id="enable_subscription1" value="1" <?php echo $this->item->enable_subscription==1? 'checked="checked"' :""?> />
                                                <label class="btn" for="enable_subscription1"><?php echo JText::_('LNG_YES')?></label>
                                                <input type="radio" class="validate[required]" name="enable_subscription" id="enable_subscription0" value="0" <?php echo $this->item->enable_subscription==0? 'checked="checked"' :""?> />
                                                <label class="btn" for="enable_subscription0"><?php echo JText::_('LNG_NO')?></label>
                                            </fieldset>
                                        </div>
                                    </div>
                                <?php } ?>
    
                            </div>
                        </fieldset>
    
                        <?php if($attributeConfig["category"]!=ATTRIBUTE_NOT_SHOW) { ?>
                        <fieldset class="boxed">
                            <h2> <?php echo JText::_('LNG_CATEGORIES');?></h2>
                            <p><?php echo JText::_('LNG_SELECT_CATEGORY');?></p>
                            <div class="form-container">
                            <div class="form-group">
                                <label for="categories"><?php echo JText::_('LNG_CATEGORY')?> <?php echo JBusinessUtil::showMandatory($attributeConfig["category"])?></label>
                                <select name="categories[]" id="categories" data-placeholder="<?php echo JText::_("LNG_SELECT_CAT") ?>" multiple class="chosen-select-categories">
                                    <?php echo JHtml::_('select.options', $this->categoryOptions, 'value', 'text', $this->item->selectedCategories); ?>
                                    </select>
                                    <a href="javascript:jbdUtils.uncheckAllCategories()"><?php echo JText::_("LNG_UNCHECK_ALL")?></a>
                                </div>
                                <div class="form-group">
                                    <label for="subcat_main_id"><?php echo JText::_('LNG_MAIN_SUBCATEGORY');?><?php echo JBusinessUtil::showMandatory($attributeConfig["category"])?></label>
                                <select data-placeholder="<?php echo JText::_("LNG_SELECT_CAT") ?>" name="main_subcategory" id="main_subcategory" <?php echo $this->appSettings->enable_attribute_category?'onchange="jbdEvents.updateAttributes(this.value, '.$this->item->id.')"':'' ?> class="input_sel <?php echo ($attributeConfig['category'] == ATTRIBUTE_MANDATORY)?"validate[required]":""?>">
                                    <?php foreach( $this->item->selectedSubCategories as $selectedCategory){?>
                                        <option value="<?php echo $selectedCategory->id ?>" <?php echo $selectedCategory->id == $this->item->main_subcategory ? "selected":"" ; ?>><?php echo $selectedCategory->name ?></option>
                                    <?php } ?>
                                </select>
                                </div>
                            </div>
                        </fieldset>
                        <?php } ?>
    
                        <?php if(!empty($this->item->customFields) || $this->appSettings->enable_attribute_category){
                            $renderedContent = AttributeService::renderAttributes($this->item->customFields, false, array());
                            if (!empty($renderedContent)) { ?>
                                <fieldset class="boxed">
                                    <h2> <?php echo JText::_('LNG_ADDITIONAL_INFO'); ?></h2>
                                    <p><?php echo JText::_('LNG_ADDITIONAL_INFO_TEXT'); ?></p>
                                    <div class="form-container " id="customFieldsContent">
                                        <?php
                                        if ($this->appSettings->enable_attribute_category) {
                                            if (!empty($this->item->main_subcategory))
                                                echo $renderedContent;
                                            else
                                                echo JText::_("LNG_NO_ATTRIBUTES_FOR_CATEGORY");
                                        } else {
                                            echo $renderedContent;
                                        }
                                        ?>
                                    </div>
                                </fieldset>
                                <?php
                            }
                        } ?>
    
                        <fieldset class="boxed">
                            <h2><?php echo JText::_('LNG_EVENT_DATES');?></h2>
                            <p><?php echo JText::_('LNG_EVENT_DATES_TEXT');?></p>
                            <div class="form-container">
                            <div class="row">
                                <div class="col-md-6">
                                    <label for="startDate"><?php echo JText::_('LNG_START_DATE')?> </label>
                                    <?php echo JHTML::_('calendar', $this->item->start_date, 'start_date', 'start_date', $this->appSettings->calendarFormat, array('style'=>'display:inline;','class'=>'inputbox calendar-date', 'size'=>'10', 'maxlength'=>'10')); ?>
                                    <div class="clear"></div>
                                </div>
                            </div>
                            <div class="row align-items-end">
                                <div class="col-md-6">
                                    <label for="endDate"><?php echo JText::_('LNG_END_DATE')?> </label>
                                    <?php echo JHTML::_('calendar', $this->item->end_date, 'end_date', 'end_date', $this->appSettings->calendarFormat, array('style'=>'display:inline;', 'class'=>'inputbox calendar-date', 'size'=>'10', 'maxlength'=>'10')); ?>
                                    <div class="clear"></div>
                                </div>
                                <div class="col-md-5">
                                    <div class="jbd-checkbox">
                                        <label class="checkbox-label" for="show_end_date"><?php echo JText::_('LNG_SHOW_END_DATE'); ?></label>
                                        <input type="checkbox" value="1" name="show_end_date" id="show_end_date" <?php echo $this->item->show_end_date?'checked':''; ?> />
                                    </div>
                                </div>
                            </div>
                            
                            <?php if($attributeConfig["time_zone"]!=ATTRIBUTE_NOT_SHOW) { ?>
                                <div class="row">
                                    <div class="col-md-12">
                                        <p> <?php echo JText::_('LNG_TIME_ZONE_INFORMATION_TEXT');?>.</p>
                                        <div class="form-group" id="time_zoneContainer">
                                            <select class="form-control input-medium chosen-select" id="time_zone" name="time_zone">
                                                <?php $timeZones = JBusinessUtil::timeZonesList();
                                                foreach ($timeZones as $key => $zone) {
                                                    $selected = ($key == $this->item->time_zone) ? " selected" : "";
                                                    echo "<option value='" . $key . "'" . $selected . ">" . $zone . "</option>";
                                                } ?>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                            <?php } ?>

                            <div class="row align-items-end">
                                <div class="col-md-6">
                                    <label for="start_time"><?php echo JText::_('LNG_START_TIME')?></label>
                                    <div class="has-jicon-right">
                                        <input type="text" name="start_time" id="start_time" class="input_txt form-control timepicker" value="<?php echo $this->item->start_time ?>">
                                        <i class="la la-clock-o"></i>
                                    </div>
                                    <div class="clear"></div>
                                </div>
                                <div class="col-md-5">
                                    <div class="jbd-checkbox">
                                        <label class="checkbox-label" for="show_start_time"><?php echo JText::_('LNG_SHOW_START_TIME'); ?></label>
                                        <input type="checkbox"value="1" name="show_start_time" id="show_start_time" <?php echo $this->item->show_start_time?'checked':''; ?> />
                                    </div>
                                </div>
                            </div>
                            <div class="row align-items-end">
                                <div class="col-md-6">
                                    <label for="end_time"><?php echo JText::_('LNG_END_TIME')?></label>
                                    <div class="has-jicon-right">
                                        <input type="text" name="end_time" id="end_time" class="input_txt form-control timepicker" value="<?php echo $this->item->end_time ?>">
                                        <i class="la la-clock-o"></i>
                                    </div>
                                    <div class="clear"></div>
                                </div>
                                <div class="col-md-5">
                                    <div class="jbd-checkbox">
                                        <label class="checkbox-label" for="show_end_time"><?php echo JText::_('LNG_SHOW_END_TIME'); ?></label>
                                        <input type="checkbox" value="1" name="show_end_time" id="show_end_time" <?php echo $this->item->show_end_time?'checked':''; ?> />
                                    </div>
                                </div>
                            </div>
                            <br/>
                            <h3><?php echo JText::_('LNG_EVENT_DOORS_OPEN');?></h3>
                            <div class="row align-items-end">
                                <div class="col-md-6">
                                    <label for="doors_open_time"><?php echo JText::_('LNG_DOORS_OPEN_TIME')?> </label>
                                    <div class="has-jicon-right">
                                        <input type="text" name="doors_open_time" id="doors_open_time" class="input_txt form-control timepicker" value="<?php echo $this->item->doors_open_time ?>">
                                        <i class="la la-clock-o"></i>
                                    </div>
                                    <div class="clear"></div>
                                </div>
                                <div class="col-md-5">
                                    <div class="jbd-checkbox">
                                        <label class="checkbox-label" for="show_doors_open_time"><?php echo JText::_('LNG_SHOW_DOORS_OPEN_TIME'); ?></label>
                                        <input type="checkbox" value="1" name="show_doors_open_time" id="show_doors_open_time" <?php echo $this->item->show_doors_open_time?'checked':''; ?> />
                                    </div>
                                </div>
                            </div>
                            <br/>
                            <?php if($this->appSettings->enable_event_reservation && $attributeConfig["booking_dates"]!=ATTRIBUTE_NOT_SHOW){?>
                                <h3><?php echo JText::_('LNG_BOOKING_DATES');?></h3>
                                <p><?php echo JText::_('LNG_BOOKING_DATES_TEXT');?></p>
                                <div class="row">
                                    <div class="col-md-6">
                                        <label for="booking_open_date"><?php echo JText::_('LNG_BOOKING_OPEN_DATE')?> </label>
                                        <?php echo JHTML::_('calendar', $this->item->booking_open_date, 'booking_open_date', 'booking_open_date', $this->appSettings->calendarFormat, array('style'=>'display:inline;', 'class'=>'inputbox calendar-date', 'size'=>'10', 'maxlength'=>'10')); ?>
                                        <div class="clear"></div>
                                    </div>
                                    <div class="col-md-5">
                                        <label for="booking_open_time"><?php echo JText::_('LNG_BOOKING_OPEN_TIME')?> </label>
                                        <div class="has-jicon-right">
                                            <input type="text" name="booking_open_time" id="booking_open_time" class="input_txt form-control timepicker" value="<?php echo $this->item->booking_open_time ?>">
                                            <i class="la la-clock-o"></i>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-6">
                                        <label for="booking_close_date"><?php echo JText::_('LNG_BOOKING_CLOSE_DATE')?> </label>
                                        <?php echo JHTML::_('calendar', $this->item->booking_close_date, 'booking_close_date', 'booking_close_date', $this->appSettings->calendarFormat, array('style'=>'display:inline;', 'class'=>'inputbox calendar-date', 'size'=>'10', 'maxlength'=>'10')); ?>
                                        <div class="clear"></div>
                                    </div>
                                    <div class="col-md-5">
                                        <label for="booking_close_time"><?php echo JText::_('LNG_BOOKING_CLOSE_TIME')?> </label>
                                        <div class="has-jicon-right">
                                            <input type="text" name="booking_close_time" id="booking_close_time" class="input_txt form-control timepicker" value="<?php echo $this->item->booking_close_time ?>">
                                            <i class="la la-clock-o"></i>
                                        </div>
                                        <div class="clear"></div>
                                    </div>
                                </div>
                                <?php } ?>
                            </div>
                        </fieldset>
    
                        <!-- Associated companies Field-->
    					<?php if($attributeConfig["associated_listings"]!=ATTRIBUTE_NOT_SHOW ){ ?>
	                        <fieldset class="boxed">
	                            <h2> <?php echo JText::_('LNG_ASSOCIATED_COMPANIES');?></h2>
	                            <p><?php echo JText::_('LNG_SELECT_ASSOCIATED_COMPANIES');?></p>
	                            <div class="form-container">
	                                <div class="form-group">
	                                    <select data-placeholder="<?php echo JText::_("LNG_SELECT_OR_SEARCH_COMPANY") ?>" class="inputbox input-medium chosen-select" multiple name="associated-listings[]" id="associated-listings">
                                            <option value=""><?php echo JText::_("LNG_SELECT_OR_SEARCH_COMPANY")?></option>
	                                        
                                            <?php if (!empty($this->item->associatedCompaniesOptions))
		                                        echo JHtml::_('select.options', $this->item->associatedCompaniesOptions, 'id', 'name', $this->item->associatedCompaniesOptions);
	                                        ?>
	                                        <?php echo JHtml::_('select.options', JBusinessUtil::substractArrays($this->associatedCompanyOptions, $this->item->associatedCompaniesOptions), 'id', 'name', -1); ?>
	                                    </select>
                                        
	                                    <div>
	                                    <a href="javascript:jbdUtils.checkAll('associated-listings')"><?php echo JText::_("LNG_CHECK_ALL") ?></a> &nbsp;&nbsp;&nbsp; <a href="javascript:jbdUtils.uncheckAll('associated-listings')"><?php echo JText::_("LNG_UNCHECK_ALL")?></a>
	                                    </div>
	                                </div>
	                            </div>
	                        </fieldset>
	    				<?php } ?>
                        <!-- END Associated companies Field-->
    
                        <?php if($attributeConfig["street_number"]!=ATTRIBUTE_NOT_SHOW || $attributeConfig["address"]!=ATTRIBUTE_NOT_SHOW ||$attributeConfig["area"]!=ATTRIBUTE_NOT_SHOW
                        || $attributeConfig["country"]!=ATTRIBUTE_NOT_SHOW || $attributeConfig["city"]!=ATTRIBUTE_NOT_SHOW
                        || $attributeConfig["province"]!=ATTRIBUTE_NOT_SHOW || $attributeConfig["region"]!=ATTRIBUTE_NOT_SHOW || $attributeConfig["postal_code"]!=ATTRIBUTE_NOT_SHOW || $attributeConfig["map"]!=ATTRIBUTE_NOT_SHOW){?>
                        <fieldset class="boxed">
    
                            <h2> <?php echo JText::_('LNG_LOCATION');?></h2>
                            
                            <div class="row align-items-center">
                                <div class="col-md">
                                	<p class="m-0"><?php echo JText::_("LNG_ADDRESS_SUGESTION")?></p>
                                </div>
                                <div class="col-md-3 text-right">
                                    <a href="javascript:void(0)" class="btn btn-success flex-row-centered" onclick="jbdEvents.loadAddress(<?php echo $this->appSettings->limit_cities_regions ? 'true' : 'false' ?>)" >
                						<?php echo JText::_('LNG_LOAD_ADDRESS'); ?>
                					</a>
                                </div>
            				</div>
                            <div class="form-container">
                                <div class="form-group autocomplete-box" id="autocomplete-box">
                                    <input type="text" id="autocomplete" class="input_txt form-control" placeholder="<?php echo JText::_('LNG_ENTER_ADDRESS') ?>" onFocus="" />
                                </div>
    
                                <div class="row">
                                   <?php if($attributeConfig["street_number"]!=ATTRIBUTE_NOT_SHOW){?>
                                        <div class="col-md">
                                            <div class="form-group">
                                                <label for="address_id"><?php echo JText::_('LNG_STREET_NUMBER')?><?php echo JBusinessUtil::showMandatory($attributeConfig["street_number"])?></label>
                                                <input type="text" name="street_number" id="street_number" class="input_txt form-control <?php echo ($attributeConfig["street_number"] == ATTRIBUTE_MANDATORY)?"validate[required]":""?>" value="<?php echo $this->escape($this->item->street_number) ?>" maxlength="20">
                                            </div>
                                        </div>
                                    <?php } ?>
                                    <?php if($attributeConfig["address"]!=ATTRIBUTE_NOT_SHOW){?>
                                    	<div class="col-md">
                                            <div class="form-group">
                                                <label for="subject"><?php echo JText::_('LNG_ADDRESS')?> <?php echo JBusinessUtil::showMandatory($attributeConfig["address"])?></label>
                                                <input type="text"
                                                    name="address" id="route" class="input_txt form-control <?php echo ($attributeConfig["address"] == ATTRIBUTE_MANDATORY)?"validate[required]":""?>" value="<?php echo $this->escape($this->item->address) ?>" maxlength="50">
                                            </div>
                                        </div>
                                    <?php } ?>
                                    <?php if($attributeConfig["area"]!=ATTRIBUTE_NOT_SHOW){?>
                                    	<div class="col-md">
                                            <div class="form-group" id="districtContainer">
                                                <label for="subject"><?php echo JText::_('LNG_AREA')?><?php echo JBusinessUtil::showMandatory($attributeConfig["area"])?> </label>
                                                <input type="text"
                                                       name="area" id="area_id" class="input_txt form-control <?php echo ($attributeConfig["area"] == ATTRIBUTE_MANDATORY)?"validate[required]":""?>" value="<?php echo $this->escape($this->item->area) ?>" maxlength="45">
                                            </div>
                                        </div>
                                    <?php } ?>
                                </div>
                                <?php if($attributeConfig["country"]!=ATTRIBUTE_NOT_SHOW){?>
                                    <div class="form-group">
                                        <label for="country"><?php echo JText::_('LNG_COUNTRY')?> <?php echo JBusinessUtil::showMandatory($attributeConfig["country"])?></label>
                                        <select data-placeholder="<?php echo JText::_("LNG_SELECT_COUNTRY") ?>" class="form-control select <?php echo $attributeConfig["country"] == ATTRIBUTE_MANDATORY?"validate[required]":""?>" name="countryId" id="country" <?php echo $this->appSettings->limit_cities_regions ? 'onclick="updateRegions()"' : ''; ?> >
                                            <option value=''></option>
                                            <?php
                                            foreach ($this->item->countries as $country) { ?>
                                                <option <?php echo $this->item->countryId==$country->id? "selected" : ""?> value='<?php echo $country->id?>'><?php echo $country->country_name ?></option>
                                                <?php
                                            } ?>
                                        </select>
                                        <span class="error_msg" id="frmCountry_error_msg" style="display: none;"><?php echo JText::_('LNG_REQUIRED_FIELD')?></span>
                                    </div>
                                <?php } ?>
                                <div class="row">
                               		<?php if ($attributeConfig["region"] != ATTRIBUTE_NOT_SHOW) { ?>
                                    	<div class="col-md">
                                            <div class="form-group" id="districtContainer">
                                                <label for="county"><?php echo JText::_('LNG_REGION') ?> <?php echo JBusinessUtil::showMandatory($attributeConfig["region"])?></label>
                                                <?php if ($this->appSettings->limit_cities_regions != 1) { ?>
                                                    <input type="text"
                                                           name="county" id="administrative_area_level_1"
                                                           class="input_txt form-control <?php echo ($attributeConfig["region"] == ATTRIBUTE_MANDATORY) ? "validate[required]" : "" ?>"
                                                           value="<?php echo $this->escape($this->item->county) ?>" maxlength="45">
                                                <?php } else { ?>
                                                    <select name="county" id="administrative_area_level_1" class="input_txt <?php echo ($attributeConfig["region"] == ATTRIBUTE_MANDATORY) ? "validate[required]" : "" ?>" onchange="updateCities()" >
                                                        <option value=""><?php echo JText::_('LNG_SELECT_REGION') ?></option>
                                                        <?php foreach ($this->item->regions as $region) { ?>
                                                            <option value="<?php echo $region->name ?>" <?php echo $this->item->county == $region->name ? "selected" : "" ?>><?php echo $region->name ?></option>
                                                        <?php } ?>
                                                    </select>
                                                <?php } ?>
                                            </div>
                                   		</div>
     								<?php } ?>
     								<?php if ($attributeConfig["city"] != ATTRIBUTE_NOT_SHOW) { ?>
                                    	<div class="col-md">
                                            <div class="form-group">
                                                <label for="city"><?php echo JText::_('LNG_CITY') ?><?php echo JBusinessUtil::showMandatory($attributeConfig["city"])?></label>
                                                <?php if ($this->appSettings->limit_cities_regions != 1) { ?>
                                                    <input type="text"
                                                           name="city" id="locality"
                                                           class="input_txt form-control <?php echo ($attributeConfig["city"] == ATTRIBUTE_MANDATORY) ? "validate[required]" : "" ?>"
                                                           value="<?php echo $this->escape($this->item->city) ?>" maxlength="45">
                                                <?php } else { ?>
                                                    <select name="city" id="locality" class="input_txt <?php echo ($attributeConfig["city"] == ATTRIBUTE_MANDATORY) ? "validate[required]" : "" ?>" >
                                                        <option value=""><?php echo JText::_('LNG_SELECT_CITY') ?></option>
                                                        <?php foreach ($this->item->cities as $city) { ?>
                                                            <option value="<?php echo $city->name ?>" <?php echo $this->item->city == $city->name ? "selected" : "" ?> ><?php echo $city->name ?></option>
                                                        <?php } ?>
                                                    </select>
                                                <?php } ?>
                                            </div>
                                       </div>
                                    <?php } ?>
                                </div>
                                <div class="row">
                                	<?php if($attributeConfig["province"]!=ATTRIBUTE_NOT_SHOW){?>
                                    	<div class="col-md">
                                            <div class="form-group">
                                                <label for="subject"><?php echo JText::_('LNG_PROVINCE')?> <?php echo JBusinessUtil::showMandatory($attributeConfig["province"])?></label>
                                                <input type="text"
                                                       name="province" id="administrative_area_level_2" class="input_txt form-control <?php echo ($attributeConfig["province"] == ATTRIBUTE_MANDATORY)?"validate[required]":""?>" value="<?php echo $this->escape($this->item->province) ?>" maxlength="45">
                                            </div>
                                    	</div>
                                    <?php } ?>
                                    <?php if($attributeConfig["postal_code"]!=ATTRIBUTE_NOT_SHOW){?>
                                    	<div class="col-md">
                                            <div class="form-group" id="districtContainer">
                                                <label for="district_id"><?php echo JText::_('LNG_POSTAL_CODE')?><?php echo JBusinessUtil::showMandatory($attributeConfig["postal_code"])?> </label>
                                                <input class="input_sel form-control <?php echo $attributeConfig["postal_code"] == ATTRIBUTE_MANDATORY?"validate[required]":""?>" type="text" name="postalCode" id="postal_code" value="<?php echo $this->escape($this->item->postalCode) ?>" maxlength="55" />
                                            </div>
                                    	</div>
                                    <?php } ?>
                                </div>
                                <?php if($attributeConfig["map"]!=ATTRIBUTE_NOT_SHOW){?>
                                    <div class="row">
                                        <div class="col-md">
                                            <div class="form-group">
                                                <label for="latitude"><?php echo JText::_('LNG_LATITUDE')?><?php echo JBusinessUtil::showMandatory($attributeConfig["map"])?> </label>
                                                <p class="small"><?php echo JText::_('LNG_MAP_INFO')?></p>
                                                <input class="input_txt form-control <?php echo ($attributeConfig["map"] == ATTRIBUTE_MANDATORY)?"validate[required]":""?>" type="text" name="latitude" id="latitude" value="<?php echo $this->escape($this->item->latitude) ?>" maxlength="45">
                                            </div>
                                        </div>
                                        <div class="col-md">
                                            <div class="form-group">
                                                <label for="longitude"><?php echo JText::_('LNG_LONGITUDE')?><?php echo JBusinessUtil::showMandatory($attributeConfig["map"])?> </label>
                                                <p class="small"><?php echo JText::_('LNG_MAP_INFO')?></p>
                                                <input class="input_txt form-control <?php echo ($attributeConfig["map"] == ATTRIBUTE_MANDATORY)?"validate[required]":""?>" type="text" name="longitude" id="longitude" value="<?php echo $this->escape($this->item->longitude) ?>" maxlength="45">
                                            </div>
                                        </div>
                                    </div>
                                    <div id="map-container">
                                        <div id="company-map">
                                        </div>
                                    </div>
                                <?php } ?>
                            </div>
                        </fieldset>
                        <?php } ?>
    
                        <?php if($attributeConfig["phone"]!=ATTRIBUTE_NOT_SHOW || $attributeConfig["email"]!=ATTRIBUTE_NOT_SHOW) { ?>
                        <fieldset class="boxed">
                            <h2><?php echo JText::_('LNG_EVENT_CONTACT_INFORMATION');?></h2>
                            <p> <?php echo JText::_('LNG_EVENT_CONTACT_INFORMATION_TEXT');?>.</p>
                            
                            
                            <div class="row">
                                <?php if($attributeConfig["phone"]!=ATTRIBUTE_NOT_SHOW){ ?>
                                	<div class="col-md">
                                    	<div class="form-group">
                                            <label for="contact_phone"><?php echo JText::_('LNG_TELEPHONE')?><?php echo JBusinessUtil::showMandatory($attributeConfig["phone"])?></label>
                                            <div class="has-jicon-right">
                                                <input type="text"	name="contact_phone" id="contact_phone" class="input_txt form-control text-input <?php echo $attributeConfig["phone"] == ATTRIBUTE_MANDATORY?"validate[required]":""?>" value="<?php echo $this->escape($this->item->contact_phone) ?>" maxlength="20">
                                                <i class="la la-phone"></i>
                                            </div>
                                        </div>
                                    </div>
                                <?php }?>
                                <?php if($attributeConfig["email"]!=ATTRIBUTE_NOT_SHOW){ ?>
                                   <div class="col-md">
                                        <div class="form-group">
                                            <label for="contact_email"><?php echo JText::_('LNG_EMAIL')?><?php echo JBusinessUtil::showMandatory($attributeConfig["email"])?></label>
                                            <div class="has-jicon-right">
                                                <input type="text" name="contact_email" id="contact_email" class="input_txt form-control text-input <?php echo $attributeConfig["email"] == ATTRIBUTE_MANDATORY?"validate[required,custom[email]]":" validate[custom[email]]"?>" value="<?php echo $this->escape($this->item->contact_email) ?>" maxlength="60">
                                                <i class="la la-envelope"></i>
                                            </div>
                                            <div class="description">e.g. office@site.com</div>
                                        </div>
                                    </div>
                                <?php } ?>
                            </div>
                        </fieldset>
                        <?php } ?>
    
                        <?php if($attributeConfig["pictures"]!=ATTRIBUTE_NOT_SHOW) { ?>
                            <fieldset class="boxed">
    	                        <?php if ($attributeConfig["pictures"] == ATTRIBUTE_MANDATORY) { ?>
                                    <input type="text" id="pictures_validate" class="validate[required] hidden-validate right" value="" />
                                <?php } ?>
                                <h2> <?php echo JText::_('LNG_EVENT_PICTURES');?> </h2>
                                <p> <?php echo JText::_('LNG_EVENT_PICTURES_INFORMATION_TEXT');?>.</p>
                                <a class="btn btn-outline-danger" id="remove-pictures" href="javascript:void(0);" onclick="uploadInstance.removeAllPicture()"><?php echo JText::_('LNG_DELETE_ALL')?></a>
                                <input type='button' name='btn_removefile' id='btn_removefile' value='x' style='display:none'>
                                <input type='hidden' name='crt_pos' id='crt_pos' value=''>
                                <input type='hidden' name='crt_path' id='crt_path' value=''>
    
                                <div class="jupload" id="pictures-list">
                                    <div class="jupload-header">
                                        <div class="jupload-header-title"></div>
                                        <div class="jupload-header-desc"></div>
                                    </div>
                                    <div class="jupload-body">
                                        <ul id="sortable" class="jbd-item-list">
                                            <?php
                                            if (!empty($this->item->pictures)) {
                                                foreach ($this->item->pictures as $picture ) { ?>
                                                    <li class="jbd-item" id="jbd-item-<?php echo $picture['id'] ?>">
                                                        <div class="jupload-files">
                                                            <div class="jupload-files-img">
                                                                <img src='<?php echo BD_PICTURES_PATH.$picture['picture_path']?>'>
                                                            </div>
                                                            <div class="jupload-files-info">
                                                                <div class="jupload-filename">
                                                                    <p><?php echo substr(basename($picture['picture_path']),0,30)?></p>
                                                                    <input id="jupload-filename-<?php echo $picture['id'] ?>" type="text"
                                                                           name="picture_title[]" value="<?php echo $picture['picture_title']?>" placeholder="<?php echo JText::_('LNG_TITLE') ?>">
                                                                    <input id="jupload-filename-<?php echo $picture['id'] ?>" type="text"
                                                                           name="picture_info[]" value="<?php echo $picture['picture_info']?>" placeholder="<?php echo JText::_('LNG_DESCRIPTION') ?>">
                                                                </div>
                                                                <div class="jupload-actions jbd-item-actions">
                                                                    <label for="jupload-filename-<?php echo $picture['id'] ?>">
                                                                        <i class="la la-pencil"></i>
                                                                    </label>
    
                                                                    <input type="hidden" name="picture_enable[]" id="picture_enable_<?php echo $picture['id'] ?>" value="<?php echo $picture['picture_enable'] ?>" />
                                                                    <input type='hidden' name='picture_path[]' id='picture_path_<?php echo $picture['id'] ?>' value='<?php echo $this->escape($picture['picture_path'])?>' />
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </li>
    
                                                    <?php
                                                }
                                            } ?>
                                        </ul>
    
                                        <div class="dropzone dropzone-previews container-fluid" id="file-upload">
                                            <div id="actions" style="margin-left:-15px;" class="row">
                                                <div class="col d-flex justify-content-center">
                                                    <!-- The fileinput-button span is used to style the file input field as button -->
                                                    <span class="btn btn-success fileinput-button dz-clickable mr-1">
                                                            <i class="glyphicon glyphicon-plus"></i>
                                                            <span><?php echo JText::_('LNG_ADD_FILES'); ?></span>
                                                        </span>
                                                    <button  class="btn btn-primary start" id="submitAll">
                                                        <i class="glyphicon glyphicon-upload"></i>
                                                        <span><?php echo JText::_('LNG_UPLOAD_ALL'); ?></span>
                                                    </button>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </fieldset>
                        <?php } ?>
    
    			<?php if($attributeConfig["video"]!=ATTRIBUTE_NOT_SHOW) { ?>
                    <fieldset class="boxed">
                        <h2> <?php echo JText::_('LNG_EVENT_VIDEOS');?></h2>
                        <p> <?php echo JText::_('LNG_EVENT_VIDEO_INFORMATION_TEXT'); ?></p>
                        <div class="form-container">
                            <div id="video-container">
                                <?php
                                if(count($this->item->videos) == 0){?>
                                    <div class="video-item" id="detailBox0">
                                        <label for="video1"><?php echo JText::_('LNG_VIDEO')?><?php echo JBusinessUtil::showMandatory($attributeConfig["video"])?></label>
                                        <div class="input-group">
                                            <input type="text" name="videos[]" id="0" class="form-control <?php echo $attributeConfig["video"] == ATTRIBUTE_MANDATORY?"validate[required]": ""?> " value="" />
                                            <div class="input-group-append">
                                                <button class="input-group-text btn-secondary" onclick="uploadInstance.removeRow('detailBox0');">
                                                    <i class="la la-lg la-remove"></i>
                                                </button>
                                            </div>
                                        </div>
                                    </div>
                                    <?php
                                } ?>
        
                                <?php $index = 0;
                                if(count($this->item->videos)>0)
                                    foreach($this->item->videos as $video) { ?>
                                        <div class="video-item" id="detailBox<?php echo $index ?>">
                                            <label for="<?php echo $video->id?>"><?php echo JText::_('LNG_VIDEO')?><?php echo JBusinessUtil::showMandatory($attributeConfig["video"])?></label>
                                            <div class="input-group">
                                            <input name="videos[]" id="<?php echo $video->id?>" class="form-control <?php echo $attributeConfig["video"] == ATTRIBUTE_MANDATORY?"validate[required]" : "" ?>> " value="<?php echo $this->escape($video->url) ?>" />
                                                <div class="input-group-append">
                                                    <button class="input-group-text btn-secondary" onclick="uploadInstance.removeRow('detailBox<?php echo $index++; ?>');">
                                                        <i class="la la-lg la-remove"></i>
                                                    </button>
                                                </div>
                                            </div>
                                        </div>
                                        <?php
                                    } ?>
                            </div>
                            <a id="add-video" href="javascript:void(0);" onclick="uploadInstance.addVideo()"><?php echo JText::_('LNG_ADD_VIDEO')?></a>
                        </div>
                    </fieldset>
    			<?php } ?>
    
    
                <?php if($this->appSettings->enable_attachments == 1) { ?>
                    <?php if($attributeConfig["attachments"]!=ATTRIBUTE_NOT_SHOW) { ?>
                        <fieldset class="boxed">
                            <h2> <?php echo JText::_('LNG_ATTACHMENTS');?> </h2>
                            <p> <?php echo JText::_('LNG_ATTACHMENTS_INFORMATION_TEXT');?>.</p>
                            <input type='button' name='btn_removefile_at' id='btn_removefile_at' value='x' style='display:none'>
                            <input type='hidden' name='crt_pos_a' id='crt_pos_a' value=''>
                            <input type='hidden' name='crt_path_a' id='crt_path_a' value=''>
                            <input type="hidden" name="process-attachments" value="1">
    
                            <div class="jupload" id="attachment-list">
                                <div class="jupload-header">
                                    <div class="jupload-header-title"></div>
                                    <div class="jupload-header-desc"></div>
                                </div>
                                <div class="jupload-body">
                                    <ul id="sortable-attachment" class="jbd-item-list">
                                        <?php
                                        if (!empty($this->item->attachments)) {
                                            foreach ($this->item->attachments as $attachment ) { ?>
    
                                                <li class="jbd-item" id="jbd-item-<?php echo $attachment->id ?>">
                                                    <div class="jupload-files">
                                                        <div class="jupload-files-img">
                                                            <i class="la la-file"></i>
                                                        </div>
                                                        <div class="jupload-files-info">
                                                            <div class="jupload-filename">
                                                                <p><?php echo basename($attachment->path)?></p>
                                                                <input id="jupload-filename-<?php echo $attachment->id ?>" type="text"
                                                                       name="attachment_name[]" value="<?php echo $attachment->name ?>">
                                                            </div>
                                                            <div class="jupload-actions jbd-item-actions">
                                                                <label for="jupload-filename-<?php echo $attachment->id ?>">
                                                                    <i class="la la-pencil"></i>
                                                                </label>
    
                                                                <input type="hidden" name="attachment_status[]" id="attachment_status_<?php echo $attachment->id ?>" value="<?php echo $attachment->status ?>" />
                                                                <input type='hidden' name='attachment_path[]' id='attachment_path_<?php echo $attachment->id ?>' value='<?php echo $this->escape($attachment->path)?>' />
                                                            </div>
                                                        </div>
                                                    </div>
                                                </li>
    
                                                <?php
                                            }
                                        } ?>
                                    </ul>
    
                                    <fieldset class="jupload-field">
                                        <p><i class="la la-cloud-upload la-2x"></i><label
                                                    for="multiFileUploader"><?php echo JText::_('LNG_CHOOSE_FILE') ?></label></p>
                                        <input class="jupload-field-input" type="file" name="uploadAttachment" id="multiFileUploader">
                                    </fieldset>
                                </div>
                            </div>
                        </fieldset>
                        <?php } ?>
                        <?php } ?>
    
    
                        <?php if($attributeConfig["metadata_information"]!=ATTRIBUTE_NOT_SHOW && (!isset($isProfile) || isset($isProfile) && $this->appSettings->front_end_meta_data)) { ?>
                            <fieldset class="boxed">
                                <h2> <?php echo JText::_('LNG_METADATA_INFORMATION');?></h2>
                                <p> <?php echo JText::_('LNG_METADATA_INFORMATION_TEXT');?>.</p>
                                <div class="form-container">
                                    <div class="form-group">
                                        <label for="meta_title"><?php echo JText::_('LNG_META_TITLE')?></label>
                                        <?php
                                        if($this->appSettings->enable_multilingual) {
                                            $jbdTabs->setOptions($options);
                                            echo $jbdTabs->startTabSet('tab_groupsd_id');
                                            foreach( $this->languages  as $k=>$lng ) {
                                                echo $jbdTabs->addTab('tab_groupsd_id', 'tab-'.$lng, $k);
                                                $langContent = isset($this->translationsMeta[$lng."_name"])?$this->translationsMeta[$lng."_name"]:"";
                                                if($lng==JBusinessUtil::getLanguageTag() && empty($langContent)){
                                                    $langContent = $this->item->meta_title;
                                                }
                                                $langContent=$this->escape($langContent);
                                                echo "<input type='text' name='meta_title_$lng' id='meta_title_$lng' class='input_txt form-control' value=\"".stripslashes($langContent)."\"  maxLength='100'>";
                                                echo $jbdTabs->endTab();
                                            }
                                            echo $jbdTabs->endTabSet();
                                        } else { ?>
                                            <input type="text" name="meta_title" id="meta_title" class="input_txt form-control" value="<?php echo $this->escape($this->item->meta_title) ?>"  maxLength="100">
                                        <?php } ?>
                                    </div>
                                </div>
                                <div class="form-container">
                                    <div class="bootstrap-tags form-group">
                                        <label for="meta_keywords"><?php echo JText::_('LNG_META_KEYWORDS')?></label>
                                        <?php
                                        if($this->appSettings->enable_multilingual) {
                                            $jbdTabs->setOptions($options);
                                            echo $jbdTabs->startTabSet('tab_groupsd_id');
                                            foreach( $this->languages  as $k=>$lng ) {
                                                echo $jbdTabs->addTab('tab_groupsd_id', 'tab-'.$lng, $k);
                                                $langContent = isset($this->translationsMeta[$lng."_short"])?$this->translationsMeta[$lng."_short"]:"";
                                                if($lng==JBusinessUtil::getLanguageTag() && empty($langContent)){
                                                    $langContent = $this->item->meta_keywords;
                                                }
                                                $langContent=$this->escape($langContent);
                                                echo "<input type='text'  data-role='tagsinput' name='meta_keywords_$lng' id='meta_keywords_$lng' class='input_txt form-control' value=\"".stripslashes($langContent)."\"  maxLength='100'>";
                                                echo $jbdTabs->endTab();
                                            }
                                            echo $jbdTabs->endTabSet();
                                        } else { ?>
                                            <input type="text" data-role="tagsinput" name="meta_keywords" class="input_txt form-control" id="meta_keywords" value="<?php echo $this->item->meta_keywords ?>" maxlength="150" />
                                        <?php } ?>
                                    </div>
                                </div>
                                <div class="form-container">
                                    <div class="form-group">
                                        <label for="meta_description"><?php echo JText::_('LNG_META_DESCRIPTION')?></label>
                                        <?php
                                        if($this->appSettings->enable_multilingual) {
                                            $jbdTabs->setOptions($options);
                                            echo $jbdTabs->startTabSet('tab_groupsd_id');
                                            foreach( $this->languages  as $k=>$lng ) {
                                                echo $jbdTabs->addTab('tab_groupsd_id', 'tab-'.$lng, $k);
                                                $langContent = isset($this->translationsMeta[$lng])?$this->translationsMeta[$lng]:"";
                                                if($lng==JBusinessUtil::getLanguageTag() && empty($langContent)){
                                                    $langContent = $this->item->meta_description;
                                                }
                                                $langContent=$this->escape($langContent);
                                                echo "<textarea name='meta_description_$lng' id='meta_description_$lng' class='h-auto' rows='4' maxLength='255'>$langContent</textarea>";
                                                echo $jbdTabs->endTab();
                                            }
                                            echo $jbdTabs->endTabSet();
                                        } else { ?>
                                            <textarea name="meta_description" id="meta_description" class="h-auto" rows="4" maxLength="255"><?php echo $this->item->meta_description ?></textarea>
                                        <?php } ?>
                                    </div>
                                </div>
                                
                            </fieldset>
                        <?php } elseif (isset($isProfile) && !$this->appSettings->front_end_meta_data ) { ?>
                            <input type="hidden" name="meta_title" id="meta_title" value="<?php echo $this->item->meta_title ?>"/>
                            <input type="hidden" name="meta_description" id="meta_description" value="<?php echo $this->item->meta_description ?>"/>
                            <input type="hidden" name="meta_keywords" value="<?php echo $this->item->meta_keywords ?>" />
                        <?php }  ?>
                    </div>
                </div>

            </div>
            <div class="col-12 order-1 col-md-5 col-lg-4 order-md-2 ml-0 ml-lg-auto">
                <div class="">
                <?php if(!isset($isProfile)) { ?>
                    <div class="metainfo-container">
                        <fieldset class="boxed approved-label">
                            <div class="form-container">
                                <div ><label id="approved" for="approved" title=""><?php echo JText::_('LNG_APPROVED'); ?></label></div>
                                <div class="form-group">
                                    <fieldset id="approved" class="radio btn-group btn-group-yesno">
                                        <input type="radio" class="validate[required]" name="approved" id="approved3" value="<?php echo 1 ?>" <?php echo $this->item->approved==1? 'checked="checked"' :""?> />
                                        <label class="btn" id="label_approved3" for="approved3"><?php echo JTEXT::_("LNG_APPROVED")?></label>
                                        <input type="radio" class="validate[required]" name="approved" id="approved4" value="<?php echo -1 ?>"  <?php echo $this->item->approved==-1? 'checked="checked"' :""?> />
                                        <label class="btn" class="bg-danger" id="label_approved4" for="approved4"><?php echo JText::_('LNG_DISAPPROVED')?></label>
                                    </fieldset>
                                </div>
                            </div>
                        </fieldset>
                        <?php if(!isset($this->item->user_id)) {
                            $this->item->user_id = 0;
                        } $itemOwner = JBusinessUtil::getUser($this->item->user_id); ?>
                        <fieldset class="boxed">
        					<h2> <?php echo JText::_('LNG_USER');?></h2>
        					<p>User information</p>
        					<div class="form-box">
                                <?php JBusinessUtil::renderUserSelection($itemOwner->name, $this->item->user_id,"user_id"); ?>
        					</div>
        				</fieldset>
                    </div>
                <?php } ?>
                </div>
            </div>
        </div>

		<?php if(isset($isProfile)) { ?>
			<div class="row py-2">
				<div class="col-md-12">
					<div>
        				<?php if($this->item->id == 0) { ?>
                            <?php echo JBusinessUtil::renderTermsAndConditions(); ?>
            			<?php } ?>
        				<div class="button-row">
                            <button id="save-btn" type="button" class="btn btn-success button-save" onclick="saveEventCompanyInformation('apply')">
                                <i class="la la-edit"></i> <?php echo JText::_("LNG_SAVE")?>
                            </button>
                            <button type="button" class="btn btn-success button-close" onclick="saveEventCompanyInformation('save');">
                                <span class="ui-button-text"><i class="la la-check"></i> <?php echo JText::_("LNG_SAVE_AND_CLOSE")?></span>
                            </button>
                            <?php if(!$isNew) {?>
                                <button type="button" class="btn btn-success button-close" onclick="saveEventCompanyInformation('duplicate');">
                                        <span class="ui-button-text"><i class="icon-save-copy"></i> <?php echo JText::_("LNG_DUPLICATE")?></span>
                                </button>
                            <?php } ?>
        					<button type="button" class="btn btn-dark button-cancel" onclick="cancel()">
        						<i class="la la-close"></i> <?php echo JText::_("LNG_CANCEL")?>
        					</button>
        				</div>
        			</div>
        		</div>
    		</div>
		<?php } ?>
		
		<input type="hidden" name="option" value="<?php echo JBusinessUtil::getComponentName()?>" />
		<input type="hidden" name="task" id="task" value="" />
		<input type="hidden" name="edit_mode" id="edit_mode" value="" />
		<input type="hidden" name="recurring_id" id="recurring_id" value="<?php echo !empty($this->item->recurring_id)?$this->item->recurring_id:0 ?>" />
		<input type="hidden" name="id" value="<?php echo $this->item->id ?>" />
        <input type="hidden" name="view_count" id="view_count" value="<?php echo !empty($this->item->view_count)?$this->item->view_count:0 ?>" />

		<?php if(isset($isProfile)) { ?>
			<input type="hidden" id="user_id" name="user_id" value="<?php echo !empty($this->item->user_id)? $this->item->user_id : $user->id ?>" />
		 <?php } ?>

		<?php echo JHTML::_('form.token'); ?>
	</form>
</div>

<?php

if (isset($isProfile)) {
	echo JBusinessUtil::getMapGDPRModal();
}

JBusinessUtil::loadUploadScript(true, true, false);

$map_latitude = $this->appSettings->map_latitude;
if ((empty($map_latitude)) || (!is_numeric($map_latitude)))
    $map_latitude = 0;

$map_longitude = $this->appSettings->map_longitude;
if ((empty($map_longitude)) || (!is_numeric($map_longitude)))
    $map_longitude = 0;

$map_zoom = $this->appSettings->map_zoom;
if ((empty($map_zoom)) || (!is_numeric($map_zoom)))
    $map_zoom = 10;

$latitude = !empty($this->item->latitude)?$this->item->latitude:$map_latitude;
$longitude = !empty($this->item->longitude)?$this->item->longitude:$map_longitude;

$initparams =  array();
$initparams['map_latitude'] = $latitude;
$initparams['map_longitude'] = $longitude;
$initparams['map_zoom'] = empty($this->item->latitude)?(int)$map_zoom:15;
$initparams['longitude'] = $this->item->longitude;
$initparams['latitude'] = $this->item->latitude;
$initparams['is_admin'] = true;
if ($this->appSettings->map_type == MAP_TYPE_BING) {
	$initparams["key"] = $mapKey;
}

$initLocation = new stdClass();
$initLocation->longitude = $longitude;
$initLocation->latitude = $latitude;
$initLocations = array($initLocation);
?>

<script>    

    jQuery(".button-cancel").click(function() {
        jQuery(this).addClass("loader")
    })
    var maxVideos = <?php echo $this->appSettings->max_video ?>;
    var maxPictures = '<?php echo $maxPictures ?>';

	var maxCategories = <?php echo isset($this->item->package)?$this->item->package->max_categories :$this->appSettings->max_categories ?>;
	var eventFolder = '<?php echo EVENT_PICTURES_PATH.((int)$this->item->id)."/"?>';
	var eventFolderPath = '<?php echo JBusinessUtil::getUploadUrl() ?>&t=<?php echo strtotime("now")?>&picture_type=<?php echo  PICTURE_TYPE_EVENT?>&_path_type=1&_target=<?php echo urlencode(EVENT_PICTURES_PATH.((int)$this->item->id)."/")?>';
	var removePath = '<?php echo JBusinessUtil::getUploadUrl('remove') ?>&_path_type=3&_filename=';
	var eventAttachFolderPath = '<?php echo JBusinessUtil::getUploadUrl('uploadFile') ?>&t=<?php echo strtotime("now")?>&_path_type=4&_target=<?php echo urlencode(EVENT_PICTURES_PATH.((int)$this->item->id)."/")?>';

    var jbdAdminMapInstance;
    var uploadInstance;

    <?php $loadMap = ($attributeConfig["map"] != ATTRIBUTE_NOT_SHOW); ?>
    function initializeMap() {
	    <?php if($loadMap) { ?>
        jbdAdminMapInstance = JBDMapHelper.loadMapScript(
		    <?php echo json_encode($initLocations) ?>,
		    <?php echo json_encode($initparams)?>
        );

        jbdUtils.addAdminMapClickAction();
	    <?php } ?>
    }

    function validatePictures()
    {
        <?php if($attributeConfig["pictures"] == ATTRIBUTE_MANDATORY) { ?>
            var root = jQuery('#pictures-list');
            var list = root.find('.jbd-item-list');
            var items = list.find('.jbd-item');
            var value = items.length > 0 ? 'not-empty' : '';

            jQuery('#pictures_validate').val(value);
        <?php } ?>
    }

	window.addEventListener("load", function () {
        uploadInstance = JBDUploadHelper.getUploadInstance({
            'maxPictures': maxPictures,
            'maxVideos': maxVideos,
            'removePath': removePath
        });

        uploadInstance.checkNumberOfPictures();
        uploadInstance.checkNumberOfVideos();
        uploadInstance.imageUploaderDropzone(
            "#file-upload",
            '<?php echo JBusinessUtil::getUploadUrl() ?>&t=<?php echo strtotime("now")?>&_path_type=1&picture_type=<?php echo PICTURE_TYPE_GALLERY?>&_target=<?php echo urlencode(EVENT_PICTURES_PATH.($this->item->id)."/")?>',
            ".fileinput-button","<?php echo JText::_('LNG_DRAG_N_DROP',true); ?>",
            eventFolder ,
            <?php echo $allowedNr ?>,
            "addPicture"
        );
		jQuery( "#sortable" ).sortable();
		jQuery( "#sortable" ).disableSelection();

        jQuery('#pictures-list').jbdList({
            statusCallback: uploadInstance.changePictureStatus,
            deleteCallback: uploadInstance.deletePicture,
            statusSelector: 'picture_enable_',
            deleteMsg: "<?php echo JText::_('LNG_CONFIRM_DELETE_PICTURE') ?>"
        });

        jQuery('#attachment-list').jbdList({
            statusCallback: uploadInstance.changeAttachmentStatus,
            deleteCallback: uploadInstance.deleteAttachment,
            statusSelector: 'attachment_status_',
            deleteMsg: "<?php echo JText::_('LNG_CONFIRM_DELETE_ATTACHMENT') ?>"
        });

        jQuery("#sortable-attachment").sortable();
        jQuery("#sortable-attachment").disableSelection();

        uploadInstance.multiFileUploader(eventFolder, eventAttachFolderPath);
        uploadInstance.btn_removefile();
        uploadInstance.btn_removefile_at();

        jQuery('.bootstrap-tagsinput input').on('keypress', function(e){
            if (e.keyCode == 13){
                e.keyCode = 188;
                e.preventDefault();
            }
        });

        jQuery(".ajax-chosen-select").chosen({width: "95%",disable_search_threshold:-1,allow_single_deselect: true});

        if (jbdUtils.getProperty("isProfile") != 1) {
            var isProfile = false;
            var userId = 0;
        } else {
            var userId = '<?php echo $user->id ?>';
        }

        let urlGetCompanies = jbdUtils.getAjaxUrl('getCompaniesByStringAjax', 'companies', 'managecompanies');

        jQuery("#company_id").ajaxChosen({
                type: 'GET',
                url: urlGetCompanies,
                data: {
                    isProfile: isProfile,
                    userId: userId
                },
                dataType: 'json'
            },
            function (data) {
                var results = new Array();
                console.debug(data);
                jQuery.each(data, function (i, val) {
                    results.push({value: val.id, text: val.name});
                });
                return results;
            },
            {
                width: "95%",disable_search_threshold:-1,allow_single_deselect: true
            });

        jQuery("#associated-listings").ajaxChosen({
                type: 'GET',
                url: urlGetCompanies,
                data: {
                    isProfile: isProfile,
                    userId: userId,
                    ignore_user: true
                },
                dataType: 'json'
            },
            function (data) {
                var results = new Array();
                console.debug(data);
                jQuery.each(data, function (i, val) {
                    results.push({value: val.id, text: val.name});
                });
                return results;
            },
            {
                width: "95%",disable_search_threshold:-1,allow_single_deselect: true
            });

        jQuery("#item-form").validationEngine('attach');
        if(jQuery("#company_id_chosen input").length || jQuery("#company_id_chzn input").length){
            document.querySelector("#company_id_chosen input, #company_id_chzn input").placeholder = "<?php echo JText::_('LNG_COMPANY_SEARCH_HINT')  ?>";
        }

        jQuery(".chosen-select").chosen({width:"95%", disable_search_threshold: 5, placeholder_text_single: "<?php echo JText::_('LNG_SELECT_OPTION')  ?>" , placeholder_text_multiple: "<?php echo JText::_('LNG_SELECT_OPTION')  ?>"});
        jQuery(".chosen-select-categories").chosen({width:"95%", max_selected_options: maxCategories});

        jQuery('.timepicker').timepicker({ 'timeFormat': jbdUtils.getProperty("timeFormat"), 'minTime': '6:00am'});

        initializeMap();
        jbdUtils.initializeAdminAutocomplete(false);

        jQuery('select#categories').on('change', function() {
            var selected = jQuery('#main_subcategory option:selected').val();
            jQuery('select#main_subcategory').find('option').remove();
            jQuery('select#categories option:selected').each(function () {
                if (jQuery(this).length) {
                    var selCategoryOption = jQuery(this).clone();
                    selCategoryOption.removeAttr('selected');
                    jQuery('select#main_subcategory').append(selCategoryOption);
                    if(selCategoryOption.val() === selected) {
                        jQuery('select#main_subcategory').find('option').attr('selected', 'selected');
                    }
                    jbdUtils.updateChosenSelect('select#main_subcategory');
                }
            });

            var catId = jQuery('#main_subcategory option:selected').val();
            if(catId === 0 || typeof catId === "undefined" ) {
                catId = -1;
            }

			<?php if($this->appSettings->enable_attribute_category) { ?>
            jbdEvents.updateAttributes(catId, '<?php echo $this->item->id ?>');
			<?php } ?>
        });

        jQuery("#jrepeat1").click(function(){
            jbdEvents.repeatNone();
        });

        jQuery("#jrepeat2").click(function(){
            jbdEvents.repeatDaily();
        });

        jQuery("#jrepeat3").click(function(){
            jbdEvents.repeatWeekly();
        });

        jQuery("#jrepeat4").click(function(){
            jbdEvents.repeatMonthly();
        });

        jQuery("#jrepeat5").click(function(){
            jbdEvents.repeatYearly();
        });

        jQuery("#endson1").click(function(){
            jbdEvents.endsOnOccurances();
        });

        jQuery("#endson2").click(function(){
            jbdEvents.endsOnDate();
        });

        <?php if ($this->appSettings->limit_cities_regions == 1) { ?>
            //updateRegions();
            //updateCities();
        <?php } ?>
	});

    function saveEventCompanyInformation(task) {

        jQuery("#item-form").validationEngine('detach');
        var evt = document.createEvent("HTMLEvents");
        evt.initEvent("click", true, true);
        var tab = ("tab-"+jbdUtils.getProperty("defaultLang"));
        if(!(document.getElementsByClassName(tab)[0] === undefined || document.getElementsByClassName(tab)[0] === null))
            document.getElementsByClassName(tab)[0].dispatchEvent(evt);
        if (jbdUtils.validateCmpForm(true, <?php echo $attributeConfig["description"] == ATTRIBUTE_MANDATORY?'true':'false' ?>, task, validatePictures)) {
            return false;
        }
        
        jbdEvents.saveDates();

        jQuery("#item-form").validationEngine('attach');
        jQuery("#item-form #task").val('managecompanyevent.'+task);
        var form = document.adminForm;

        form.submit();
    }

    function cancel() {
        jQuery("#item-form #task").val('managecompanyevent.cancel');
        var form = document.adminForm;
        form.submit();
    }

	<?php if ($this->appSettings->limit_cities_regions == 1) { ?>
    var showCountryAttr = <?php echo $attributeConfig["country"]!=ATTRIBUTE_NOT_SHOW ?'true':'false'; ?>

    function updateCities(callback)
    {
        var regionIds = jQuery('#administrative_area_level_1').val();

        var dataSelected = [];
        jQuery('#locality').find('option:selected').each(function(){
            dataSelected.push(jQuery(this).val());
        });

        if (regionIds == null) {
            jQuery('#locality').empty();
            jbdUtils.updateChosenSelect('#locality');
            return;
        }
        let url = jbdUtils.getAjaxUrl('getCitiesByRegionsAjax', 'event', 'managecompanyevent');
        jQuery.ajax({
            type: 'GET',
            url: url,
            data: {regionName: regionIds},
            dataType: 'json',
            success: function (data) {
                var selectedVar;
                jQuery('#locality').empty();
                jQuery('#locality').append('<option value=""><?php echo JText::_('LNG_SELECT_CITY') ?></option>');
                jQuery.each(data, function (i, val) {
                    selectedVar = "";
                    if (jQuery.inArray(val.name, dataSelected) != '-1'  && dataSelected.length > 0) {
                        selectedVar = "selected";
                    }
                    jQuery('#locality').append('<option ' + selectedVar + ' value="' + val.name + '">' + val.name + '</option>');
                });

                if (typeof callback !== "undefined") {
                    callback();
                }
            }
        });
    }

    function updateRegions(callback)
    {
        var countryId = jQuery('#country').val();

        var dataSelected = [];
        jQuery('#administrative_area_level_1').find('option:selected').each(function(){
            dataSelected.push(jQuery(this).val());
        });

        if (showCountryAttr && countryId == null) {
            jQuery('#administrative_area_level_1').empty();
            jbdUtils.updateChosenSelect('#administrative_area_level_1');
            return;
        }
        let url = jbdUtils.getAjaxUrl('getRegionsByCountryAjax', 'event', 'managecompanyevent');
        jQuery.ajax({
            type: 'GET',
            url: url,
            data: {countryId: countryId},
            dataType: 'json',
            success: function (data) {
                var selectedVar;
                jQuery('#administrative_area_level_1').empty();
                jQuery('#administrative_area_level_1').append('<option value=""><?php echo JText::_('LNG_SELECT_REGION') ?></option>');
                jQuery.each(data, function (i, val) {
                    selectedVar = "";
                    if (jQuery.inArray(val.name, dataSelected) != '-1' && dataSelected.length > 0) {
                        selectedVar = "selected";
                    }
                    jQuery('#administrative_area_level_1').append('<option ' + selectedVar + ' value="' + val.name + '">' + val.name + '</option>');
                });

                if (jQuery('#administrative_area_level_1').val().length > 0) {
                    updateCities();
                } else {
                    updateCities(function(){
                        jQuery('#locality').empty();
                        jQuery('#locality').append('<option value=""><?php echo JText::_('LNG_SELECT_CITY') ?></option>');
                    });
                }

                if (typeof callback !== "undefined") {
                    callback();
                }
            }
        });
    }
	<?php } ?>
</script>