<?php
/**
 * @package    JBusinessDirectory
 *
 * @author     CMSJunkie http://www.cmsjunkie.com
 * @copyright  Copyright (C) 2007 - 2021 CMSJunkie. All rights reserved.
 * @license    https://www.gnu.org/licenses/agpl-3.0.en.html
 */

defined('_JEXEC') or die('Restricted access');
require_once HELPERS_PATH.'/helper.php';

/**
 * The HTML Menus Menu Menus View.
 *
 * @package     JBusinessDirectory
 * @subpackage  com_jbusinessdirectory
 */
class JBusinessDirectoryViewDiscounts extends JBusinessDirectoryAdminView {
	protected $items;
	protected $pagination;
	protected $state;

	/**
	 * Display the view
	 */
	public function display($tpl = null) {
		$this->items = $this->get('Items');

		$this->pagination = $this->get('Pagination');
		$this->state      = $this->get('State');

		$this->packages = $this->get('PackagesOption');
		$this->states   = $this->get('States');

		$this->filterForm    = $this->get('FilterForm');
		$this->activeFilters = $this->get('ActiveFilters');

		JBusinessDirectoryHelper::addSubmenu('discounts');

		// Check for errors.
		if (count($errors = $this->get('Errors'))) {
			JFactory::getApplication()->enqueueMessage(implode("\n", $errors), 'error');
			return false;
		}

		$layout = JFactory::getApplication()->input->get("layout");
		if (isset($layout)) {
			$tpl = $layout;
		}

		$this->addToolbar();
		parent::display($tpl);
	}

	/**
	 * Add the page title and toolbar.
	 *
	 * @since   1.6
	 */
	protected function addToolbar() {
		$canDo = JBusinessDirectoryHelper::getActions();
		$user  = JBusinessUtil::getUser();
		$bar   = JToolBar::getInstance('toolbar');

		JToolBarHelper::title('J-BusinessDirectory : ' . JText::_('LNG_DISCOUNTS'), 'generic.png');
		if ($canDo->get('core.create') || (count($user->getAuthorisedCategories('com_jbusinessdirectory', 'core.create'))) > 0) {
			JToolbarHelper::addNew('discount.add');
		}

		if (($canDo->get('core.edit'))) {
			JToolbarHelper::editList('discount.edit');
		}

		if ($canDo->get('core.delete')) {
			JToolbarHelper::divider();
			JToolbarHelper::deleteList('', 'discounts.delete');
		}

		JToolBarHelper::custom('discounts.generateDiscounts', 'plus', 'plus', JText::_("LNG_GENERATE"), false, false);

		if ($canDo->get('core.admin')) {
			JToolbarHelper::preferences('com_jbusinessdirectory');
		}

		$dhtml = '<button data-toggle="modal" onclick="jQuery( \'#export-model\' ).jbdModal();" class="btn btn-small">
		<i class="icon-download" title="' . JText::_('LNG_EXPORT_CSV') . '"></i>' . JText::_('LNG_EXPORT_CSV') . '</button>';
		$bar->appendButton('Custom', $dhtml, 'discounts.showExportCsv');

		//JToolBarHelper::custom('discounts.showExportCsv', 'download', 'stats.png', JText::_('LNG_EXPORT_CSV'), false, false );

		JToolbarHelper::divider();
		JToolBarHelper::custom('discounts.back', 'dashboard', 'dashboard', JText::_("LNG_CONTROL_PANEL"), false, false);
		JToolBarHelper::help('', false, DOCUMENTATION_URL . 'businessdiradmin.html#discounts');
	}
}
