<?php
/**
 * @package    JBusinessDirectory
 *
 * @author CMSJunkie http://www.cmsjunkie.com
 * @copyright  Copyright (C) 2007 - 2021 CMSJunkie. All rights reserved.
 * @license   https://www.gnu.org/licenses/agpl-3.0.en.html
 */

defined('_JEXEC') or die('Restricted access');

// Include the component HTML helpers.
JHtml::addIncludePath(JPATH_COMPONENT.'/helpers/html');

// Load the tooltip behavior.

?>

<script type="text/javascript">
window.addEventListener('load', function() {
	Joomla.submitbutton = function(task)
	{	
		if (task == 'discount.cancel' || task == 'discount.aprove' || task == 'discount.disaprove' || !jbdUtils.validateCmpForm()){
			Joomla.submitform(task, document.getElementById('item-form'));
		}
    }
});
</script>

<?php 
$appSetings = JBusinessUtil::getApplicationSettings();
?>

<div id="jbd-container" class="jbd-container jbd-edit-container">
    <div id="jbd-edit-container" class="jbd-edit-container">
        <form action="<?php echo JRoute::_('index.php?option=com_jbusinessdirectory&layout=edit&id='.(int) $this->item->id); ?>" method="post" name="adminForm" id="item-form" class="form-horizontal">
            <div class="row">
                <div class="col-md-7">
                    <div class="clr mandatory oh">
                        <p><?php echo JText::_("LNG_REQUIRED_INFO")?></p>
                    </div>
                    <fieldset class="boxed">
                        <h2> <?php echo JText::_('LNG_GENERATE_DISCOUNTS');?></h2>
                        <div class="form-container">
                            <div class="form-group">
                                <div  class="form-detail req"></div>
                                <label for="subject"><?php echo JText::_('LNG_NR_DISCOUNTS')?> </label>
                                <input type="text" name="nr_discounts" id="nr_discounts" class="form-control validate[required]" value="<?php echo $this->item->name ?>"  maxLength="100">
                            </div>

                            <div class="form-group">
                                <label for="startDate"><?php echo JText::_('LNG_START_DATE')?> </label>
                                <?php echo JHTML::_('calendar', $this->item->start_date, 'start_date', 'start_date', $appSetings->calendarFormat, array('class'=>'form-control calendar-date', 'size'=>'10',  'maxlength'=>'10')); ?>
                            </div>

                            <div class="form-group">
                                <label for="endDate"><?php echo JText::_('LNG_END_DATE')?> </label>
                                <?php echo JHTML::_('calendar', $this->item->end_date, 'end_date', 'end_date', $appSetings->calendarFormat, array('class'=>'form-control calendar-date', 'size'=>'10',  'maxlength'=>'10')); ?>
                            </div>


                            <div class="form-group">
                                <label for="package_ids"><?php echo JText::_('LNG_SELECT_PACKAGE')?></label>

                                <select multiple="multiple" id="package_ids" class="chosen-select" name="package_ids[]">
                                    <option  value=""> </option>
                                    <?php
                                    foreach( $this->packages as $package )
                                    {
                                        $selected = false;
                                        foreach($this->item->package_ids as $pId){
                                            if($pId == $package->id)
                                                $selected = true;
                                        }
                                    ?>
                                    <option <?php echo $selected ? "selected" : ""?> value='<?php echo $package->id ?>'>
                                        <?php echo $package->name ?>
                                    </option>
                                    <?php
                                    }
                                    ?>
                                </select>
                            </div>


                            <div class="form-group">
                                <div  class="form-detail req"></div>
                                <label for="code"><?php echo JText::_('LNG_COUPON_CODE_PREFIX')?></label>
                                <input type="text" name="code_prefix" id="code_prefix" class="form-control validate[required]" value=""  maxLength="50">
                            </div>

                            <div class="form-group">
                                <div  class="form-detail req"></div>
                                <label for="code"><?php echo JText::_('LNG_COUPON_CODE_LENGTH')?></label>
                                <input type="text" name="code_length" id="code_length" class="form-control validate[required]" value=""  maxLength="50">
                            </div>

                            <div class="form-group">
                                <div  class="form-detail req"></div>
                                <label for="uses_per_coupon"><?php echo JText::_('LNG_USES_PER_COUPON')?></label>
                                <input type="text" name="uses_per_coupon" id="uses_per_coupon" class="form-control validate[required]" value="<?php echo $this->item->uses_per_coupon ?>"  maxLength="50">
                                <span><?php echo JText::_("LNG_USED").": ". $this->item->coupon_used?></span>
                            </div>

                            <div class="form-group">
                                <div  class="form-detail req"></div>
                                <label for="companyId"><?php echo JText::_('LNG_VALUE')?></label>
                                <input type="text" name="value" id="value" class="form-control validate[required]" value="<?php echo $this->item->value ?>"  maxLength="50">
                            </div>
                            <div class="form-group">
                                <div  class="form-detail req"></div>

                                <fieldset id="price-type" class="radio btn-group btn-group-yesno">
                                    <input type="radio" class="validate[required]" name="price_type" id="price-value" value="1" <?php echo $this->item->price_type==1? 'checked="checked"' :""?> />
                                    <label class="btn" for="price-value"><?php echo JText::_('LNG_VALUE')?></label>
                                    <input type="radio" class="validate[required]" name="price_type" id="price-percent" value="2" <?php echo $this->item->price_type==2? 'checked="checked"' :""?> />
                                    <label class="btn" for="price-percent"><?php echo JText::_('LNG_PERCENT')?></label>
                                </fieldset>
                            </div>

                            <div class="form-group">
                                <label for="state"><?php echo JText::_('LNG_STATE')?></label>
                                <select name="state" id="state" class="form-control input-medium">
                                    <?php echo JHtml::_('select.options', $this->states, 'value', 'text', $this->item->state);?>
                                </select>
                            </div>
                        </div>
                        </fieldset>

                    <input type="hidden" name="option" value="<?php echo JBusinessUtil::getComponentName()?>" />
                    <input type="hidden"name="task" id="task" value="" />
                    <input type="hidden" name="id" value="<?php echo $this->item->id ?>" />
                    <?php echo JHTML::_( 'form.token' ); ?>
                </div>
            </div>
        </form>
    </div>
</div>

<script>
	var packageList = null;
	window.addEventListener('load', function(){
		jQuery(".chosen-select").chosen({width:"95%", disable_search_threshold: 5, placeholder_text_single: "<?php echo JText::_('LNG_SELECT_OPTION')  ?>" , placeholder_text_multiple: "<?php echo JText::_('LNG_SELECT_OPTION')  ?>"});
	});

	function checkAllPackages(){
		uncheckAllPackages();
		jQuery(".cities_ids-select option").each(function(){ 
			if(jQuery(this).val()!=""){
				packageList.add(jQuery(this));
			}
		});

		jQuery("#package_ids option").each(function(){ 
			jQuery(this).attr("selected","selected"); 
		});
	}  

	function uncheckAllPackages(){
		jQuery("#package_ids option").each(function(){ 
			jQuery(this).removeAttr("selected"); 
		});
		packageList.remove();
	}
</script>
