<?php
/**
 * @package    JBusinessDirectory
 *
 * @author CMSJunkie http://www.cmsjunkie.com
 * @copyright  Copyright (C) 2007 - 2021 CMSJunkie. All rights reserved.
 * @license   https://www.gnu.org/licenses/agpl-3.0.en.html
 */

defined('_JEXEC') or die('Restricted access');
JHtml::addIncludePath(JPATH_COMPONENT.'/helpers/html');
JHtml::_('bootstrap.tooltip');
JHtml::_('behavior.multiselect');
 JBusinessUtil::initializeChosen();

use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Multilanguage;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Layout\LayoutHelper;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Session\Session;

$listOrder	= $this->escape($this->state->get('list.ordering'));
$listDirn	= $this->escape($this->state->get('list.direction'));
$ordering 	= ($listOrder == 'a.lft');
$saveOrder 	= ($listOrder == 'a.lft' && strtolower($listDirn) == 'asc');

$canOrder	= true;
$saveOrder	= $listOrder == 'ct.id';
?>

<script type="text/javascript">
window.addEventListener('load', function() {
	Joomla.submitbutton = function(task) {
		if (task != 'companyarticles.delete' || confirm('<?php echo JText::_('COM_JBUSINESS_DIRECTORY_ITEMS_CONFIRM_DELETE', true);?>')) {
			Joomla.submitform(task);
		}
	}
});
</script>

<div id="jbd-container" class="jbd-container">
    <form action="<?php echo JRoute::_('index.php?option=com_jbusinessdirectory&view=companyarticles');?>" method="post" name="adminForm" id="adminForm">
        <div id="j-main-container" class="j-main-container">
            <?php
            // Search tools bar
            echo JLayoutHelper::render('joomla.searchtools.default', array('view' => $this, 'options' => array('filtersHidden' =>JBusinessUtil::setFilterVisibility($this->state))));
            ?>
        </div>
        <div class="clr clearfix"></div>

        <?php if (empty($this->items)) { ?>
            <div class="alert alert-warning">
                <?php echo JText::_('JGLOBAL_NO_MATCHING_RESULTS'); ?>
            </div>
        <?php } else { ?>
    	<table class="jtable"  id="itemList">
    		<thead class="jtable-head">
    			<tr class="jtable-head-row">
                    <th class="jtable-head-row-data" width="1%"></th>
                    <th class="jtable-head-row-data" width="1%">#</th>
                    <th class="jtable-head-row-data" width="1%">
                        <div class="d-flex justify-content-center align-items-center">
                            <div class="jradio">
                                <input id="jradio-2" type="checkbox" title="<?php echo JText::_('JGLOBAL_CHECK_ALL');?>" onclick="Joomla.checkAll(this)" />
                                <label for="jradio-2"></label>
                            </div>
                        </div>
                    </th>
    				<th class="jtable-head-row-data"><?php echo HTMLHelper::_('searchtools.sort', 'LNG_TITLE', 'ct.title', $listDirn, $listOrder); ?></th>
    				<th class="jtable-head-row-data"><?php echo HTMLHelper::_('searchtools.sort', 'LNG_COMPANY', 'c.name', $listDirn, $listOrder); ?></th>
    				<th class="jtable-head-row-data"><?php echo HTMLHelper::_('searchtools.sort', 'LNG_AUTHOR', 'ua.name', $listDirn, $listOrder); ?></th>
    				<th class="jtable-head-row-data"><?php echo HTMLHelper::_('searchtools.sort', 'LNG_DATE_CREATED', 'ct.created', $listDirn, $listOrder); ?></th>
    				<th class="jtable-head-row-data"><?php echo HTMLHelper::_('searchtools.sort', 'JGRID_HEADING_ID', 'ct.id', $listDirn, $listOrder); ?></th>
    			</tr>
    		</thead>
    		<tfoot>
    			<tr>
    				<td colspan="15"><?php echo $this->pagination->getListFooter(); ?></td>
    			</tr>
    		</tfoot>
    		<tbody class="jtable-body">
    			<?php $count = count($this->items); ?>
    			<?php $nrcrt = 1;$i=0;
    			foreach ($this->items as $index => $item) :
    				$ordering  = ($listOrder == 'ct.id');
    				$canCreate = true;
    				$canEdit   = true;
    				$canChange = true;
    				?>
    				<tr class="jtable-body-row">
                        <td class="jtable-body-row-data">
                            <div class="d-flex align-items-center">
                                <div id="item-status-<?php echo $item->id?>" class="jtable-body-status bg-success"></div>
                            </div>
                        </td>
    					<td class="jtable-body-row-data"><?php echo $nrcrt++?></td>
    					<td class="jtable-body-row-data">
                            <?php echo HTMLHelper::_('jbdgrid.id', $i, $item->id); ?>
                        </td>
    					<td class="jtable-body-row-data">
    						<?php if ($canEdit) : ?>
    							<a target="_blank" class="hasTooltip" href="<?php echo JRoute::_('index.php?option=com_content&task=article.edit&id=' . $item->id); ?>" title="<?php echo JText::_('JACTION_EDIT'); ?>">
    								<?php echo $this->escape($item->title); ?>
    							</a>
    						<?php else : ?>
    							<span title="<?php echo JText::sprintf('JFIELD_ALIAS_LABEL', $this->escape($item->alias)); ?>"><?php echo $this->escape($item->title); ?></span>
    						<?php endif; ?>
    						<span class="small break-word">
    							<?php echo JText::sprintf('JGLOBAL_LIST_ALIAS', $this->escape($item->alias)); ?>
    						</span>
    					</td>
    					<td class="jtable-body-row-data">
    						<?php echo $item->company_name?>
    					</td>
    					<td class="jtable-body-row-data">
    						<a class="hasTooltip" href="<?php echo JRoute::_('index.php?option=com_users&task=user.edit&id=' . (int) $item->created_by); ?>" title="<?php echo JText::_('JAUTHOR'); ?>">
    									<?php echo $this->escape($item->author_name); ?></a>
    					</td>
    					<td class="jtable-body-row-data">
    						<?php echo $item->created?>
    					</td>
    					<td class="jtable-body-row-data"><?php echo (int) $item->id; ?></td>
    				</tr>
    			<?php $i++; endforeach; ?>
    		</tbody>
    	</table>
        <?php } ?>

        <input type="hidden" name="task" value="" />
    	<input type="hidden" name="id" value="" />
    	<input type="hidden" name="boxchecked" value="0" />
    	<?php echo JHTML::_( 'form.token' ); ?> 
    </form>
</div>