<?php
/**
 * @package    JBusinessDirectory
 * @subpackage  com_jbusinessdirectory
 *
 * @copyright   Copyright (C) 2007 - 2015 CMS Junkie. All rights reserved.
 * @license     GNU General Public License version 2 or later;
 */

defined('_JEXEC') or die('Restricted access');

/**
 * The HTML  View.
 */

JBusinessUtil::loadJQueryUI();
JBusinessUtil::enqueueScript('libraries/chosen/ajax-chosen.min.js');

JBusinessUtil::includeValidation();

require_once HELPERS_PATH.'/helper.php';

class JBusinessDirectoryViewAnnouncement extends JBusinessDirectoryAdminView {
	protected $item;
	protected $state;

	/**
	 * Display the view
	 */
	public function display($tpl = null) {
		$this->item	 = $this->get('Item');
		$this->state = $this->get('State');
		$this->actions = JBusinessUtil::getAnnouncementActions();
		$this->translations = JBusinessDirectoryTranslations::getAllTranslations(ANNOUNCEMENT_DESCRIPTION_TRANSLATION, $this->item->id);
		$this->languages    = JBusinessUtil::getLanguages();

		$this->companyOptions = JBusinessUtil::getCompaniesOptions($this->item->company_id);
		
		// Check for errors.
		if (count($errors = $this->get('Errors'))) {
			JError::raiseError(500, implode("\n", $errors));
			return false;
		}
		$this->addToolbar();

		parent::display($tpl);
	}

	/**
	 * Add the page title and toolbar.
	 *
	 * @since   1.6
	 */
	protected function addToolbar() {
		$canDo = JBusinessDirectoryHelper::getActions();
		$input = JFactory::getApplication()->input;
		$input->set('hidemainmenu', true);
		$isNew = ($this->item->id == 0);

		JToolbarHelper::title(JText::_($isNew ? 'COM_JBUSINESSDIRECTORY_NEW_ANNOUNCEMENT' : 'COM_JBUSINESSDIRECTORY_EDIT_ANNOUNCEMENT'), 'menu.png');

		if ($canDo->get('core.edit')) {
			JToolbarHelper::apply('announcement.apply');
			JToolbarHelper::save('announcement.save');
		}

		JToolbarHelper::cancel('announcement.cancel', 'JTOOLBAR_CLOSE');

		JToolbarHelper::divider();
		JToolbarHelper::help('JHELP_JBUSINESSDIRECTORY_ANNOUNCEMENT_EDIT');
	}
}
