<?php
/**
 * @package    JBusinessDirectory
 *
 * @author CMSJunkie http://www.cmsjunkie.com
 * @copyright  Copyright (C) 2007 - 2021 CMSJunkie. All rights reserved.
 * @license   https://www.gnu.org/licenses/agpl-3.0.en.html
 */
 
defined('_JEXEC') or die('Restricted access');
?>

<style>

.container-fluid.container-main, .subhead-collapse{
	margin: 0 !important;
	padding: 0 !important;	
}

header.header{
	display: none;
}
</style>

<div id="jdb-wrapper" class="jbd-container jdb-wrapper-admin tmpl-style-1">
	<div id="menu-button" class="menu-button btn-primary">
		<i class="la la-bars"></i> <?php echo JText::_("LNG_SHOW_MENU") ?>
	</div>
	<nav class="navbar-default navbar-static-side closed" role="navigation" id="dir-navigation">
		<div class="sidebar-collapse">
			<ul class="nav metismenu" id="side-menu">
				<li class="nav-header">
					<div class="navbar-minimalize minimalize-styl-2"><i class="la la-bars"></i> </div>
				</li>
				<?php foreach ($template->menus as $menu) {?>
					<li class="<?php echo isset($menu["active"])?"active":""?>">
						<a href="<?php echo JRoute::_($menu["link"])?>">
							<i class="<?php echo $menu["icon"] ?>"></i>	<span class="nav-label"><?php echo $menu["title"] ?></span>
							<?php if (isset($menu['display-unread-message'])) { ?>
								<span class="nav-label" id="message-unreaded"></span>
							<?php } ?>

							<?php if (isset($menu["new"])) {?>
								<span class="label label-info pull-right"><?php echo JText::_("LNG_NEW")?></span>
							<?php } ?>
								
							 <?php if (isset($menu["submenu"])) {?> 
								 <span class="la la-menu-arrow"></span>
							 <?php } ?>
						</a>
						 <?php if (isset($menu["submenu"])) {?> 
							<ul class="nav nav-second-level">
								<?php foreach ($menu["submenu"] as $submenu) {?>
									<li class="<?php echo isset($submenu["active"])?"active":""?>">
										<a href="<?php echo JRoute::_($submenu["link"])?>">
											<?php echo $submenu["title"] ?>
											<?php if (isset($submenu["new"])) {?>
												<span class="label label-info pull-right"><?php echo JText::_("LNG_NEW")?></span>
											<?php } ?>
										</a>
									</li>
								<?php } ?>
							</ul>
						 <?php } ?>
					</li>
				<?php } ?>
			</ul>
		</div>
		<div class="user-manual-section">			
			<h3> User Manual </h3>
			<p> Need help? Use our online documentation to get answers for most of your questions in setting up the J-BusinessDirectory functionality. </p>
			<a href="http://cmsjunkie.com/docs/jbusinessdirectory/index.html" target="_blank" > <button class="btn btn-small btn-success"> Read it now </button> </a>
		</div>
	</nav>
	<div id="page-wrapper">
		<div class="normalheader transition animated fadeIn">
			<div class="hpanel">
				<div class="panel-body">
					<div class="pull-right m-t-lg" id="hbreadcrumb">
						<ol class="hbreadcrumb breadcrumb">
							<li><a href="<?php echo JRoute::_("index.php?option=com_jbusinessdirectory")?>"><?php echo JText::_("LNG_DASHBOARD")?></a></li>
							<li class="active">
								<span><?php echo $this->section_name?></span>
							</li>
						</ol>
					</div>
					<h2 class="font-light m-b-xs">
						<?php echo $this->section_name?>
					</h2>
					<small><?php echo $this->section_description ?></small>
				</div>
			</div>
		</div>
		<div id="content-wrapper">
			<?php echo $template->content?>
			<div class="clear"></div>
		</div>
	</div>
</div>

<script>
	window.addEventListener('load', function() {

		//colapse the Joomla!4 main menu when JBD active
		var menuClass = jQuery("#menu-collapse-icon").attr('class');
		console.debug(menuClass);
		if(menuClass && menuClass.includes("icon-toggle-off")){
			console.debug("toggle on");
			jQuery("#menu-collapse").trigger("click");
			
			var wrapper = document.getElementById('wrapper');
			wrapper.classList.add('closed');
			localStorage.setItem('atum-sidebar', 'closed');

			// window.dispatchEvent(new CustomEvent('joomla:menu-toggle', {
			// 	detail: wrapper.classList.contains('closed') ? 'closed' : 'open',
			// 	bubbles: true,
			// 	cancelable: true
			// }));
		}
	
		// Minimalize menu
		jQuery('.navbar-minimalize').click(function () {
			jQuery("#jdb-wrapper").toggleClass("mini-navbar");
			SmoothlyMenu();
		
		//show hide the user manual section
		jQuery('.user-manual-section').fadeIn(1000);
		  if (jQuery('#jdb-wrapper').hasClass('mini-navbar')){
			jQuery('.user-manual-section').hide();
		  }
	
		});
	
		jQuery(".subhead").removeClass("subhead-fixed");
		
		setupNav();
		jQuery(window).bind("resize", function () {
			setupNav();
		});
	
		 // MetisMenu
		jQuery("#side-menu").metisMenu();
	
		// Collapse ibox function
		jQuery('.collapse-link').click(function () {
			var ibox = jQuery(this).closest('div.ibox');
			var button = jQuery(this).find('i');
			var content = ibox.find('div.ibox-content');
			content.slideToggle(200);
			button.toggleClass('la la-chevron-up').toggleClass('la la-chevron-down');
			ibox.toggleClass('').toggleClass('border-bottom');
			setTimeout(function () {
				ibox.resize();
				ibox.find('[id^=map-]').resize();
			}, 50);
		});
	
		// Close ibox function
		jQuery('.close-link').click(function () {
			var content = jQuery(this).closest('div.ibox');
			content.remove();
		});
	
		if(jQuery("#page-wrapper").height() < jQuery("#dir-navigation").height())
			   jQuery("#page-wrapper").css("height", jQuery("#dir-navigation").height()+'px');
	
		// Fullscreen ibox function
		jQuery('.fullscreen-link').click(function() {
			var ibox = jQuery(this).closest('div.ibox');
			var button = jQuery(this).find('i');
			jQuery('body').toggleClass('fullscreen-ibox-mode');
			button.toggleClass('la-expand').toggleClass('la-compress');
			ibox.toggleClass('fullscreen');
			setTimeout(function() {
				jQuery(window).trigger('resize');
			}, 100);
		});
	
		jQuery("#menu-button").click(function(){
			 jQuery("#side-menu").slideToggle(500);   
			 if (jQuery('#side-menu').height()<10){
				 jQuery(this).html("<?php echo "<i class='la la-bars'></i> ".JText::_("LNG_HIDE_MENU")?>");
			 }else{
				 jQuery(this).html("<?php echo "<i class='la la-bars'></i> ".JText::_("LNG_SHOW_MENU")?>");
			 }
		});
	});

	function setupNav(){
		if (jQuery(this).width() < 769 && jQuery(this).width() > 556) {
			jQuery('#jdb-wrapper').addClass('mini-navbar')
		} else {
			jQuery('#jdb-wrapper').removeClass('mini-navbar')
		}
	}

	function SmoothlyMenu() {
		if (!jQuery('#side-menu').hasClass('mini-navbar') || jQuery('body').hasClass('body-small')) {
			// Hide menu in order to smoothly turn on when maximize menu
			jQuery('#side-menu').hide();
			// For smoothly turn on menu
			setTimeout(
				function () {
					jQuery('#side-menu').fadeIn(500);
				}, 100);
		} else {
			// Remove all inline style from jquery fadeIn function to reset menu state
			jQuery('#side-menu').removeAttr('style');
		}
	}
</script>
