<?php
/**
 * @package    JBusinessDirectory
 *
 * @author CMSJunkie http://www.cmsjunkie.com
 * @copyright  Copyright (C) 2007 - 2021 CMSJunkie. All rights reserved.
 * @license   https://www.gnu.org/licenses/agpl-3.0.en.html
 */
defined('_JEXEC') or die('Restricted access');

class TableCompanyArticles extends JTable {

	/**
	 * Constructor
	 *
	 * @param object Database connector object
	 */
	public function __construct(&$db) {
		parent::__construct('#__jbusinessdirectory_company_articles', 'article_id', $db);
	}

	public function setKey($k) {
		$this->_tbl_key = $k;
	}

	public function getCompanyArticles($companyId) {
		$db =JFactory::getDBO();
		$query = "select *
                  from #__jbusinessdirectory_company_articles ca
                  inner join #__content ct on ct.id =  ca.article_id
                  where company_id=$companyId and ct.state = 1
                  order by ct.created desc";
		$db->setQuery($query);
		return $db->loadObjectList();
	}

	public function getArticleTitle($articleId){
		$db = JFactory::getDBO();
		$query = "select title from #__content 
		where id = $articleId";
		$db->setQuery($query);
		return $db->loadObject();
	}
}
