<?php
/**
 * @package    JBusinessDirectory
 *
 * @author CMSJunkie http://www.cmsjunkie.com
 * @copyright  Copyright (C) 2007 - 2021 CMSJunkie. All rights reserved.
 * @license   https://www.gnu.org/licenses/agpl-3.0.en.html
 */

// No direct access to this file
defined('_JEXEC') or die('Restricted access');

if(!defined('DS')) define('DS', "/");

if (! defined('BD_PICTURES_UPLOAD_PATH')) {
	define('BD_PICTURES_UPLOAD_PATH', JPATH_ROOT . '/media/com_jbusinessdirectory/pictures');
}

use Joomla\CMS\Language\LanguageHelper;
/**
 * Script file of HelloWorld plugin
 * Group: Universe
 */
class com_jBusinessDirectoryInstallerScript
{
    /**
     * Method to install the extension
     * $parent is the class calling this method
     *
     * @return void
     */
    function install($parent)
    {

    }

    /**
     * Method to uninstall the extension
     * $parent is the class calling this method
     *
     * @return void
     */
    function uninstall($parent)
    {
        $db = JFactory::getDBO();
        $db = JFactory::getDBO();
        $query = "SELECT `extension_id` FROM `#__extensions` WHERE `type`='module' AND element = 'mod_jbusinessdirectory_icons'";
        $db->setQuery($query);
        $extension = $db->loadObject();
        if (!empty($extension)) {
            $installer = new JInstaller;
            $result = $installer->uninstall('module', $extension->extension_id);
        }

        $query = "SELECT `extension_id` FROM `#__extensions` WHERE `type`='plugin' AND element = 'urltranslator'";
        $db->setQuery($query);
        $extension = $db->loadObject();
        if (!empty($extension)) {
            $installer = new JInstaller;
            $result = $installer->uninstall('plugin', $extension->extension_id);
        }

    }

    /**
     * Method to update the extension
     * $parent is the class calling this method
     *
     * @return void
     */
    function update($parent)
    {

    }

    /**
     * Method to run before an install/update/uninstall method
     * $parent is the class calling this method
     * $type is the type of change (install, update or discover_install)
     *
     * @return void
     */
    function preflight($type, $parent)
    {
        $db = JFactory::getDBO();
        // $db->setQuery(" UPDATE #__extensions SET enabled=0 WHERE element='urltranslator' ");
        // $db->execute();

		$noImageName = BD_PICTURES_UPLOAD_PATH . '/no_image.jpg';
		$newNoImageName = BD_PICTURES_UPLOAD_PATH . '/new_no_image.jpg';
		if(file_exists($noImageName)){
			rename($noImageName, $newNoImageName);
		}

        $query = "SHOW TABLES LIKE '%__jbusinessdirectory_statistics_archive%'";
        $db->setQuery("$query");
        $result = $db->loadObject();
        $tableExists = !empty($result);
        	
        if($tableExists){
            //remove duplicates
            $query = " DELETE `a`
                    FROM  `#__jbusinessdirectory_statistics_archive` AS `a`,
                            `#__jbusinessdirectory_statistics_archive` AS `b`
                        WHERE
                        a.id> 0 and 
                        `a`.`id` < `b`.`id`
                        AND (`a`.`item_id` =`b`.`item_id` ) and  (`a`.`item_type` =`b`.`item_type` ) and (`a`.`date` =`b`.`date` ) and  (`a`.`type` =`b`.`type` )";
            $db->setQuery($query); 
            $db->execute();           
        }

        $query = "SHOW TABLES LIKE '%__jbusinessdirectory_search_logs_archive%'";
        $db->setQuery("$query");
        $result = $db->loadObject();
        $tableExists = !empty($result);
        	
        if($tableExists){
            //remove duplicates
            $query = " DELETE `a`
                    FROM  `#__jbusinessdirectory_search_logs_archive` AS `a`,
                            `#__jbusinessdirectory_search_logs_archive` AS `b`
                        WHERE
                        a.id> 0 and 
                        `a`.`id` < `b`.`id`
                        AND (`a`.`object_type` =`b`.`object_type` ) and  (`a`.`item_type` =`b`.`item_type` ) and (`a`.`date` =`b`.`date` ) and  (`a`.`value` =`b`.`value` )";
            $db->setQuery($query); 
            $db->execute();           
        }

    }

    /**
     * Method to run after an install/update/uninstall method
     * $parent is the class calling this method
     * $type is the type of change (install, update or discover_install)
     *
     * @return void
     */
    function postflight($type, $parent)
    {

        if ( $type == 'uninstall' ) {
            return;
        }

        self::deleteUpdateFiles();

		$defaultNoImageName = BD_PICTURES_UPLOAD_PATH . '/no_image.jpg';
		$newDefaultNoImageName = BD_PICTURES_UPLOAD_PATH . '/old_no_image.jpg';
		if(file_exists($defaultNoImageName)){
			rename($defaultNoImageName, $newDefaultNoImageName);
		}

        $noImageName =  BD_PICTURES_UPLOAD_PATH . '/new_no_image.jpg';
		$newNoImageName =  BD_PICTURES_UPLOAD_PATH . '/no_image.jpg';
		if(file_exists($noImageName)){
			rename($noImageName, $newNoImageName);
		}

        JHtml::_('stylesheet', 'components/com_jbusinessdirectory/assets/css/font-awesome.css');

        jimport('joomla.installer.helper');
        $basedir = dirname(__FILE__);
        $packageDir = $basedir . '/admin/' . 'extensions';
        $extensionsDirs = JFolder::folders($packageDir);
        foreach ($extensionsDirs as $extensionDir) {
            $tmpInstaller = new JInstaller();
            $tmpInstaller->setOverwrite(true);
            if (!$tmpInstaller->install($packageDir . '/' . $extensionDir)) {
                JError::raiseWarning(100, "Extension :" . $extensionDir);
            }
        }
        $path = JPATH_ADMINISTRATOR . '/components/com_jbusinessdirectory/help/intro.php';
        include($path);

        $db = JFactory::getDBO();
        $db->setQuery(" UPDATE #__extensions SET enabled=1 WHERE element='urltranslator' ");
        $db->execute();

        $position = "cpanel";
        $name = "mod_jbusinessdirectory_icons";
        $db->setQuery("UPDATE #__modules SET `position`=" . $db->quote($position) . ",`published`='1' WHERE `module`=" . $db->quote($name));
        $db->execute();

        $db->setQuery("SELECT id FROM #__modules WHERE `module` = " . $db->quote($name));
        $id = (int)$db->loadResult();

        $db->setQuery("INSERT IGNORE INTO #__modules_menu (`moduleid`,`menuid`) VALUES (" . $id . ", 0)");
        $db->execute();

        require_once(JPATH_SITE.'/components/com_jbusinessdirectory/helpers/category_lib.php');
        $service = new JBusinessDirectorCategoryLib();
        $service->updateCategoryStructure();

        $db->setQuery("SELECT * FROM #__jbusinessdirectory_application_settings where name = 'company_name'");
        $appSetting = $db->loadObject();
        
        if (empty($appSetting) || $appSetting->value=="JBusinessDirectory") {
        	
        	$query = "SHOW TABLES LIKE '%__jbusinessdirectory_applicationsettings%'";
        	$db->setQuery("$query");
        	$result = $db->loadObject();
        	$tableExists = !empty($result);
        	
        	if($tableExists){
	            $db->setQuery("SELECT * FROM #__jbusinessdirectory_applicationsettings");
	            $appSettings = $db->loadObjectList();
	            $timeZone = $appSettings[0]->default_time_zone;
	            
	            if(!empty($timeZone)){
	                if (strpos($timeZone, '+') !== false){
	                    $temp = explode('+',$timeZone);
	                    $appSettings[0]->default_time_zone = '+'.sprintf("%02d", $temp[1]).':00';
	                }else{
	                    $temp = explode('-',$timeZone);
	                    $appSettings[0]->default_time_zone = '-'.sprintf("%02d", $temp[1]).':00';
	                }
	            }
	            foreach ($appSettings[0] as $name => $value) {
	            	if(!empty($name) && !empty($value)){
	            		try{
	            			$query = "Update #__jbusinessdirectory_application_settings set value = '$value' where name = '$name'";
	            			$db->setQuery($query);
	            			$db->execute();
	            		}catch(Exception $e){
	            		}
	            	}
	            }
        	}
        }

        if (!class_exists('JBusinessUtil')) {
        	require_once JPATH_SITE.'/components/com_jbusinessdirectory/helpers/utils.php';
        }

        //update the order end date
        if(method_exists('JBusinessUtil','updateOrderEndTime')){
            JBusinessUtil::updateOrderEndTime();
        }else{
            JError::raiseWarning(100, "One process associated with the update has not been performed successfully. Please run the installation process again!");
        }
       
        require_once JPATH_ADMINISTRATOR . DS . 'components' . DS . 'com_jbusinessdirectory' . DS . 'models' . DS . 'applicationsettings.php';
        $appSettingsModel = new JBusinessDirectoryModelApplicationSettings();
        $languages = $appSettingsModel->getLanguages(JPATH_ADMINISTRATOR . DS . 'components' . DS . 'com_jbusinessdirectory');

        foreach ($languages as $language) {
            $path = JPATH_ADMINISTRATOR . DS . 'components' . DS . 'com_jbusinessdirectory' . DS . 'language' . DS . $language->language . DS . $language->language . '.' . 'com_jbusinessdirectory' . '.ini';
            $customPath = JPATH_ADMINISTRATOR . DS . 'components' . DS . 'com_jbusinessdirectory' . DS . 'language' . DS . $language->language . DS . $language->language . '-custom.' . 'com_jbusinessdirectory' . '.ini';

            $file1 = file_get_contents($path);
            if (file_exists($customPath)){
                $file2 = file_get_contents($customPath);
                if ($file1 !== $file2) {
                    file_put_contents($path, "\n".$file2,FILE_APPEND);
                }
            }
        }

        $db->setQuery("SHOW TABLES LIKE '#__jbusinessdirectory_company_messages'");
        $countCompSMSTables = count($db->loadObjectList());
        if ($countCompSMSTables > 0){
            $query = "INSERT INTO #__jbusinessdirectory_messages (`name`,`surname`,`email`, `message`, `item_id`, `contact_id`, `type`, `read`)
                          SELECT `name`,`surname`,`email`, `message`, `company_id`, `contact_id` ,".MESSAGE_TYPE_BUSINESS." , '0'
                            FROM #__jbusinessdirectory_company_messages
                            ORDER BY id DESC";
            $db->setQuery($query);
            if ($db->execute()){
                $query = "DROP TABLE #__jbusinessdirectory_company_messages";
                $db->setQuery($query);
                $db->execute();
            }
        }

        $db->setQuery("SHOW TABLES LIKE '#__jbusinessdirectory_event_messages'");
        $countCompSMSTables = count($db->loadObjectList());
        if ($countCompSMSTables > 0){
            $query = "INSERT INTO #__jbusinessdirectory_messages (`name`,`surname`,`email`, `message`, `item_id`, `type`, `read`)
                          SELECT `name`,`surname`,`email`, `message`, `event_id` ,".MESSAGE_TYPE_EVENT." , '0'
                            FROM #__jbusinessdirectory_event_messages
                            ORDER BY id DESC";
            $db->setQuery($query);
            if ($db->execute()){
                $query = "DROP TABLE #__jbusinessdirectory_event_messages";
                $db->setQuery($query);
                $db->execute();
            }
        }

        $db->setQuery("SHOW TABLES LIKE '#__jbusinessdirectory_offer_messages'");
        $countCompSMSTables = count($db->loadObjectList());
        if ($countCompSMSTables > 0){
            $query = "INSERT INTO #__jbusinessdirectory_messages (`name`,`surname`,`email`, `message`, `item_id`, `type`, `read`)
                          SELECT `name`,`surname`,`email`, `message`, `offer_id` ,".MESSAGE_TYPE_OFFER." , '0'
                            FROM #__jbusinessdirectory_offer_messages
                            ORDER BY id DESC";
            $db->setQuery($query);
            if ($db->execute()){
                $query = "DROP TABLE #__jbusinessdirectory_offer_messages";
                $db->setQuery($query);
                $db->execute();
            }
        }

    }

    function deleteUpdateFiles(){

        $path = JPATH_ADMINISTRATOR . '/components/com_jbusinessdirectory/sql/updates/mysql';
		foreach (JFolder::files($path) as $file) {
            //delete all files
            if(version_compare($file, '5.7.3') < 0){
                unlink(JPATH_ADMINISTRATOR . '/components/com_jbusinessdirectory/sql/updates/mysql/'.$file);
            }
        }
    }

}