<?php
/**
 * @package    JBusinessDirectory
 *
 * @author CMSJunkie http://www.cmsjunkie.com
 * @copyright  Copyright (C) 2007 - 2021 CMSJunkie. All rights reserved.
 * @license   https://www.gnu.org/licenses/agpl-3.0.en.html
 */
defined('_JEXEC') or die('Restricted access');
jimport('joomla.application.component.modeladmin');

class JBusinessDirectoryModelMarketing extends JModelAdmin {
	public function __construct() {
		$this->appSettings = JBusinessUtil::getApplicationSettings();
		parent::__construct();
	}

	/**
	 * Returns a Table object, always creating it
	 *
	 * @param   type    The table type to instantiate
	 * @param   string    A prefix for the table class name. Optional.
	 * @param   array  Configuration array for model. Optional.
	 * @return  JTable    A database object
	 */
	public function getTable($type = 'Marketing', $prefix = 'JTable', $config = array()) {
		return JTable::getInstance($type, $prefix, $config);
	}

	public function getForm($data = array(), $loadData = true) {
	}

	public function saveLog($data) {
		//save in banners table
		$table = $this->getTable();

		// Bind the form fields to the table
		if (!$table->bind($data)) {
			dump($table->getError());
			$this->setError($table->getError());
			return false;
		}
		// Make sure the record is valid
		if (!$table->check()) {
			dump($table->getError());
			$this->setError($table->getError());
			return false;
		}

		// Store the web link table to the database
		if (!$table->store()) {
			dump($table->getError());
			$this->setError($table->getError());
			return false;
		}

		$this->cleanCache();

		return true;
	}

	public function sendCreationListingsNotificationEmail() {
		$data = array();
		$message = "";
		$countSuccess = 0;
		$companiesTable = $this->getTable('Company');
		$companies = $companiesTable->getAllCompanies();
		$companyWithnotSendedEmail = array();
		foreach ($companies as $company) {
			$specific_company = $companiesTable->getCompany($company->id);
			if (!empty($specific_company->email)) {
				$result = EmailService::sendNewCompanyNotificationEmailToOwner($specific_company);

				if ($result) {
					$countSuccess++;
				} else {
					array_push($companyWithnotSendedEmail, $specific_company->name);
				}
			} else {
				array_push($companyWithnotSendedEmail, $specific_company->name);
			}
		}

		$data["email_type"] = CREATION_LISTING_NOTIFICATION;
		$data["number_email_sent"] = $countSuccess;
		$data["sending_date"] = date("Y-m-d H:i:s");
		$data["failed_sent"] = count($companyWithnotSendedEmail);

		$saveData = $this->saveLog($data);

		if (!$saveData) {
			$message = $message . JFactory::getApplication()->enqueueMessage(JText::_('LNG_ERROR_SAVING_LOG'), 'warning');
		}

		if (!empty($companyWithnotSendedEmail)) {
			$message = $message . JFactory::getApplication()->enqueueMessage(JText::_('LNG_ERROR_SENDING_EMAIL'), 'warning');
			foreach ($companyWithnotSendedEmail as $company) {
				$message = $message . JFactory::getApplication()->enqueueMessage($company->name, 'warning');
			}
			$message = $message . JFactory::getApplication()->enqueueMessage("<br/>", 'warning');
			$message = $message . JText::plural('COM_JBUSINESS_DIRECTORY_N_EMAILS_SENT', $countSuccess);
			$message = $message . "<br/>";
		} else {
			$message = $message . JText::plural('COM_JBUSINESS_DIRECTORY_N_EMAILS_SENT', $countSuccess);
			$message = $message . "<br/>";
		}
		return $message;
	}


	public function sendStatisticsNotificationEmail() {
		$data = array();
		$message = "";
		$countSuccess = 0;
		$companiesTable = $this->getTable('Company');
		$marketingTable = $this->getTable();
		$searchDetails["enablePackages"] = 0;
		$searchDetails["getMonthlyStatistics"] = 1;
		$companyWithnotSendedEmail = array();

		$start = 0;
		$batch = STATISTIC_ITEMS_BATCH_SIZE;
		do {
			$companies = $companiesTable->getCompaniesByNameAndCategories($searchDetails, $start, $batch);

			foreach ($companies as $company) {
				$specific_company = $company;

				if (!empty($specific_company->email)) {
					//get events of the specific company
					$events = $marketingTable->getMonthlyEvents($specific_company->id);

					//get offer of specific company
					$offers = $marketingTable->getMonthlyOffer($specific_company->id);
					if (!empty($offers)) {
						JBusinessDirectoryTranslations::updateOffersTranslation($offers);
						foreach ($offers as $offer) {
							switch ($offer->view_type) {
								case 1:
									$offer->link = JBusinessUtil::getofferLink($offer->id, $offer->alias);
									break;
								case 2:
									$offer->link = JRoute::_('index.php?option=com_content&view=article&id=' . $offer->article_id);
									break;
								case 3:
									$offer->link = $offer->url;
									break;
								default:
									$offer->link = JBusinessUtil::getofferLink($offer->id, $offer->alias);
							}
						}
					}

					//get reviews of specific company
					$reviewsTable = $this->getTable("Review");
					$reviews = $marketingTable->getMonthlyReviews($specific_company->id, $this->appSettings->show_pending_review, REVIEW_TYPE_BUSINESS);

					if (!empty($reviews)) {
						foreach ($reviews as $review) {
							$review->responses = $reviewsTable->getCompanyReviewResponse($review->id);
							if (isset($review->scores)) {
								$review->scores = explode(",", $review->scores);
							}
							if (isset($review->criteria_ids)) {
								$review->criteriaIds = explode(",", $review->criteria_ids);
							}
							if (isset($review->answer_ids)) {
								$review->answerIds = explode(",", $review->answer_ids);
							}
							if (isset($review->question_ids)) {
								$review->questionIds = explode(",", $review->question_ids);

								$temp = array();
								$i = 0;
								foreach ($review->questionIds as $val) {
									$temp[$val] = $review->answerIds[$i];
									$i++;
								}
								$review->answerIds = $temp;
							}
						}
					}

					$seen = array(
						STATISTIC_TYPE_VIEW => '0',
						STATISTIC_TYPE_ARTICLE_CLICK => '0',
						STATISTIC_TYPE_WEBSITE_CLICK => '0',
						STATISTIC_TYPE_CONTACT => '0',
						STATISTIC_TYPE_SHARE => '0',
					);
					if (!empty($specific_company->statistics)) {
						$statistics = explode('##', $specific_company->statistics);
						foreach ($statistics as $stat) {
							$dataStat = explode('-', $stat);
							$seen[$dataStat[1]] = $seen[$dataStat[1]]+$dataStat[2];
						}
					}

					$specific_company->monthlyView = $seen[STATISTIC_TYPE_VIEW];
					$specific_company->articlesViews = $seen[STATISTIC_TYPE_ARTICLE_CLICK];
					$specific_company->events = $events;
					$specific_company->offers = $offers;
					$specific_company->reviews = $reviews;

					$result = EmailService::sendStatisticsNotificationEmail($specific_company);

					if ($result) {
						$countSuccess++;
					} else {
						array_push($companyWithnotSendedEmail, $specific_company->name);
					}
				} else {
					array_push($companyWithnotSendedEmail, $specific_company->name);
				}
			}
			$start += $batch;
		} while (count($companies) == $batch);

		$data["email_type"] = STATISTICAT_EMAIL_NOTIFICATION;
		$data["number_email_sent"] = $countSuccess;
		$data["sending_date"] = date("Y-m-d H:i:s");
		$data["failed_sent"] = count($companyWithnotSendedEmail);
		$saveData = $this->saveLog($data);

		if (!$saveData) {
			$message = $message . JFactory::getApplication()->enqueueMessage(JText::_('LNG_ERROR_SAVING_LOG'), 'warning');
		}

		if (!empty($companyWithnotSendedEmail)) {
			$message = $message . JFactory::getApplication()->enqueueMessage(JText::_('LNG_ERROR_SENDING_EMAIL'), 'warning');
			foreach ($companyWithnotSendedEmail as $company) {
				$message = $message . JFactory::getApplication()->enqueueMessage($company->name, 'warning');
			}
			$message = $message . JFactory::getApplication()->enqueueMessage("<br/>", 'warning');
			$message = $message . JText::plural('COM_JBUSINESS_DIRECTORY_N_EMAILS_SENT', $countSuccess);
			$message = $message . "<br/>";
		} else {
			$message = $message . JText::plural('COM_JBUSINESS_DIRECTORY_N_EMAILS_SENT', $countSuccess);
			$message = $message . "<br/>";
		}
		return $message;
	}


	public function sendUpgradeNotificationEmail() {
		$data = array();
		$message = "";
		$countSuccess = 0;
		$companiesTable = $this->getTable('Company');
		$freePlanTable = $this->getTable();
		$companies = $freePlanTable->getFreePlanBusiness();
		$companyWithnotSendedEmail = array();

		foreach ($companies as $company) {
			$specific_company = $companiesTable->getCompany($company->id);
			if (!empty($specific_company->email)) {
				$result = EmailService::sendUpgradeNotificationEmail($specific_company);

				if ($result) {
					$countSuccess++;
				} else {
					array_push($companyWithnotSendedEmail, $specific_company->name);
				}
			} else {
				array_push($companyWithnotSendedEmail, $specific_company->name);
			}
		}

		$data["email_type"] = UPGRADE_LISTING_NOTIFICATION;
		$data["number_email_sent"] = $countSuccess;
		$data["sending_date"] = date("Y-m-d H:i:s");
		$data["failed_sent"] = count($companyWithnotSendedEmail);

		$saveData = $this->saveLog($data);

		if (!$saveData) {
			$message = $message . JFactory::getApplication()->enqueueMessage(JText::_('LNG_ERROR_SAVING_LOG'), 'warning');
		}

		if (!empty($companyWithnotSendedEmail)) {
			$message = $message . JFactory::getApplication()->enqueueMessage(JText::_('LNG_ERROR_SENDING_EMAIL'), 'warning');
			foreach ($companyWithnotSendedEmail as $company) {
				$message = $message . JFactory::getApplication()->enqueueMessage($company->name, 'warning');
			}
			$message = $message . JFactory::getApplication()->enqueueMessage("<br/>", 'warning');
			$message = $message . JText::plural('COM_JBUSINESS_DIRECTORY_N_EMAILS_SENT', $countSuccess);
			$message = $message . "<br/>";
		} else {
			$message = $message . JText::plural('COM_JBUSINESS_DIRECTORY_N_EMAILS_SENT', $countSuccess);
			$message = $message . "<br/>";
		}
		return $message;
	}

	public function getLogs() {
		$table = $this->getTable();
		$log = $table->getEmailLogs();
		foreach ($log as $item) {
			if ($item->email_type == 1) {
				$item->email_type = JText::_('LNG_CREATE_LISTINGS_EMAIL_NOTIFICATION_TYPE');
			} elseif ($item->email_type == 2) {
				$item->email_type = JText::_('LNG_STATISTICS_EMAIL_NOTIFICATION_TYPE');
			} elseif ($item->email_type == 3) {
				$item->email_type = JText::_('LNG_UPGRADE_LISTING_EMAIL_NOTIFICATION_TYPE');
			}
		}
		return $log;
	}

	public function getEmailDescriptions() {
		return array(
			CREATE_LISTINGS_EMAIL_NOTIFICATION_TYPE => JText::_('LNG_CREATE_LISTINGS_EMAIL_NOTIFICATION_TYPE_DESCRIPTION'),
			STATISTICS_EMAIL_NOTIFICATION_TYPE => JText::_('LNG_STATISTICS_EMAIL_NOTIFICATION_TYPE_DESCRIPTION'),
			UPGRADE_LISTING_EMAIL_NOTIFICATION_TYPE => JText::_('LNG_UPGRADE_LISTING_EMAIL_NOTIFICATION_TYPE_DESCRIPTION')
		);
	}
}
