<?php
/**
 * @package    JBusinessDirectory
 *
 * @author     CMSJunkie http://www.cmsjunkie.com
 * @copyright  Copyright (C) 2007 - 2021 CMSJunkie. All rights reserved.
 * @license    https://www.gnu.org/licenses/agpl-3.0.en.html
 */
defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\Factory;
use Joomla\CMS\Cache\CacheControllerFactoryInterface;

class modJBusinessDirectoryHelper {
	public static function getMainCategories() {
		$db    = JFactory::getDBO();
		$query = 'SELECT * FROM #__jbusinessdirectory_categories 
				  WHERE parent_id=1 AND published=1 AND type=' . CATEGORY_TYPE_BUSINESS . '  
			      ORDER BY lft';
		$db->setQuery($query);
		return $db->loadObjectList();
	}

	public static function getSubCategories() {
		$db    = JFactory::getDBO();
		$query = 'SELECT c.* FROM #__jbusinessdirectory_categories c
                   INNER JOIN  #__jbusinessdirectory_categories  cc  ON c.parent_id = cc.id  
                   WHERE c.parent_id!=1 AND c.published=1  AND c.type=' . CATEGORY_TYPE_BUSINESS . '
                   ORDER BY c.lft';
		$db->setQuery($query, 0, 1000);
		$result = $db->loadObjectList();

		return $result;
	}

	public static function getTypes() {
		$db    = JFactory::getDBO();
		$query = 'SELECT * FROM #__jbusinessdirectory_company_types ORDER BY ordering ASC';
		$db->setQuery($query);
		$result = $db->loadObjectList();

		return $result;
	}

	public static function getCities() {
		$appSettings = JBusinessUtil::getApplicationSettings();
		$db          = JFactory::getDBO();
		$query       = "SELECT DISTINCT city, city AS id FROM #__jbusinessdirectory_companies
                  WHERE state = 1 AND city != ''
                    " . (($appSettings->show_secondary_locations) ? "
                  union
                  select distinct city, city as id from #__jbusinessdirectory_company_locations where city != ''
                    " : "") . "
                  ORDER BY city ASC";
		$db->setQuery($query);
		return $db->loadObjectList();
	}

	public static function getActivityCities() {
		$appSettings = JBusinessUtil::getApplicationSettings();
		$db    = JFactory::getDBO();

		$orderBy = ' name asc';
		if($appSettings->cities_regions_order == ORDER_BY_ORDER) {
			$orderBy = ' ordering asc';
		}
		$query = 'SELECT id, name AS city FROM #__jbusinessdirectory_cities ORDER BY '.$orderBy;
		$db->setQuery($query);
		return $db->loadObjectList();
	}

	public static function getRegions() {
		$appSettings = JBusinessUtil::getApplicationSettings();
		$db          = JFactory::getDBO();
		$query       = "SELECT DISTINCT county, county AS id FROM #__jbusinessdirectory_companies 
				  WHERE state = 1 AND county != ''
                    " . (($appSettings->show_secondary_locations) ? "
                  union
                  select distinct county, county as id from #__jbusinessdirectory_company_locations where county != ''
                    " : "") . "
                  ORDER BY county ASC";
		$db->setQuery($query);
		return $db->loadObjectList();
	}

	public static function getCitiesRegions() {
		$appSettings = JBusinessUtil::getApplicationSettings();
		$db          = JFactory::getDBO();
		$query       = "SELECT city, county 
                      FROM #__jbusinessdirectory_companies
                      WHERE state = 1 AND city != ''
                        " . (($appSettings->show_secondary_locations) ? "
                      union
                      select  city, county 
                        from #__jbusinessdirectory_company_locations where city != ''
                        " : "") . "
                  ORDER BY county ASC";

		$db->setQuery($query);
		$items = $db->loadObjectList();

		$result = array();
		foreach ($items as $item) {
			if (empty($result[$item->county])) {
				$result[$item->county] = array();
			}
			if (!in_array($item->city, $result[$item->county])) {
				$result[$item->county][] = $item->city;
			}
		}

		return $result;
	}

	public static function getActivityRegions() {
		$appSettings = JBusinessUtil::getApplicationSettings();
		$db    = JFactory::getDBO();

		$orderBy = ' name asc';
		if($appSettings->cities_regions_order == ORDER_BY_ORDER) {
			$orderBy = ' ordering asc';
		}
		
		$query = 'SELECT id, name AS county FROM #__jbusinessdirectory_regions ORDER BY '.$orderBy;
		$db->setQuery($query);
		return $db->loadObjectList();
	}

	public static function getProvinces() {
		$appSettings = JBusinessUtil::getApplicationSettings();
		$db          = JFactory::getDBO();
		$query       = "SELECT DISTINCT province FROM #__jbusinessdirectory_companies WHERE state = 1 AND province != ''
                    " . (($appSettings->show_secondary_locations) ? "
                  UNION
                  Select distinct province FROM #__jbusinessdirectory_company_locations where province != ''
                    " : "") . "
                  ORDER BY province ASC";
		$db->setQuery($query);
		return $db->loadObjectList();
	}

	public static function getCountries() {
		$appSettings = JBusinessUtil::getApplicationSettings();
		$db          = JFactory::getDBO();
		$query       = "SELECT DISTINCT c.id, c.country_name FROM #__jbusinessdirectory_countries c
                    INNER JOIN #__jbusinessdirectory_companies cp ON c.id = cp.countryId
                      WHERE country_name!=''
                    " . (($appSettings->show_secondary_locations) ? "
                  UNION
                  select distinct c.id, c.country_name FROM #__jbusinessdirectory_countries c
                    inner join #__jbusinessdirectory_company_locations lo on lo.countryId = c.id
                      where country_name!=''
                    " : "") . "
                  ORDER BY country_name ASC";
		$db->setQuery($query);
		return $db->loadObjectList();
	}

	public static function getCompanies($maxListings, $moduleId) {
		if (isset($_REQUEST["search-results"])) {
			return $_REQUEST["search-results"];
		}

		//load items through cache mechanism
		$companies = null;
		$cache     = Factory::getCache('mod_jbusiness_listings_search', '');
		$key       = 'mod_jbusiness_listings' . $moduleId;
		if ($cache->contains($key)) {
			$companies = $cache->get($key);
		} else {
			$companies = self::getCompaniesFromDB($maxListings);
			$cache->store($companies, $key);
		}

		return $companies;
	}


	public static function getCompaniesFromDB($maxListings) {
		JTable::addIncludePath(JPATH_ROOT . '/administrator/components/com_jbusinessdirectory/tables');
		$companiesTable                            = JTable::getInstance('Company', 'JTable');
		$appSettings                               = JBusinessUtil::getApplicationSettings();
		$searchDetails                             = array();
		$searchDetails["enablePackages"]           = $appSettings->enable_packages;
		$searchDetails["showPendingApproval"]      = ($appSettings->enable_item_moderation == '0' || ($appSettings->enable_item_moderation == '1' && $appSettings->show_pending_approval == '1'));
		$searchDetails["showSecondayLocationsMap"] = $appSettings->show_secondary_locations;
		$searchDetails["showCustomMarkers"]        = $appSettings->show_custom_markers;

		$companies = $companiesTable->getCompaniesByNameAndCategories($searchDetails, 0, $maxListings);

		foreach ($companies as $company) {
			$company->packageFeatures = array();
			if (!empty($company->features)) {
				$company->packageFeatures = explode(",", $company->features);
			}
			$attributesTable           = JTable::getInstance('CompanyAttributes', 'JTable');
			$company->customAttributes = $attributesTable->getCompanyAttributes($company->id);
		}

		return $companies;
	}

	public static function getCustomAttributes($attributes, $atrributesValues) {
		$attributes = array_filter($attributes);
		if (empty($attributes)) {
			return;
		}

		JTable::addIncludePath(JPATH_ROOT . '/administrator/components/com_jbusinessdirectory/tables');
		$attributesTable = JTable::getInstance('Attribute', 'JTable');

		$attributes = implode(",", array_filter($attributes));
		$attributes = $attributesTable->getAttributesConfiguration($attributes);

		foreach ($attributes as $attribute) {
			if (isset($atrributesValues[$attribute->id])) {
				$attribute->attributeValue = $atrributesValues[$attribute->id];
			}
		}
		return $attributes;
	}
}
