<?php
/**
 * @package    JBusinessDirectory
 *
 * @author CMSJunkie http://www.cmsjunkie.com
 * @copyright  Copyright (C) 2007 - 2021 CMSJunkie. All rights reserved.
 * @license   https://www.gnu.org/licenses/agpl-3.0.en.html
 */
defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\Session\Session;
use Joomla\Utilities\ArrayHelper;

class JBusinessDirectoryControllerOffers extends JControllerLegacy {
	
	/**
	 * Class constructor.
	 *
	 * @param   array  $config  A named array of configuration variables.
	 *
	 * @since   1.6
	 */
	public function __construct($config = array()) {
		parent::__construct($config);
		
		$this->registerTask('unpublish', 'changeState');
		$this->registerTask('publish', 'changeState');
	}
	
	/**
	 * Display the view
	 *
	 * @param   boolean			If true, the view output will be cached
	 * @param   array  An array of safe url parameters and their variable types, for valid values see {@link JFilterInput::clean()}.
	 *
	 * @return  JController		This object to support chaining.
	 * @since   1.6
	 */
	public function display($cachable = false, $urlparams = false) {
	}

	/**
	 * Method to get a model object, loading it if required.
	 *
	 * @param   string  $name    The model name. Optional.
	 * @param   string  $prefix  The class prefix. Optional.
	 * @param   array   $config  Configuration array for model. Optional.
	 *
	 * @return  object  The model.
	 *
	 * @since   1.6
	 */
	public function getModel($name = 'Offers', $prefix = 'JBusinessDirectoryModel', $config = array('ignore_request' => true)) {
		$model = parent::getModel($name, $prefix, $config);
		return $model;
	}

	public function back() {
		$this->setRedirect('index.php?option=com_jbusinessdirectory');
	}
	
	/**
	 * Removes an item
	 */
	public function delete() {
		// Check for request forgeries
		JSession::checkToken() or jexit(JText::_('JINVALID_TOKEN'));

		// Get items to remove from the request.
		$cid = $this->input->get('cid', array(), 'array');
		if (!is_array($cid) || count($cid) < 1) {
			JError::raiseWarning(500, JText::_('COM_JBUSINESSDIRECTORY_NO_OFFER_SELECTED'));
		} else {
			// Get the model.
			$model = $this->getModel("Offer");

			// Make sure the item ids are integers
			jimport('joomla.utilities.arrayhelper');
			ArrayHelper::toInteger($cid);

			// Remove the items.
			if (!$model->delete($cid)) {
				$this->setMessage($model->getError());
			} elseif (!empty($model->getErrors())) {
				$implodeErrors = implode('<br />', $model->getErrors());
				$this->setMessage(JText::sprintf('COM_JBUSINESSDIRECTORY_DELETED_WARNING', $implodeErrors), 'Warning');
			} else {
				$this->setMessage(JText::plural('COM_JBUSINESSDIRECTORY_N_OFFERS_DELETED', count($cid)));
			}
		}
		$app = JFactory::getApplication();
		$type = $app->getUserState('com_jbusinessdirectory.offers.filter.type');

		$this->setRedirect('index.php?option=com_jbusinessdirectory&view=offers&filter_type='.$type);
	}

	public function unpublish() {
		$model = $this->getModel('Offer');
		
		if ($model->changeState()) {
			$this->setMessage(JText::_('LNG_ERROR_CHANGE_STATE'), 'warning');
		}
		
		$this->setRedirect('index.php?option=com_jbusinessdirectory&view=offers');
	}

	public function changeState() {
		// Check for request forgeries
		//Session::checkToken() or die(JText::_('JINVALID_TOKEN'));

		// Get items to publish from the request.
		$cid   = $this->input->get('cid', array(), 'array');
		$data  = array('publish' => 1, 'unpublish' => 0, 'archive' => 2, 'trash' => -2, 'report' => -3);
		$task  = $this->getTask();
		$value = ArrayHelper::getValue($data, $task, 0, 'int');
		$error = false;

		$model = $this->getModel('Offer');

		if (!$model->changeState($cid[0])) {
			$this->setMessage(JText::_('LNG_ERROR_CHANGE_STATE'), 'warning');
		} else {
			$this->text_prefix = "COM_JBUSINESSDIRECTORY";
			if ($value === 1) {
				$ntext = $this->text_prefix . '_N_ITEMS_PUBLISHED';
			} elseif ($value === 0) {
				$ntext = $this->text_prefix . '_N_ITEMS_UNPUBLISHED';
			} elseif ($value === 2) {
				$ntext = $this->text_prefix . '_N_ITEMS_ARCHIVED';
			}

			if ($ntext !== null) {
				$this->setMessage(\JText::plural($ntext, count($cid)));
			}
		}

		$ajax = $this->input->get('ajax');
		if (!empty($ajax)) {
			$response          = array();
			$response["cid"]   = $cid[0];
			$response["error"] = $error;

			echo json_encode($response);

			exit;
		}

		$app = JFactory::getApplication();
		$type = $app->getUserState('com_jbusinessdirectory.offers.filter.type');

		$this->setRedirect('index.php?option=com_jbusinessdirectory&view=offers&filter_type='.$type);
	}

	public function changeStateOfferOfTheDay() {
		$model = $this->getModel('Offer');
	
		if (!$model->changeStateOfferOfTheDay()) {
			$this->setMessage(JText::_('LNG_ERROR_CHANGE_STATE'), 'warning');
		}
	
		$this->setRedirect('index.php?option=com_jbusinessdirectory&view=offers');
	}

	public function importFromCsv() {
		JFactory::getApplication()->input->set("layout", "import");
		parent::display();
	}

	public function showExportCsv() {
		JFactory::getApplication()->input->set("layout", "export");
		parent::display();
	}

	public function exportOffersCsv() {
		JSession::checkToken() or jexit(JText::_('JINVALID_TOKEN'));
		$model = $this->getModel('offers');
		$model->exportOffersCSV();
		exit;
	}

	public function importOffersFromCsv() {
		JSession::checkToken() or jexit(JText::_('JINVALID_TOKEN'));
		$config = JBusinessUtil::getSiteConfig();
		$filePath = $config->tmp_path;
		$data = JFactory::getApplication()->input->post->getArray();

		//upload file
		$filePath = JBusinessUtil::uploadFile("csvFile", $data, $filePath);

		$model = $this->getModel("Offer");
		$model->importOffersFromCSV($filePath, $data["delimiter"]);
		$model->getImportStatus();

		$this->setRedirect('index.php?option=com_jbusinessdirectory&view=offers');
	}

	public function importOffersFromTxtArea() {
		JSession::checkToken() or jexit(JText::_('JINVALID_TOKEN'));
		$data = JFactory::getApplication()->input->get('jform', array(), 'ARRAY');

		$csvContent = null;
		if (!empty($data["offerData_ForImport"])) {
			$csvContent = explode("\n", $data["offerData_ForImport"]);
		}

		$model = $this->getModel("Offer");
		$model->importOffersFromTextArea($csvContent, $data["delimiter"]);
		$model->getImportStatus();


		$this->setRedirect('index.php?option=com_jbusinessdirectory&view=offers');
	}
}
