<?php

/**
 * @package    JBusinessDirectory
 *
 * @author CMSJunkie http://www.cmsjunkie.com
 * @copyright  Copyright (C) 2007 - 2021 CMSJunkie. All rights reserved.
 * @license   https://www.gnu.org/licenses/agpl-3.0.en.html
 */

defined('_JEXEC') or die('Restricted access');

class JBusinessDirectoryControllerMarketing extends JControllerLegacy {

  /**
   * constructor (registers additional tasks to methods)
   * @return void
   */

	public function __construct() {
		parent::__construct();
	}

	public function CreationListingsNotification() {
		$modelsend = $this->getModel('marketing');
		$message = $modelsend->sendCreationListingsNotificationEmail();
		$this->setMessage($message);
		$this->setRedirect('index.php?option=com_jbusinessdirectory&view=marketing');
	}

	public function StatisticsNotification() {
		$modelsend = $this->getModel('marketing');
		$message = $modelsend->sendStatisticsNotificationEmail();
		$this->setMessage($message);
		$this->setRedirect('index.php?option=com_jbusinessdirectory&view=marketing');
	}

	public function UpgradeNotification() {
		$modelsend = $this->getModel('marketing');
		$message = $modelsend->sendUpgradeNotificationEmail();
		$this->setMessage($message);
		$this->setRedirect('index.php?option=com_jbusinessdirectory&view=marketing');
	}
}
