<?php
/**
 * @package    JBusinessDirectory
 *
 * @author CMSJunkie http://www.cmsjunkie.com
 * @copyright  Copyright (C) 2007 - 2021 CMSJunkie. All rights reserved.
 * @license   https://www.gnu.org/licenses/agpl-3.0.en.html
 */
defined('_JEXEC') or die('Restricted access');
use Joomla\Utilities\ArrayHelper;
use Joomla\CMS\Session\Session;

jimport('joomla.application.component.controlleradmin');

class JBusinessDirectoryControllerListingRegistrations extends JControllerAdmin {

	/**
	 * Display the view
	 *
	 * @param   boolean			If true, the view output will be cached
	 * @param   array  An array of safe url parameters and their variable types, for valid values see {@link JFilterInput::clean()}.
	 *
	 * @return  JController		This object to support chaining.
	 * @since   1.6
	 */
	public function display($cachable = false, $urlparams = false) {
	}

	/**
	 * Method to get a model object, loading it if required.
	 *
	 * @param   string  $name    The model name. Optional.
	 * @param   string  $prefix  The class prefix. Optional.
	 * @param   array   $config  Configuration array for model. Optional.
	 *
	 * @return  object  The model.
	 *
	 * @since   1.6
	 */
	public function getModel($name = 'ListingRegistrations', $prefix = 'JBusinessDirectoryModel', $config = array('ignore_request' => true)) {
		$model = parent::getModel($name, $prefix, $config);
		return $model;
	}

	public function back() {
		$this->setRedirect('index.php?option=com_jbusinessdirectory');
	}

	public function aprove() {
		$model = $this->getModel('ListingRegistrations');
		$error = false;
		$cid   = $this->input->get('cid', array(), 'array');
		$isCP   = $this->input->get('front', false);
		$ajax = $this->input->get('ajax');

		foreach ($cid as $id) {
			if (!$model->changeAprovalState($id, LISTING_JOIN_STATUS_APPROVED)) {
				$this->setMessage(JText::_('LNG_ERROR_CHANGE_STATE'), 'warning');
				$error = true;
			} else {
				$this->setMessage(\JText::plural("COM_JBUSINESSDIRECTORY_N_ITEMS_APPROVED", count($cid)));
			}
		}


		if (!empty($ajax)) {
			$response = array();
			$response["cid"] = $cid[0];
			$response["error"] = $error;

			echo json_encode($response);

			exit;
		}

		$view = 'listingregistrations';
		if ($isCP) {
			$view = 'managelistingregistrations';
		}

		$this->setRedirect(JRoute::_('index.php?option=com_jbusinessdirectory&view='.$view, false));
	}

	public function disaprove() {
		$model = $this->getModel('ListingRegistrations');
		$error = false;
		$cid   = $this->input->get('cid', array(), 'array');
		$isCP   = $this->input->get('front', false);
		$ajax = $this->input->get('ajax');

		foreach ($cid as $id) {
			if (!$model->changeAprovalState($id, LISTING_JOIN_STATUS_DISAPPROVED)) {
				$this->setMessage(JText::_('LNG_ERROR_CHANGE_STATE'), 'warning');
				$error = true;
			} else {
				$this->setMessage(\JText::plural("COM_JBUSINESSDIRECTORY_N_ITEMS_DISAPPROVED", count($cid)));
			}
		}

		if (!empty($ajax)) {
			$response = array();
			$response["cid"] = $cid[0];
			$response["error"] = $error;

			echo json_encode($response);
			exit;
		}
		$view = 'listingregistrations';
		if ($isCP) {
			$view = 'managelistingregistrations';
		}

		$this->setRedirect(JRoute::_('index.php?option=com_jbusinessdirectory&view='.$view, false));
	}
}
