<?php
/**
 * @package     Joomla.Site
 * @subpackage  mod_login
 *
 * @copyright   Copyright (C) 2005 - 2019 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

JLoader::register('UsersHelperRoute', JPATH_SITE . '/components/com_users/helpers/route.php');

JHtml::_('behavior.keepalive');
JHtml::_('bootstrap.tooltip');
$usersConfig = JComponentHelper::getParams('com_users'); 
$userToken = JSession::getFormToken();
$createView = $appSettings->enable_packages?"packages":"managecompany";
$currentUrl = JUri::getInstance();
?>

<div class="jbd-mod-user">
	<?php if(!$user->id){ ?>
    <div class="user-area signin-area">
		<i class="fa fa-user"></i>
        <a href="#jbd-user-login" rel="modal:open"><?php echo JText::_("MOD_JBUSINESS_USER_SIGN_IN")?></a>
        <?php if ($usersConfig->get('allowUserRegistration') && $params->get('showregistration')) { ?>
        	<span class="allow-registration">
				<span><?php echo JText::_("MOD_JBUSINESS_USER_OR")?></span>
				<?php if ($params->get('external_registration')) {?>
					<a href="<?php echo JRoute::_(ModJBusinessUserHelper::getRedirectUrl($params, "external_registration")); ?>">
							<?php echo JText::_('MOD_JBUSINESS_USER_REGISTER'); ?> </a>
				<?php }else{ ?>
					<a href="#jbd-user-registration" rel="modal:open"><?php echo JText::_("MOD_JBUSINESS_USER_REGISTER")?></a>
				<?php } ?>
			</span>
		<?php } ?>
    </div>
	<?php }else{ ?>
    	<div class="jbd-user-menu">
			<ul class="user-menu menu-animation-fade-up">
				<li class="menu-item has-child"><a href="#" class="jbd-username"><i class="la la-user"></i> <span class="jbd-user-name"><?php echo $user->name?></span></a>
					<div class="dropdown dropdown-main menu-right">
        				<div class="dropdown-inner">
            				<ul class="dropdown-items">
            					<li class="menu-item">
            						<a href="<?php echo $dashboardLink ?>"><?php echo JText::_("MOD_JBUSINESS_USER_DASHBOARD")?></a>
            					</li>
            					<li class="menu-item">
            						<a href="<?php echo JRoute::_('index.php?option=com_users&view=profile') ?>"><?php echo JText::_("MOD_JBUSINESS_USER_PROFILE")?></a>
            					</li>
            					<li class="menu-item">
            						<a href="<?php echo JRoute::_('index.php?option=com_users&task=user.logout&'.$userToken.'=1&return='.$return)?>"><?php echo JText::_("MOD_JBUSINESS_USER_LOGOUT")?></a>
            					</li>
            				</ul>
            			</div>
            		</div>
        		</li>
        	</ul>
    	</div>
   <?php } ?>
   
   <?php if ($params->get('showcart')) { ?>
       <div class="jbd-view-cart">
       	   <a href="<?php echo JRoute::_("index.php?option=com_jbusinessdirectory&view=cart")?>" title="View your shopping cart">
    	   	   <i class="fa fa-shopping-basket">
    	   	   <?php if(!empty($cartItemsCount)){?>
    	   	   	<span class="cart-badge"><?php echo $cartItemsCount?></span>
    	   	   <?php } ?>
    	   	   </i>
       	   </a>
       </div>		
   <?php } ?>							
   
   <?php if ($params->get('showcreatelisting')) { ?>
       <div class="jbd-button-container">
          <a href="<?php echo JRoute::_("index.php?option=com_jbusinessdirectory&view=$createView")?>" class="button-create">
          	<i class="fa fa-plus"></i> <?php echo JText::_("MOD_JBUSINESS_USER_ADD_LISTING")?>
          </a>
       </div>
   <?php } ?>		
    <div id="jbd-user-login" class="jbd-container" style="display:none"> 
    	<form action="<?php echo JRoute::_('index.php', true, $params->get('usesecure', 0)); ?>" method="post" id="login-form" class="form-inline">
        	<div class="jmodal-sm">
        		<div class="jmodal-header">
        			<p class="jmodal-header-title"><?php echo JText::_("MOD_JBUSINESS_USER_SIGN_IN") ?></p>
        			<a href="#close-modal" rel="modal:close" class="close-btn"><i class="la la-close "></i></a>
        		</div>
        		<div class="jmodal-body">
            		<?php if ($params->get('pretext')){ ?>
            			<div class="pretext">
            				<p><?php echo $params->get('pretext'); ?></p>
            			</div>
            		<?php } ?>
            		
            		<div class="row">
    					<div class="col-md-12">
    						<div class="jinput-outline jinput-hover">
                				<input class="validate[required]" id="jinput-username" name="username" type="text"  required="" > 
                				<label for="jinput-username"><?php echo JText::_('MOD_JBUSINESS_USER_VALUE_USERNAME') ?></label>
                    		</div>
    					</div>
    				</div>	
            		<div class="row">
    					<div class="col-md-12">
    						<div class="jinput-outline jinput-hover">
                				<input class="validate[required]" type="password" name="password" id="modlgn-passwd" required="">
                				<label for="modlgn-passwd"><?php echo JText::_('JGLOBAL_PASSWORD') ?></label> 
                    		</div>
    					</div>
    				</div>	
            			
            		<?php if (count($twofactormethods) > 1) { ?>
            			<div class="row">
        					<div class="col-md-12">
        						<div class="jinput-outline jinput-hover">
                    				<input class="validate[required]" autocomplete="off" type="text" name="secretkey" id="modlgn-secretkey" required="">
                    				<label for="modlgn-secretkey"><?php echo JText::_('JGLOBAL_SECRETKEY') ?></label> 
                        		</div>
        					</div>
        				</div>	
            		<?php } ?>

                    <div class="row">
                        <div class="col-md-12">
                            <div class="jbd-checkbox justify-content-end">
                            </div>
                        </div>
                    </div>

            		<div class="row">
    					<div class="col-md-6">
                    		<?php if (JPluginHelper::isEnabled('system', 'remember')) : ?>
                				<div class="jbd-checkbox justify-content-end">
                					<label for="modlgn-remember"><?php echo JText::_('MOD_JBUSINESS_USER_REMEMBER_ME')?></label>
                                    <input type="checkbox" name="remember" id="modlgn-remember" value="1" value="yes" /> 
                                </div>
                   			<?php endif; ?>
    					</div>
    					<div class="col-md-6 d-flex align-items-center justify-content-end">
    						<a href="<?php echo JRoute::_('index.php?option=com_users&view=reset'); ?>">
            						<?php echo JText::_('MOD_JBUSINESS_USER_FORGOT_YOUR_PASSWORD'); ?></a>
    					</div>               			
               		</div>
               		
               		<div class="row">
               			<div class="col-md-12 text-center my-3">
    						<button type="submit" tabindex="0" name="Submit" class="btn btn-primary login-button"><?php echo JText::_('JLOGIN'); ?></button>
    					</div>
    				</div>

					<?php if ($params->get('external_registration')) {?>
						<div class="row">
                   			<div class="col-md-12 text-center">
                         		<?php echo JText::_('MOD_JBUSINESS_USER_NOT_MEMBER'); ?><a href="<?php echo JRoute::_(ModJBusinessUserHelper::getRedirectUrl($params, "external_registration")); ?>">
                						<?php echo JText::_('MOD_JBUSINESS_USER_REGISTER_HERE'); ?> </a>
                        	</div>
                        </div>
    				<?php } else if ($usersConfig->get('allowUserRegistration')) {?>
        				<div class="row">
                   			<div class="col-md-12 text-center">
                         		<?php echo JText::_('MOD_JBUSINESS_USER_NOT_MEMBER'); ?><a href="#jbd-user-registration" rel="modal:open">
                						<?php echo JText::_('MOD_JBUSINESS_USER_REGISTER_HERE'); ?> </a>
                        	</div>
                        </div>
                    <?php } ?>
                    
                    <?php if ($params->get('showforgotuser')) { ?>
        				<div class="row">
                   			<div class="col-md-12 text-center">
                         		 <a href="<?php echo JRoute::_('index.php?option=com_users&view=remind'); ?>">
                						<?php echo JText::_('MOD_JBUSINESS_FORGOT_YOUR_USERNAME'); ?> </a>
                        	</div>
                        </div>
                    <?php } ?>
                    
                    <?php if ($params->get('socialloging')) { ?>
                    <div class="row">
               			<div class="col-md-12 text-center">
               				<div class="social-network-wrapper">
               					<span><?php echo JText::_("MOD_JBUSINESS_USER_FASTER_LOGIN")?></span>
               					<div class="social-login-button">
                       				<div class="row d-flex justify-content-center align-content-center"> 
										<?php if (!empty($appSettings->google_client_id) && !empty($appSettings->google_client_secret)) { ?>
											<div class="col-md-4">
												<a class="social-btn jbd-google-signin" href="<?php echo JRoute::_('index.php?option=com_jbusinessdirectory&task=userprofile.oauthCallback&type=google&redirect='.$currentUrl) ?>">
													<i class="la la-google"></i>
													<span><?php echo JText::_("MOD_JBUSINESS_USER_SIGN_GOOGLE")?></span>
												</a>
											</div>
										<?php } ?>
										<?php if (!empty($appSettings->facebook_client_id) && !empty($appSettings->facebook_client_secret)) { ?>
											<div class="col-md-4">
												<a class="social-btn jbd-facebook-signin" href="<?php echo JRoute::_('index.php?option=com_jbusinessdirectory&task=userprofile.oauthCallback&type=facebook&redirect='.$currentUrl) ?>">
													<i class="la la-facebook-official"></i>
													<?php echo JText::_("MOD_JBUSINESS_USER_SIGN_FACEBOOK")?>
												</a>
											</div>
										<?php } ?>
										<?php if (!empty($appSettings->linkedin_client_id) && !empty($appSettings->linkedin_client_secret)) { ?>
											<div class="col-md-4">
												<a class="social-btn jbd-linkedin-signin" href="<?php echo JRoute::_('index.php?option=com_jbusinessdirectory&task=userprofile.oauthCallback&type=linkedin&redirect='.$currentUrl) ?>">
													<i class="la la-linkedin"></i>
													<?php echo JText::_("MOD_JBUSINESS_USER_SIGN_LINKEDIN")?>
												</a>
											</div>
										<?php } ?>
                       				</div>
                   				</div>
                   			</div>
               			</div>
               		</div>
               		<?php } ?>
               		
               		<?php if ($params->get('posttext')) { ?>
            			<div class="posttext">
            				<p><?php echo $params->get('posttext'); ?></p>
            			</div>
					<?php } ?>
               		
        			<input type="hidden" name="option" value="com_users" />
        			<input type="hidden" name="task" value="user.login" />
        			<input type="hidden" name="return" value="<?php echo $return; ?>" />
        			<?php echo JHtml::_('form.token'); ?>
        		</div>
        	</div>	
    	</form>
    </div>
	
	<div id="jbd-user-registration" class="jbd-container" style="display:none">
		<form id="member-registration" action="<?php echo JRoute::_('index.php?option=com_jbusinessdirectory&task=businessuser.addUser'); ?>" method="post" class="form-validate form-horizontal well" enctype="multipart/form-data"> 
    		<div class="jmodal-sm">
        		<div class="jmodal-header">
        			<p class="jmodal-header-title"><?php echo JText::_("MOD_JBUSINESS_USER_REGISTRATION") ?></p>
        			<a href="#close-modal" rel="modal:close" class="close-btn"><i class="la la-close "></i></a>
        		</div>
        		<div class="jmodal-body">
					<div class="row">
    					<div class="col-md-12">
    						<div class="jinput-outline jinput-hover">
                				<input class="validate[required]" id="jform_name" name="name" type="text"  required="" > 
                				<label for="jform_name"><?php echo JText::_('MOD_JBUSINESS_USER_NAME') ?></label>
                    		</div>
    					</div>
    				</div>	
					<div class="row">
    					<div class="col-md-12">
    						<div class="jinput-outline jinput-hover">
                				<input class="validate[required]" id="jform_username" name="username" type="text"  required="" > 
                				<label for="jform_username"><?php echo JText::_('MOD_JBUSINESS_USER_USERNAME') ?></label>
                    		</div>
    					</div>
    				</div>
    				
    				<div class="row">
    					<div class="col-md-12">
    						<div class="jinput-outline jinput-hover">
                				<input class="validate[required]" id="jform_password1" name="password1" type="password" required="" > 
                				<label for="jform_password1"><?php echo JText::_('MOD_JBUSINESS_USER_PASSWORD') ?></label>
                    		</div>
    					</div>
    				</div>
    				
    				<div class="row">
    					<div class="col-md-12">
    						<div class="jinput-outline jinput-hover">
                				<input class="validate[required]" id="jform_email" name="email" type="text" required="" > 
                				<label for="jform_email"><?php echo JText::_('MOD_JBUSINESS_USER_EMAIL') ?></label>
                    		</div>
    					</div>
					</div>

					<?php if ($params->get('showbusinessownercheck')) { ?>
						<div class="row">
							<div class="col-md-12">
								<!--div class="control-group user-group-selection">
									<fieldset id="user_type_fld" class="radio btn-group btn-group-yesno">
										<input type="radio"  name="user_type" id="user_type1" value="1" required=""/>
										<label  class="validate[required] btn" for="user_type1"><?php echo JText::_('MOD_JBUSINESS_USER_I_AM_REGULAR_USER')?></label> 
										<input type="radio"  name="user_type" id="user_type2" value="2" required=""/>
										<label class="validate[required] btn" for="user_type2"><?php echo JText::_('MOD_JBUSINESS_USER_I_AM_BUSINESS_OWNER')?></label>
									</fieldset>
								</div -->
								<div class="jbd-checkbox justify-content-end">
									<label for="business_owner"><?php echo JText::_('MOD_JBUSINESS_USER_I_AM_BUSINESS_OWNER')?> </label>
									<input type="checkbox" name="business_owner" id="business_owner" value="1">
								</div>
							</div>
						</div>
					<?php } ?>

                    <div class="row">
                        <div class="col-md-12">
							<?php echo JBusinessUtil::renderTermsAndConditions(); ?>
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-12">
                        	<?php 
                        		if($appSettings->captcha){
        							$namespace="registration";
        							$class=" required";
        							
        							$captcha = JCaptcha::getInstance("recaptcha");
        																
        							if(!empty($captcha)){	
        								echo $captcha->display("captcha", "captcha-div-registration", $class);
        							}
	        					} 
	        				?>
            			</div>
            		</div>

    				<div class="row">
    					<div class="col-md-12 text-center my-3">
    						<button type="submit" class="btn btn-primary validate">
            					<?php echo JText::_('JREGISTER'); ?>
            				</button>
            			</div>
            		</div>
            	
            		<div class="jbd-user-has-account">
    					<?php echo JText::_('MOD_JBUSINESS_USER_HAVE_ACCOUNT'); ?> <a href="#jbd-user-login" rel="modal:open"><?php echo JText::_('MOD_JBUSINESS_USER_LOGIN'); ?></a>
    				</div>
    				
    				<input type="hidden" name="option" value="com_jbusinessdirectory" />
    				<input type="hidden" name="task" value="businessuser.addUser" />
					<input type="hidden" name="return" value="<?php echo ModJBusinessUserHelper::getReturnUrl($params, "registration_redirect"); ; ?>" />
    			</div>
				<?php echo JHtml::_('form.token'); ?>	
			</div>
		</form>
	</div>

</div>